//===================================================================
//
// File:  menu.h
//
// OS-Dependant Menu Support
//
// Credits:
//
//   Steve Fischer (2005)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Alastair Bridgewater (1998-2001)
//     - http://www.dridus.com/~nyef/darcnes
//     - Initial distribution use in this port
//
//===================================================================
//
// Ported By: Steve Fischer (steve@stevesprojects.com)
//
//	(c) Copyright 2005, Steve Fischer
//	All Rights Reserved
//
//===================================================================
//
// DarcNES is Copyright 1998, 1999, 2000, 2001 by Alastair Bridgewater.
//
// Commercial use prohibited without express written permission from
// the author. Everyone else can do whatever they want, provided that
// I am credited in the documentation (and, if released, the source code).
//
// See the "readme" file for complete DarcNES details
//
//===================================================================

#ifndef __MENU_H__
#define __MENU_H__

/* $Id: menu.h,v 1.4 2000/08/21 01:13:07 nyef Exp $ */

typedef void (*ui_menu_callback)(void *);
struct ui_menu 
{
    char            *name;
    int              flags; /* MF_xxx constants */
    ui_menu_callback callback;
    void            *callback_data;
    struct ui_menu  *child_menu;
    void            *ui_data;
};

#define MF_NONE  0x0000
#define MF_CHILD 0x0001

extern void menu_init(struct ui_menu *);
extern void menu_rename_item(struct ui_menu *);
extern void menu_enable_item(struct ui_menu *);
extern void menu_disable_item(struct ui_menu *);

typedef void (*ui_open_callback)(void *, char *);
extern void menu_file_open_box(ui_open_callback callback, void *data, char *filter);


#endif // __MENU_H__
