/*
 * tool.c
 *
 * a program to aide in hacking FF3j
 */

/* $Id: tool.c,v 1.34 2001/03/25 21:53:41 nyef Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "machdep.h"
#include "ui.h"
#include "vid.h"
#include "tool.h"
#include "system.h"

unsigned long system_flags;

rom_file read_romimage(const char *filename)
{
   FILE *file;
   int numread;
   int error;
   rom_file retval;
   
   file = NULL;

   retval = malloc(sizeof(*retval));

   if (retval)
   {
      retval->filename = NULL;
      retval->data = NULL;
      error = 0;
   }
   else
   {
      error = 1;
   }
   
   if (!error)
   {
      file = fopen(filename, "rb");
      error = !file;
   }

   if (!error)
   {
      /* FIXME: ignoring the return value from fseek() isn't good */
      fseek(file, 0, SEEK_END);
      retval->size = ftell(file);
      fseek(file, 0, SEEK_SET);
      
      retval->filename = strdup(filename);
      retval->data = malloc(retval->size);
      error = !(retval->data && retval->filename);
   }

   if (!error)
   {
      numread = fread(retval->data, 1, retval->size, file);
      error = (numread != retval->size);
   }

   if (error && retval)
   {
      if (retval->filename)
      {
         free(retval->filename);
      }
      if (retval->data)
      {
         free(retval->data);
      }
      free(retval);
      retval = NULL;
   }
   
   if (file)
   {
      fclose(file);
   }

   return retval;
}

void free_romfile(rom_file romfile)
{
   if (!romfile)
   {
      deb_printf("free_romfile(): warning: NULL romfile.\n");
      return;
   }
   
   if (romfile->filename)
   {
      free(romfile->filename);
   }

   if (romfile->data)
   {
      free(romfile->data);
   }
   free(romfile);
}

char *get_battery_filename(const char *filename)
{
   char *retval;
   int length;
   int last_period;
   
   last_period = 0;
   for (length = 0; filename[length]; length++)
   {
      if (filename[length] == '.')
      {
         last_period = length;
      }
   }
   
   if (last_period == 0)
   {
      last_period = length;
   }
   
   retval = malloc(last_period + 5);
   if (!retval)
   {
      return NULL;
   }
   
   strncpy(retval, filename, last_period);
   
   retval[last_period++] = '.';
   retval[last_period++] = 's';
   retval[last_period++] = 'a';
   retval[last_period++] = 'v';
   retval[last_period++] = '\0';
   
   return retval;
}

rom_file init_battery_file(rom_file romfile, int size)
{
   FILE *file;
   rom_file retval;
   
   file = NULL;
   
   retval = malloc(sizeof(*retval));
   
   if (!retval)
   {
      return NULL;
   }
   
   retval->filename = get_battery_filename(romfile->filename);
   
   retval->data = malloc(size);
   retval->size = size;
   
   // FIXME: retval->data and retval->filename can both be NULL right now
   
   file = fopen(retval->filename, "rb");
   
   if (!file)
   {
      // No file? just return an empty buffer
      return retval;
   }
   
   // FIXME: error handling?
   fread(retval->data, 1, retval->size, file);
   
   fclose(file);
   
   return retval;
}

void save_battery_file(rom_file batteryfile)
{
   FILE *batfile;
   
   deb_printf("attempting to save battery file.\n");
   
   // FIXME: error checking might be nice
   
   batfile = fopen(batteryfile->filename, "wb");
   
   if (batfile != NULL)
   {
      fwrite(batteryfile->data, batteryfile->size, 1, batfile);
      fclose(batfile);
   }
   else
   {
      deb_printf("could not open battery file.\n");
   }
}

/*
 * $Log: tool.c,v $
 * Revision 1.34  2001/03/25 21:53:41  nyef
 * changed read_romimage() and parse_system_name() to take const arguments
 *
 * Revision 1.33  2001/03/24 21:51:11  nyef
 * fixed overrun screw in get_battery_filename()
 *
 * Revision 1.32  2001/02/27 04:18:06  nyef
 * disabled genesis support
 *
 * Revision 1.31  2000/11/25 15:01:39  nyef
 * added activation entries for the MSX
 *
 * Revision 1.30  2000/11/23 16:23:51  nyef
 * added detect and activation entries for the SC3000
 *
 * Revision 1.29  2000/09/24 00:44:11  nyef
 * added some error trapping code to free_romfile()
 *
 * Revision 1.28  2000/09/23 02:57:47  nyef
 * added a function to free rom_files
 *
 * Revision 1.27  2000/05/06 21:50:17  nyef
 * fixed to compile with C++-fixed tool.h
 *
 * Revision 1.26  2000/03/06 01:26:51  nyef
 * added parse_system_name() to convert a string to a system_type
 *
 * Revision 1.25  2000/02/15 03:40:24  nyef
 * rewrote the battery file handling to not use the cheap hack it was before
 *
 * Revision 1.24  2000/02/15 03:22:04  nyef
 * removed the old implementation of guess_system()
 *
 * Revision 1.23  2000/01/01 04:12:05  nyef
 * added activation entry for the Apple ][
 *
 * Revision 1.22  1999/12/07 00:52:58  nyef
 * made the cheap hack used for the battery filename endian-independant
 *
 * Revision 1.21  1999/12/06 00:33:31  nyef
 * added battery file support
 *
 * Revision 1.20  1999/12/05 00:47:05  nyef
 * cleaned up a bit I missed when adding the new type system
 *
 * Revision 1.19  1999/11/28 17:47:01  nyef
 * fixed type in new system_guess() implementation ('smd', not 'smb')
 *
 * Revision 1.18  1999/11/27 20:09:01  nyef
 * added detect and activation entries for the SG1000
 *
 * Revision 1.17  1999/11/27 18:59:15  nyef
 * built a new version of guess_system() that detects based on filenames
 *
 * Revision 1.16  1999/11/27 18:34:04  nyef
 * added gamegear support to activate_system()
 *
 * Revision 1.15  1999/11/20 05:26:35  nyef
 * redesigned rom loading interface
 * refactored to use standard C file routines in read_romimage()
 * refactored activate_system()
 *
 * Revision 1.14  1999/06/08 01:48:02  nyef
 * added colecovision support (the rom detect is really lame, though)
 *
 * Revision 1.13  1999/04/17 22:24:41  nyef
 * added genesis support.
 *
 * Revision 1.12  1999/02/20 20:12:07  nyef
 * added minimum size checks to SMS/GG detection (fixes small PCE roms)
 * changed most if not all strncmp()s to memcmp()s
 *
 * Revision 1.11  1999/02/14 06:18:19  nyef
 * added detection of FDS images
 *
 * Revision 1.10  1999/01/30 17:53:02  nyef
 * reduced the 0x4000s in the genesis/pce detect to 0x2000 (this doesn't
 * affect the genesis detect much, and fixes the pce detect to catch some
 * roms produced with the MagicKit assembler).
 *
 * Revision 1.9  1999/01/01 06:26:50  nyef
 * added support for Master System.
 *
 * Revision 1.8  1998/12/21 02:58:59  nyef
 * added char * romfilename to save the name of the rom file.
 *
 * Revision 1.7  1998/10/11 20:34:33  nyef
 * added SMS/GG detection to read_romimage()
 * added preliminary GB detection to read_romimage()
 *
 * Revision 1.6  1998/08/02 13:42:40  nyef
 * changed every printf to deb_printf for debug console.
 *
 * Revision 1.5  1998/08/01 01:07:44  nyef
 * fixed stupid mistake in activate_system().
 *
 * Revision 1.4  1998/08/01 01:03:20  nyef
 * moved main() out to the video interfaces. retained some of the logic in
 * activate_system().
 *
 * Revision 1.3  1998/07/12 23:07:07  nyef
 * added a romsize variable and fixed read_romimage() to set it
 *
 * Revision 1.2  1998/07/12 20:52:06  nyef
 * enabled PC-Engine emulation
 *
 * Revision 1.1  1998/07/11 22:19:09  nyef
 * Initial revision
 *
 */
