/*
 * system.h
 *
 * definitions for system emulation control
 */

/* $Id: system.h,v 1.12 2000/11/25 15:02:00 nyef Exp $ */

#ifndef __SYSTEM_H__
#define __SYSTEM_H__

#include "tool.h"

extern void nes_run(rom_file romfile);
extern int  nes_getcontextsize( void );
extern int  nes_getcontext( unsigned char *buffer, int max_length );
extern void nes_setcontext( unsigned char *buffer, int length );

#endif /* __SYSTEM_H__ */

/*
 * $Log: system.h,v $
 * Revision 1.12  2000/11/25 15:02:00  nyef
 * added prototype for msx_run()
 *
 * Revision 1.11  2000/11/23 16:23:03  nyef
 * added system define for SC3000
 * added prototype for sc3k_run()
 *
 * Revision 1.10  2000/05/29 19:28:35  nyef
 * removed disused definition of system_type
 *
 * Revision 1.9  2000/01/01 04:11:26  nyef
 * added prototype for apple2_run()
 *
 * Revision 1.8  1999/11/27 20:08:44  nyef
 * added system define for SG1000
 * added prototype for sg1k_run()
 *
 * Revision 1.7  1999/11/27 18:33:18  nyef
 * added a separate system type for the gamegear
 * added prototype for gg_run()
 *
 * Revision 1.6  1999/11/20 05:29:18  nyef
 * fixed to work with new rom loading interface
 *
 * Revision 1.5  1999/06/08 01:49:04  nyef
 * added prototype for cv_run()
 * moved mac, psx, n64, and saturn type codes up by 10
 * added codes for apple2, colecovision, and msx
 *
 * Revision 1.4  1999/04/17 22:24:15  nyef
 * added prototype for genesis_run().
 *
 * Revision 1.3  1999/01/01 06:27:13  nyef
 * added prototype for sms_run().
 *
 * Revision 1.2  1998/07/26 14:20:06  nyef
 * added system defines for Master System, GameBoy, SNES, Lynx, Jaguar,
 *   SegaCD, Macintosh, Playstation and N64.
 *
 * Revision 1.1  1998/07/11 22:19:03  nyef
 * Initial revision
 *
 */
