/*******************************************************************
 *
 *	File:		PolledAS.cpp
 *
 *	Author:		Peter van Sebille (peter@yipton.net)
 *
 *	(c) Copyright 2002, Peter van Sebille
 *	All Rights Reserved
 *
 *******************************************************************/

/*
 * Oh Lord, forgive me for I have sinned.
 * In their infinite wisdom, Symbian Engineers have decided that
 * the Active Scheduler's queue of Active Objects is private
 * and no getters are provided... sigh.
 * This mere mortal will have to excercise the power of C pre-processor 
 * once more to circumvent the will of the gods.
 */


/*
 * This will declare CPrivatePolledActiveScheduler as a friend
 * of all classes that define a friend. CPrivatePolledActiveScheduler needs to
 * be a friend of CActive
 */
/*#define friend\
	friend class CPrivatePolledActiveScheduler; friend
*/
#define Deque()\
	Deque(); friend class CPrivatePolledActiveScheduler;


/*
 * This will change the:
 *		 void DoStart();
 * method in CActiveScheduler to:
 *		 void DoStart(); friend class CPrivatePolledActiveScheduler;
 * We need this to access the private datamembers in CActiveScheduler.
 */
#define DoStart()\
	DoStart(); friend class CPrivatePolledActiveScheduler;
#include <e32base.h>
#include "PolledAS.h"


class CPrivatePolledActiveScheduler : public CActiveScheduler
{
public:
	void Schedule();
};



void CPrivatePolledActiveScheduler::Schedule()
{
	TDblQueIter<CActive> q(iActiveQ);
	q.SetToFirst();
	FOREVER
	{
		CActive *pR=q++;
		if (pR)
		{
			if (pR->IsActive() && pR->iStatus!=KRequestPending)
			{
				pR->iActive=EFalse;
				TRAPD(r,pR->RunL());
				break;
			}
		}
		else
			break;
	}
}


CPolledActiveScheduler::~CPolledActiveScheduler()
{
	delete iPrivatePolledActiveScheduler;
}

static CPolledActiveScheduler* sPolledActiveScheduler = NULL;
CPolledActiveScheduler* CPolledActiveScheduler::NewL()
{
	CPolledActiveScheduler*	self = sPolledActiveScheduler = new(ELeave)CPolledActiveScheduler;
	CleanupStack::PushL(self);
	self->ConstructL();
	CleanupStack::Pop();
	return self;
}

void CPolledActiveScheduler::ConstructL()
{
	iPrivatePolledActiveScheduler = new(ELeave) CPrivatePolledActiveScheduler;
	iPrivatePolledActiveScheduler->Install(iPrivatePolledActiveScheduler);
}


void CPolledActiveScheduler::Schedule()
{
	iPrivatePolledActiveScheduler->Schedule();
}

CPolledActiveScheduler* CPolledActiveScheduler::Instance()
{
//	return (CPolledActiveScheduler*) CActiveScheduler::Current();
	return sPolledActiveScheduler;
}
