//===================================================================
//
// File: Navigation.h
//
// From EDoom, heavily modified for the A920
//
// Credits:
//
//   Steve Fischer (2005)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Peter van Sebille
//     - http://mobile.yipton.net
//     - Author of EMame for P800/P900 from which this port 
//       came from
//
//===================================================================
//
// Modifed By: Steve Fischer (steve@stevesprojects.com)
//
// (c) Copyright 2004-2005, Steve Fischer
// All Rights Reserved
//
//===================================================================
//
// Author:  Peter van Sebille (peter@yipton.net)
//
// (c) Copyright 2002, Peter van Sebille
// All Rights Reserved
//
//===================================================================

#ifndef __NAVIGATION_H
#define __NAVIGATION_H

#include <e32keys.h>
#include <quartzkeys.h>


typedef struct 
{
	TInt	iPhysicalKey;
	TInt	iGameKey;
} TGameKeyCodeTable;

typedef struct 
{
	TInt	iPhysicalScanCode;
	TInt	iGameScanCode;
} TGameScanCodeTable;

//===============================================
//
// Game key section
//
// All key events sent out use these scan 
// and key codes
//
//===============================================

enum
{ GAME_KEYCODE_UP = 10
, GAME_KEYCODE_DOWN
, GAME_KEYCODE_LEFT
, GAME_KEYCODE_RIGHT
, GAME_KEYCODE_SELECT
, GAME_KEYCODE_BUTTON1
, GAME_KEYCODE_BUTTON2
, GAME_KEYCODE_HOME
, GAME_KEYCODE_SHORTCUT
};

//===============================================
//
// Define the scan codes and key codes used for navigation
// on this device.
//
//===============================================

// Extra ones for virtual keys
#define DEVICE_SCANCODE_EXTRA    EStdKeyApplicationC
#define DEVICE_SCANCODE_ESC      EStdKeyApplicationD
#define DEVICE_SCANCODE_START    EStdKeyApplicationE
#define DEVICE_SCANCODE_SELECT2  EStdKeyApplicationF

//===============================================
// A92x & A1000 Keys
//

// Physical Key Scancodes
#define DEVICE_SCANCODE_UP       EStdKeyDevice4
#define DEVICE_SCANCODE_DOWN     EStdKeyDevice5
#define DEVICE_SCANCODE_LEFT     EStdKeyDevice6
#define DEVICE_SCANCODE_RIGHT    EStdKeyDevice7
#define DEVICE_SCANCODE_SELECT   EStdKeyDevice8
#define DEVICE_SCANCODE_BUTTON1  EStdKeyApplicationA
#define DEVICE_SCANCODE_BUTTON2  EStdKeyApplicationB
#define DEVICE_SCANCODE_HOME     EStdKeyApplication0
#define DEVICE_SCANCODE_SHORTCUT EStdKeyApplication1
#define DEVICE_SCANCODE_VOICE    EStdKeyDeviceA
#define DEVICE_SCANCODE_CAMERA   EStdKeyDeviceB
#define DEVICE_SCANCODE_VOLUP    EStdKeyIncVolume
#define DEVICE_SCANCODE_VOLDN    EStdKeyDecVolume
#define DEVICE_SCANCODE_SEND     EStdKeyYes
#define DEVICE_SCANCODE_END      EStdKeyNo

// Physical Key Keycodes
#define DEVICE_KEYCODE_UP        EKeyDevice4          //(0xF846)
#define DEVICE_KEYCODE_DOWN      EKeyDevice5          //(0xF847)
#define DEVICE_KEYCODE_LEFT      EKeyDevice6          //(0xF848)
#define DEVICE_KEYCODE_RIGHT     EKeyDevice7          //(0xF849)
#define DEVICE_KEYCODE_SELECT    EKeyDevice8          //(0xF84A)
#define DEVICE_KEYCODE_BUTTON1   EKeyApplicationA     //(0xF85C)
#define DEVICE_KEYCODE_BUTTON2   EKeyApplicationB     //(0xF85D)
#define DEVICE_KEYCODE_HOME      EKeyApplication0     //(0xF852)
#define DEVICE_KEYCODE_SHORTCUT  EKeyApplication1     //(0xF853)
#define DEVICE_KEYCODE_VOICE     EKeyDeviceA          //(0xF84C)
#define DEVICE_KEYCODE_CAMERA    EKeyDeviceB          //(0xF84D)
#define DEVICE_KEYCODE_VOLUP     EKeyIncVolume        //(0xF840)
#define DEVICE_KEYCODE_VOLDN     EKeyDecVolume        //(0xF841)
#define DEVICE_KEYCODE_SEND      EKeyYes              //(0xF862)
#define DEVICE_KEYCODE_END       EKeyNo               //(0xF863)

//===============================================
// P8xx & P9xx Keys
//

// Don't know much about the P8xx & P9xx - this is a guess

// Physical Key Scancodes
#define DEVICE_SCANCODE_PXXX_BROWSER     EStdKeyApplication0
#define DEVICE_SCANCODE_PXXX_CAMERA      EStdKeyApplication1
#define DEVICE_SCANCODE_PXXX_JOG_UP      EStdKeyDevice1
#define DEVICE_SCANCODE_PXXX_JOG_DOWN    EStdKeyDevice2
#define DEVICE_SCANCODE_PXXX_JOG_LEFT    EStdKeyDeviceE
#define DEVICE_SCANCODE_PXXX_JOG_RIGHT   EStdKeyDeviceD
#define DEVICE_SCANCODE_PXXX_JOG_INWARD  EStdKeyDevice8

// Physical Key Keycodes
#define DEVICE_KEYCODE_PXXX_BROWSER      EKeyApplication0
#define DEVICE_KEYCODE_PXXX_CAMERA       EKeyApplication1
#define DEVICE_KEYCODE_PXXX_JOG_UP       EKeyDevice1
#define DEVICE_KEYCODE_PXXX_JOG_DOWN     EKeyDevice2
#define DEVICE_KEYCODE_PXXX_JOG_LEFT     EKeyDeviceE
#define DEVICE_KEYCODE_PXXX_JOG_RIGHT    EKeyDeviceD
#define DEVICE_KEYCODE_PXXX_JOG_INWARD   EKeyDevice8


#endif			/* __NAVIGATION_H */


