//===================================================================
//
// File: keybrd.h
//
// From EDoom, moved some video.cpp/h code here for the A920
//
// Credits:
//
//   Steve Fischer (2005)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Peter van Sebille
//     - http://mobile.yipton.net
//     - Author of EMame for P800/P900 from which this port 
//       came from
//
//===================================================================
//
// Modifed By: Steve Fischer (steve@stevesprojects.com)
//
// (c) Copyright 2004-2005, Steve Fischer
// All Rights Reserved
//
//===================================================================
//
// Author:  Peter van Sebille (peter@yipton.net)
//
// (c) Copyright 2001, Peter van Sebille
// All Rights Reserved
//
//===================================================================

#ifndef _KEYBRD_H_
#define _KEYBRD_H_

#include "options.h"

#include <e32base.h>
#include "video.h"
#include "controller.h"

#ifdef USE_VIRTUAL_KEYBOARD

struct TVirtualKey
{
   TInt  iWidth;             // width in pixels
   TInt  iScanCode;
   char *iText;              // text displayed in normal mode
   TInt  iKeyCode;           // generated key code
   char *iShiftText;         // text displayed in when the shift key is pressed
   TInt  iShiftKeyCode;      // generated key code when the shift key is pressed
};

//===============================================
//
// CVirtualKeyboard
//
//===============================================

class CVirtualKeyboard : public CBase
                       , public MGameScreenDrawObserver
                       , public MGameControlRawInputHandler
                       , public MGameControlInputHandler
                       , public MScreenOrientationObserver
{
public:
   ~CVirtualKeyboard();
   static CVirtualKeyboard* NewL(CGameWindow& aGameWindow, CGameController& aGameController);
   
   void SetPosition(const TPoint& aPosition);
   void SetActiveRect(const TRect& aRect){iActiveRect=aRect;}

   void SetKeyCodesAreScanCodes(TBool aEnable){iKeyCodesAreScanCodes = aEnable;}

   void ActivateL();
   void Deactivate();

   TBool IsHotKeyForVirtualKeyboard(TInt aKeyCode){return (aKeyCode == iVkHotKeyKeyCode);}
   void  SetHotKeyForVirtualKeyboard(TInt aKeyCode){iVkHotKeyKeyCode = aKeyCode;}

public:         // implements MGameScreenDrawObserver
   virtual TBool WantDrawToScreen();
   virtual void  PostDrawFrameToScreen(CGameScreenDevice* aDstGameScreenDevice);

public:         // imlements MGameControlRawInputHandler
   virtual TBool ConsumeRawKeyEvent(TInt /*aType*/, const TKeyEvent& /*aKeyEvent*/){return EFalse;}
   virtual TBool ConsumeRawPointerEvent(const TPointerEvent& aPointerEvent);

public:         // imlements MGameControlInputHandler
   virtual void HandleKeyEvent(TInt aType, const TKeyEvent& aKeyEvent);
   virtual void HandlePointerEvent(const TPointerEvent& aPointerEvent);

public:      // implements MScreenOrientationObserver
   virtual void ScreenOrientationChanged(TOrientation aOrientation);

protected:
   CVirtualKeyboard(CGameWindow& aGameWindow, CGameController& aGameController);
   void ConstructL();

   TInt  KeyCode(const TVirtualKey* aVirtualKey);
   TInt  ScanCode(const TVirtualKey* aVirtualKey);
   void  CheckForVirtualKeyboardHotKey(TInt aKeyCode);
   void  HandleVirtualKeyDown(const TVirtualKey* aVirtualKey);
   void  HandleVirtualKeyUp();
   const TVirtualKey* FindVirtualKey(const TPoint& aPoint);
   const TVirtualKey* iKey;

   TBool iCapsMode;
   TBool iShiftMode;
   TBool iSymbolMode;

   TBool iKeyCodesAreScanCodes;

   void  DrawKeyboard();
   void  ClearKeyboard();

   CFbsGameScreenDevice *iBitmap;
   CFont                *iFont;
   TRect                 iRect;
   CGameWindow&          iGameWindow;
   CGameController&      iGameController;
   TBool                 iIsActive;
   TRgb                  iFgColor;
   TRgb                  iBgColor;

   TInt                  iAlpha;
   TInt                  iAlphaInc;

   TRect                 iActiveRect;
   TOrientation          iOrientation;
   TInt                  iVkHotKeyKeyCode;
};

#endif // USE_VIRTUAL_KEYBOARD

#endif // _KEYBRD_H_
