/*******************************************************************
 *
 *	File:		GameEngine.h
 *
 *	Author:		Peter van Sebille (peter@yipton.net)
 *
 *	(c) Copyright 2001, Peter van Sebille
 *	All Rights Reserved
 *
 *******************************************************************/

#ifndef __GAMEENGINE_H
#define __GAMEENGINE_H


#ifdef _UNICODE

#define HEREL2(l)	L#l
#define HEREL1(l)	HEREL2(l)
#define TO_UNI1(s)	L##s
#define TO_UNI(s)	TO_UNI1(s)
#define HERE_STR(m) TO_UNI(__FILE__) L"(" HEREL1(__LINE__) L") : " L##m
#define HERE(m)	TPtrC((const TText *) HERE_STR(m))

#else

#define HEREL2(l)	#l
#define HEREL1(l)	HEREL2(l)
#define HERE_STR   __FILE__ "(" HEREL1(__LINE__) ") : "
#define HERE(m)	TPtrC((const TText *) HERE_STR m)

#endif


#ifdef _DEBUG
	#ifdef __WINS__
		#define EMAME_DEBUGGER_ALWAYS() _asm int 3
	#else
		#define EMAME_DEBUGGER_ALWAYS()
	#endif

	#ifdef __xWINS__
		#define DEBUGGER() _asm int 3
	#else /* __WINS__ */
		#define DEBUGGER()
	#endif
#else /* _DEBUG */
	#define DEBUGGER()
	#define EMAME_DEBUGGER_ALWAYS()
#endif



// simple debugging tool for target
#ifdef __MARM__

#define WAIT_TARGET(des, sec)	\
	User::InfoPrint(des);		\
	User::After(1000 * 1000 * sec);

#else

#define WAIT_TARGET(des, sec);

#endif

#endif /* __GAMEENGINE_H */
