//===================================================================
//
// File:  controller.h
//
// From EDoom, moved some video.cpp/h code here for the A920
//
// Credits:
//
//   Steve Fischer (2005)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Peter van Sebille
//     - http://mobile.yipton.net
//     - Author of EMame for P800/P900 from which this port 
//       came from
//
//===================================================================
//
// Modifed By: Steve Fischer (steve@stevesprojects.com)
//
// (c) Copyright 2005, Steve Fischer
// All Rights Reserved
//
//===================================================================
//
// Author:  Peter van Sebille (peter@yipton.net)
//
// (c) Copyright 2001, Peter van Sebille
// All Rights Reserved
//
//===================================================================

#ifndef _CONTROLLER_H_
#define _CONTROLLER_H_

#include "options.h"

#include <e32base.h>
#include "video.h"

//===============================================
//
// MGameControlInputHandler
//
//===============================================

class MGameControlInputHandler
{
public:
   virtual void HandleKeyEvent(TInt aType, const TKeyEvent& aKeyEvent) = 0;
   virtual void HandlePointerEvent(const TPointerEvent& aPointerEvent) = 0;
};

//===============================================
//
// MGameControlRawInputHandler
//
//===============================================

class MGameControlRawInputHandler
{
public:
   virtual TBool ConsumeRawKeyEvent(TInt aType, const TKeyEvent& aKeyEvent) = 0;
   virtual TBool ConsumeRawPointerEvent(const TPointerEvent& aPointerEvent) = 0;
};

//===============================================
//
// CGameController
//
//===============================================

class CGameController : public CBase
                      , public MGameScreenDrawObserver
                      , public MScreenOrientationObserver
{
public:
   ~CGameController();
   static CGameController* NewL(RWsSession& aWsSession);

   void AddGameControlRawInputHandlerL(MGameControlRawInputHandler& aControlImputConsumser);
   void AddGameControlInputHandlerL(MGameControlInputHandler& aGameControlObserver);
   void RemoveGameControlRawInputHandler(MGameControlRawInputHandler& aControlImputConsumser);
   void RemoveGameControlInputHandler(MGameControlInputHandler& aGameControlObserver);

   void PauseGame(TBool aDoPause);
   void InjectKeyEvent(TInt aEventType, TInt aKeyOrScanKey, TInt aRepeat = 0);

   void SetGameKeymapping(TGameScanCodeTable& aGameScanCodeTable, TGameKeyCodeTable& aGameKeyCodeTable);

   int  IsKeyPressed( unsigned short aScanCode );

   void ResetKeys();

   // Implementation of MGameScreenDrawObserver virtual methods
   virtual void PostDrawFrameToScreen(CGameScreenDevice* aDstGameScreenDevice);

   // Implementation of MScreenOrientationObserver virtual methods
   virtual void ScreenOrientationChanged(TOrientation aOrientation);

protected:
   CGameController(RWsSession& aWsSession) : iWsSession(aWsSession){}
   void ConstructL();

   void MapToGameEvents(TInt aType, TKeyEvent& aKeyEvent);
   TGameScanCodeTable *iGameScanCodeTable;
   TGameKeyCodeTable  *iGameKeyCodeTable;

   TBool          iIsPaused;

   // Raw pointer events
   void HandlePointerEvent(const TPointerEvent& aPointerEvent);
   void HandleKeyEvent(TInt aType, const TKeyEvent& aKeyEvent);

   TKeyEvent TranslateEventForOrientation(TInt aType, const TKeyEvent& aKeyEvent);
   TOrientation   iOrientation;

   // Window Server stuff
   void HandleWsEvent(const TWsEvent& aWsEvent);
   void HandleRedrawEvent(const TWsRedrawEvent& iRedrawEvent);
   void StartWServEvents();
   void PollWServEvents();
   void CancelWServEvents();

   void StoreKeyEvent(TInt aType, const TKeyEvent& aKeyEvent);
   enum { KMaxKeysPressed = 10 };
   TKeyEvent      iKeysPressed[KMaxKeysPressed];

   RWsSession&    iWsSession;
   TRequestStatus iWsEventStatus;
   TRequestStatus iRedrawEventStatus;
   TWsEvent       iWsEvent;
   TWsRedrawEvent iRedrawEvent;

   CArrayPtrFlat<MGameControlInputHandler>    *iGameControlInputHandlers;
   CArrayPtrFlat<MGameControlRawInputHandler> *iGameControlRawInputHandlers;
};

//===============================================
//
// CSmartPenInputHandler
//
//===============================================

class CSmartPenInputHandler : public CBase
                            , public MGameControlInputHandler
                            , public MGameScreenDrawObserver
                            , public MScreenOrientationObserver
{
public:
   ~CSmartPenInputHandler();
   TBool IsPenDown(){return iPenDown;}

   // Implementation of MGameControlInputHandler virtual methods
   virtual void HandleKeyEvent(TInt /*aType*/, const TKeyEvent& /*aKeyEvent*/){};
   virtual void HandlePointerEvent(const TPointerEvent& aPointerEvent);

   // Implementation of MGameScreenDrawObserver virtual methods
   virtual void PostDrawFrameToScreen(CGameScreenDevice* aDstGameScreenDevice);

   // Implementation of MScreenOrientationObserver virtual methods
   virtual void ScreenOrientationChanged(TOrientation aOrientation){iOrientation=aOrientation;}

protected:
   virtual void HandleMoveEvent(TInt aX, TInt aY) = 0;
   virtual void HandleUpEvent() = 0;
   virtual void HandleDownEvent() = 0;

protected:
   CSmartPenInputHandler(CGameWindow& aGameWindow, CGameController& aGameController);
   void ConstructL();

   void SimulateAutoMove();
   void PenMoveEvent(const TPoint& aPosition, TBool aStrict = ETrue);
   void PenUpEvent(const TPoint& aPosition);
   void PenDownEvent(const TPoint& aPosition);
   TPoint TransformDeltaForOrientation(const TPoint& aPoint);

   TOrientation     iOrientation;

   TPoint           iLastPenPosition;
   TPoint           iDownPenPosition;
   TPoint           iLastDelta;
   TBool            iPenDown;
   TInt             iEventCount;

   TBool            iAutoX;
   TBool            iAutoY;

   TInt             iFramesThreshHold;
   TInt             iFramesRepeatThreshHold;
   TInt             iFramesMoveThreshHold;
   TInt             iFrameCount;

   CGameController& iGameController;
   CGameWindow&     iGameWindow;
};

//===============================================
//
// CSmartPenToKeyInputHandler
//
//===============================================

class CSmartPenToKeyInputHandler : public CSmartPenInputHandler
{
public:
   static CSmartPenToKeyInputHandler* NewL(CGameWindow& aGameWindow, CGameController& aGameController);

   void CanDo_X_And_Y_AtTheSameTime(TBool aCanDo) { iCanDo_X_And_Y_AtTheSameTime = aCanDo; }
   void AutoForward(TBool aEnable)                { iEnableAutoForward=aEnable;iCanDo_X_And_Y_AtTheSameTime = ETrue; }

protected:
   virtual void HandleMoveEvent(TInt aX, TInt aY);
   virtual void HandleUpEvent();
   virtual void HandleDownEvent();

   void HandleVertMoveEvent(TInt aNewVertMove);
   void HandleHorMoveEvent(TInt aNewHorMove);

protected:
   CSmartPenToKeyInputHandler(CGameWindow& aGameWindow, CGameController& aGameController);
   void ConstructL();

   void InjectKeyEvent(TInt aEventType, TInt aKeyOrScanKey, TInt aRepeat=0);

   TBool  iCanDo_X_And_Y_AtTheSameTime;

   TInt   iHorMove;
   TInt   iVertMove;

   TInt   iLeftCount;
   TInt   iRightCount;
   TInt   iUpCount;
   TInt   iDownCount;

   TBool  iIsMovingVert;
   TBool  iEnableAutoForward;
   TPoint iLastPenPosition1;
};

#endif _CONTROLLER_H_
