//===================================================================
//
// File: buttons.h
//
// From EDoom, moved some video.cpp/h code here for the A920
//
// Credits:
//
//   Steve Fischer (2005)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Peter van Sebille
//     - http://mobile.yipton.net
//     - Author of EMame for P800/P900 from which this port 
//       came from
//
//===================================================================
//
// Modifed By: Steve Fischer (steve@stevesprojects.com)
//
// (c) Copyright 2005, Steve Fischer
// All Rights Reserved
//
//===================================================================
//
// Author:  Peter van Sebille (peter@yipton.net)
//
// (c) Copyright 2001, Peter van Sebille
// All Rights Reserved
//
//===================================================================

#ifndef _BUTTONS_H_
#define _BUTTONS_H_

#include "options.h"

#include <e32base.h>
#include "video.h"
#include "controller.h"

#ifdef USE_VIRTUAL_BUTTONS

struct TVirtualButton
{
   TInt   iScanCode;
   TInt   iTlX;
   TInt   iTlY;
   TInt   iBrX;
   TInt   iBrY;
   TInt   iBitmapIdxReleased;
   TInt   iBitmapIdxPressed;
};

//===============================================
//
// CVirtualKeyboard
//
//===============================================

class CVirtualButtons : public CBase
                      , public MGameScreenDrawObserver
                      , public MGameControlRawInputHandler
                      , public MScreenOrientationObserver
{
public:
   ~CVirtualButtons();
   static CVirtualButtons* NewL( CGameWindow          &aGameWindow
                               , CGameController      &aGameController
                               , const TVirtualButton *aVirtualButtons
                               );
   
   void ActivateL( void );
   void Deactivate( void );

   // Implements MGameScreenDrawObserver
   virtual TBool WantDrawToScreen();
   virtual void  PostDrawFrameToScreen(CGameScreenDevice* aDstGameScreenDevice);

   // Implements MGameControlRawInputHandler
   virtual TBool ConsumeRawKeyEvent(TInt /*aType*/, const TKeyEvent& /*aKeyEvent*/){return EFalse;}
   virtual TBool ConsumeRawPointerEvent(const TPointerEvent& aPointerEvent);

   // Implements MScreenOrientationObserver
   virtual void ScreenOrientationChanged(TOrientation aOrientation);

protected:
   CVirtualButtons( CGameWindow          &aGameWindow
                  , CGameController      &aGameController
                  , const TVirtualButton *aVirtualButtons
                  );
   void  ConstructL( void );

   void  ClearButtons( void );
   void  DetermineButtonRectL( void );
   void  DrawButtons( void );
   const TVirtualButton* FindVirtualButton(const TPoint& aPoint);
   void  HandleVirtualButtonDown(const TVirtualButton* aVirtualButton);
   void  HandleVirtualButtonUp( void );

   CFbsGameScreenDevice *iBitmap;
   TRect                 iRect;
   CGameWindow&          iGameWindow;
   CGameController&      iGameController;
   const TVirtualButton *iVirtualButtons;
   const TVirtualButton *iButton;

   TBool                 iIsActive;
   TOrientation          iOrientation;

   CArrayPtrFlat<CFbsBitmap> *iButtonBitmaps;
};

#endif // USE_VIRTUAL_BUTTONS

#endif // _BUTTONS_H_
