//===================================================================
//
// File:  audio_motorola.h
//
// Nearly entirely re-written for EMame/EDoom 
//
// Credits:
//
//   Steve Fischer (2004)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Peter van Sebille
//     - http://mobile.yipton.net
//     - Author of EMame for P800/P900 from which this port 
//       came from
//
//===================================================================
//
// Modifed By: Steve Fischer (steve@stevesprojects.com)
//
//	(c) Copyright 2004-2005, Steve Fischer
//	All Rights Reserved
//
//===================================================================
//
// Author:  Peter van Sebille (peter@yipton.net)
//
//	(c) Copyright 2001, Peter van Sebille
//	All Rights Reserved
//
//===================================================================

#ifndef __AUDIO_MOTOROLA_H
#define __AUDIO_MOTOROLA_H

#include <cmaudiofb.h>

#include <e32base.h>
#include <w32std.h>

//===================================================================
//
// CGameAudio class
//
//===================================================================

const TInt KAudioSampleRate    = EMAudioFBSampleRate8K;
const TInt KBufferTime         = 50;  // milliseconds
const TInt KQueueTime          = 500; // milliseconds
const TInt KSamplesPerBuffer   = (EMAudioFBSampleRate8K/(1000/KBufferTime));
const TInt KSoundBuffers       = (KQueueTime/KBufferTime);
const TInt KAudioWatchdogCount = 15;

class CGameAudio : public CBase, public MMAudioFBObserver, public MMAudioACObserver
{
public:
   static CGameAudio* NewL( TBool aStereo, TInt aSamplesPerFrame );
	~CGameAudio( void );

   void CreateSoundApiL( void );
   void DestroySoundApi( void );

   TBool IsSoundOn( void );
   void SetSoundOn( TBool aEnable );
   TInt Write( TUint16 *aPtr, TInt aLen );

   enum { EIncreaseMasterVolume, EDecreaseMasterVolume };
   void SetMasterVolume( TInt aUpDn );

   // Implementation of MMAudioFBObserver
   void OnEvent( TMAudioFBCallbackState aState, TInt aError );
   void OnEvent( TMAudioFBCallbackState aState, TInt aError, TDes8* aBuffer );

   // Implementation of MMAudioACObserver
   void OnEvent( TMAudioACCallbackState aState, TInt aError );

private:
   CGameAudio( TBool aStereo, TInt aSamplesPerFrame );
   void ConstructL( void );

   void QueueBuffer( TInt aBufferIdx );

   class CQueueBuffer : public CActive
   {
   public:
      CQueueBuffer();
      ~CQueueBuffer() { Cancel(); };

      void SetParent( CGameAudio *aParent );
      void Activate();
      void Queue( TInt aBufIdx );

   private:
      void RunL( void );
      void DoCancel( void );
      TInt RunError( TInt aError );

      TInt            iThreadId;
      CGameAudio     *iParent;
      TRequestStatus *iStatusPtr;
      TInt            iBufferIdx;
   };
   friend CQueueBuffer;
   
   class CDestroyApi : public CActive
   {
   public:
      CDestroyApi();
      ~CDestroyApi() { Cancel(); };

      void SetParent( CGameAudio *aParent );
      void Activate();
      void Destroy();

   private:
      void RunL( void );
      void DoCancel( void );
      TInt RunError( TInt aError );

      TInt            iThreadId;
      CGameAudio     *iParent;
      TRequestStatus *iStatusPtr;
   };
   friend CDestroyApi;

   class CRestartApi : public CActive
   {
   public:
      CRestartApi();
      ~CRestartApi() { Cancel(); };

      void SetParent( CGameAudio *aParent );
      void Activate();
      void Restart();

   private:
      void RunL( void );
      void DoCancel( void );
      TInt RunError( TInt aError );

      TInt            iThreadId;
      CGameAudio     *iParent;
      TRequestStatus *iStatusPtr;
   };
   friend CRestartApi;

   CQueueBuffer iQueueAO;
   CDestroyApi  iDestroyAO;
   CRestartApi  iRestartAO;

   CMAudioFB *iPcmServer;
   CMAudioFB *iDeleteMe;
   CMAudioAC *iAudioCtrl;

   TInt    iSamplesPerFrame;
   TBool   iStereo;
   TInt    iMaxFrameSize;

   TBool   iACConnect;
	TBool   iSoundOn;
	TBool   iConnected;
	TBool   iDecoding;

   enum { EBufferFree, EBufferInUse };

	HBufC8 *iPcmBuffers[KSoundBuffers];
   TPtr8  *iPcmBufPtrs[KSoundBuffers];
   TUint8  iPcmBufFlag[KSoundBuffers];
   TInt    iBufferSize;
   TInt    iCurrentBuffer;
   TInt    iCurrentOffset;

   TInt    iQueueCnt;

   TInt    iWatchDog;
};

#endif  /* __AUDIO_MOTOROLA_H */
