//===================================================================
//
// File:  audio.h
//
// Nearly entirely re-written for ENes 
//
// Credits:
//
//   Steve Fischer (2004)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Peter van Sebille
//     - http://mobile.yipton.net
//     - Author of EMame for P800/P900 from which this port 
//       came from
//
//===================================================================
//
// Modifed By: Steve Fischer (steve@stevesprojects.com)
//
//	(c) Copyright 2004-2005, Steve Fischer
//	All Rights Reserved
//
//===================================================================
//
// Author:  Peter van Sebille (peter@yipton.net)
//
//	(c) Copyright 2001, Peter van Sebille
//	All Rights Reserved
//
//===================================================================

#ifndef __AUDIO_H
#define __AUDIO_H

#include <e32base.h>
#include <w32std.h>

#ifdef AUDIO_MEDIASERVER
#include "audio_mediaserver.h"
#else // AUDIO_MOTOROLA
#include "audio_motorola.h"
#endif

//===================================================================
//
//  CAudioWatcher Class Definition
//
//  The creator thread must have an object of this
//  class to manage the audio thread
//
//===================================================================

class CAudioWatcher : public CActive
{
public:
    CAudioWatcher( void );
   ~CAudioWatcher( void );

   void        ActivateAudio( TBool aStereo, TInt aSamplesPerFrame );
   void        DeactivateAudio( void );

   TBool       IsAudioActive( void ) { return ( iGameAudio != NULL ); }
   CGameAudio* GameAudio( void )     { return ( iGameAudio );         }

private:
   static TInt ThreadStarter( TAny *aPtr );
   void ThreadMainL( CAudioWatcher *aWatcher );

   // Implement CActive
   void RunL( void );
   void DoCancel( void );
   TInt RunError( TInt aError );

   RThread     iAudioThread;
   TInt        iThreadCount;
   CGameAudio *iGameAudio;
   TBool       iStereo;
   TInt        iSamplesPerFrame;
};

#endif  /* __AUDIO_H */
