//===================================================================
//
// File:  audio.cpp
//
// Nearly entirely re-written for ENes 
//
// Credits:
//
//   Steve Fischer (2004)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Peter van Sebille
//     - http://mobile.yipton.net
//     - Author of EMame for P800/P900 from which this port 
//       came from
//
//===================================================================
//
// Modifed By: Steve Fischer (steve@stevesprojects.com)
//
//	(c) Copyright 2004-2005, Steve Fischer
//	All Rights Reserved
//
//===================================================================
//
// Author:  Peter van Sebille (peter@yipton.net)
//
//	(c) Copyright 2001, Peter van Sebille
//	All Rights Reserved
//
//===================================================================

#include <e32svr.h>
#include "audio.h"

#define __AUD_DEBUG(x...)

//===================================================================
//
//  CAudioWatcher Class Definition
//
//  The creator thread must have an object of this
//  class to manage the audio thread
//
//===================================================================

CAudioWatcher::CAudioWatcher( void ) : CActive( EPriorityHigh )
{
   CActiveScheduler::Add(this);
   iGameAudio       = NULL;
   iThreadCount     = 0;
   iStereo          = EFalse;
   iSamplesPerFrame = 0;
}

CAudioWatcher::~CAudioWatcher( void )
{
   DeactivateAudio();
   Cancel();
}

void CAudioWatcher::ActivateAudio
( TBool aStereo
, TInt  aSamplesPerFrame
) 
{
   __AUD_DEBUG( _L("CAudioWatcher::ActivateAudio"));

   if ( !iGameAudio && !IsActive() )
   {
      iStereo          = aStereo;
      iSamplesPerFrame = aSamplesPerFrame;
      
      TBuf<32>   thread_name;
      thread_name.Format(_L("Audio%d"), iThreadCount++);
      
      TInt err = iAudioThread.Create( thread_name
                                    , CAudioWatcher::ThreadStarter
                                    , 0x00001000
                                    , 0x00001000
                                    , 0x00100000
                                    , this
                                    , EOwnerThread
                                    );
      
      __AUD_DEBUG( _L("AudioThreadErr/%d"), err );
      
      if ( err == KErrNone )
      {
         SetActive();
         iAudioThread.Logon( iStatus );
         iAudioThread.SetPriority( EPriorityMuchMore );
         iAudioThread.Resume();
      }
      else
      {
         // Just to make sure
         iGameAudio = NULL;
      }
   }
   else
   {
      __AUD_DEBUG( _L("ActivateAudio - Failed to activate"));
   }
}

void CAudioWatcher::DeactivateAudio( void )
{
   __AUD_DEBUG( _L("CAudioWatcher::DeactivateAudio"));

   if ( iGameAudio )
   {
      __AUD_DEBUG( _L("DeactivateAudio 1"));
      Cancel();
      iAudioThread.Terminate( KErrCancel );
      iGameAudio = NULL;
   }
}

TInt CAudioWatcher::ThreadStarter( TAny *aPtr )
{
   __AUD_DEBUG( _L("CAudioWatcher::ThreadStarter") );

   CAudioWatcher *watcher = (CAudioWatcher*) aPtr;
   CTrapCleanup  *cleanup = CTrapCleanup::New();

   TRAPD( err, watcher->ThreadMainL( watcher ) );

   delete cleanup;

   __AUD_DEBUG( _L("ThreadStarter exit") );

   return(err);
}

void CAudioWatcher::ThreadMainL( CAudioWatcher *aWatcher )
{
   __AUD_DEBUG( _L("CAudioWatcher::ThreadMainL") );

   CActiveScheduler *active_scheduler = new (ELeave) CActiveScheduler();
   CleanupStack::PushL( active_scheduler );
   CActiveScheduler::Install( active_scheduler );

   iGameAudio = CGameAudio::NewL( iStereo, iSamplesPerFrame);

   CActiveScheduler::Start();

   // Cleanup
   if ( iGameAudio )
   {
      delete iGameAudio;
      iGameAudio = NULL;
   }

   // Pop off and destroy the active_scheduler
   CleanupStack::PopAndDestroy();

   __AUD_DEBUG( _L("ThreadMainL exit") );
}

void CAudioWatcher::RunL( void )
{
   __AUD_DEBUG( _L("CAudioWatcher::RunL %d"), iStatus );

   iGameAudio = NULL;
}

void CAudioWatcher::DoCancel( void )
{
   __AUD_DEBUG( _L("CAudioWatcher::DoCancel") );

   iAudioThread.LogonCancel( iStatus );
}

TInt CAudioWatcher::RunError( TInt aError )
{
   User::Panic( _L("CAudioWatcher"), aError );
   return ( ETrue );
}

