//===================================================================
//
// File:  interface.h
//
// Defines the interface structure for the data passed between the
// app and the exe
//
// Credits:
//
//   Steve Fischer (2005) 
//     - Added for ENes
//
//===================================================================
//
//	Author:	Steve Fischer (steve@stevesprojects.com)
//
//	(c) Copyright 2005, Steve Fischer
//	All Rights Reserved
//
//===================================================================

#ifndef __INTERFACE_H__
#define __INTERFACE_H__

enum TAppToExeRotation
{ EAppToExeRotationNormal
, EAppToExeRotationLeft
, EAppToExeRotationRight
};

enum TAppToExeDisplayMode
{ EAppToExeDisplayFitToScreen
, EAppToExeDisplayCenter
};

enum TAppToExeButton
{ EAppToExeButtonNone
, EAppToExeButtonVirtualBlue
, EAppToExeButtonVirtualGreen
, EAppToExeButtonVirtualPurple
, EAppToExeButtonA92xA1000GameA
, EAppToExeButtonA92xA1000GameB
, EAppToExeButtonA92xA1000Select
, EAppToExeButtonA92xA1000Shortcut
, EAppToExeButtonA92xA1000Browser
, EAppToExeButtonA92xSpeakerphone
, EAppToExeButtonA92xVoiceNotes
, EAppToExeButtonA1000Speakerphone
, EAppToExeButtonA1000Camera
, EAppToExeButtonPxxxBrowser
, EAppToExeButtonPxxxCamera
, EAppToExeButtonPxxxJogUp
, EAppToExeButtonPxxxJogDown
, EAppToExeButtonPxxxJogLeft
, EAppToExeButtonPxxxJogRight
, EAppToExeButtonPxxxJogInward
};

const TUint32 GameOptionVersion = 0x102;
// Versions:
// - 0x100 = Initial w/Rotation & Sound
// - 0x101 = Addition of Start/Select/GameA/GameB Buttons
// - 0x102 = Addition of Turbo settings, Display Mode, Disable Send/End, Combo A+B Key
typedef struct TGameOptions
{
   TUint32              iVersion;
   TAppToExeRotation    iRotation;
   TAppToExeDisplayMode iDisplayMode;
   TBool                iSound;
   TAppToExeButton      iButtonStart;
   TAppToExeButton      iButtonSelect;
   TAppToExeButton      iButtonGameA;
   TAppToExeButton      iButtonGameB;
   TAppToExeButton      iButtonComboAB;
   TBool                iTurboGameA;
   TBool                iTurboGameB;
   TUint32              iTurboSpeed;
   TBool                iDisableSendEnd;
};

typedef struct TAppToExeInterface
{
   TGameOptions iOptions;
   char         iFilename[256];
};

#endif  /* __INTERFACE_H__ */