//===================================================================
//
// File:  engine.h
//
// From EDoom & EMame, heavily modified
//
// Credits:
//
//   Steve Fischer (2005) 
//     - Ported & integrated all the below code to ENes for the A920
//
//   Peter van Sebille (2002-2003)
//     - http://mobile.yipton.net
//     - Author of EDoom & EMame for P800/P900 for which much of the
//       front-end GUI application came from
//
//===================================================================
//
//	Author:	Peter van Sebille (peter@yipton.net)
//
//	(c) Copyright 2002, Peter van Sebille
//	All Rights Reserved
//
//===================================================================

#ifndef __ENGINE_H
#define __ENGINE_H

#include <e32base.h>
#include <badesca.h>
#include <f32file.h>

#include "interface.h"

//===================================================================
//
//  MGameWatcher Class Declaration
//
//===================================================================

class MGameWatcher
{
public:
	virtual void NotifyGameFinished() = 0;
};

//===================================================================
//
//  CGameEngine Class Declaration
//
//===================================================================

class CGameEngine : public CBase
{
public:
	static CGameEngine* NewL( RFs& aFs );

   ~CGameEngine();

   void FindRomsL();
   TInt GetRomName( TInt aIndex, TDes& aName );
   TInt GetRomFilename( TInt aIndex, TDes& aFilename );
   TInt GetRomIndex( const TDesC& aName );
   TInt NoOfRoms();

   TGameOptions GameOptions( void ) { return ( iOptions ); }
   void SetGameOptions( TGameOptions &aOptions );

private:
   CGameEngine( RFs& aFs );
   void ConstructL();

   void CheckDirL( const TDesC& aDir );

   void DefaultOptions( void );
   void LoadGameOptions( void );
   void SaveGameOptions( void );

   RFs&            iFs;
   CDesCArrayFlat* iRomNameArray;

   TGameOptions    iOptions;
};

//===================================================================
//
//  CGameRunner Class Declaration
//
//===================================================================

class CGameRunner : public CActive
{
public:
	static CGameRunner* NewL( MGameWatcher& aGameWatcher, CGameEngine& aGameEngine );
	~CGameRunner();

	void RunGameL( const TDesC& aFilename );
	void TerminateGame(TBool aNotifyObserver = ETrue);
	void ResumeGame();

protected:
	CGameRunner( MGameWatcher& aGameWatcher, CGameEngine& aGameEngine );
	void ConstructL();

	virtual void RunL();
	virtual void DoCancel();

	void DoRunGameL();
	void ShutdownGame();

	MGameWatcher&   iGameWatcher;
   CGameEngine&    iGameEngine;
	RThread         iThread;
   RChunk          iChunk;

   TFileName       iGameFilename;
};

#endif