//===================================================================
//
// File:  dialogs.h
//
// From EDoom & EMame, heavily modified
//
// Credits:
//
//   Steve Fischer (2005) 
//     - Ported & integrated all the below code to ENes for the A920
//
//   Peter van Sebille (2002-2003)
//     - http://mobile.yipton.net
//     - Author of EDoom & EMame for P800/P900 for which much of the
//       front-end GUI application came from
//
//===================================================================
//
//	Author:	Peter van Sebille (peter@yipton.net)
//
//	(c) Copyright 2002, Peter van Sebille
//	All Rights Reserved
//
//===================================================================

#ifndef __DIALOGS_H
#define __DIALOGS_H

#include <eikenv.h>
#include <eikdialg.h>
#include <eiktxlbx.h>
#include <eiktxlbm.h>
#include <eikdlgtb.h>
#include <eiklabel.h>
#include <eikchlst.h>
#include <eikchkbx.h>
#include <eikedwob.h>

class CRichText;
class CEikRichTextEditor;
class CGameRunner;
class CGameEngine;

//===================================================================
//
//  CSimpleTextInfoDialog Class Declaration
//
//===================================================================

class CSimpleTextInfoDialog : public CEikDialog, public MEikEdwinSizeObserver
{
public:
	CSimpleTextInfoDialog(TInt aTextIdOne = -1, TInt aRichTextCtlIdOne = -1, 
		TInt aTextIdTwo = -1, TInt aRichTextCtlIdTwo = -1,
		TBool aSimpleTextResIdOneIsArray = EFalse, TBool aSimpleTextResIdTwoIsArray = EFalse
		);
	void SetDialogBackground(TBool aEnable){iSetDialogBackground=aEnable;}
	void WantVertScrollbar(TBool aEnable){iWantVertScrollbar=aEnable;}
public:			// implements MEikEdwinSizeObserver
	virtual TBool HandleEdwinSizeEventL(CEikEdwin* aEdwin, TEdwinSizeEvent aEventType, TSize aDesirableEdwinSize);

protected: // framework
   void PreLayoutDynInitL();
	void PostLayoutDynInitL();

protected:	// new stuff
	virtual void ShowTextL(CRichText& aRichText, TInt aRichTextCtlId, TInt aResId);
	virtual void PreLayoutDynInitRichTextL(CEikRichTextEditor& aRichTextEditor, TInt aRichTextCtlId, TInt aResId);

	void ShowSimpleTextL(const TDesC& aSimpleText, CRichText& aRichText);

	TInt	iSimpleTextResIdOne;
	TInt	iSimpleTextResIdTwo;
	TInt	iRichTextCtlIdOne;
	TInt	iRichTextCtlIdTwo;
	TBool	iSimpleTextResIdOneIsArray;
	TBool	iSimpleTextResIdTwoIsArray;
	TBool	iSetDialogBackground;
	TBool	iWantVertScrollbar;
};

//===================================================================
//
//  CGameSetupDialog Class Declaration
//
//===================================================================

class CGameSetupDialog : public CEikDialog
{
public:
	CGameSetupDialog( CGameEngine& aGameEngine );

protected: // framework
   void  PreLayoutDynInitL();
	void  SetSizeAndPositionL(const TSize& aSize);
   TBool OkToExitL(TInt aKeycode);

   CGameEngine& iGameEngine;
};

//===================================================================
//
//  CGameRunningDialog Class Declaration
//
//===================================================================

class CGameRunningDialog : public CEikDialog
{
public:
	CGameRunningDialog(CGameRunner& aGameRunner);

protected: // framework
   void PreLayoutDynInitL();
	void HandleControlStateChangeL(TInt aControlId);

	CGameRunner&		iGameRunner;
};

//===================================================================
//
//  CAboutDialog Class Declaration
//
//===================================================================

class CAboutDialog : public CSimpleTextInfoDialog
{
public:
	CAboutDialog();
protected:	// from CSimpleTextInfoDialog
	virtual void ShowTextL(CRichText& aRichText, TInt aRichTextCtlId, TInt aResId);
};

//===================================================================
//
//  CPlayListDialog Class Declaration
//
//===================================================================

class CPlayListDialog : public CEikDialog
{
public:
   CPlayListDialog( CGameEngine *aEngine, TInt& aGameToRun ); 

protected:
   void PreLayoutDynInitL();
   void PostLayoutDynInitL();

   void HandleControlStateChangeL(TInt aControlId);
   void SetSizeAndPositionL(const TSize& aSize);
   TInt GameIndex();

   TBool OkToExitL(TInt aKeycode);

   CGameEngine* iEngine;
   TInt&        iGameToRun;
   TInt         iTitleResId;
};

#endif			/* __DIALOGS_H */