//===================================================================
//
// File:  app.h
//
// From EDoom & EMame, heavily modified
//
// Credits:
//
//   Steve Fischer (2005) 
//     - Ported & integrated all the below code to ENes for the A920
//
//   Peter van Sebille (2002-2003)
//     - http://mobile.yipton.net
//     - Author of EDoom & EMame for P800/P900 for which much of the
//       front-end GUI application came from
//
//===================================================================
//
//	Author:	Peter van Sebille (peter@yipton.net)
//
//	(c) Copyright 2001, Peter van Sebille
//	All Rights Reserved
//
//===================================================================

#ifndef __APP_H
#define __APP_H

#include <coecntrl.h>
#include <coeccntx.h>
#include <coemain.h>

#include <eikappui.h>
#include <eikapp.h>
#include <eikdoc.h>

#include "Engine.h"
#include "ENes.hrh"

const TUid KUidENesApp = { 0x101FFFAA };

class CWsBitmap;
class CGameRunningDialog;

//===================================================================
//
//  CENesDocument Class Declaration
//
//===================================================================

class CENesDocument : public CEikDocument
{
public:
	~CENesDocument();
	CENesDocument(CEikApplication& aApp);
	void ConstructL();

private: // from CEikDocument
	CEikAppUi* CreateAppUiL();
};

//===================================================================
//
//  CENesAppView Class Declaration
//
//===================================================================

class CENesAppView : public CCoeControl, public MCoeControlBrushContext
{
public:
	~CENesAppView();
	void ConstructL(const TRect& aRect);
private:
	void Draw(const TRect& /*aRect*/) const;

	CWsBitmap*	iBgImage;
	TPoint		iImagePosition;
};

//===================================================================
//
//  CENesAppUi Class Declaration
//
//===================================================================

class CENesAppUi : public CEikAppUi, public MGameWatcher
{
public:
	CENesAppUi();
	~CENesAppUi();

   void ConstructL();

   // Implements MGameWatcher
	void NotifyGameFinished();

protected:
   // from CEikAppUi
	void HandleCommandL(TInt aCommand);

protected:
	void DisplayAboutDialogL();
   void DisplayOptionsDialogL();
	void DisplayControlsHelpDialogL();
	void DisplayControlsRomFilesDialogL();
   void DisplayPlayListL();

	void StopGame();
	void RunGameL();

	CGameRunningDialog* iGameRunningDialog;
	CGameRunner*        iGameRunner;
   CGameEngine*        iGameEngine;
   TInt                iGameToRun;

   RFs                 iFs;

private:
	CENesAppView* iAppView;
};

//===================================================================
//
//  CENesApplication Class Declaration
//
//===================================================================

class CENesApplication : public CEikApplication
{
private: // from CApaApplication
	CApaDocument* CreateDocumentL();
	TUid AppDllUid() const;
};

#endif
