//===================================================================
//
// File:  app.cpp
//
// From EDoom & EMame, heavily modified
//
// Credits:
//
//   Steve Fischer (2005) 
//     - Ported & integrated all the below code to ENes for the A920
//
//   Peter van Sebille (2002-2003)
//     - http://mobile.yipton.net
//     - Author of EDoom & EMame for P800/P900 for which much of the
//       front-end GUI application came from
//
//===================================================================
//
//	Author:	Peter van Sebille (peter@yipton.net)
//
//	(c) Copyright 2001, Peter van Sebille
//	All Rights Reserved
//
//===================================================================

#include "app.h"
#include <enes.rsg>
#include <enes.mbg>
#include <eikenv.h>
#include <eikdialg.h>
#include <gulutil.h>

#include "Dialogs.h"

#define __APP_DEBUG(x...)

_LIT(KAppOnC,    "C:\\System\\Apps\\Enes\\");
_LIT(KRomDirOnC, "C:\\Documents\\Media Files\\Document\\NESROMS\\");
_LIT(KRomDirOnD, "D:\\Media Files\\Document\\NESROMS\\");

//===================================================================
//
//  CENesDocument Class Definition
//
//===================================================================

CENesDocument::CENesDocument(CEikApplication& aApp) : CEikDocument(aApp)
{
}

CENesDocument::~CENesDocument()
{
}

void CENesDocument::ConstructL()
{
}

CEikAppUi* CENesDocument::CreateAppUiL()
{
   return new(ELeave) CENesAppUi;
}

//===================================================================
//
//  CENesAppView Class Definition
//
//===================================================================

void CENesAppView::ConstructL(const TRect& aRect)
{
   CreateWindowL();
   SetRect(aRect);
   ActivateL();

   /*
    * Load background image
    */
   TBuf<1> name = _L("*");
   TRAPD(err, iBgImage = CEikonEnv::Static()->CreateBitmapL(name, EMbmEnesEnes));
   if (iBgImage)
   {
      iImagePosition.iX = (aRect.Size().iWidth - iBgImage->SizeInPixels().iWidth) / 2;
      iImagePosition.iY = ((aRect.Size().iHeight - iBgImage->SizeInPixels().iHeight) / 2) - 20;
      if ( iImagePosition.iY < 0 )
      {
         iImagePosition.iY = 0;
      }
   }
}

CENesAppView::~CENesAppView()
{
   delete iBgImage;
}

void CENesAppView::Draw(const TRect& aRect) const
{
   CWindowGc& gc = SystemGc();

   if (iBgImage)
   {
      gc.DrawBitmap(iImagePosition, iBgImage);
      DrawUtils::ClearBetweenRects(gc, Rect(), TRect(iImagePosition, iBgImage->SizeInPixels()));
   }
   else
      gc.Clear(aRect);
}

//===================================================================
//
//  CENesAppUi Class Definition
//
//===================================================================

CENesAppUi::CENesAppUi()
{
   iAppView    = NULL;
   iGameEngine = NULL;

   iGameToRun  = -1;
}

CENesAppUi::~CENesAppUi()
{
   delete iGameEngine;
   delete iAppView;
   iFs.Close();
}

void CENesAppUi::ConstructL()
{
	iFs.Connect();

	iFs.MkDirAll(KAppOnC);
   iFs.MkDirAll(KRomDirOnC);
   iFs.MkDirAll(KRomDirOnD);

   BaseConstructL();
   iAppView = new (ELeave) CENesAppView;
   iAppView->ConstructL(ClientRect());

   iGameEngine = CGameEngine::NewL( iFs );
}

void CENesAppUi::HandleCommandL(TInt aCommand)
{
   __APP_DEBUG( _L("HandleCommandL/%d"), aCommand );

   switch (aCommand)
   {
      case EEikCmdExit: 
         Exit();
         break;

      case EEikCmdENesPlay:
         DisplayPlayListL();
         break;

      case EEikCmdENesOpts:
         DisplayOptionsDialogL();
         break;

      case EEikCmdENesAbout:
         DisplayAboutDialogL();
         break;

      case EEikCmdENesControlsHelp:
         DisplayControlsHelpDialogL();
         break;

      case EEikCmdENesRomFilesHelp:
         DisplayControlsRomFilesDialogL();
         break;
   }
}

void CENesAppUi::DisplayAboutDialogL()
{
   CEikDialog*	dialog = new(ELeave) CAboutDialog;
   dialog->ExecuteLD(R_DIALOG_ABOUT);
}

void CENesAppUi::DisplayOptionsDialogL()
{
   CEikDialog*	dialog = new(ELeave) CGameSetupDialog( *iGameEngine );
   dialog->ExecuteLD(R_DIALOG_GAME_SETUP);
}

void CENesAppUi::DisplayControlsHelpDialogL()
{
   CSimpleTextInfoDialog*	dialog = new(ELeave) CSimpleTextInfoDialog(R_SIMPLE_TEXT_ENES_CONTROLS_HELP, 1, -1, -1, ETrue);
   dialog->ExecuteLD(R_DIALOG_DISPLAY_ENES_HELP);
}

void CENesAppUi::DisplayControlsRomFilesDialogL()
{
   CSimpleTextInfoDialog*	dialog = new(ELeave) CSimpleTextInfoDialog(R_SIMPLE_TEXT_ENES_ROMFILES_HELP, 1, -1, -1, ETrue);
   dialog->ExecuteLD(R_DIALOG_DISPLAY_ENES_HELP);
}

void CENesAppUi::DisplayPlayListL()
{
   __APP_DEBUG( _L("+DisplayPlayListL") );

   iGameEngine->FindRomsL();

   if ( iGameEngine->NoOfRoms() > 0 )
	{
		CEikDialog*	dialog = new (ELeave) CPlayListDialog( iGameEngine, iGameToRun );
      if (dialog->ExecuteLD(R_DIALOG_PLAY_LIST))
		{
         __APP_DEBUG( _L(" DisplayPlayListL - Run/%d"), iGameToRun );

			RunGameL();
		}
	}
   __APP_DEBUG( _L("-DisplayPlayListL") );
}

void CENesAppUi::NotifyGameFinished()
{
   StopGame();
}

void CENesAppUi::StopGame()
{
   delete iGameRunningDialog;
   iGameRunningDialog = NULL;
   delete iGameRunner;
   iGameRunner = NULL;
}

void CENesAppUi::RunGameL()
{
   __APP_DEBUG( _L("+RunGameL") );

   StopGame();
   
   TBuf<256> rom_name;
   iGameEngine->GetRomFilename( iGameToRun, rom_name );

   iGameRunner = CGameRunner::NewL( *this, *iGameEngine );
   iGameRunner->RunGameL( rom_name );
   iGameRunningDialog = new(ELeave)CGameRunningDialog(*iGameRunner);
   iGameRunningDialog->ExecuteLD(R_DIALOG_RUNNING_GAME);

   __APP_DEBUG( _L("-RunGameL") );
}

//===================================================================
//
//  CENesApplication Class Definition
//
//===================================================================

CApaDocument* CENesApplication::CreateDocumentL()
{
   CENesDocument* doc = new (ELeave) CENesDocument(*this);

   CleanupStack::PushL(doc);
   doc->ConstructL();
   CleanupStack::Pop();

   return doc;
}

TUid CENesApplication::AppDllUid() const
{
   return KUidENesApp;
}

//===================================================================
//
//  Startup Methods Definition
//
//===================================================================

GLDEF_C TInt E32Dll(TDllReason)
{
   return KErrNone;
}

EXPORT_C CApaApplication* NewApplication()
{
   return new CENesApplication;
}


