/*************************************************************************

    Mitchell hardware

*************************************************************************/

#include "sound/okim6295.h"

class mitchell_state : public driver_device
{
public:
	mitchell_state(const machine_config &mconfig, device_type type, const char *tag)
		: driver_device(mconfig, type, tag),
		  m_maincpu(*this, "maincpu"),
		  m_audiocpu(*this, "audiocpu"),
		  m_oki(*this, "oki") ,
		m_colorram(*this, "colorram"),
		m_videoram(*this, "videoram"){ }

	/* devices */
	required_device<cpu_device> m_maincpu;
	optional_device<cpu_device> m_audiocpu;
	optional_device<okim6295_device> m_oki;
	/* memory pointers */
	required_shared_ptr<UINT8> m_colorram;
	required_shared_ptr<UINT8> m_videoram;

	/* video-related */
	tilemap_t    *m_bg_tilemap;
	UINT8      *m_objram;           /* Sprite RAM */
	int        m_flipscreen;
	int        m_video_bank;
	int        m_paletteram_bank;

	/* sound-related */
	int        m_sample_buffer;
	int        m_sample_select;

	/* misc */
	int        m_input_type;
	int        m_dial[2];
	int        m_dial_selected;
	int        m_dir[2];
	int        m_keymatrix;

	UINT8 *m_nvram;
	size_t m_nvram_size;
	UINT8 m_irq_source;
	DECLARE_READ8_MEMBER(pang_port5_r);
	DECLARE_WRITE8_MEMBER(pang_bankswitch_w);
	DECLARE_READ8_MEMBER(block_input_r);
	DECLARE_WRITE8_MEMBER(block_dial_control_w);
	DECLARE_READ8_MEMBER(mahjong_input_r);
	DECLARE_WRITE8_MEMBER(mahjong_input_select_w);
	DECLARE_READ8_MEMBER(input_r);
	DECLARE_WRITE8_MEMBER(input_w);
	DECLARE_WRITE8_MEMBER(spangbl_msm5205_data_w);
	DECLARE_WRITE8_MEMBER(mstworld_sound_w);
	DECLARE_WRITE8_MEMBER(pang_video_bank_w);
	DECLARE_WRITE8_MEMBER(mstworld_video_bank_w);
	DECLARE_WRITE8_MEMBER(mgakuen_videoram_w);
	DECLARE_READ8_MEMBER(mgakuen_videoram_r);
	DECLARE_WRITE8_MEMBER(mgakuen_objram_w);
	DECLARE_READ8_MEMBER(mgakuen_objram_r);
	DECLARE_WRITE8_MEMBER(pang_videoram_w);
	DECLARE_READ8_MEMBER(pang_videoram_r);
	DECLARE_WRITE8_MEMBER(pang_colorram_w);
	DECLARE_READ8_MEMBER(pang_colorram_r);
	DECLARE_WRITE8_MEMBER(pang_gfxctrl_w);
	DECLARE_WRITE8_MEMBER(pangbl_gfxctrl_w);
	DECLARE_WRITE8_MEMBER(mstworld_gfxctrl_w);
	DECLARE_WRITE8_MEMBER(pang_paletteram_w);
	DECLARE_READ8_MEMBER(pang_paletteram_r);
	DECLARE_WRITE8_MEMBER(mgakuen_paletteram_w);
	DECLARE_READ8_MEMBER(mgakuen_paletteram_r);
	DECLARE_WRITE8_MEMBER(eeprom_cs_w);
	DECLARE_WRITE8_MEMBER(eeprom_clock_w);
	DECLARE_WRITE8_MEMBER(eeprom_serial_w);
	DECLARE_WRITE8_MEMBER(oki_banking_w);
	DECLARE_DRIVER_INIT(mgakuen2);
	DECLARE_DRIVER_INIT(block);
	DECLARE_DRIVER_INIT(pangb);
	DECLARE_DRIVER_INIT(qtono1);
	DECLARE_DRIVER_INIT(mgakuen);
	DECLARE_DRIVER_INIT(hatena);
	DECLARE_DRIVER_INIT(mstworld);
	DECLARE_DRIVER_INIT(spangbl);
	DECLARE_DRIVER_INIT(pkladiesbl);
	DECLARE_DRIVER_INIT(spang);
	DECLARE_DRIVER_INIT(cworld);
	DECLARE_DRIVER_INIT(spangj);
	DECLARE_DRIVER_INIT(qsangoku);
	DECLARE_DRIVER_INIT(marukin);
	DECLARE_DRIVER_INIT(pang);
	DECLARE_DRIVER_INIT(sbbros);
	DECLARE_DRIVER_INIT(pkladies);
	DECLARE_DRIVER_INIT(blockbl);
	DECLARE_DRIVER_INIT(dokaben);
	TILE_GET_INFO_MEMBER(get_tile_info);
	DECLARE_MACHINE_START(mitchell);
	DECLARE_MACHINE_RESET(mitchell);
	DECLARE_VIDEO_START(pang);
};


/*----------- defined in video/mitchell.c -----------*/





SCREEN_UPDATE_IND16( pang );
