// GenesisPlusInjector.cpp : Genesis Plus DOL maker
//

#include <iostream.h>
#include <fstream.h>

int main(int argc, char* argv[])
{
	char copy;

	cout << "Genesis Plus for Gamecube DOL creator" << endl;

	if(argc <= 1){
		cout << "No arguments provided. Please pass the filename of a Genesis/Megadrive ROM." << endl;
	}
	else{
		int chunk[3];
		int temp;
		char genver[2], gcver[2];
		ifstream romfile;
		ifstream datafile;
		ofstream outfile;

		char outfilename[64];
		
		char securitycode[16];
		int romsize = 0;

		romfile.open(argv[1],ios::in | ios::binary);
		datafile.open("genplus.bin",ios::in | ios::binary);

		if(datafile.peek() == EOF){
			cout << "Run this from the command prompt!" << endl;
			return 0;
		}

		cout << "Enter a filename for the output DOL: (Example: genesisplus.dol)" << endl;
		cin >> outfilename;

		outfile.open(outfilename,ios::out | ios::binary);
		
		//Perform copy and bytesetup
		//Data file format:
		//First 16 bytes are the header
		//0x00 - 4 byte file beginning chunk size
		//0x04 - Post data A size - Data A must be ROM
		//0x08 - Post data B size - Data B must be checksum
		//0x0C - GenPlusVersion
		//0x0E - GCNversion
		for (temp=0; temp<3; temp++){
			datafile.get(copy);
			chunk[temp] = (copy & 0xFF) << 24;
			datafile.get(copy);
			chunk[temp] += (copy & 0xFF) << 16;
			datafile.get(copy);
			chunk[temp] += (copy & 0xFF) << 8;
			datafile.get(copy);
			chunk[temp] += (copy & 0xFF);
		}
		for (temp=0; temp<2; temp++){
			datafile.get(copy);
			genver[temp] = copy;
		}
		for (temp=0; temp<2; temp++){
			datafile.get(copy);
			gcver[temp] = copy;
		}

		cout << "Genesis Plus version " << int(genver[0]) << "." << int(genver[1]) << " - ";
		cout << "Gamecube version " << int(gcver[0]) << "." << int(gcver[1]) << endl;

		for(temp=0; temp<chunk[0]; temp++){
			//Copy DOL header
			datafile.get(copy);
			outfile.put(copy);

			if (datafile.peek() == EOF){
				datafile.close();
				romfile.close();
				outfile.close();
				cout << "There was an error in the data file. The DOL can not be created." << endl;
				return 0;
			}
		}

		//Initialize the security code
		for(temp = 4; temp < 16; temp++)
			securitycode[temp]=8*temp;

		//Copy Rom and generate checksum
		while(romfile.peek() != EOF){
			romfile.get(copy);
			outfile.put(copy);
			securitycode[(romsize%12)+4] ^= copy;
			romsize++;

			if (romsize == 0x400000)
				break;
			//Shit, this rom is too big.
		}

		temp=0;
		while(romsize+temp < 0x400000){
			outfile.put(char(0xFF));
			temp++;
		}

		//Copy Post ROM data
		for(temp=0; temp<chunk[1]; temp++){
			datafile.get(copy);
			outfile.put(copy);

			if (datafile.peek() == EOF){
				datafile.close();
				romfile.close();
				outfile.close();
				cout << "There was an error in the data file! Attempt to create the DOL has failed." << endl;
				return 0;
			}
		}
		
		//Encode checksum a bit more
		for(temp=4; temp<16; temp++)
			securitycode[temp] ^= 0xFF - (temp*8);

		//Copy Checksum
		securitycode[0] = char((romsize & 0xFF000000) >> 24);
		securitycode[1] = char((romsize & 0xFF0000) >> 16);
		securitycode[2] = char((romsize & 0xFF00) >> 8);
		securitycode[3] = char(romsize & 0xFF);
		for(temp=0; temp<16; temp++)
			outfile.put(securitycode[temp]);

		//Copy End of DOL data
		for(temp=0; temp<chunk[2]; temp++){
			datafile.get(copy);
			outfile.put(copy);

			if ((temp < chunk[2]-1) && (datafile.peek() == EOF)){
				datafile.close();
				romfile.close();
				outfile.close();
				cout << "There was an error in the data file! Attempt to create the DOL has failed." << endl;
				return 0;
			}
		}

		cout << outfilename << " has been created successfully." << endl;
		
		datafile.close();
		romfile.close();
		outfile.close();
	}

	return 0;
}

