	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE gfx.h
	INCLUDE mcu.h
	INCLUDE cart.h
	INCLUDE 6502.h

	EXPORT IO_reset
	EXPORT IO_R
	EXPORT IO_W
	EXPORT joycfg
	EXPORT spriteinit
	EXPORT suspend
	EXPORT refreshEMUjoypads
	EXPORT resetSIO
	EXPORT thumbcall_r1
	EXPORT gettime
	EXPORT vbaprint
	EXPORT waitframe
	EXPORT LZ77UnCompVram
	EXPORT CheckGBAVersion


 AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -

vbaprint
	swi 0xFF0000		;!!!!!!! Doesn't work on hardware !!!!!!!
	bx lr
LZ77UnCompVram
	swi 0x120000
	bx lr
waitframe
VblWait
	mov r0,#0				;don't wait if not necessary
	mov r1,#1				;VBL wait
	swi 0x040000			; Turn of CPU until VBLIRQ if not too late allready.
	bx lr
CheckGBAVersion
	ldr r0,=0x5AB07A6E		;Fool proofing
	mov r12,#0
	swi 0x0D0000			;GetBIOSChecksum
	ldr r1,=0xABBE687E		;Proto GBA
	cmp r0,r1
	moveq r12,#1
	ldr r1,=0xBAAE187F		;Normal GBA
	cmp r0,r1
	moveq r12,#2
	ldr r1,=0xBAAE1880		;Nintendo DS
	cmp r0,r1
	moveq r12,#4
	mov r0,r12
	bx lr

scaleparms;	   NH     FH     NV     FV
	DCD 0x0000,0x0100,0xff01,0x0150,0xfeb6,OAM_BUFFER1+6,AGB_OAM+774
;----------------------------------------------------------------------------
IO_reset
;----------------------------------------------------------------------------
	adr r6,scaleparms		;set sprite scaling params
	ldmia r6,{r0-r6}

	mov r7,#2
scaleloop
	strh r1,[r5],#8				;buffer1, buffer2
	strh r0,[r5],#8
	strh r0,[r5],#8
	strh r3,[r5],#232
		strh r2,[r5],#8
		strh r0,[r5],#8
		strh r0,[r5],#8
		strh r3,[r5],#232
			strh r1,[r5],#8
			strh r0,[r5],#8
			strh r0,[r5],#8
			strh r4,[r5],#232
	subs r7,r7,#1
	bne scaleloop

	strh r2,[r6],#8				;7000200
	strh r0,[r6],#8
	strh r0,[r6],#8
	strh r4,[r6]


	ldrb r0,dipswitch2
	and r0,r0,#0x03				;MCU bits
	orr r0,r0,#0x20
	strb r0,dipswitch2


	ldrb r0,emuflags+1
	;..to spriteinit
;----------------------------------------------------------------------------
spriteinit	;build yscale_lookup tbl (called by ui.c) r0=scaletype
;called by ui.c:  void spriteinit(char scaletype) (pass scaletype in r0 because globals ptr isn't set up to read it)
;----------------------------------------------------------------------------
	ldr r3,=flipsizeTable
	add r2,r3,#4*4
	mov r12,#0
	cmp r0,#SCALED
	movhi r12,#0x100

si6	ldr r1,[r3]
	bic r1,r1,#0x100		;disable rot/scale sprites
	orr r1,r1,r12			;enable rot/scale sprites
	str r1,[r3],#4
	cmp r2,r3
	bne si6
	ldr r3,=YSCALE_LOOKUP
	cmp r0,#SCALED
	bpl si1

;------------------ unscaled
si5
	sub r3,r3,#48
	sub r2,r3,#240-(160+48)
	mov r0,#164
si2	strb r0,[r2],#1
	cmp r2,r3
	bne si2

	add r2,r3,#256+32
	mov r0,#-32
si3	strb r0,[r3],#1
	add r0,r0,#1
	cmp r0,#164
	movpl r0,#164
	cmp r2,r3
	bne si3
	bx lr

;------------------ scaled
si1
	sub r3,r3,#240-224
	mov r0,#0x0000c000		;0.75
	ldr r1,=0xffff0000		;-(16)*0.75
si4	mov r2,r1,lsr#16
	strb r2,[r3],#1
	add r1,r1,r0
	cmp r2,#0xe0
	bne si4
	bx lr
;----------------------------------------------------------------------------
suspend	;called from ui.c and h6280.s
;-------------------------------------------------
	mov r3,#REG_BASE

	ldr r1,=REG_P1CNT
	ldr r0,=0xc00c			;interrupt on start+sel
	strh r0,[r3,r1]

	ldrh r1,[r3,#REG_SGCNT_L]
	strh r3,[r3,#REG_SGCNT_L]	;sound off

	ldrh r0,[r3,#REG_DISPCNT]
	orr r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD off

	swi 0x030000

	ldrh r0,[r3,#REG_DISPCNT]
	bic r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD on

	strh r1,[r3,#REG_SGCNT_L]	;sound on

	bx lr
;----------------------------------------------------------------------------
gettime	;called from ui.c
;----------------------------------------------------------------------------
	ldr r3,=0x080000c4		;base address for RTC
	mov r1,#1
	strh r1,[r3,#4]			;enable RTC
	mov r1,#7
	strh r1,[r3,#2]			;enable write

	mov r1,#1
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]			;State=Command

	mov r2,#0x65			;r2=Command, YY:MM:DD 00 hh:mm:ss
	mov addy,#8
RTCLoop1
	mov r1,#2
	and r1,r1,r2,lsr#6
	orr r1,r1,#4
	strh r1,[r3]
	mov r1,r2,lsr#6
	orr r1,r1,#5
	strh r1,[r3]
	mov r2,r2,lsl#1
	subs addy,addy,#1
	bne RTCLoop1

	mov r1,#5
	strh r1,[r3,#2]			;enable read
	mov r2,#0
	mov addy,#32
RTCLoop2
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r2,r2,lsr#1
	orr r2,r2,r1,lsl#30
	subs addy,addy,#1
	bne RTCLoop2

	mov r0,#0
	mov addy,#24
RTCLoop3
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r0,r0,lsr#1
	orr r0,r0,r1,lsl#22
	subs addy,addy,#1
	bne RTCLoop3

	bx lr
;----------------------------------------------------------------------------
resetSIO	;r0=joycfg
;----------------------------------------------------------------------------
	bic r0,r0,#0x0f000000
	str r0,joycfg

	mov r2,#2		;only 2 players.
	mov r1,r0,lsr#29
	cmp r1,#0x6
	moveq r2,#4		;all 4 players
	cmp r1,#0x5
	moveq r2,#3		;3 players.
	str r2,nrplayers

	mov r2,#REG_BASE
	add r2,r2,#0x100

	mov r1,#0
	strh r1,[r2,#REG_RCNT]

	tst r0,#0x80000000
	moveq r1,#0x2000
	movne r1,   #0x6000
	addne r1,r1,#0x0002	;16bit multiplayer, 57600bps
	strh r1,[r2,#REG_SIOCNT]

	bx lr
;----------------------------------------------------------------------------
refreshEMUjoypads	;call every frame
;exits with Z flag clear if update incomplete (waiting for other player)
;is my multiplayer code butt-ugly?  yes, I thought so.
;i'm not trying to win any contests here.
;----------------------------------------------------------------------------
	mov r6,lr		;return with this..


		ldr r4,frame
		movs r0,r4,lsr#2 ;C=frame&2 (autofire alternates every other frame)
	ldr r4,EMUjoypad
	mov r0,r4,lsr#4
		ldr r2,joycfg
		andcs r4,r4,r2
		movcss addy,r4,lsr#10	;L?
		andcs r4,r4,r2,lsr#16
	tst r0,#0x10				;R
	and r0,r0,#0x0f
	orrne r0,r0,#0x20			;Jump
	tst r4,#0x2					;B
	orrne r0,r0,#0x10			;Attack Left
	mov r1,#0
	mov r3,#0
	tst r4,#0x4					;Select
	orrne r3,r3,#0x4000			;Coin
	tst r4,#0x8					;Start
	orrne r3,r3,#0x40			;Start
	tst r4,#0x1					;A
	orrne r3,r3,#0x40000		;Attack Right
	tst r2,#0x20000000
	movne r1,r0
	movne r0,#0
	orreq r0,r0,r3
	orrne r0,r0,r3,lsl#1
	orreq r1,r1,r3,lsr#8
	orrne r1,r1,r3,lsr#7
	moveq r3,r3,lsr#16
	movne r3,r3,lsr#15

	strb r0,joy0state
	strb r1,joy1state
	strb r3,joy2state
	ands r0,r0,#0		;Z=1
	mov pc,r6		;Return

joycfg DCD 0x40ff01ff ;byte0=auto mask, byte1=(saves R), byte2=R auto mask
;bit 31=single/multi, 30,29=1P/2P, 27=(multi) link active, 24=reset signal received
nrplayers DCD 0		;Number of players in multilink.
joySerial DCB 0
joy0state DCB 0
joy1state DCB 0
joy2state DCB 0
ssba2rs12	DCB 0x00,0x02,0x01,0x03, 0x04,0x06,0x05,0x07, 0x08,0x0a,0x09,0x0b, 0x0c,0x0e,0x0d,0x0f

;----------------------------------------------------------------------------
Input0_R		;Player1
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA debugg
	ldrb r0,joy0state
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
Input1_R		;Player2
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA debugg
	ldrb r0,joy1state
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
Input2_R
;----------------------------------------------------------------------------
	ldrb r0,dipswitch2
	ldrb r1,joy2state
	orr r0,r0,r1
	eor r0,r0,#0x40				;why? MAME says ACTIVE_LOW...
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
Input3_R
;----------------------------------------------------------------------------
	ldrb r0,dipswitch1
	eor r0,r0,#0xFF
	mov pc,lr

;----------------------------------------------------------------------------
;--------------------------------------------------
	INCLUDE visoly.s
 AREA wram_code1, CODE, READWRITE
;-- - - - - - - - - - - - - - - - - - - - - -

thumbcall_r1 bx r1

;----------------------------------------------------------------------------
IO_R		;I/O read, 0x2000-0x3FFFF
;----------------------------------------------------------------------------
;	mov r11,r11
	subs r1,addy,#0x3800
	bmi More_IO_R
	cmp r1,#8
	ldrmi pc,[pc,r1,lsl#2]
;---------------------------
	b empty_IO_R
;io_read_tbl
	DCD Input0_R		;0x3800
	DCD Input1_R		;0x3801
	DCD Input2_R		;0x3802
	DCD Input3_R		;0x3803
	DCD MCU04_R			;0x3804
	DCD MCU05_R			;0x3805
	DCD empty_IO_R		;0x3806
	DCD empty_IO_R		;0x3807
;----------------------------------------------------------------------------
More_IO_R		;ram, 
;----------------------------------------------------------------------------
	subs r1,addy,#0x3200
	movpl r0,#0
	ldrmib r0,[cpu_zpage,addy]
	mov pc,lr



;----------------------------------------------------------------------------
IO_W		;I/O write, 0x2000-0x3FFFF
;----------------------------------------------------------------------------
;	mov r11,r11
	cmp addy,#0x3200
	bmi ram_W
	subs r1,addy,#0x3800
	bmi empty_W
	cmp r1,#8
	ldrmi pc,[pc,r1,lsl#2]
;---------------------------
	b empty_W
;io_write_tbl
	DCD ScrolX_L_W		;0x3800
	DCD ScrolX_H_W		;0x3801
	DCD Sound_W			;0x3802
	DCD Flip_W			;0x3803
	DCD MCU04_W			;0x3804
	DCD BankSwitch_W	;0x3805
	DCD WatchDog_W		;0x3806
	DCD Coin_W			;0x3807

;----------------------------------------------------------------------------
Sound_W
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
Flip_W
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
WatchDog_W
;----------------------------------------------------------------------------
	mov pc,lr
;----------------------------------------------------------------------------
Coin_W
;----------------------------------------------------------------------------
	ldrb r0,irqPending
	bic r0,r0,#1
	strb r0,irqPending
	mov pc,lr
;----------------------------------------------------------------------------
BankSwitch_W
;----------------------------------------------------------------------------
	stmfd sp!,{r3,lr}

	and r3,r0,#1
	mov r1,r3,lsl#1
	mov r0,#0x4
	bl HuMapper_

	mov r1,r3,lsl#1
	add r1,r1,#1
	mov r0,#0x8
	bl HuMapper_

	ldmfd sp!,{r3,pc}
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
	END
