	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE cart.h
	INCLUDE io.h
	INCLUDE 6502.h
	INCLUDE 6502mac.h

	EXPORT GFX_init
	EXPORT GFX_reset
	EXPORT debug_
	EXPORT AGBinput
	EXPORT EMUinput
	EXPORT paletteinit
	EXPORT PaletteTxAll
	EXPORT newframe
	EXPORT endframe
	EXPORT flipsizeTable
	EXPORT gfxstate
	EXPORT gammavalue
	EXPORT oambufferready
	EXPORT ScrolX_L_W
	EXPORT ScrolX_H_W
	EXPORT twitch
	EXPORT flicker
	EXPORT fpsenabled
	EXPORT FPSValue
	EXPORT vbldummy
	EXPORT vblankfptr
	EXPORT vblankinterrupt

	IMPORT RumbleInterrupt
	IMPORT StartRumbleComs

 AREA rom_code, CODE, READONLY

;----------------------------------------------------------------------------
GFX_init	;(called from main.c) only need to call once
;----------------------------------------------------------------------------
	mov addy,lr

	mov r1,#0xffffff00		;build bg tile decode tbl
	ldr r2,=CHR_DECODE2
ppi0	mov r0,#0
	tst r1,#0x01
	orrne r0,r0,#0x0001
	tst r1,#0x02
	orrne r0,r0,#0x0010
	tst r1,#0x04
	orrne r0,r0,#0x0100
	tst r1,#0x08
	orrne r0,r0,#0x1000
	tst r1,#0x10
	orrne r0,r0,#0x0002
	tst r1,#0x20
	orrne r0,r0,#0x0020
	tst r1,#0x40
	orrne r0,r0,#0x0200
	tst r1,#0x80
	orrne r0,r0,#0x2000
	str r0,[r2],#4
	adds r1,r1,#1
	bne ppi0

	mov r1,#0xffffffc0		;build fg tile decode tbl
	ldr r2,=CHR_DECODE1
ppi1	mov r0,#0
	tst r1,#0x01
	orrne r0,r0,#0x01
	tst r1,#0x02
	orrne r0,r0,#0x10
	tst r1,#0x04
	orrne r0,r0,#0x02
	tst r1,#0x08
	orrne r0,r0,#0x20
	tst r1,#0x10
	orrne r0,r0,#0x04
	tst r1,#0x20
	orrne r0,r0,#0x40
;	tst r1,#0x40
;	orrne r0,r0,#0x08
;	tst r1,#0x80
;	orrne r0,r0,#0x80
	strb r0,[r2],#1
	adds r1,r1,#1
	bne ppi1


	mov r1,#REG_BASE
	mov r0,#0x0008
	strh r0,[r1,#REG_DISPSTAT]	;vblank en


	add r0,r1,#REG_BG0HOFS		;DMA0 always goes here
	str r0,[r1,#REG_DM0DAD]
	ldr r0,=DMA0BUFF+8			;DMA0 src=
	str r0,[r1,#REG_DM0SAD]
	mov r0,#2					;2 word transfer
	strh r0,[r1,#REG_DM0CNT_L]

	add r2,r1,#REG_IE
	mov r0,#-1
	strh r0,[r2,#2]		;stop pending interrupts
	ldr r0,=irqhandler
	str r0,[r1,#-4]		;=AGB_IRQVECT
	ldr r0,=0x1091
	strh r0,[r2]		;key,vblank,timer1 enable. (serial interrupt=0x80)
	mov r0,#1
	strh r0,[r2,#8]		;master irq enable

	bx addy
;----------------------------------------------------------------------------
GFX_reset	;called with CPU reset
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!

	mov r1,#0
	str r1,windowtop

	ldr r0,=gfxstate
	mov r2,#5				;5*4
	bl memset_				;clear GFX regs

	mov r0,#1
	strb r0,sprmemreload

	mov r0,#13
	strb r0,ystart

	mov r1,#REG_BASE
	ldr r0,=0x400A
	strh r0,[r1,#REG_BG0CNT]
	ldr r0,=0x0205
	strh r0,[r1,#REG_BG1CNT]


	mov r0,#AGB_OAM
	mov r1,#0x2a0
	mov r2,#0x100
	bl memset_		;no stray sprites please
	ldr r0,=OAM_BUFFER1
	mov r2,#0x180
	bl memset_

	bl paletteinit	;do palette mapping
	ldr pc,[sp],#4

;----------------------------------------------------------------------------
paletteinit;	r0-r3 modified.
;called by ui.c:  void map_palette(char gammavalue)
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r7,lr}
	mov r7,#0xF0
	ldr r6,=MAPPED_RGB
	ldrb r1,gammavalue	;gamma value = 0 -> 4
	mov r4,#8192		;Renegade bgr, r1=R, r2=G, r3=B
	sub r4,r4,#2
nomap					;map 0000bbbbggggrrrr  ->  0bbbbbgggggrrrrr
	and r0,r7,r4,lsr#5	;Blue ready
	bl gprefix
	mov r5,r0

	and r0,r7,r4,lsr#1	;Green ready
	bl gprefix
	orr r5,r0,r5,lsl#5

	and r0,r7,r4,lsl#3	;Red ready
	bl gprefix
	orr r5,r0,r5,lsl#5

	strh r5,[r6,r4]
	subs r4,r4,#2
	bpl nomap

	ldmfd sp!,{r4-r7,lr}
	bx lr

;----------------------------------------------------------------------------
gprefix
	orr r0,r0,r0,lsr#4
;----------------------------------------------------------------------------
gammaconvert;	takes value in r0(0-0xFF), gamma in r1(0-4),returns new value in r0=0x1F
;----------------------------------------------------------------------------
	rsb r2,r0,#0x100
	mul r3,r2,r2
	rsbs r2,r3,#0x10000
	rsb r3,r1,#4
	orr r0,r0,r0,lsl#8
	mul r2,r1,r2
	mla r0,r3,r0,r2
	mov r0,r0,lsr#13

	bx lr
;----------------------------------------------------------------------------
showfps_		;fps output, r0-r3=used.
;----------------------------------------------------------------------------
	ldrb r0,fpschk
	subs r0,r0,#1
	movmi r0,#59
	strb r0,fpschk
	bxpl lr					;End if not 60 frames has passed

	str lr,[sp,#-4]!
	ldr r1,=StartRumbleComs
	adr lr,ret_
	bx r1
ret_
	ldr lr,[sp],#4

	ldrb r0,fpsenabled
	tst r0,#1
	bxeq lr					;End if not enabled

	ldr r0,fpsvalue
	cmp r0,#0
	bxeq lr					;End if fps==0, to keep it from appearing in the menu
	mov r1,#0
	str r1,fpsvalue

	mov r1,#100
	swi 0x060000			;Division r0/r1, r0=result, r1=remainder.
	add r0,r0,#0x30
	strb r0,fpstext+5
	mov r0,r1
	mov r1,#10
	swi 0x060000			;Division r0/r1, r0=result, r1=remainder.
	add r0,r0,#0x30
	strb r0,fpstext+6
	add r1,r1,#0x30
	strb r1,fpstext+7
	

	adr r0,fpstext
	ldr r2,=DEBUGSCREEN
;	add r2,r2,r1,lsl#6
db1
	ldrb r1,[r0],#1
	orr r1,r1,#0x4100
	strh r1,[r2],#2
	tst r2,#0xE
	bne db1

	bx lr
;----------------------------------------------------------------------------
fpstext DCB "FPS:    "
fpsenabled DCB 0
fpschk	DCB 0
gammavalue DCB 0
		DCB 0
;----------------------------------------------------------------------------
debug_		;debug output, r0=val, r1=line, r2=used.
;----------------------------------------------------------------------------
 [ DEBUG
	ldr r2,=DEBUGSCREEN
	add r2,r2,r1,lsl#6
db0
	mov r0,r0,ror#28
	and r1,r0,#0x0f
	cmp r1,#9
	addhi r1,r1,#7
	add r1,r1,#0x30
	orr r1,r1,#0x4100
	strh r1,[r2],#2
	tst r2,#15
	bne db0
 ]
	bx lr
;----------------------------------------------------------------------------
flipsizeTable;	convert from PCE spr to GBA obj.
;----------------------------------------------------------------------------
;	    nothing		xflip		height32	xflip+height32
	DCD 0x40000000,0x50000000,0x80008000,0x90008000
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
	AREA wram_code1, CODE, READWRITE
irqhandler	;r0-r3,r12 are safe to use
;----------------------------------------------------------------------------
	mov r2,#REG_BASE
	mov r3,#REG_BASE
	ldr r1,[r2,#REG_IE]!
	and r1,r1,r1,lsr#16	;r1=IE&IF
	ldrh r0,[r3,#-8]
	orr r0,r0,r1
	strh r0,[r3,#-8]

		;---these CAN'T be interrupted
		ands r0,r1,#0x80
		strneh r0,[r2,#2]		;IF clear
		bne RumbleInterrupt
		;---

		;---these CAN be interrupted
		ands r0,r1,#0x01
		ldrne r12,vblankfptr
		bne jmpintr
		;----
		adreq r12,irq0
		moveq r0,r1		;if unknown interrupt occured clear it.
jmpintr
	strh r0,[r2,#2]		;IF clear

	mrs r3,spsr
	stmfd sp!,{r3,lr}
	mrs r3,cpsr
	bic r3,r3,#0x9f
	orr r3,r3,#0x1f			;--> Enable IRQ . Set CPU mode to System.
	msr cpsr_cf,r3
	stmfd sp!,{lr}
	adr lr,irq0

	mov pc,r12


irq0
	ldmfd sp!,{lr}
	mrs r3,cpsr
	bic r3,r3,#0x9f
	orr r3,r3,#0x92        		;--> Disable IRQ. Set CPU mode to IRQ
	msr cpsr_cf,r3
	ldmfd sp!,{r0,lr}
	msr spsr_cf,r0
vbldummy
	bx lr
;----------------------------------------------------------------------------
vblankfptr DCD vbldummy			;later switched to vblankinterrupt
twitch DCB 0
flicker DCB 1
		DCB 0
		DCB 0
vblankinterrupt;
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r7,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

	bl showfps_

	ldr r2,=DMA0BUFF	;setup DMA buffer for scrolling:
	add r3,r2,#160*8
	ldr r6,scrollX_bak
	add r6,r6,#8
	mov r7,#8
	ldrb r0,emuflags+1
	cmp r0,#SCALED
	bhs vblscaled

vblunscaled
	ldr r0,windowtop+12
	add r6,r6,r0,lsl#16
	add r7,r7,r0,lsl#16
	mov r4,r6
	mov r5,r7
vbl6
	stmia r2!,{r4-r7}
	cmp r2,r3
	bmi vbl6

	b vbl5

vblscaled					;(scaled)
	ldrb r0,ystart
	ldrb r5,flicker
	ldrb r4,twitch
	eors r4,r4,r5
	strb r4,twitch
	add r6,r6,r0,lsl#16
	add r7,r7,r0,lsl#16
	streq r6,[r2],#4
	streq r7,[r2],#4
		ldr r4,adjustblend
		ands r4,r4,#3
		beq vbl3
		cmp r4,#2
		bhi vbl2
vbl1
		addmi r6,r6,#0x10000
		addmi r7,r7,#0x10000
		str r6,[r2],#4
		str r7,[r2],#4
vbl2
		str r6,[r2],#4
		str r7,[r2],#4
vbl3
		str r6,[r2],#4
		str r7,[r2],#4
	cmp r2,r3
	bmi vbl1

vbl5


	mov r1,#REG_BASE
	strh r1,[r1,#REG_DM0CNT_H]		;DMA0 stop
	strh r1,[r1,#REG_DM3CNT_H]		;DMA3 stop

	add r2,r1,#REG_DM3SAD

	ldr r0,oambufferready
	cmp r0,#0
	ldrne r4,dmaoambuffer			;DMA3 src, OAM transfer:
	movne r5,#AGB_OAM				;DMA3 dst
	movne r6,#0x84000000			;noIRQ 32bit incsrc incdst
	orrne r6,r6,#0xc0				;196 words (768 bytes)
	stmneia r2,{r4-r6}				;DMA3 go

	ldrne r4,=PCEPALBUFF			;DMA3 src, Palette transfer:
	movne r5,#AGB_PALETTE			;DMA3 dst
	movne r6,#0x84000000			;noIRQ 32bit incsrc incdst
	orrne r6,r6,#0x100				;256 words (1024 bytes)
	stmneia r2,{r4-r6}				;DMA3 go
	mov r0,#0
	str r0,oambufferready

	ldr r0,=DMA0BUFF				;setup HBLANK DMA for display scroll:
	ldr r4,[r0],#4
	str r4,[r1,#REG_BG0HOFS]		;set 1st value manually, HBL is AFTER 1st line
	ldr r4,[r0],#4
	str r4,[r1,#REG_BG1HOFS]		;set 1st value manually, HBL is AFTER 1st line
	ldr r0,=0xA660					;noIRQ hblank 32bit repeat incsrc inc_reloaddst
	strh r0,[r1,#REG_DM0CNT_H]		;DMA0 go

	mov r0,#0x1740					;1d sprites, BG0/BG1/BG2 enable. OBJ enable, DISPCNTBUFF startvalue. 0x1540
	strh r0,[r1,#REG_DISPCNT]		;set value manually

exit_vbl
	ldmfd sp!,{r4-r7,globalptr,pc}


;----------------------------------------------------------------------------
newframe	;called before line 0	(r0-r9 safe to use)
;----------------------------------------------------------------------------
	mov r0,#0
	str r0,scanline			;reset scanline count
	ldrb r0,dipswitch2
	bic r0,r0,#0x40			;NMI flag
	strb r0,dipswitch2

;--------------------------
	bx lr

;----------------------------------------------------------------------------
endframe	;called just before screen end (~line 240)	(r0-r2 safe to use)
;----------------------------------------------------------------------------
	stmfd sp!,{r3-r9,lr}

	bl bg_finish
	bl fg_finish
;--------------------------
	bl sprDMA_do
;--------------------------
	bl PaletteTxAll
;--------------------------

	mrs r4,cpsr
	orr r1,r4,#0x80			;--> Disable IRQ.
	msr cpsr_cf,r1

	ldr r0,dmaoambuffer
	ldr r1,tmpoambuffer
	str r0,tmpoambuffer
	str r1,dmaoambuffer

	ldr r0,scrollX
	str r0,scrollX_bak

	mov r0,#1
	str r0,oambufferready

	adrl r0,windowtop		;load wtop, store in wtop+4.......load wtop+8, store in wtop+12
	ldmia r0,{r1-r3}		;load with post increment
	stmib r0,{r1-r3}		;store with pre increment

	msr cpsr_cf,r4			;--> restore mode,Enable IRQ.


	ldmfd sp!,{r3-r9,lr}
	bx lr
;----------------------------------------------------------------------------
PaletteTxAll		; Called from ui.c
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r9,lr}
	ldr r4,=0x1FFE			;mask
	ldr r2,=PCE_RAM+0x3000
	add r3,r2,#0x100
	ldr r7,=MAPPED_RGB
	ldr r5,=PCEPALBUFF

	mov r6,#0				;source, FG
	mov r8,#0				;destination
	mov r9,#8*4				;len
	bl PalCpy

	mov r6,#192*2			;source, BG
	mov r8,#128*2			;destination
	mov r9,#8*8				;len
	bl PalCpy

	mov r6,#128*2			;source, Spr
	mov r8,#256*2			;destination
	mov r9,#8*4				;len
	bl PalCpy

	mov r6,#192*2			;source, BG. Copy AC bg color to GBA bg color.
	mov r8,#0				;destination
	mov r9,#1				;len
	bl PalCpy

	ldmfd sp!,{r4-r9,lr}
	bx lr

;----------------------------------------------------------------------------
PalCpy
	ldrb r0,[r2,r6,lsr#1]	;Source GR
	ldrb r1,[r3,r6,lsr#1]	;Source B
	orr r0,r0,r1,lsl#8
	and r0,r4,r0,lsl#1
	ldrh r0,[r7,r0]			;Gamma
	strh r0,[r5,r8]			;Destination
	add r6,r6,#2
	add r8,r8,#2
	tst r8,#0x10
	addne r8,r8,#0x10
	subs r9,r9,#1
	bne PalCpy
	bx lr

;----------------------------------------------------------------------------
ScrolX_L_W		;0x3000
;----------------------------------------------------------------------------
	strb r0,scrollX
	mov pc,lr
;----------------------------------------------------------------------------
ScrolX_H_W		;0x3001
;----------------------------------------------------------------------------
;	mov r11,r11
	sub r0,r0,#1			;Something wrong with the MCU emulation?
	and r0,r0,#3
	strb r0,scrollX+1
	mov pc,lr

;----------------------------------------------------------------------------
sprDMA_do			;Called from endframe. YATX
;----------------------------------------------------------------------------
PRIORITY EQU 0x800		;0x800=AGB OBJ priority 2
	str lr,[sp,#-4]!


	ldr r9,=SPRTILELUT
	ldrb r0,sprmemreload
	tst r0,#0xff
	beq noreload
	mov r0,r9				;r0=destination
	mov r1,#0				;r1=value
	mov r2,#4096			;4096 tile entries
	bl memset_				;clear lut
	strb r1,sprmemreload	;clear spr mem reload.
	strb r1,sprmemalloc		;clear spr mem alloc.
noreload

	add addy,cpu_zpage,#0x2000	;Source
	ldr r2,tmpoambuffer		;Destination

	ldr r1,emuflags
	and r5,r1,#0x300
	cmp r5,#SCALED_SPRITES*256
	moveq r6,#2		;r6=ypos scale diff
	movne r6,#0

	mov r0,#0
	ldrb r4,ystart			;first scanline?
	cmp r5,#UNSCALED_AUTO*256	;do autoscroll
	bhi dm2
	movle r4,#0
	bne dm0
;	ldr r3,AGBjoypad
;	ands r3,r3,#0x300
;	eornes r3,r3,#0x300
;	bne dm0				;stop if L or R pressed (manual scroll)
	ldrb r0,[cpu_zpage,#0x83]	;follow memory
	rsb r0,r0,#0x74
	adds r0,r0,r0,asr#3
	movmi r0,#0
	cmp r0,#80
	movpl r0,#80
	str r0,windowtop
dm0
	ldr r0,windowtop+8
dm2
	add r4,r4,r0
	adrl r5,yscale_lookup
	sub r5,r5,r4
	mov r8,#96
	add addy,addy,r8,lsl#2	;Begin with the last sprite
dm11
	ldr r7,=0x1ff
	ldr r4,[addy,#-4]!	;Renegade OBJ, r3=Ypos,Attrib,Tile,Xpos.
	and r0,r4,#0xff		;mask Y
	rsb r0,r0,#240		;fix up Y
	cmp r0,#16
	bmi dm10			;skip if sprite Y<16
	mov r1,#8			;or 0?
	rsb r3,r1,r4,lsr#24	;x -= 8
	cmp r3,#240
	beq dm10			;skip if sprite X==240
	subpl r3,r3,#256
	and r3,r3,r7		;mask X

	tst r4,#0x8000		;check Ysize
	moveq r7,#1
	movne r7,#2
	subne r0,r0,#16
	ldrb r0,[r5,r0]		;y = scaled y
	subne r0,r0,r6		;r6=2 if scaled sprites
	and r0,r0,#0xff
	orr r0,r0,r3,lsl#16


	and r1,r4,#0xc000
	ldr r3,=flipsizeTable
	ldr r1,[r3,r1,lsr#12]
	orr r0,r0,r1
	str r0,[r2],#4		;store OBJ Atr 0,1. Xpos, ypos, xflip, scale/rot, size, shape.

	and r1,r4,#0xFF0000
	and r0,r4,#0xF00	;0xF00
	orr r1,r0,r1,lsr#16
	bl VRAM_spr_16		;jump to spr copy, takes tile# in r1, gives new tile# in r0
ret01
	and r0,r0,#0xff		;tile mask
	and r1,r4,#0x3000	;color
	orr r0,r1,r0,lsl#2
	orr r0,r0,#PRIORITY	;priority
	strh r0,[r2],#4		;store OBJ Atr 2. Pattern, palette.
dm9
	subs r8,r8,#1
	bne dm11
	ldr pc,[sp],#4
dm10
	mov r0,#0x2a0		;double, y=160
	str r0,[r2],#8
	b dm9

;----------------------------------------------------------------------------
VRAM_spr_16;		takes tilenumber in r1, returns new tilenumber in r0
;----------------------------------------------------------------------------
	ldr r0,[r9,r1,lsl#2]
	cmp r7,r0,lsr#16
	movle pc,lr			;allready cached
noluthit16
	bic r3,r1,#1
	ldrb r0,sprmemalloc
	orr r0,r0,#0x20000
	str r0,[r9,r3,lsl#2]
	add r3,r3,#1
	add r0,r0,#1
	str r0,[r9,r3,lsl#2]
	bic r0,r0,#1
	and r3,r1,#1
	add r0,r0,r3
	stmfd sp!,{r0-r6,lr}

	bic r1,r1,#1

	add r3,r0,#2		;allways alloc 2 tiles
	bic r3,r3,#1
	strb r3,sprmemalloc
	tst r3,#0x100
	movne r3,#0xab
	strneb r3,sprmemreload

;----------------------------------------------------------------------------
do16
	and r0,r0,#0xfe

	ldr r3,vrombase2			;r3 = bitplane 0
	add r4,r3,#0x20000			;r4 = bitplane 1 & 2
	add r4,r4,r1,lsl#6
	adr r5,chr_decode2
	mov r6,#AGB_VRAM			;r6=AGB SPR tileset
	orr r6,r6,#0x10000			;spr ram
	add r6,r6,r0,lsl#7			;

	tst r1,#0x100
	and r0,r1,#0xe00
	bic r1,r1,#0x100
	sub r1,r1,r0,lsr#1
	add r3,r3,r1,lsl#6
	bne spr2

spr1
	ldrb r0,[r3],#1				;read 3rd plane
	ldrb r1,[r4],#1				;read 1st & 2nd plane
	and r0,r0,#0xf

	ldr r0,[r5,r0,lsl#2]
	ldr r1,[r5,r1,lsl#2]
	orr r2,r1,r0,lsl#2

	ldrb r0,[r3,#15]			;read 3rd plane
	ldrb r1,[r4,#15]			;read 1st & 2nd plane
	and r0,r0,#0xf

	ldr r0,[r5,r0,lsl#2]
	ldr r1,[r5,r1,lsl#2]
	orr r0,r1,r0,lsl#2
	orr r0,r2,r0,lsl#16
	str r0,[r6],#4

	tst r6,#0x1c
	bne spr1

	add r3,r3,#24
	add r4,r4,#24

	tsteq r6,#0x20
	bne spr1
	sub r3,r3,#56
	sub r4,r4,#56
	tsteq r6,#0x40
	bne spr1

	add r3,r3,#48
	add r4,r4,#48
	tsteq r6,#0x80		;allways 2 16x16 tiles
	bne spr1

cachehit16
	ldmfd sp!,{r0-r6,pc}

spr2
	ldrb r0,[r3],#1				;read 3rd plane
	ldrb r1,[r4],#1				;read 1st & 2nd plane
	mov r0,r0,lsr#4

	ldr r0,[r5,r0,lsl#2]
	ldr r1,[r5,r1,lsl#2]
	orr r2,r1,r0,lsl#2

	ldrb r0,[r3,#15]			;read 3rd plane
	ldrb r1,[r4,#15]			;read 1st & 2nd plane
	mov r0,r0,lsr#4

	ldr r0,[r5,r0,lsl#2]
	ldr r1,[r5,r1,lsl#2]
	orr r0,r1,r0,lsl#2
	orr r0,r2,r0,lsl#16
	str r0,[r6],#4

	tst r6,#0x1c
	bne spr2

	add r3,r3,#24
	add r4,r4,#24

	tsteq r6,#0x20
	bne spr2
	sub r3,r3,#56
	sub r4,r4,#56
	tsteq r6,#0x40
	bne spr2

	add r3,r3,#48
	add r4,r4,#48
	tsteq r6,#0x80		;allways 2 16x16 tiles
	bne spr2

	ldmfd sp!,{r0-r6,pc}
;----------------------------------------------------------------------------

tmpoambuffer DCD OAM_BUFFER1
dmaoambuffer DCD OAM_BUFFER2

oambufferready DCD 0
pcepaletteready DCD 0
;----------------------------------------------------------------------------
	AREA wram_globals1, CODE, READWRITE

FPSValue
	DCD 0
AGBinput			;this label here for main.c to use
	DCD 0 			;AGBjoypad (why is this in gfx.s again?  um.. i forget)
EMUinput	DCD 0	;EMUjoypad (this is what PCE sees)
	DCD 1			;adjustblend
	DCD 0			;windowtop
wtop	DCD 0,0,0	;windowtop  (this label too)   L/R scrolling in unscaled mode
gfxstate
	DCD 0 ;scrollX
	DCD 0 ;scrollX_bak

	DCB 0 ;irqDisable
	DCB 0 ;irqPending
	DCB 0 ;ystart
	DCB 0 ;sprmemalloc
	DCB 0 ;sprmemreload
	DCB 0 ;chrmemalloc
	DCB 0 ;chrmemreload
	DCB 0 ;fgmemalloc
	DCB 0 ;fgmemreload
;...update load/savestate if you move things around in here
;----------------------------------------------------------------------------
	END

