	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE 6502mac.h
	INCLUDE 6502.h
	INCLUDE io.h
	INCLUDE gfx.h
	INCLUDE mcu.h

	IMPORT findrom ;from main.c
	IMPORT pogoshell ;from main.c
	IMPORT pogosize ;from main.c

	EXPORT loadcart
	EXPORT HuMapper_
	EXPORT bg_finish
	EXPORT fg_finish
	EXPORT savestate
	EXPORT loadstate
	EXPORT g_emuflags
	EXPORT romstart
	EXPORT romnum
	EXPORT g_scaling
	EXPORT g_cartflags
	EXPORT g_dipswitch1
	EXPORT g_dipswitch2
;-------------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
loadcart ;called from C:  r0=rom number, r1=emuflags
;-------------------------------------------------------------------------------
	stmfd sp!,{r0-r1,r4-r11,lr}

	ldr r1,=findrom
	bl thumbcall_r1
	add r3,r0,#48		;r0 now points to rom image (including header)

	ldr globalptr,=|wram_globals0$$Base|	;need ptr regs init'd
	ldr cpu_zpage,=PCE_RAM

	ldmfd sp!,{r0-r1}
	str r0,romnumber
	str r1,emuflags

	ldr r1,=pogoshell
	ldrb r1,[r1]
	cmp r1,#0
	addeq r3,r3,#16		;If using rombuilder skip NES header.
						;r3=rombase til end of loadcart so DON'T FUCK IT UP
	ldrne r1,=pogosize
	ldrne r1,[r1]		;Size from Pogoshell
	ldreq r1,[r3,#-32]	;size of rom in bytes (from rombuilder).
	str r3,rombase		;set rom base
	add r0,r3,#0x10000
	str r0,vrombase0	;set vrom base fg
	add r0,r0,#0x8000
	str r0,vrombase1	;set vrom base bg
	add r0,r0,#0x30000
	str r0,vrombase2	;set vrom base spr


	mov r1,r1,lsr#13	;size in 8k blocks
	mov r2,#1
bigmask
	mov r2,r2,lsl#1
	cmp r2,r1
	bmi bigmask
	sub r2,r2,#1
	str r2,rommask		;rommask=romsize-1

	ldr r4,=MEMMAPTBL_
	ldr r5,=RDMEMTBL_
	ldr r6,=WRMEMTBL_
	ldr r7,=rom_R0
	ldr r8,=rom_W
	mov r0,#0

tbloop1
	and r1,r0,r2
	add r1,r3,r1,lsl#13
	str r1,[r4,r0,lsl#2]
	str r7,[r5,r0,lsl#2]
	str r8,[r6,r0,lsl#2]
	add r0,r0,#1
	cmp r0,#0x88
	bne tbloop1
resbg
	ldr r7,=empty_R
	ldr r8,=empty_W
tbloop2
	str r3,[r4,r0,lsl#2]
	str r7,[r5,r0,lsl#2]
	str r8,[r6,r0,lsl#2]
	add r0,r0,#1
	cmp r0,#0x100
	bne tbloop2


	ldr r1,=PCE_RAM
	ldr r7,=ram_R
	ldr r8,=ram_W
	mov r0,#0xF8			;RAM
meml3
	str r1,[r4,r0,lsl#2]	;MemMap
	str r7,[r5,r0,lsl#2]	;RdMem
	str r8,[r6,r0,lsl#2]	;WrMem
	add r0,r0,#1			;0xF8-0xFB RAM
	cmp r0,#0xFB
	bne meml3

	ldr r7,=IO_R
	ldr r8,=IO_W
	mov r0,#0xFF			;IO
	str r7,[r5,r0,lsl#2]	;RdMem
	str r8,[r6,r0,lsl#2]	;WrMem

	mov m6502_pc,#0		;(eliminates any encodePC errors during mapper*init)
	str m6502_pc,lastbank

	adr r4,HuMapData
	mov r5,#0x80
HuDataLoop
	mov r0,r5
	ldrb r1,[r4],#1
	bl HuMapper_
	movs r5,r5,lsr#1
	bne HuDataLoop

	mov r0,cpu_zpage		;clear RAM
	mov r1,#0		
	mov r2,#0x3200/4
	bl memset_

	bl SpeedHackSetup		;check games for speedhack

	ldrb r0,emuflags
	and r0,r0,#4
	mov r0,r0,lsr#2				;0 for Renegade MCU, 1 for Kunio Kun MCU
	bl MCU_reset
	bl GFX_reset
	bl IO_reset
	bl CPU_reset			;reset everything else
	ldmfd sp!,{r4-r11,lr}
	bx lr
;-------------------------------------------------------------------------------
HuMapData
	DCB 0x07,0x06,0x05,0x04,0x01,0x00,0xFF,0xF8			;Renegade
;	DCB 0x00,0x00,0x00,0xF7,0x00,0x00,0xF8,0xFF			;PC-Engine
;-------------------------------------------------------------------------------
SpeedHackSetup

	mov r0,#0x200			;0x200=BEQ(0xF0), 0x100=BNE(0xD0), 0x80=BCS(0xB0), 0x40=BCC(0x90), 0x20=BRA(0x80), 0x02=BMI(0x30), 0x01=BPL(0x10).
	str r0,hackflags
	mov pc,lr

;-------------------------------------------------------------------------------
savestate	;called from ui.c.
;int savestate(void *here): copy state to <here>, return size
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r6,globalptr,lr}

	ldr globalptr,=|wram_globals0$$Base|

	ldr r2,rombase
	rsb r2,r2,#0				;adjust rom maps,etc so they aren't based on rombase
	bl fixromptrs				;(so savestates are valid after moving roms around)

	mov r6,r0					;r6=where to copy state
	mov r0,#0					;r0 holds total size (return value)

	adr r4,savelst				;r4=list of stuff to copy
	mov r3,#(lstend-savelst)/8	;r3=items in list
ss1	ldmia r4!,{r1,r2}			;r1=what to copy, r2=how much to copy
	add r0,r0,r2
ss0	ldr r5,[r1],#4
	str r5,[r6],#4
	subs r2,r2,#4
	bne ss0
	subs r3,r3,#1
	bne ss1

	ldr r2,rombase
	bl fixromptrs

	ldmfd sp!,{r4-r6,globalptr,lr}
	bx lr

savelst	DCD rominfo,8,PCE_RAM,0x2000,AGB_SRAM,0x2000					;Remember to fix the copy loop to do bytes for SRAM
		DCD mapperstate,8;,cpustate,44,gfxstate,80;PCE_VRAM,0x10000
lstend

fixromptrs	;add r2 to some things
	stmfd sp!,{r0,r2,lr}

	mov r3,#0x80
	adrl r4,mapperdata+7
HuMapLoop
	ldrb r0,[r4],#-1	;What contents.
	mov r1,r3		;Which bank.
	bl HuMapper_
	movs r3,r3,lsr#1
	bne HuMapLoop

	ldmfd sp!,{r0,r2,lr}

	ldr r3,lastbank
	add r3,r3,r2
	str r3,lastbank

	ldr r3,cpuregs+6*4	;6502 PC
	add r3,r3,r2
	str r3,cpuregs+6*4

	mov pc,lr
;-------------------------------------------------------------------------------
loadstate	;called from ui.c
;void loadstate(int rom#,u32 *stateptr)	 (stateptr must be word aligned)
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r7,globalptr,lr}

	mov r6,r1		;r6=where state is at
	ldr globalptr,=|wram_globals0$$Base|

	ldr r1,[r6]		;emuflags
	bl loadcart		;cart init

	mov r0,#(lstend-savelst)/8	;read entire state
	adr r4,savelst
ls1	ldmia r4!,{r1,r2}
ls0	ldr r5,[r6],#4
	str r5,[r1],#4
	subs r2,r2,#4
	bne ls0
	subs r0,r0,#1
	bne ls1

	ldr r2,rombase		;adjust ptr shit (see savestate above)
	bl fixromptrs


;	bl resetBGCHR

	ldmfd sp!,{r4-r7,globalptr,lr}
	bx lr

;	bg0_cnt 0x5c02,


;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
bg_finish	;end of frame...  finish up BGxCNTBUFF
;-------------------------------------------------------------------------------
	stmfd sp!,{r3-r9,r11,lr}

	ldr r4,=mem_dirtytbl
	ldrb r0,chrmemreload
	cmp r0,#0
	bne nobgreload
	strb r0,chrmemalloc
	ldr r0,=BG_TILELUT
	mov r1,#-1
	mov r2,#64		;256/4 entries
	bl memset_		;clear map
	strb r1,chrmemreload

	ldr r0,=DIRTYSPRITES
	ldr r1,=0x20202020
	mov r2,#64		;256/4 entries
	bl memorr_		;clear map
	b bg_cont
nobgreload
	ldr r0,scrollX
	ldr r1,scrollX_bak
	add r0,r0,#8
	add r1,r1,#8
	eor r0,r0,r1
	bics r0,r0,#0xF
	bne bg_cont
	ldr r0,windowtop+4
	ldr r1,windowtop+8
	eor r0,r0,r1
	bics r0,r0,#0xF
	bne bg_cont
	ldrb r0,[r4,#5]
	cmp r0,#0
	ldmeqfd sp!,{r3-r9,r11,pc}
bg_cont
	mov r0,#0
	strb r0,[r4,#5]

	ldr r1,emuflags
	tst r1,#0x200
	ldreq r4,windowtop+4		;first scanline unscaled.
	ldrneb r4,ystart			;first scanline scaled.
	moveq r0,#160
	movne r0,#224
	add r5,r4,r0
	ldr r1,=sheight
	str r5,[r1]
	ldr r2,scrollX
	add r2,r2,#8
	mov r2,r2,lsr#2
	str r2,[r1,#4]					;scrlxtmp

	ldr r3,=BG_TILELUT
	ldr addy,=0x00020002

	b bglo2

;-------------------------------------------------------------------------------
fg_finish	;end of frame...
;-------------------------------------------------------------------------------
	stmfd sp!,{r3-r9,r11,lr}

	ldr r4,=mem_dirtytbl
	ldrb r0,fgmemreload
	cmp r0,#0
	bne nofgreload
	strb r0,fgmemalloc
	ldr r0,=FG_TILELUT
	mov r1,#-1
	mov r2,#256		;256 entries
	bl memset_		;clear map
	strb r1,fgmemreload

	ldr r0,=DIRTYSPRITES
	ldr r1,=0x40404040
	mov r2,#64		;256/4 entries
	bl memorr_		;clear map
	b fg_cont
nofgreload
	ldrb r0,[r4,#3]
	cmp r0,#0
	ldmeqfd sp!,{r3-r9,r11,pc}
;	ldmfd sp!,{r3-r9,r11,pc}
fg_cont
	mov r0,#0
	strb r0,[r4,#3]

	ldr r1,emuflags
	tst r1,#0x200
	ldreq r4,windowtop+4		;first scanline unscaled.
	ldrneb r4,ystart			;first scanline scaled.
	moveq r0,#160
	movne r0,#216
	add r5,r4,r0
	ldr r1,=sheight
	str r5,[r1]
	ldr r3,=FG_TILELUT

	b fglo2



;-------------------------------------------------------------------------------
 AREA wram_code4, CODE, READWRITE
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;bgchrfinish2	;end of frame...
;-------------------------------------------------------------------------------
bglo2
	bic r0,r4,#0xf

	add r5,cpu_zpage,#0x2800	;bg tilemap
	add r5,r5,r0,lsl#2			;64x16 tiles
	add r8,r5,#0x400
	ldr r2,scrlxtmp

	add r9,r0,#AGB_VRAM>>3
	mov r7,#16					;width
bgtrloop
	and r2,r2,#0xfc
	ldrb r0,[r5,r2,lsr#2]		;Read from Renegade Tilemap RAM
	ldrb r1,[r8,r2,lsr#2]		;Read from Renegade Tilemap RAM
	orr r0,r0,r1,lsl#8
	bic r6,r0,#0xf800
	ldrb r1,[r3,r6,lsr#3]		;TileRemapLUT
	tst r1,#0xa0
	bne allocbgmem
bgret
	orr r6,r1,r0,lsl#29
	and r1,r0,#0xE000
	orr r0,r6,r1,lsr#6
	mov r0,r0,ror#27
	orr r0,r0,#0x18000			;2nd palette half + next tile
	orr r0,r0,r0,lsl#16

	orr r6,r2,r2,lsl#5			;move 0x40 to 0x800
	bic r6,r6,#0x37C0
	str r0,[r6,r9,lsl#3]!		;Write to GBA Tilemap RAM
	orr r0,r0,addy				;#0x00020002
	str r0,[r6,#0x40]			;Write to GBA Tilemap RAM
	add r2,r2,#4
	subs r7,r7,#1
	bne bgtrloop

	ldr r5,sheight
	add r4,r4,#16
	cmp r4,r5					;160*4/3=213.33333
	ble bglo2

	bl RedrawBGTiles
	ldmfd sp!,{r3-r9,r11,pc}

allocbgmem
	bic r1,r1,#0x20				;test
	tst r1,#0x80
	ldrneb r1,chrmemalloc
	strb r1,[r3,r6,lsr#3]		;strneb?
	beq bgret

	addne r6,r1,#1
	strneb r6,chrmemalloc
	tst r6,#0x20
	beq bgret

	movne r6,#0
	strneb r6,chrmemreload
	strneb r6,chrmemalloc
	b bgret

sheight DCD 0
scrlxtmp DCD 0
;-------------------------------------------------------------------------------
;fgchrfinish2	;end of frame...
;-------------------------------------------------------------------------------
fglo2
	bic r0,r4,#0x7

	add r5,cpu_zpage,#0x1800	;bg tilemap
	add r5,r5,r0,lsl#2			;32x32 tiles
	add r8,r5,#0x400
	mov r2,#2					;or 1

	mov r9,#AGB_VRAM
	add r9,r9,#0x1000
	add r9,r9,r0,lsl#3
	mov r7,#30					;width
fgtrloop
	and r2,r2,#0x3e
	ldrb r0,[r5,r2,lsr#1]		;Read from Renegade Tilemap RAM
	ldrb r1,[r8,r2,lsr#1]		;Read from Renegade Tilemap RAM
	orr r0,r0,r1,lsl#8
	and r6,r0,#0x03FC
	and r1,r0,#0xC000
	and r0,r0,#3
	orr r0,r0,r1,lsr#2
	ldr r1,[r3,r6]				;TileRemapLUT
	tst r1,#0x180
	bne allocfgmem
fgret
	and r1,r1,#0x7F
	orr r0,r0,r1,lsl#2
	strh r0,[r9,r2]				;Write to GBA Tilemap RAM
	add r2,r2,#2
	subs r7,r7,#1
	bne fgtrloop

	ldr r5,sheight
	add r4,r4,#8
	cmp r4,r5					;160*4/3=213.33333
	ble fglo2

	bl RedrawFGTiles
	ldmfd sp!,{r3-r9,r11,pc}

allocfgmem
	bic r1,r1,#0x80				;test
	tst r1,#0x100
	ldrneb r1,fgmemalloc
	str r1,[r3,r6]				;strne?
	beq fgret

	addne r6,r1,#1
	strneb r6,fgmemalloc
	tst r6,#0x80
	beq fgret

	movne r6,#0
	strneb r6,fgmemreload
	strneb r6,fgmemalloc
	b fgret

;----------------------------------------------------------------------------
RedrawBGTiles
;----------------------------------------------------------------------------
;	mov r11,r11
	mov addy,lr
	ldr r5,=CHR_DECODE2
	ldr r7,=BG_TILELUT
	mov r8,#0xff
bgtiloop
	ldrb r1,[r7,r8]
	tst r1,#0xa0
	bleq dobgtiles
	subs r8,r8,#1
	bpl bgtiloop
	mov pc,addy

dobgtiles
	orr r1,r1,#0x20				;must be #0x20 for tileram 2
	strb r1,[r7,r8]
	ldr r2,=DIRTYSPRITES
	ldrb r0,[r2,r8]				;read from dirtymap.
	tst r0,#0x20
	moveq pc,lr
	bic r0,r0,#0x20
	strb r0,[r2,r8]				;write to dirtymap.
dobgtiles2
	ldr r3,vrombase1			;r3 = bitplane 0
	add r4,r3,#0x10000			;r4 = bitplane 1 & 2
	add r4,r4,r8,lsl#9
	mov r6,#AGB_VRAM			;r6=AGB BG tileset
	add r6,r6,r1,lsl#10			;tile ram 2

	and r0,r8,#0xfc0
	bic r1,r8,#0x20
	sub r1,r1,r0,lsr#1
	add r3,r3,r1,lsl#9
	tst r8,#0x20
	bne bgchr2

bgchr1
	ldrb r0,[r3],#1				;read 3rd plane
	ldrb r1,[r4],#1				;read 1st & 2nd plane
	and r0,r0,#0xf

	ldr r0,[r5,r0,lsl#2]
	ldr r1,[r5,r1,lsl#2]
	orr r2,r1,r0,lsl#2

	ldrb r0,[r3,#15]			;read 3rd plane
	ldrb r1,[r4,#15]			;read 1st & 2nd plane
	and r0,r0,#0xf

	ldr r0,[r5,r0,lsl#2]
	ldr r1,[r5,r1,lsl#2]
	orr r0,r1,r0,lsl#2
	orr r0,r2,r0,lsl#16
	str r0,[r6],#4

	tst r6,#0x1c
	bne bgchr1

	add r3,r3,#24
	add r4,r4,#24

	tsteq r6,#0x20
	bne bgchr1
	sub r3,r3,#56
	sub r4,r4,#56
	tsteq r6,#0x40
	bne bgchr1

	add r3,r3,#48
	add r4,r4,#48
	tsteq r6,#0x380
	bne bgchr1

	mov pc,lr

bgchr2
	ldrb r0,[r3],#1				;read 3rd plane
	ldrb r1,[r4],#1				;read 1st & 2nd plane
	mov r0,r0,lsr#4

	ldr r0,[r5,r0,lsl#2]
	ldr r1,[r5,r1,lsl#2]
	orr r2,r1,r0,lsl#2

	ldrb r0,[r3,#15]			;read 3rd plane
	ldrb r1,[r4,#15]			;read 1st & 2nd plane
	mov r0,r0,lsr#4

	ldr r0,[r5,r0,lsl#2]
	ldr r1,[r5,r1,lsl#2]
	orr r0,r1,r0,lsl#2
	orr r0,r2,r0,lsl#16
	str r0,[r6],#4

	tst r6,#0x1c
	bne bgchr2

	add r3,r3,#24
	add r4,r4,#24

	tsteq r6,#0x20
	bne bgchr2
	sub r3,r3,#56
	sub r4,r4,#56
	tsteq r6,#0x40
	bne bgchr2

	add r3,r3,#48
	add r4,r4,#48
	tsteq r6,#0x380
	bne bgchr2

	mov pc,lr
;----------------------------------------------------------------------------
RedrawFGTiles
;----------------------------------------------------------------------------
;	mov r11,r11
	mov addy,lr
	ldr r5,=CHR_DECODE1
	ldr r7,=FG_TILELUT
	mov r8,#0xff
fgtiloop
	ldr r1,[r7,r8,lsl#2]
	tst r1,#0x180
	bleq dofgtiles
	subs r8,r8,#1
	bpl fgtiloop
	mov pc,addy

dofgtiles
	orr r1,r1,#0x80				;must be #0x80 for tileram 1.5
	str r1,[r7,r8,lsl#2]
	ldr r2,=DIRTYSPRITES
	ldrb r0,[r2,r8]				;read from dirtymap.
	tst r0,#0x40
	moveq pc,lr
	bic r0,r0,#0x40
	strb r0,[r2,r8]				;write to dirtymap.
dofgtiles2
	ldr r4,vrombase0			;get vrombase fg
	mov r6,#AGB_VRAM			;r3=AGB BG tileset
	add r4,r4,r8,lsl#7
	add r6,r6,r1,lsl#7			;tile ram 2

fgchr1							;do 4 8x8 tiles
	ldrb r0,[r4],#1				;read 1st & 2nd pixels
	ldrb r1,[r4,#7]				;read 3rd & 4th pixels
	ldrb r2,[r4,#15]			;read 5th & 6th pixels
	ldrb r3,[r4,#23]			;read 7th & 8th pixels

	ldrb r0,[r5,r0]
	ldrb r1,[r5,r1]
	ldrb r2,[r5,r2]
	ldrb r3,[r5,r3]
	orr r0,r0,r1,lsl#8
	orr r0,r0,r2,lsl#16
	orr r0,r0,r3,lsl#24
	str r0,[r6],#4
	tst r6,#0x1c
	addeq r4,r4,#24
	tsteq r6,#0x60
	bne fgchr1

	mov pc,lr


;----------------------------------------------------------------------------
HuMapper_	;rom paging..
;----------------------------------------------------------------------------
	stmfd sp!,{r3-r7}
	ldr r6,=MEMMAPTBL_
	ldr r2,[r6,r1,lsl#2]!
	ldr r3,[r6,#-1024]		;RDMEMTBL_
	ldr r4,[r6,#-2048]		;WRMEMTBL_

	mov r5,#0
	cmp r1,#0x88
	movmi r5,#12

wr_tbl
	adr r6,readmem_tbl
	add r7,r6,#96
	tst r0,#0xFF
	bne memaps				;safety
	b flush
memapl
	add r6,r6,#4
	add r7,r7,#1
memap2
	add r3,r3,r5
	sub r2,r2,#0x2000
memaps
	movs r0,r0,lsr#1
	bcc memapl				;C=0
	strcs r3,[r6],#4		;readmem_tbl
	strcs r4,[r6,#28]		;writemem_tb
	strcs r2,[r6,#60]		;memmap_tbl
	strcsb r1,[r7],#1		;MPR reg
	bne memap2

;------------------------------------------
flush		;update cpu_pc & lastbank
;------------------------------------------
	ldr r1,lastbank
	sub m6502_pc,m6502_pc,r1
	encodePC

	ldmfd sp!,{r3-r7}
	mov pc,lr


;----------------------------------------------------------------------------
 [ BUILD = "DEBUG"
 AREA zzzzz, DATA, READWRITE ;MUST be last area

	DCB "0123456789abcdef0123456789abcde",0
	DCD 16400 ;romsize
	DCD 0 ;flags
	DCD 0 ;follow
	DCD 0 ;reserved
	DCB "NES",0x1a,8,8,0,0,0,0,0,0,0,0,0,0

 ]
;----------------------------------------------------------------------------
 AREA wram_globals2, CODE, READWRITE

romstart
	DCD 0 ;rombase
romnum
	DCD 0 ;romnumber
rominfo                 ;keep emuflags/BGmirror together for savestate/loadstate
g_emuflags	DCB 0 ;emuflags        (label this so UI.C can take a peek) see equates.h for bitfields
g_scaling	DCB SCALED_SPRITES ;(display type)
	% 2   ;(sprite follow val)
	DCD 0 ;BGmirror		(BG size for BG0CNT)

	DCD 0 ;rommask
	DCD 0 ;vrombase0
	DCD 0 ;vrombase1
	DCD 0 ;vrombase2

g_cartflags
	DCB 0 ;cartflags
g_dipswitch1
	DCB 0 ;dipswitch1
g_dipswitch2
	DCB 0 ;dipswitch2

;----------------------------------------------------------------------------
	END

