//-----------------------------------------------------------------------------
// MEKA - keysname.h
// Keyboard Keys Names - Headers
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitions
//-----------------------------------------------------------------------------

#define KEY_INFO_PRINTABLE    (0x01)
#define KEY_INFO_ALLOW_USE    (0x02)

//-----------------------------------------------------------------------------
// Data
//-----------------------------------------------------------------------------

typedef struct
{
    int     scancode;
    char *  name;
    int     flags;
} t_key_info;

//-----------------------------------------------------------------------------
// Functions
//-----------------------------------------------------------------------------

const t_key_info *    KeyInfo_FindByScancode(int scancode);
const t_key_info *    KeyInfo_FindByName(const char *name);

//-----------------------------------------------------------------------------

