/*///////////////////////////////////////////////////////////////////////////
// Name:        romslist.h
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
///////////////////////////////////////////////////////////////////////////*/

#include "../wxheaders.h" /* For wxWidget Support */ 

class RomsList
{
public:
	RomsList(wxString FileToParse); /* Loads the Roms List File into memory */
	~RomsList();
	
	bool IsInitialized(); /* Tells wether a roms.list file was successfully loaded */
	
	/* Set the index to the line where the MD5 sum is corresponding */
	/* Return whether or not a MD5 Sum was found or not             */
	bool SetIndexToMD5Sum(wxString MD5Sum);
	
	wxString GetRomName(); /* Must be called after SetIndexToMD5Sum */
	wxString GetRomType(); /* Must be called after SetIndexToMD5Sum */
	wxString GetRomRegion(); /* Must be called after SetIndexToMD5Sum */
	wxString GetRomScreenshotName(); /* Must be called after SetIndexToMD5Sum */

private:
	/* The console from which all the roms are */
	wxString RomsConsole;
	
	/* Things to load to every kind of rom */
	wxString RomsListFile;
	wxArrayString MD5Sums;
	wxArrayString RomNames;
	wxArrayString RomTypes;
	wxArrayString RomRegions;
	
	bool Initialized; /* Indicates if a Rom list is loaded */
	long Index; /* The line of the arrays where we are pointing */
};
