/////////////////////////////////////////////////////////////////////////////
// Name:        romlistctrl.h
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "../wxheaders.h"

#include "../configuration/configuration.h" // for Configuration Class

class RomListCtrl : public wxListCtrl
{
public:
    RomListCtrl(wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, long style);
        
    
    void OnDblClickOnRomList(wxListEvent& event);
    
    void GetConfig(Configuration * Config)
    {
    	this->Config = Config;
    };
    
    // The list of files in the romlistCtrl
    wxArrayString RomFilenames;

private:

    // Launch a rom from a filename
    void LaunchRom(wxString RomFileName);
    
    // The config taken from the MyFrame with GetConfig()
    Configuration * Config;
    
    DECLARE_EVENT_TABLE()
}; 
