/////////////////////////////////////////////////////////////////////////////
// Name:        romlistctrl.cpp
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "romlistctrl.h" // Header

#include "enum.h" // For constants enumeration constitency

// ----------------------------------------------------------------------------
// event tables and other macros for wxWindows
// ----------------------------------------------------------------------------

// the event tables connect the wxWindows events with the functions (event
// handlers) which process them. It can be also done at run-time, but for the
// simple menu events like this the static method is much simpler.
BEGIN_EVENT_TABLE(RomListCtrl, wxListCtrl)
    EVT_LIST_ITEM_ACTIVATED(wxOsmose_List_Rom, RomListCtrl::OnDblClickOnRomList)
END_EVENT_TABLE()

// -----------------------------------------------------------------------------
// MyTextCtrl
// -----------------------------------------------------------------------------

RomListCtrl::RomListCtrl(wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, long style)
        : wxListCtrl(parent, id, pos, size, style)
{
	Config = 0;
	// The list of files in the romlistCtrl
	RomFilenames.Clear();
}

void RomListCtrl::OnDblClickOnRomList(wxListEvent& event)
{
	// We open the selected rom
	wxString SelectedRom = RomFilenames[event.GetIndex()];
	LaunchRom(SelectedRom);
}

void RomListCtrl::LaunchRom(wxString RomFileName)
{
	#ifdef _DEBUG_
		wxLogMessage(Config->GetUserHomeDirectory());
		wxLogMessage(Config->GetExecutableFilename());
		wxLogMessage(Config->GetLastOpenedDirectory());
	#endif
	
	// Check line-command Options
	wxString Options = _T("");
	
	// Video
	if ( Config->IsFullScreenEnabled() )
	{
		Options += _T(" -fs");
	}
	
	if ( Config->IsTVModeEnabled() )
	{
		Options += _T(" -tv");
	}
	
	if ( Config->IsScale2xEnabled() )
	{
		Options += _T(" -scale2x");
	}
	
	if ( Config->IsDarkPaletteEnabled() )
	{
		Options += _T(" -dp");
	}
	
	if ( Config->IsMonochromEnabled() )
	{
		Options += _T(" -monochrom");
	}
	
	if ( Config->IsFPSDisplayEnabled() )
	{
		Options += _T(" -fps");
	}
	
	// Audio
	if ( !(Config->IsSoundEnabled()) )
	{
		Options += _T(" -nosound");
	}
	
	// Options
	if ( Config->IsMousepadEnabled() )
	{
		Options += _T(" -paddle");
		Options += wxString::Format(_T(" -acceleration %0.00f"), float(Config->GetMousepadAcceleration()) );
		
	}
	// Zone
	if ( Config->IsJapaneseModeEnabled() )
	{
		Options += _T(" -jap");
	}
	
	if ( Config->IsPALModeEnabled() )
	{
		Options += _T(" -pal");
	}
	
	// Check if ini file exists
	wxString IniFile = _T("");
	wxString wxOsmoseIniFullName = _T("");
	#ifdef __USE_UNIX98
	wxOsmoseIniFullName = Config->GetUserHomeDirectory();
	wxOsmoseIniFullName += _T("/.osmose/wxosmose.ini");
	#endif
	#ifdef _WIN32
	wxOsmoseIniFullName = wxGetCwd(); // The current directory...
	wxOsmoseIniFullName += _T("\wxosmose.ini"); 
	#endif
	
	if ( !( wxFileExists( wxOsmoseIniFullName ) ) )
	{
		IniFile = _T(""); // Use defaults
	}
	else
	{
		IniFile = _T(" -inifile \"");
		IniFile += wxOsmoseIniFullName;
		IniFile += _T("\" ");
	}
	
	wxString RomPath = _T("");
	wxString Command = _T("\"");
	Command += Config->GetExecutableFilename();
	Command += _T("\"");
	if ( Command == wxString::Format(_T("\"\"")) )
	{
		Command = _T("./osmose");
	}
	
	if ( wxFileExists( RomFileName ) )
	{
		RomPath = _T(" \"");
		RomPath += RomFileName;
		RomPath += _T("\"");
		Command += RomPath + Options + IniFile; 
		#ifdef _DEBUG_
			wxLogMessage(Command);
		#endif
		/*int ReturnCode =*/ wxExecute(Command, wxEXEC_SYNC);
	}
}
