/////////////////////////////////////////////////////////////////////////////
// Name:        mytextctrl.cpp
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "mytextctrl.h" // Header

#include "enum.h" // For constants enumeration constitency

// ----------------------------------------------------------------------------
// event tables and other macros for wxWindows
// ----------------------------------------------------------------------------

// the event tables connect the wxWindows events with the functions (event
// handlers) which process them. It can be also done at run-time, but for the
// simple menu events like this the static method is much simpler.
BEGIN_EVENT_TABLE(MyTextCtrl, wxTextCtrl)
	EVT_KEY_DOWN(MyTextCtrl::OnKeyDown)
END_EVENT_TABLE()

// -----------------------------------------------------------------------------
// MyTextCtrl
// -----------------------------------------------------------------------------

MyTextCtrl::MyTextCtrl(wxWindow *parent, wxWindowID id, const wxString &value,
               const wxPoint &pos, const wxSize &size)
        : wxTextCtrl(parent, id, value, pos, size)
{
	// Nothing
}

void MyTextCtrl::OnKeyDown(wxKeyEvent& event)
{
	// cout << "KeyDown" << endl;
	event.Skip();
	// Return the code of the pushed key.
	((wxDialog *)FindWindowById(wxOsmose_ChangeAKeyDialog))->EndModal(event.GetKeyCode());
}
