/////////////////////////////////////////////////////////////////////////////
// Name:        aboutdialog.cpp
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "myaboutdialog.h" // header

#include "../version.h" // For obtaining the version number

#if defined(__WXGTK__) || defined(__WXMOTIF__) || defined(__WXMAC__) || defined(__WXMGL__) || defined(__WXX11__)
    #include "../ressources/osmose_logo.xpm"
#endif

// ----------------------------------------------------------------------------
// event tables and other macros for wxWindows
// ----------------------------------------------------------------------------

// the event tables connect the wxWindows events with the functions (event
// handlers) which process them. It can be also done at run-time, but for the
// simple menu events like this the static method is much simpler.
BEGIN_EVENT_TABLE(MyAboutDialog, wxDialog)
    
    EVT_PAINT(MyAboutDialog::OnPaint)
    
END_EVENT_TABLE()


// ----------------------------------------------------------------------------
// Key Change Dialog
// ----------------------------------------------------------------------------

// frame constructor
MyAboutDialog::MyAboutDialog(wxWindow * parent, const wxString& title, const wxPoint& pos, const wxSize& size)
       : wxDialog(parent, -1, title, pos, size)
{
	wxPoint TempPosition;

	OsmoseBitmap = 0;
	OsmoseBitmap = new wxBitmap(wxBITMAP(osmose));
	
	wxSize TextSize;
	wxPoint TextPosition;
	wxStaticText * About_Text = 0;
	
	wxString wxOsmOseVersion = wxString::Format(wxT(WXOSMOSE_VERSION));
	wxString MinimumOsmoseVersion = wxString::Format(wxT(OSMOSE_MINIMUM_VERSION));
	wxString Message = wxString::Format(_T("wxOsmOse is the Front-End of the Osmose Master System Emulator.\nVersion : %s\nAuthor : Bertram <bertram@cegetel.net>\nLicense : GPL v2.0\n\nMinimum OsmOse Version : %s\nOsmOse's Author : Bruno Vedder <bruno.vedder@emu-france.com>"), wxOsmOseVersion.c_str(), MinimumOsmoseVersion.c_str());
	
	About_Text = new wxStaticText(this, -1, Message, wxPoint(10,-1));
	About_Text->Centre(wxHORIZONTAL);
	TempPosition = About_Text->GetPosition();
	TextPosition.x = TempPosition.x;
	TextPosition.y = OsmoseBitmap->GetHeight() + 2*5;
	About_Text->SetPosition( TextPosition );
	TextSize = About_Text->GetSize();
	
	wxSize ButtonSize;
	wxPoint ButtonPosition;
	wxButton * Button_Ok = 0;
	Button_Ok = new wxButton(this, wxID_OK, _T("Ok"), wxPoint(40, -1), wxSize(-1, -1));
	Button_Ok->Centre(wxHORIZONTAL);
	TempPosition = Button_Ok->GetPosition();
	ButtonPosition.x = TempPosition.x;
	ButtonPosition.y = OsmoseBitmap->GetHeight() + TextSize.GetHeight()+3*5;
	Button_Ok->SetPosition( ButtonPosition );
	ButtonSize = Button_Ok->GetSize();
	
	SetSize(OsmoseBitmap->GetWidth() + 2*10, OsmoseBitmap->GetHeight() + TextSize.GetHeight() + ButtonSize.GetHeight() + 4*5);
	Centre();
	
	About_Text->Centre(wxHORIZONTAL);
	TempPosition = About_Text->GetPosition();
	TextPosition.x = TempPosition.x;
	TextPosition.y = OsmoseBitmap->GetHeight() + 2*5;
	About_Text->SetPosition( TextPosition );
	TextSize = About_Text->GetSize();
	
	Button_Ok->Centre(wxHORIZONTAL);
	TempPosition = Button_Ok->GetPosition();
	ButtonPosition.x = TempPosition.x;
	ButtonPosition.y = OsmoseBitmap->GetHeight() + TextSize.GetHeight()+3*5;
	Button_Ok->SetPosition( ButtonPosition );

}

void MyAboutDialog::OnPaint(wxPaintEvent& event)
{
      wxPaintDC dc(this);
      dc.DrawBitmap(*OsmoseBitmap, 10, 5, false);
}
