/////////////////////////////////////////////////////////////////////////////
// Name:        keydialog.h
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "../wxheaders.h" // Header

// Define a new Dialog type: this is going to be our Key Change Dialog
class KeyDialog : public wxDialog
{
public:
    // ctor(s)
    KeyDialog(wxWindow * parent, const wxString& title, const wxPoint& pos, const wxSize& size);

    // event handlers (these functions should _not_ be virtual)
    
    void OnChangeAKey(wxCommandEvent& event);

    void OnChangeMousepad(wxCommandEvent& event);
    void OnChangeMousepadAcceleration(wxCommandEvent& event);
    
private:

 // Temporary Keys
    int P1_Up;
    int P1_Down;
    int P1_Left;
    int P1_Right;
    int P1_A;
    int P1_B;
    
    int P2_Up;
    int P2_Down;
    int P2_Left;
    int P2_Right;
    int P2_A;
    int P2_B;
    
    int Pause;
    int Screenshot;
    int Tileshot;
    int Soundshot;
    int Quit;

    bool Mousepad;
    double MousepadAcceleration;
    #ifdef _DEBUG_CONSOLE_
    int Debug;
    #endif
    
    // Update the window display correctly
    void UpdateKeyPanel();
    
    // Obtain SDL Key equivalent for Key pushed in wxWidgets.
    int GetSDLKeyFromWXKey(int MyWXKey);
    
    // For the Gamepads painting
    void OnPaint(wxPaintEvent& event);
    
    // The PixMap of a Master System Gamepad
    wxBitmap * GamePadBitmap;

    // any class wishing to process wxWindows events must use this macro
    DECLARE_EVENT_TABLE()
}; 
