/////////////////////////////////////////////////////////////////////////////
// Name:        keydialog.cpp
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "keydialog.h" // header
#include "changeakeydialog.h" // For the changeakeydialog class
#include "myframe.h" // For the MyFrame class

// SDL
#include "../SDL/SDL_keysym.h" // For SDL keys comprehension

#include "enum.h" // For constants enumeration constitency

#if defined(__WXGTK__) || defined(__WXMOTIF__) || defined(__WXMAC__) || defined(__WXMGL__) || defined(__WXX11__)
    #include "../ressources/pad.xpm"
#endif

// ----------------------------------------------------------------------------
// event tables and other macros for wxWindows
// ----------------------------------------------------------------------------

// the event tables connect the wxWindows events with the functions (event
// handlers) which process them. It can be also done at run-time, but for the
// simple menu events like this the static method is much simpler.
BEGIN_EVENT_TABLE(KeyDialog, wxDialog)
	EVT_BUTTON(wxOsmose_Button_P1_Up, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P1_Down, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P1_Left, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P1_Right, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P1_A, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P1_B, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P2_Up, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P2_Down, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P2_Left, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P2_Right, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P2_A, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_P2_B, KeyDialog::OnChangeAKey)

	EVT_BUTTON(wxOsmose_Button_Pause, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_Quit, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_Screenshot, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_Tileshot, KeyDialog::OnChangeAKey)
	EVT_BUTTON(wxOsmose_Button_Soundshot, KeyDialog::OnChangeAKey)
	
	EVT_CHECKBOX(wxOsmose_CheckBox_Mousepad, KeyDialog::OnChangeMousepad)
	EVT_SLIDER(wxOsmose_Slider_MousepadAcceleration, KeyDialog::OnChangeMousepadAcceleration)
	#ifdef _DEBUG_CONSOLE_
	EVT_BUTTON(wxOsmose_Button_Debug, KeyDialog::OnChangeAKey)
	#endif
	EVT_BUTTON(wxOsmose_Button_Ok, KeyDialog::OnChangeAKey)
	
	EVT_PAINT(KeyDialog::OnPaint)
END_EVENT_TABLE()

// ----------------------------------------------------------------------------
// Key Change Dialog
// ----------------------------------------------------------------------------

// frame constructor
KeyDialog::KeyDialog(wxWindow * parent, const wxString& title, const wxPoint& pos, const wxSize& size)
       : wxDialog(parent, -1, title, pos, size)
{

	// We save keys first
	P1_Up = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_Up;
	P1_Down = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_Down;
	P1_Left = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_Left;
	P1_Right = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_Right;
	P1_A = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_A;
	P1_B = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_B;
    
	P2_Up = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_Up;
	P2_Down = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_Down;
	P2_Left = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_Left;
	P2_Right = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_Right;
	P2_A = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_A;
	P2_B = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_B;
	
	Pause = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.Pause;
	Screenshot = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.Screenshot;
	Tileshot = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.Tileshot;
	Soundshot = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.Soundshot;
	Quit = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.Quit;

	Mousepad = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.IsMousepadEnabled();
	MousepadAcceleration = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.GetMousepadAcceleration();
	#ifdef _DEBUG_CONSOLE_
	Debug = ((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.DebugKey;
	#endif
	
	GamePadBitmap = 0;
	GamePadBitmap = new wxBitmap(wxBITMAP(pad));
	
	// We put the buttons and the static texts
	wxButton * Button_Ok = 0;
	Button_Ok = new wxButton (this, wxOsmose_Button_Ok, _T("Ok"), wxPoint(350,270));
	wxButton * Button_Cancel = 0;
	Button_Cancel = new wxButton (this, wxID_CANCEL, _T("Cancel"), wxPoint(350,300));
	
	// Static Texts 
	wxStaticText * Pad1 = 0;
	Pad1 = new wxStaticText(this, -1, _T("Pad 1"), wxPoint(130,15));
	wxStaticText * Pad2 = 0;
	Pad2 = new wxStaticText(this, -1, _T("Pad 2"), wxPoint(130,160));
	
	// Keys Button
	wxString MyKey = _T("");
	
	wxButton * Button_P1_Up = 0;
	Button_P1_Up = new wxButton (this, wxOsmose_Button_P1_Up, _T("^"), wxPoint(55,30), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P1_Up);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P1_Up = 0;
	Text_P1_Up = new wxStaticText(this, wxOsmose_Text_P1_Up, MyKey, wxPoint(40,115));
	
	wxButton * Button_P1_Left = 0;
	Button_P1_Left = new wxButton (this, wxOsmose_Button_P1_Left, _T("<"), wxPoint(35,50), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P1_Left);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P1_Left = 0;
	Text_P1_Left = new wxStaticText(this, wxOsmose_Text_P1_Left, MyKey, wxPoint(10,125));
	
	wxButton * Button_P1_Right = 0;
	Button_P1_Right = new wxButton (this, wxOsmose_Button_P1_Right, _T(">"), wxPoint(75,50), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P1_Right);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P1_Right = 0;
	Text_P1_Right = new wxStaticText(this, wxOsmose_Text_P1_Right, MyKey, wxPoint(80,125));
	
	wxButton * Button_P1_Down = 0;
	Button_P1_Down = new wxButton (this, wxOsmose_Button_P1_Down, _T("v"), wxPoint(55,70), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P1_Down);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P1_Down = 0;
	Text_P1_Down = new wxStaticText(this, wxOsmose_Text_P1_Down, MyKey, wxPoint(40,135));
	
	wxButton * Button_P1_A = 0;
	Button_P1_A = new wxButton (this, wxOsmose_Button_P1_A, _T("A"), wxPoint(182,68), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P1_A);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P1_A = 0;
	Text_P1_A = new wxStaticText(this, wxOsmose_Text_P1_A, MyKey, wxPoint(180,115));
	
	wxButton * Button_P1_B = 0;
	Button_P1_B = new wxButton (this, wxOsmose_Button_P1_B, _T("B"), wxPoint(231,68), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P1_B);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P1_B = 0;
	Text_P1_B = new wxStaticText(this, wxOsmose_Text_P1_B, MyKey, wxPoint(225,125));
	
	wxButton * Button_P2_Up = 0;
	Button_P2_Up = new wxButton (this, wxOsmose_Button_P2_Up, _T("^"), wxPoint(55,176), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P2_Up);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P2_Up = 0;
	Text_P2_Up = new wxStaticText(this, wxOsmose_Text_P2_Up, MyKey, wxPoint(40,260));
	
	wxButton * Button_P2_Left = 0;
	Button_P2_Left = new wxButton (this, wxOsmose_Button_P2_Left, _T("<"), wxPoint(35,196), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P2_Left);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P2_Left = 0;
	Text_P2_Left = new wxStaticText(this, wxOsmose_Text_P2_Left, MyKey, wxPoint(10,270));
	
	wxButton * Button_P2_Right = 0;
	Button_P2_Right = new wxButton (this, wxOsmose_Button_P2_Right, _T(">"), wxPoint(75,196), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P2_Right);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P2_Right = 0;
	Text_P2_Right = new wxStaticText(this, wxOsmose_Text_P2_Right, MyKey, wxPoint(80,270));
	
	wxButton * Button_P2_Down = 0;
	Button_P2_Down = new wxButton (this, wxOsmose_Button_P2_Down, _T("v"), wxPoint(55,216), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P2_Down);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P2_Down = 0;
	Text_P2_Down = new wxStaticText(this, wxOsmose_Text_P2_Down, MyKey, wxPoint(40,280));
	
	wxButton * Button_P2_A = 0;
	Button_P2_A = new wxButton (this, wxOsmose_Button_P2_A, _T("A"), wxPoint(182,213), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P2_A);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P2_A = 0;
	Text_P2_A = new wxStaticText(this, wxOsmose_Text_P2_A, MyKey, wxPoint(180,260));
	
	wxButton * Button_P2_B = 0;
	Button_P2_B = new wxButton (this, wxOsmose_Button_P2_B, _T("B"), wxPoint(231,213), wxSize(20,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(P2_B);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_P2_B = 0;
	Text_P2_B = new wxStaticText(this, wxOsmose_Text_P2_B, MyKey, wxPoint(225,270));
	
	wxButton * Button_Pause = 0;
	Button_Pause = new wxButton (this, wxOsmose_Button_Pause, _T("Pause"), wxPoint(310,20));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(Pause);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_Pause = 0;
	Text_Pause = new wxStaticText(this, wxOsmose_Text_Pause, MyKey, wxPoint(410,25));
	
	wxButton * Button_Quit = 0;
	Button_Quit = new wxButton (this, wxOsmose_Button_Quit, _T("Quit"), wxPoint(310,50));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(Quit);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_Quit = 0;
	Text_Quit = new wxStaticText(this, wxOsmose_Text_Quit, MyKey, wxPoint(410,55));
	
	wxButton * Button_Screenshot = 0;
	Button_Screenshot = new wxButton (this, wxOsmose_Button_Screenshot, _T("Screenshot"), wxPoint(310,80));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(Screenshot);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_Screenshot = 0;
	Text_Screenshot = new wxStaticText(this, wxOsmose_Text_Screenshot, MyKey, wxPoint(410,85));
	
	wxButton * Button_Tileshot = 0;
	Button_Tileshot = new wxButton (this, wxOsmose_Button_Tileshot, _T("Tileshot"), wxPoint(310,110));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(Tileshot);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_Tileshot = 0;
	Text_Tileshot = new wxStaticText(this, wxOsmose_Text_Tileshot, MyKey, wxPoint(410,115));
	
	wxButton * Button_Soundshot = 0;
	Button_Soundshot = new wxButton (this, wxOsmose_Button_Soundshot, _T("Soundshot on/off"), wxPoint(310,140));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(Soundshot);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_Soundshot = 0;
	Text_Soundshot = new wxStaticText(this, wxOsmose_Text_Soundshot, MyKey, wxPoint(410,145));
	
	#ifdef _DEBUG_CONSOLE_
	wxButton * Button_Debug = 0;
	Button_Debug = new wxButton (this, wxOsmose_Button_Debug, _T("Debug"), wxPoint(310,170));
	MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(Debug);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	wxStaticText * Text_DebugKey = 0;
	Text_DebugKey = new wxStaticText(this, wxOsmose_Text_Debug, MyKey, wxPoint(410,175));
	#endif
	
	wxButton * Button_SaveState = 0;
	Button_SaveState = new wxButton (this, wxOsmose_Button_SaveState, _T("Save Game State"), wxPoint(30,300));
	//MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(SaveState);
	//MyKey = MyKey.substr(5, MyKey.length() - 5);
	Button_SaveState->Disable();
	wxStaticText * Text_SaveState = 0;
	Text_SaveState = new wxStaticText(this, wxOsmose_Text_SaveState, _T("<Nothing>"), wxPoint(30,330));
	
	wxButton * Button_LoadState = 0;
	Button_LoadState = new wxButton (this, wxOsmose_Button_LoadState, _T("Load Game State"), wxPoint(130,300));
	//MyKey = ((MyFrame*)parent)->Config.GetStringKeyFromSDLKey(LoadState);
	//MyKey = MyKey.substr(5, MyKey.length() - 5);
	Button_LoadState->Disable();
	wxStaticText * Text_LoadState = 0;
	Text_LoadState = new wxStaticText(this, wxOsmose_Text_LoadState, _T("<Nothing>"), wxPoint(130,330));

	wxCheckBox * CheckBox_Mousepad = 0;
	CheckBox_Mousepad = new wxCheckBox(this, wxOsmose_CheckBox_Mousepad, _T("Enable Mousepad"), wxPoint(310,205), wxDefaultSize, wxCHK_2STATE);
	CheckBox_Mousepad->SetValue(Mousepad);

	wxSlider * Slider_MousepadAcceleration = 0;
	Slider_MousepadAcceleration = new wxSlider(this, wxOsmose_Slider_MousepadAcceleration, int(MousepadAcceleration*100), 0, 200, wxPoint(310,240), wxSize(150,20), wxSL_HORIZONTAL);

}

void KeyDialog::OnPaint(wxPaintEvent& event)
{
      wxPaintDC dc(this);
      dc.DrawBitmap(*GamePadBitmap, 10, 5, false);
      dc.DrawBitmap(*GamePadBitmap, 10, 150, false);
}

void KeyDialog::UpdateKeyPanel()
{
	wxString MyKey;
	//((MyFrame*) FindWindowById(wxOsmose_MainFrame)) == MyFrame * MainFrame
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P1_Up);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P1_Up))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P1_Left);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P1_Left))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P1_Right);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P1_Right))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P1_Down);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P1_Down))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P1_A);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P1_A))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P1_B);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P1_B))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P2_Up);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P2_Up))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P2_Left);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P2_Left))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P2_Right);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P2_Right))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P2_Down);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P2_Down))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P2_A);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P2_A))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(P2_B);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_P2_B))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(Screenshot);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_Screenshot))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(Tileshot);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_Tileshot))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(Soundshot);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_Soundshot))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(Pause);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_Pause))->SetLabel(MyKey);
	
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(Quit);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_Quit))->SetLabel(MyKey);
	
	#ifdef _DEBUG_CONSOLE
	MyKey = ((MyFrame*) FindWindowById(wxOsmose_MainFrame))->Config.GetStringKeyFromSDLKey(Debug);
	MyKey = MyKey.substr(5, MyKey.length() - 5);
	((wxStaticText *)FindWindowById(wxOsmose_Text_Debug))->SetLabel(MyKey);
	#endif
	
}

void KeyDialog::OnChangeAKey(wxCommandEvent& event)
{
	
	int ReturnedKey = 0;
	
	// If we don't want to close the window applying changes, we open the change key window.
	if ( event.GetId() != wxOsmose_Button_Ok )
	{
	
		ChangeAKeyDialog NewKeyDialog(this, _T("Type a new Key..."), wxPoint(-1,-1));
		
		ReturnedKey = NewKeyDialog.ShowModal();
		//wxLog(wxString::Format(_T("Pushed Key : %i"), ReturnedKey));
	
	}
	
	if ( ReturnedKey != wxID_CANCEL && ReturnedKey != -1 )
	{
		// Depending on the button that was pushed...
		switch ( event.GetId() )
		{
			default:
				// Something got wrong...
			break;
			
			case wxOsmose_Button_P1_Up:
				P1_Up = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P1_Down:
				P1_Down = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P1_Left:
				P1_Left = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P1_Right:
				P1_Right = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P1_A:
				P1_A = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P1_B:
				P1_B = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P2_Up:
				P2_Up = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P2_Down:
				P2_Down = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P2_Left:
				P2_Left = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P2_Right:
				P2_Right = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P2_A:
				P2_A = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_P2_B:
				P2_B = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_Pause:
				Pause = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_Quit:
				Quit = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_Screenshot:
				Screenshot = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_Tileshot:
				Tileshot = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			case wxOsmose_Button_Soundshot:
				Soundshot = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			#ifdef _DEBUG_CONSOLE_
			case wxOsmose_Button_Debug:
				Debug = GetSDLKeyFromWXKey(ReturnedKey);
			break;
			#endif
			
			
			case wxOsmose_Button_Ok:
				// Apply Changes
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_Up = P1_Up;
    				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_Down = P1_Down;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_Left = P1_Left;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_Right = P1_Right;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_A = P1_A;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P1_B = P1_B;
				
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_Up = P2_Up;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_Down = P2_Down;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_Left = P2_Left;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_Right = P2_Right;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_A = P2_A;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.P2_B = P2_B;
				
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.Pause = Pause;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.Screenshot = Screenshot;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.Tileshot = Tileshot;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.Soundshot = Soundshot;
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.Quit = Quit;

				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.SetMousepadEnabled(Mousepad);
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.SetMousepadAcceleration(MousepadAcceleration);
				#ifdef _DEBUG_CONSOLE_
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.DebugKey = Debug;
				#endif
				
				// We save them to make the emulator know the new keys.
				((MyFrame *) FindWindowById(wxOsmose_MainFrame))->Config.WriteConfig();
				Close(TRUE);
			break;
		}
	
	}
	else
	{
		// Bad or unsupported Input
		wxString msg;
    		msg.Printf( _T("Something got wrong or the key you just pushed isn't supported.\nAll keys aren't supported on purpose, don't worry and try something else..."));

    		wxMessageBox(msg, _T("About the key you just pressed..."), wxOK | wxICON_INFORMATION, this);
	}
	UpdateKeyPanel();
	
}

void KeyDialog::OnChangeMousepad(wxCommandEvent& event)
{
	/* Toggle Mousepad in config */
	Mousepad = ((wxCheckBox *) FindWindowById(wxOsmose_CheckBox_Mousepad))->GetValue();
}

void KeyDialog::OnChangeMousepadAcceleration(wxCommandEvent& event)
{
	MousepadAcceleration = double( (float)((wxSlider *) FindWindowById(wxOsmose_Slider_MousepadAcceleration))->GetValue() / 100 );
}

// For wxKey to SDLKey translation
int KeyDialog::GetSDLKeyFromWXKey(int MyWXKey)
{
	// By this, we get the correct Alt Key.
	if ( MyWXKey == SDLK_RALT )
		return SDLK_LALT;
	
	switch ( MyWXKey )
	{
		// For all alpahnumeric and ASCII standard
		default:
			return MyWXKey;
		break;
		
		// For all non supported keys
		case WXK_START:
 		case WXK_LBUTTON:
 		case WXK_RBUTTON:
 		case WXK_CANCEL:
 		case WXK_MBUTTON:
		case WXK_MENU:
		case WXK_CAPITAL:
		case WXK_SELECT:
 		case WXK_PRINT:
 		case WXK_EXECUTE:
 		case WXK_SNAPSHOT:
		case WXK_HELP:
		case WXK_F16:
 		case WXK_F17:
 		case WXK_F18:
 		case WXK_F19:
 		case WXK_F20:
 		case WXK_F21:
 		case WXK_F22:
 		case WXK_F23:
 		case WXK_F24:
 		case WXK_NUMLOCK:
 		case WXK_SCROLL:
		case WXK_DECIMAL:
			return -1;
		break;
		
		case 65: // a == 65
			return SDLK_a;
		break;
		case 66: // b
			return SDLK_b;
		break;
		case 67: // c
			return SDLK_c;
		break;
		case 68: // d
			return SDLK_d;
		break;
		case 69: // e
			return SDLK_e;
		break;
		case 70: // f
			return SDLK_f;
		break;
		case 71: // g
			return SDLK_g;
		break;
		case 72: // h
			return SDLK_h;
		break;
		case 73: // i
			return SDLK_i;
		break;
		case 74: // j
			return SDLK_j;
		break;
		case 75: // k
			return SDLK_k;
		break;
		case 76: // l
			return SDLK_l;
		break;
		case 77: // m
			return SDLK_m;
		break;
		case 78: // n
			return SDLK_n;
		break;
		case 79: // o
			return SDLK_o;
		break;
		case 80: // p
			return SDLK_p;
		break;
		case 81: // q
			return SDLK_q;
		break;
		case 82: // r
			return SDLK_r;
		break;
		case 83: // s
			return SDLK_s;
		break;
		case 84: // t
			return SDLK_t;
		break;
		case 85: // u
			return SDLK_u;
		break;
		case 86: // v
			return SDLK_v;
		break;
		case 87: // w
			return SDLK_w;
		break;
		case 88: // x
			return SDLK_x;
		break;
		case 89: // y
			return SDLK_y;
		break;
		case 90: // z
			return SDLK_z;
		break;
		
		case WXK_BACK:
			return SDLK_BACKSPACE;
		break;
 		case WXK_TAB:
			return SDLK_TAB;
		break;
 		case WXK_RETURN:
			return SDLK_RETURN;
		break;
 		case WXK_ESCAPE:
			return SDLK_ESCAPE;
		break;
 		case WXK_SPACE:
			return SDLK_SPACE;
		break;
 		case WXK_DELETE:
			return SDLK_DELETE;
		break;
 		case WXK_CLEAR:
			return SDLK_CLEAR;
		break;
 		case WXK_SHIFT:
			return SDLK_LSHIFT;
		break;
 		case WXK_CONTROL:
			return SDLK_LCTRL;
		break;
 		case WXK_PAUSE:
			return SDLK_PAUSE;
		break;
 		case WXK_PRIOR:
			return SDLK_PAGEUP;
		break;
 		case WXK_NEXT:
			return SDLK_PAGEDOWN;
		break;
 		case WXK_END:
			return SDLK_END;
		break;
 		case WXK_HOME:
			return SDLK_HOME;
		break;
 		case WXK_LEFT:
			return SDLK_LEFT;
		break;
 		case WXK_UP:
			return SDLK_UP;
		break;
 		case WXK_RIGHT:
			return SDLK_RIGHT;
		break;
 		case WXK_DOWN:
			return SDLK_DOWN;
		break;
 		case WXK_INSERT:
			return SDLK_INSERT;
		break;
 		case WXK_NUMPAD0:
			return SDLK_KP0;
		break;
 		case WXK_NUMPAD1:
			return SDLK_KP1;
		break;
 		case WXK_NUMPAD2:
			return SDLK_KP2;
		break;
 		case WXK_NUMPAD3:
			return SDLK_KP3;
		break;
 		case WXK_NUMPAD4:
			return SDLK_KP4;
		break;
 		case WXK_NUMPAD5:
			return SDLK_KP5;
		break;
 		case WXK_NUMPAD6:
			return SDLK_KP6;
		break;
 		case WXK_NUMPAD7:
			return SDLK_KP7;
		break;
 		case WXK_NUMPAD8:
			return SDLK_KP8;
		break;
 		case WXK_NUMPAD9:
			return SDLK_KP9;
		break;
 		case WXK_MULTIPLY:
			return SDLK_KP_MULTIPLY;
		break;
 		case WXK_ADD:
			return SDLK_KP_PLUS;
		break;
 		case WXK_SEPARATOR:
			return SDLK_KP_PERIOD;
		break;
 		case WXK_SUBTRACT:
			return SDLK_KP_MINUS;
		break;
 		case WXK_DIVIDE:
			return SDLK_KP_DIVIDE;
		break;
 		case WXK_F1:
			return SDLK_F1;
		break;
 		case WXK_F2:
			return SDLK_F2;
		break;
 		case WXK_F3:
			return SDLK_F3;
		break;
 		case WXK_F4:
			return SDLK_F4;
		break;
 		case WXK_F5:
			return SDLK_F5;
		break;
 		case WXK_F6:
			return SDLK_F6;
		break;
 		case WXK_F7:
			return SDLK_F7;
		break;
 		case WXK_F8:
			return SDLK_F8;
		break;
 		case WXK_F9:
			return SDLK_F9;
		break;
 		case WXK_F10:
			return SDLK_F10;
		break;
 		case WXK_F11:
			return SDLK_F11;
		break;
 		case WXK_F12:
			return SDLK_F12;
		break;
 		case WXK_F13:
			return SDLK_F13;
		break;
 		case WXK_F14:
			return SDLK_F14;
		break;
 		case WXK_F15:
			return SDLK_F15;
		break;
 
	}
	
	return -1;
}

