/*///////////////////////////////////////////////////////////////////////////
// Name:        DebugDialog.h
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
///////////////////////////////////////////////////////////////////////////*/

#include "../wxheaders.h" /* For wxWidgets Support */

#include "../configuration/configuration.h" /* For Configuration class */

class DebugDialog : public wxDialog
{
public:
    /* ctor(s) */
    DebugDialog(wxWindow * MyDialog, const wxString& title, const wxPoint& pos, Configuration *Config);
    
    void OnOpenRom(wxCommandEvent& event);
    void SeekIniFile(wxCommandEvent& event);
    void SeekRomFile(wxCommandEvent& event);
    
    wxTextCtrl *OptionsTextCtrl;
    
    wxTextCtrl *IniFileTextCtrl;
    
    wxTextCtrl *RomFileTextCtrl;
    
    /* the grabbed config */
    Configuration * Config;
     
private:

DECLARE_EVENT_TABLE()

}; 
