/*///////////////////////////////////////////////////////////////////////////
// Name:        configuration.h
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
///////////////////////////////////////////////////////////////////////////*/

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include "../wxheaders.h"
#include <wx/string.h>

/**
The class that makes Osmose read in a  .ini file to remember osmose keys, and wxosmose options.

@author Ferreira Yohann
*/
class Configuration{
public:
    Configuration();
    void Init();

    ~Configuration();
    void WriteConfig();
    
    /* Permit the translation between SDLKeys and others Keys systems.
    // And also to show the key pushed... */
    wxString GetStringKeyFromSDLKey(int MySDLKey);
    int GetSDLKeyFromStringKey(wxString MyStringKey);
    
    /* Video Settings */
    bool IsFullScreenEnabled()
    { return FullScreenEnabled; };
    
    void SetFullScreenEnabled( bool Enabled )
    { FullScreenEnabled = Enabled; };
    
    bool IsTVModeEnabled()
    { return TVLikeEnabled; };
    
    void SetTVModeEnabled( bool Enabled )
    { TVLikeEnabled = Enabled; };
    
    bool IsScale2xEnabled()
    { return Scale2xEnabled; };
    
    void SetScale2xEnabled( bool Enabled )
    { Scale2xEnabled = Enabled; };
    
    bool IsMonochromEnabled()
    { return MonochromEnabled; };
    
    void SetMonochromEnabled( bool Enabled )
    { MonochromEnabled = Enabled; };
    
    bool IsDarkPaletteEnabled()
    { return DarkPaletteEnabled; };
    
    void SetDarkPaletteEnabled( bool Enabled )
    { DarkPaletteEnabled = Enabled; };
    
    bool IsFPSDisplayEnabled()
    { return FPSDisplayEnabled; };
    
    void SetFPSDisplayEnabled( bool Enabled )
    { FPSDisplayEnabled = Enabled; };

    bool IsBilinearFilteringEnabled()
    { return BilinearFilteringEnabled; };
    
    void SetBilinearFilteringEnabled( bool Enabled )
    { BilinearFilteringEnabled = Enabled; };
    
    /* Audio */
    bool IsSoundEnabled()
    { return SoundEnabled; };
    
    void SetSoundEnabled( bool Enabled )
    { SoundEnabled = Enabled; };
    
    /* Zone */
    bool IsExportedModeEnabled();
    
    void SetExportedModeEnabled( bool Enabled );
    
    bool IsJapaneseModeEnabled();
    
    void SetJapaneseModeEnabled( bool Enabled );
    
    bool IsPALModeEnabled();
    
    void SetPALModeEnabled( bool Enabled );
    
    /* Options */
    bool IsGamepadEnabled()
    { return GamepadEnabled; };
    
    void SetGamepadEnabled( bool Enabled )
    { GamepadEnabled = Enabled; };

    bool IsMousepadEnabled()
    { return MousepadEnabled; };
    
    void SetMousepadEnabled( bool Enabled )
    { MousepadEnabled = Enabled; };

    double GetMousepadAcceleration()
    { return MousepadAcceleration; };
    
    void SetMousepadAcceleration( double Acceleration );
    
    /* Paths */
    wxString GetUserHomeDirectory()
    { return UserHomeDirectory; };
    
    wxString GetExecutableFilename()
    { return ExecutableFilename; };
    
    void SetExecutableFilename(wxString Filename)
    { ExecutableFilename = Filename; };
    
    wxString GetLastOpenedDirectory()
    { return LastOpenedDirectory; };
    
    void SetLastOpenedDirectory(wxString Filename)
    { LastOpenedDirectory = Filename; };
    
    /* Keys */
	int Screenshot;
	int Soundshot;
	int Tileshot;
	int Pause;
	int Quit;
	
	int P1_Up;
	int P1_Down;
	int P1_Left;
	int P1_Right;
	int P1_A;
	int P1_B;
	
	int P2_Up;
	int P2_Down;
	int P2_Left;
	int P2_Right;
	int P2_A;
	int P2_B;
	
	#ifdef _DEBUG_CONSOLE_
	int DebugKey;
	#endif
    
private:
	/* -------------- General Options */
	
	/* Paths (Options) */
	wxString User, UserHomeDirectory, IniFilename;
	wxString ExecutableFilename, LastOpenedDirectory;
	
	/* Video */
	bool FullScreenEnabled; /* Indicates if the full screen mode is enabled */
	
	bool TVLikeEnabled; /* Indicates if the TV Mode is Enabled */
	
	bool Scale2xEnabled; /* Indicates if the 2x scaled mode is enabled */
	
	bool DarkPaletteEnabled; /* Indicates if the dark palette is enabled */
	
	bool MonochromEnabled; /* Indicates if the monochrom mode is enabled */
	
	bool FPSDisplayEnabled; /* Indicates if the FPS are displayed on title bar */

	bool BilinearFilteringEnabled; /* Indicates if the Bilinear Filtering is enabled */
	
	/* Audio */
	bool SoundEnabled;	/* Indicates if the Sound must be activated */
	
	/* Zone */
	bool ExportedModeEnabled; /* Indicates if a ROM should be read as an USA one. */
	
	bool JapaneseModeEnabled; // Indicates if a ROM should be read as a Japanese one. */
	
	bool PALModeEnabled; /* Indicates if a ROM should be read as a PAL one. */
	
	/* Options */
	bool GamepadEnabled; /* Indicates if the Joystick Use is activated */

	bool MousepadEnabled; /* Indicates if the Mouse Use for a pad is activated */

	double MousepadAcceleration; /* Indicates the acceleration of the mouse pad */

};

#endif
