/*///////////////////////////////////////////////////////////////////////////
// Name:        romslist.cpp
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
///////////////////////////////////////////////////////////////////////////*/

#include "romslist.h" /* Header */
#include <wx/textfile.h> /* For wxTextFile class support */

RomsList::RomsList(wxString FileToParse) /* Loads the Roms List File into memory */
{
	RomsConsole = _T("Master System");
	
	/* Things to load to every kind of rom */
	RomsListFile = FileToParse;
	MD5Sums.Clear();
	RomNames.Clear();
	RomTypes.Clear();
	RomRegions.Clear();
	
	Index = -1;
	Initialized = false;
	wxTextFile MyFile(FileToParse);
	MyFile.Open();
	if ( MyFile.IsOpened() )
	{
		unsigned int LineIndex = 0;
		while ( LineIndex < MyFile.GetLineCount() ) 
		{
			wxString CurrentLine = MyFile.GetLine(LineIndex);
			int CommaPointer = -1;
			int OldPointer = -1;
			LineIndex++;
			
			if ( CurrentLine.substr(0, 1) != _T('#') ) // If it is isn't a comment
			{
				/* MD5 */
				CommaPointer = CurrentLine.find(_T(","), 0);
				MD5Sums.Add(CurrentLine.substr(0, CommaPointer ));
				/* Rom Name */
				OldPointer = CommaPointer;
				CommaPointer = CurrentLine.find(_T(","), CommaPointer + 1);
				RomNames.Add(CurrentLine.substr(OldPointer+1, CommaPointer-OldPointer-1 ));
				/* Type */
				OldPointer = CommaPointer;
				CommaPointer = CurrentLine.find(_T(","), CommaPointer + 1);
				RomTypes.Add(CurrentLine.substr(OldPointer+1, CommaPointer-OldPointer-1 ));
				/* Region */
				OldPointer = CommaPointer;
				CommaPointer = CurrentLine.find(_T(","), CommaPointer + 1);
				RomRegions.Add(CurrentLine.substr(OldPointer+1, CommaPointer-OldPointer-1 ));
			}
		}
	
		Index = MD5Sums.GetCount()-1; /* Points on the first occurence, -1 if none. */
		Initialized = true;
		
		MyFile.Close();
	}
}

RomsList::~RomsList()
{
	RomsConsole = _T("");
	RomsListFile = _T("");
	MD5Sums.Clear();
	RomNames.Clear();
	RomTypes.Clear();
	RomRegions.Clear();
	
	Initialized = false; 
	Index = -1;
}

bool RomsList::IsInitialized()
{
	return Initialized;
}

bool RomsList::SetIndexToMD5Sum(wxString MD5Sum) /* Set the index to the line where the MD5 sum is corresponding */
{
	if ( Initialized )
	{
		for (int i = 0; i < (int)MD5Sums.GetCount(); i++)
		{
			if ( MD5Sums[i] == MD5Sum )
			{
				Index = i;
				return true;
			}
		}
	}
	return false;
}

wxString RomsList::GetRomName() /* Must be called after SetIndexToMD5Sum */
{
	if ( Initialized )
	{
		if ( Index <= (int)RomNames.GetCount()-1 )
			return RomNames[Index];
		else
			return wxEmptyString;
	}
	return wxEmptyString;
}

wxString RomsList::GetRomType() /* Must be called after SetIndexToMD5Sum */
{
	if ( Initialized )
	{
		if ( Index <= (int)RomTypes.GetCount()-1 )
			return RomTypes[Index];
		else
			return wxEmptyString;
	}
	return wxEmptyString;
}

wxString RomsList::GetRomRegion() /* Must be called after SetIndexToMD5Sum */
{
	if ( Initialized )
	{
		if ( Index <= (int)RomRegions.GetCount()-1 )
			return RomRegions[Index];
		else
			return wxEmptyString;
	}
	return wxEmptyString;
}

wxString RomsList::GetRomScreenshotName() /* Must be called after SetIndexToMD5Sum */
{
	if ( Initialized )
	{
		if ( Index <= (int)RomNames.GetCount()-1 )
			return wxString::Format(_T("datas/MasterSystem/shots/%s.png"), RomNames[Index].c_str());
		else
			return wxEmptyString;
	}
	return wxEmptyString;
}
