/*//////////////////////////////////
//
// MD5 class
//
//////////////////////////////////*/

#include "md5.h"	/* header */.

//#include <wx/strconv.h> /* For String convertion Functions */
#include <wx/file.h>    /* For wxFile Support */
//#include <wx/zipstrm.h> /* For Zip Support */
#include "unzip/unzip.h" /* For Zip Support using unzip static lib */

typedef unsigned char *POINTER;

static wxCSConv IsoConv(wxT("iso8859-1"));
#if wxUSE_UNICODE
	/* 
	 * Unfortunately, unicode2char() cannot be a function, because upon function
	 * return the object to which the returned (const char *) pointer points to
	 * gets out of scope. So, we stick to the macro version for now.
	 */
	#define unicode2char(x) (const char*) IsoConv.cWX2MB(x)
	//inline const char* unicode2char(wxString x) { return ((const char*) aMuleConv.cWX2MB(x));};
	inline const wxCharBuffer unicode2charbuf(wxString x) { return IsoConv.cWX2MB(x); };
	inline const wxWCharBuffer char2unicode(const char* x) { return IsoConv.cMB2WX(x); };
#else
	inline const char* unicode2char(wxString x) { return ((const char*) x); };
	inline const wxCharBuffer unicode2charbuf(wxString x) { return (const char*)x; };
	inline const wxCharBuffer char2unicode(const char* x) { return x; };
#endif


typedef struct {
  unsigned long int state[4];
  unsigned long int count[2];
  unsigned char buffer[64];
} MD5_CTX;

void MD5Init (MD5_CTX *);
void MD5Update (MD5_CTX *, const unsigned char *, unsigned int);
void MD5Final (unsigned char [16], MD5_CTX *);

MD5Sum::MD5Sum()
{
	m_sHash = wxEmptyString;
}

MD5Sum::MD5Sum(wxString sSource)
{
	Calculate(sSource);
}

wxString MD5Sum::Calculate(wxString sSource)
{
	MD5_CTX context;
	unsigned char digest[16];

	MD5Init (&context);
	MD5Update (&context, (const unsigned char*)unicode2char(sSource), sSource.Length());
	MD5Final (digest, &context);

	m_sHash = wxEmptyString;
	for (int i = 0; i < 16; ++i)
	{
		wxString sT;
		sT.Printf(wxT("%02x"), digest[i]);
		m_sHash += sT;
	}

	return m_sHash;
}

wxString MD5Sum::CalculateFromFile(wxString sSourceFilename)
{
	MD5_CTX context;
	unsigned char digest[16];
	
	/* Put the file into a Buffer */
	wxFile MyFile(sSourceFilename);
	if ( MyFile.IsOpened() )
	{
		char * Buffer = new char[MyFile.Length()+1];
		MyFile.Read((char*) Buffer, MyFile.Length());
	
		MD5Init (&context);
		MD5Update (&context, (const unsigned char*)Buffer, MyFile.Length());
		MD5Final (digest, &context);
	
		m_sHash = wxEmptyString;
		for (int i = 0; i < 16; ++i)
		{
			wxString sT;
			sT.Printf(wxT("%02x"), digest[i]);
			m_sHash += sT;
		}
		MyFile.Close();
		delete Buffer;
		return m_sHash;
	}
	return wxEmptyString;
}

wxString MD5Sum::CalculateFromZipFile(wxString sSourceFilename, wxString FileExtensionSeeked) /* This version uses the libz.a and unzip.a libs which are working.
								// Thanks Bruno ! ;) */
{
	unzFile myZip = NULL; // Zip File
	unz_global_info zip_global_info; // Zip Global info
	unz_file_info zip_file_info;    // Infos on the seeked zipped file
	char ZippedFile[256];		// Name of the zipped file
	int ret = 0; 			// ID infos on zip file
	unsigned int Length = 0;	// Zipped file size to put into a buffer
	
	// Open ROM with file pointer at the end of ROM.
	myZip = unzOpen(unicode2char(sSourceFilename)); 
	if (myZip == NULL)
	{
		#ifdef _DEBUG_
		wxLogMessage(wxString::Format(_T("Unable to open %s zip archive."), sSourceFilename.c_str()));
		#endif
	}
	else // Zip Open Successful
	{
		// Get global information on zip.
		ret = unzGetGlobalInfo(myZip, &zip_global_info);
		if ( ret != UNZ_OK )
		{
			#ifdef _DEBUG_
			wxLogMessage(wxString::Format(_T("Unable to read files contained in %s zip file."), sSourceFilename.c_str()));
			#endif
		}
		else // Found files in zip file
		{
			// Get First file in zip archive.
			ret = unzGoToFirstFile(myZip);
			if (ret != UNZ_OK)
			{
				#ifdef _DEBUG_
				wxLogMessage(wxString::Format(_T("Unable to get the first file contained in %s zip file."), sSourceFilename.c_str()));
				#endif
			}
			else // Getting first file
			{
				bool FoundSmsFile = false;
				while ( !FoundSmsFile )
				{
					ret = unzGetCurrentFileInfo(myZip, &zip_file_info, ZippedFile, 256, NULL,0, NULL, 0);
					if (ret == UNZ_OK) // Got file infos
					{
						if (strstr(ZippedFile,unicode2char(FileExtensionSeeked)) == NULL /*&& strstr(ZippedFile,"Sms") == NULL && strstr(ZippedFile,"SMS") == NULL */) // If the extension isn't sms, Sms, or SMS
						{
							ret = unzGoToNextFile(myZip);
							if (ret != UNZ_OK)
							{
								#ifdef _DEBUG_
								wxLogMessage(wxString::Format(_T("No sms file found in %s Zip File"), sSourceFilename.c_str()));
								#endif
								return wxEmptyString;
							}
						}
						else // sms found
						{
							Length = zip_file_info.uncompressed_size;
							ret = unzOpenCurrentFile(myZip);
							if (ret != UNZ_OK) // Can't get sms file
							{
								#ifdef _DEBUG_
								wxLogMessage(wxString::Format(_T("Unable to get the sms file in %s Zip file."), sSourceFilename.c_str()));
								#endif
							}
							else  // Read the sms file
							{
								char * Buffer = new char[Length+1];
								ret = unzReadCurrentFile(myZip, Buffer, Length);
								if (ret < 0) // Unable to actually read
								{
									#ifdef _DEBUG_
									wxLogMessage(wxString::Format(_T("Unable to read %s Zipped file."), ZippedFile));
									#endif
								}
								else // read the sms file
								{
									MD5_CTX context;
									unsigned char digest[16];
									MD5Init (&context);
									MD5Update (&context, (const unsigned char*)Buffer, Length);
									MD5Final (digest, &context);
						
									m_sHash = wxEmptyString;
									for (int i = 0; i < 16; ++i)
									{
										wxString sT;
										sT.Printf(wxT("%02x"), digest[i]);
										m_sHash += sT;
									}
									delete Buffer;
									unzClose(myZip);
									return m_sHash;
								} // End if read current zipped file
							} // open current zipped file
						} // End if it is a sms file
					} // End if get current file info
				} // End while finding sms file
			} // End if get first file
		} // End if found files in zip files
	} // End if Zip open successful
	unzClose(myZip);
	return wxEmptyString;
}

/*wxString MD5Sum::CalculateFromZipFile(wxString sSourceFilename) // This version uses wxZlib which is still buggy.
{								// To be reimplemented later...
	
	
	wxDEFINE_SCOPED_PTR_TYPE(wxZipEntry);
	wxZipEntryPtr entry; // Zip File list pointer
	
	// open the zip
	wxFFileInputStream in(sSourceFilename); // The zipped stream
	wxZipInputStream zip(in); // The unzipped stream
	wxInputStream ZippedFile(zip); // The unzip file datas

	// call GetNextEntry() until the required internal name is found
	while (entry.get() != NULL ) // If there is still a valid file and if we didn't find anything yet
	{
		// We look for the name of that entry
		if ( entry->GetName().Matches(_T("*.sms")) || entry->GetName().Matches(_T("*.Sms")) || entry->GetName().Matches(_T("*.SMS")) )
		{
			// Not found yet. Try next file
			entry.reset(zip.GetNextEntry());
		}
		else
		{
			// We access the buffer and we finish
			if (entry.get() != NULL)
			{
				// read the entry's data and make the MD5 sum
				MD5_CTX context;
				unsigned char digest[16];
				// Put the file into a Buffer 
				//char * Buffer = new char[entry->GetSize()+1];
				MyFile.Read((char*) Buffer, entry->GetSize());
				
				MD5Init (&context);
				MD5Update (&context, (const unsigned char*)Buffer, entry->GetSize());
				MD5Final (digest, &context);
	
				m_sHash = wxEmptyString;
				for (int i = 0; i < 16; ++i)
				{
					wxString sT;
					sT.Printf(wxT("%02x"), digest[i]);
					m_sHash += sT;
				}
				delete Buffer;
				return m_sHash;
			} // End if accessed a true file in zip
		} // End if found a match
	} // End of While seeking a matches

	
	 Put the file into a Buffer 
	wxFile MyFile(sSourceFilename);
	if ( MyFile.IsOpened() )
	{
		char * Buffer = new char[MyFile.Length()+1];
		MyFile.Read((char*) Buffer, MyFile.Length());
	
		MD5Init (&context);
		MD5Update (&context, (const unsigned char*)Buffer, MyFile.Length());
		MD5Final (digest, &context);
	
		m_sHash = wxEmptyString;
		for (int i = 0; i < 16; ++i)
		{
			wxString sT;
			sT.Printf(wxT("%02x"), digest[i]);
			m_sHash += sT;
		}
		MyFile.Close();
		return m_sHash;
	}
	return wxEmptyString;
}*/


wxString MD5Sum::GetHash()
{
	return m_sHash;
}

#define S11 7
#define S12 12
#define S13 17
#define S14 22
#define S21 5
#define S22 9
#define S23 14
#define S24 20
#define S31 4
#define S32 11
#define S33 16
#define S34 23
#define S41 6
#define S42 10
#define S43 15
#define S44 21

static void MD5Transform (unsigned long int [4], const unsigned char [64]);
static void Encode (unsigned char *, unsigned long int *, unsigned int);
static void Decode (unsigned long int *, const unsigned char *, unsigned int);
static void MD5_memcpy (POINTER, POINTER, unsigned int);
static void MD5_memset (POINTER, int, unsigned int);

static unsigned char PADDING[64] = {
  0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

/* F, G, H and I are basic MD5 functions.
 */
#define F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define G(x, y, z) (((x) & (z)) | ((y) & (~z)))
#define H(x, y, z) ((x) ^ (y) ^ (z))
#define I(x, y, z) ((y) ^ ((x) | (~z)))

/* ROTATE_LEFT rotates x left n bits.
	15-April-2003 Sony: use MSVC intrinsic to save some cycles
 */
#ifdef _MSC_VER
#pragma intrinsic(_rotl)
#define ROTATE_LEFT(x, n) _rotl((x), (n))
#else
#define ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))
#endif

/* FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4.
Rotation is separate from addition to prevent recomputation.
*/
/* Defines must be on one line to work with GCC-2.95.3 */
#define FF(a, b, c, d, x, s, ac) { (a) += F ((b), (c), (d)) + (x) + (unsigned long int)(ac); (a) = ROTATE_LEFT ((a), (s)); (a) += (b); }
#define GG(a, b, c, d, x, s, ac) { (a) += G ((b), (c), (d)) + (x) + (unsigned long int)(ac); (a) = ROTATE_LEFT ((a), (s)); (a) += (b); }
#define HH(a, b, c, d, x, s, ac) { (a) += H ((b), (c), (d)) + (x) + (unsigned long int)(ac); (a) = ROTATE_LEFT ((a), (s)); (a) += (b); }
#define II(a, b, c, d, x, s, ac) { (a) += I ((b), (c), (d)) + (x) + (unsigned long int)(ac); (a) = ROTATE_LEFT ((a), (s)); (a) += (b); }

/* MD5 initialization. Begins an MD5 operation, writing a new context.
 */
void MD5Init (MD5_CTX *context)
{
  context->count[0] = context->count[1] = 0;
  /* Load magic initialization constants.
*/
  context->state[0] = 0x67452301;
  context->state[1] = 0xefcdab89;
  context->state[2] = 0x98badcfe;
  context->state[3] = 0x10325476;
}

/* MD5 block update operation. Continues an MD5 message-digest
  operation, processing another message block, and updating the
  context.
 */
void MD5Update (MD5_CTX *context, const unsigned char *input, unsigned int inputLen)
{
	unsigned int i, index, partLen;

	/* Compute number of bytes mod 64 */
	index = (unsigned int)((context->count[0] >> 3) & 0x3F);

	/* Update number of bits */
	if ((context->count[0] += ((unsigned long int)inputLen << 3)) < ((unsigned long int)inputLen << 3)) {
		context->count[1]++;
	}
	context->count[1] += ((unsigned long int)inputLen >> 29);
	partLen = 64 - index;

	/* Transform as many times as possible. */
	if (inputLen >= partLen) {
		MD5_memcpy((POINTER)&context->buffer[index], (POINTER)input, partLen);
		MD5Transform (context->state, context->buffer);

		for (i = partLen; i + 63 < inputLen; i += 64) {
			MD5Transform (context->state, &input[i]);
		}
		index = 0;
	} else {
		i = 0;
	}
	/* Buffer remaining input */
	MD5_memcpy((POINTER)&context->buffer[index], (POINTER)&input[i], inputLen-i);
}

/* MD5 finalization. Ends an MD5 message-digest operation, writing the
 * the message digest and zeroizing the context. 
 */
void MD5Final (unsigned char digest[16], MD5_CTX *context)
{
	unsigned char bits[8];
	unsigned int index, padLen;

	/* Save number of bits */
	Encode (bits, context->count, 8);

	/* Pad out to 56 mod 64. */
	index = (unsigned int)((context->count[0] >> 3) & 0x3f);
	padLen = (index < 56) ? (56 - index) : (120 - index);
	MD5Update (context, PADDING, padLen);

	/* Append length (before padding) */
	MD5Update (context, bits, 8);
	/* Store state in digest */
	Encode (digest, context->state, 16);

	/* Zeroize sensitive information.*/
	MD5_memset ((POINTER)context, 0, sizeof (*context));
}

/* MD5 basic transformation. Transforms state based on block.
 */
static void MD5Transform (unsigned long int state[4], const unsigned char block[64])
{
  unsigned long int a = state[0], b = state[1], c = state[2], d = state[3], x[16];

  Decode (x, block, 64);

  /* Round 1 */
  FF (a, b, c, d, x[ 0], S11, 0xd76aa478); /* 1 */
  FF (d, a, b, c, x[ 1], S12, 0xe8c7b756); /* 2 */
  FF (c, d, a, b, x[ 2], S13, 0x242070db); /* 3 */
  FF (b, c, d, a, x[ 3], S14, 0xc1bdceee); /* 4 */
  FF (a, b, c, d, x[ 4], S11, 0xf57c0faf); /* 5 */
  FF (d, a, b, c, x[ 5], S12, 0x4787c62a); /* 6 */
  FF (c, d, a, b, x[ 6], S13, 0xa8304613); /* 7 */
  FF (b, c, d, a, x[ 7], S14, 0xfd469501); /* 8 */
  FF (a, b, c, d, x[ 8], S11, 0x698098d8); /* 9 */
  FF (d, a, b, c, x[ 9], S12, 0x8b44f7af); /* 10 */
  FF (c, d, a, b, x[10], S13, 0xffff5bb1); /* 11 */
  FF (b, c, d, a, x[11], S14, 0x895cd7be); /* 12 */
  FF (a, b, c, d, x[12], S11, 0x6b901122); /* 13 */
  FF (d, a, b, c, x[13], S12, 0xfd987193); /* 14 */
  FF (c, d, a, b, x[14], S13, 0xa679438e); /* 15 */
  FF (b, c, d, a, x[15], S14, 0x49b40821); /* 16 */

 /* Round 2 */
  GG (a, b, c, d, x[ 1], S21, 0xf61e2562); /* 17 */
  GG (d, a, b, c, x[ 6], S22, 0xc040b340); /* 18 */
  GG (c, d, a, b, x[11], S23, 0x265e5a51); /* 19 */
  GG (b, c, d, a, x[ 0], S24, 0xe9b6c7aa); /* 20 */
  GG (a, b, c, d, x[ 5], S21, 0xd62f105d); /* 21 */
  GG (d, a, b, c, x[10], S22,  0x2441453); /* 22 */
  GG (c, d, a, b, x[15], S23, 0xd8a1e681); /* 23 */
  GG (b, c, d, a, x[ 4], S24, 0xe7d3fbc8); /* 24 */
  GG (a, b, c, d, x[ 9], S21, 0x21e1cde6); /* 25 */
  GG (d, a, b, c, x[14], S22, 0xc33707d6); /* 26 */
  GG (c, d, a, b, x[ 3], S23, 0xf4d50d87); /* 27 */
  GG (b, c, d, a, x[ 8], S24, 0x455a14ed); /* 28 */
  GG (a, b, c, d, x[13], S21, 0xa9e3e905); /* 29 */
  GG (d, a, b, c, x[ 2], S22, 0xfcefa3f8); /* 30 */
  GG (c, d, a, b, x[ 7], S23, 0x676f02d9); /* 31 */
  GG (b, c, d, a, x[12], S24, 0x8d2a4c8a); /* 32 */

  /* Round 3 */
  HH (a, b, c, d, x[ 5], S31, 0xfffa3942); /* 33 */
  HH (d, a, b, c, x[ 8], S32, 0x8771f681); /* 34 */
  HH (c, d, a, b, x[11], S33, 0x6d9d6122); /* 35 */
  HH (b, c, d, a, x[14], S34, 0xfde5380c); /* 36 */
  HH (a, b, c, d, x[ 1], S31, 0xa4beea44); /* 37 */
  HH (d, a, b, c, x[ 4], S32, 0x4bdecfa9); /* 38 */
  HH (c, d, a, b, x[ 7], S33, 0xf6bb4b60); /* 39 */
  HH (b, c, d, a, x[10], S34, 0xbebfbc70); /* 40 */
  HH (a, b, c, d, x[13], S31, 0x289b7ec6); /* 41 */
  HH (d, a, b, c, x[ 0], S32, 0xeaa127fa); /* 42 */
  HH (c, d, a, b, x[ 3], S33, 0xd4ef3085); /* 43 */
  HH (b, c, d, a, x[ 6], S34,  0x4881d05); /* 44 */
  HH (a, b, c, d, x[ 9], S31, 0xd9d4d039); /* 45 */
  HH (d, a, b, c, x[12], S32, 0xe6db99e5); /* 46 */
  HH (c, d, a, b, x[15], S33, 0x1fa27cf8); /* 47 */
  HH (b, c, d, a, x[ 2], S34, 0xc4ac5665); /* 48 */

  /* Round 4 */
  II (a, b, c, d, x[ 0], S41, 0xf4292244); /* 49 */
  II (d, a, b, c, x[ 7], S42, 0x432aff97); /* 50 */
  II (c, d, a, b, x[14], S43, 0xab9423a7); /* 51 */
  II (b, c, d, a, x[ 5], S44, 0xfc93a039); /* 52 */
  II (a, b, c, d, x[12], S41, 0x655b59c3); /* 53 */
  II (d, a, b, c, x[ 3], S42, 0x8f0ccc92); /* 54 */
  II (c, d, a, b, x[10], S43, 0xffeff47d); /* 55 */
  II (b, c, d, a, x[ 1], S44, 0x85845dd1); /* 56 */
  II (a, b, c, d, x[ 8], S41, 0x6fa87e4f); /* 57 */
  II (d, a, b, c, x[15], S42, 0xfe2ce6e0); /* 58 */
  II (c, d, a, b, x[ 6], S43, 0xa3014314); /* 59 */
  II (b, c, d, a, x[13], S44, 0x4e0811a1); /* 60 */
  II (a, b, c, d, x[ 4], S41, 0xf7537e82); /* 61 */
  II (d, a, b, c, x[11], S42, 0xbd3af235); /* 62 */
  II (c, d, a, b, x[ 2], S43, 0x2ad7d2bb); /* 63 */
  II (b, c, d, a, x[ 9], S44, 0xeb86d391); /* 64 */

  state[0] += a;
  state[1] += b;
  state[2] += c;
  state[3] += d;

  /* Zeroize sensitive information.
   */
  MD5_memset ((POINTER)x, 0, sizeof (x));
}

/* Encodes input (unsigned long int) into output (unsigned char). Assumes len is
  a multiple of 4.
 */
static void Encode (unsigned char *output, unsigned long int *input, unsigned int len)
{
  unsigned int i, j;

  for (i = 0, j = 0; j < len; i++, j += 4) {
 output[j] = (unsigned char)(input[i] & 0xff);
 output[j+1] = (unsigned char)((input[i] >> 8) & 0xff);
 output[j+2] = (unsigned char)((input[i] >> 16) & 0xff);
 output[j+3] = (unsigned char)((input[i] >> 24) & 0xff);
  }
}

/* Decodes input (unsigned char) into output (unsigned long int). Assumes len is
  a multiple of 4.
 */
static void Decode (unsigned long int *output, const unsigned char *input, unsigned int len)
{
  unsigned int i, j;

  for (i = 0, j = 0; j < len; i++, j += 4)
 output[i] = ((unsigned long int)input[j]) | (((unsigned long int)input[j+1]) << 8) |
   (((unsigned long int)input[j+2]) << 16) | (((unsigned long int)input[j+3]) << 24);
}

/* Note: Replace "for loop" with standard memcpy if possible.
 */

static void MD5_memcpy (POINTER output, POINTER input, unsigned int len)
{
  unsigned int i;

  for (i = 0; i < len; i++)
 output[i] = input[i];
}

/* Note: Replace "for loop" with standard memset if possible.
 */
static void MD5_memset (POINTER output, int value, unsigned int len)
{
  unsigned int i;

  for (i = 0; i < len; i++)
 ((char *)output)[i] = (char)value;
}
