/////////////////////////////////////////////////////////////////////////////
// Name:        MyFrame.h
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "../wxheaders.h"

#include "../configuration/configuration.h" // For Configuration class
#include "romlistctrl.h" // For RomListCtrl Class support

// Define a new frame type: this is going to be our main frame
class MyFrame : public wxFrame
{
public:
    // ctor(s)
    MyFrame(const wxString& title, const wxPoint& pos, const wxSize& size,
            long style = wxDEFAULT_FRAME_STYLE);

    // event handlers (these functions should _not_ be virtual)
    // File Menu
    void OnOpenRom(wxCommandEvent& event);
    void OnQuit(wxCommandEvent& event);
    
    // Video
    void OnChangeFullScreen(wxCommandEvent& event);
    void OnChangeScale2x(wxCommandEvent& event);
    void OnChangeTVMode(wxCommandEvent& event);
    void OnChangeDarkPaletteMode(wxCommandEvent& event);
    void OnChangeMonochromMode(wxCommandEvent& event);
    void OnChangeFPSDisplay(wxCommandEvent& event);
    void OnChangeBilinearFiltering(wxCommandEvent& event);
    
    // Audio
    void OnChangeSound(wxCommandEvent& event);
    
    // Options & Paths
    void OnChangeKeys(wxCommandEvent& event);
    void OnChangeExecutablePath(wxCommandEvent& event);
    #ifdef _DEBUG_CONSOLE_
    void OnOpenDebugConsole(wxCommandEvent& event);
    #endif
    
    // Zone
    void OnChangeExportedMode(wxCommandEvent& event);
    void OnChangePALMode(wxCommandEvent& event);
    void OnChangeJapaneseMode(wxCommandEvent& event);
    
    // Help Menu
    void OnAbout(wxCommandEvent& event);
    
    // Contains the config
    Configuration Config;
    
    // Function to update the list
    void UpdateRomList();

private:

    // create a menu bar
    wxMenu *FileMenu;

    // the "About" item should be in the help menu
    wxMenu *HelpMenu;
    wxMenu *OptionsMenu;
    wxMenu *VideoMenu;
    wxMenu *AudioMenu;
    wxMenu *ZoneMenu;
    wxMenuBar * MenuBar;
    
    // The list ctrl with rom list displaying
    RomListCtrl * MyRomListCtrl;

    // any class wishing to process wxWindows events must use this macro
    DECLARE_EVENT_TABLE()
};
