/////////////////////////////////////////////////////////////////////////////
// Name:        myapp.cpp
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "myapp.h" // header
#include "myframe.h" // My Frame class
#include "../version.h" // In order to obtain wxOsmOse Version

// 'Main program' equivalent: the program execution "starts" here
bool MyApp::OnInit()
{
    
    // create the main application window
    MyFrame *frame = new MyFrame(wxString::Format(wxT(WXOSMOSE_APPNAME)),
                                 wxPoint(-1, -1), wxSize(450, 250));

    // and show it (the frames, unlike simple controls, are not shown when
    // created initially)
    frame->Centre();
    frame->Show(TRUE);
    frame->UpdateRomList();

    // success: wxApp::OnRun() will be called which will enter the main message
    // loop and the application will run. If we returned FALSE here, the
    // application would exit immediately.
    return TRUE;
} 
