/////////////////////////////////////////////////////////////////////////////
// Name:        enum.h
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

// ----------------------------------------------------------------------------
// constants
// ----------------------------------------------------------------------------

// IDs for the controls and the menu commands
enum
{
    // menu items
    
    // File Menu
    wxOsmose_Quit = 1,
    wxOsmose_OpenRom,
    
    // Video Menu
    wxOsmose_FullScreen,
    wxOsmose_TVLike,
    wxOsmose_Scale2x,
    wxOsmose_Monochrom,
    wxOsmose_DarkPalette,
    wxOsmose_FPS,
    wxOsmose_Bilinear,
    
    // Audio Menu
    wxOsmose_Sound,
    
    // Options Menu
    wxOsmose_Keys,
    wxOsmose_ExecutablePath,
    wxOsmose_Gamepad,
    wxOsmose_CheckBox_Mousepad,
    wxOsmose_Slider_MousepadAcceleration,
    #ifdef _DEBUG_CONSOLE_
    wxOsmose_DebugConsole,
    wxOsmose_TextCtrl_Options,
    wxOsmose_TextCtrl_Inifile,
    wxOsmose_TextCtrl_RomPath,
    wxOsmose_Button_LaunchRomDebug,
    wxOsmose_Button_SeekInifile,
    wxOsmose_Button_SeekRomfile,
    #endif
    
    // Zone Menu
    wxOsmose_Exported,
    wxOsmose_Pal,
    wxOsmose_Jap,
    
    // List Ctrl
    wxOsmose_List_Rom,
    
    // Buttons in Key Dialog
    wxOsmose_Button_P1_Up,
    wxOsmose_Button_P1_Down,
    wxOsmose_Button_P1_Left,
    wxOsmose_Button_P1_Right,
    wxOsmose_Button_P1_A,
    wxOsmose_Button_P1_B,
    wxOsmose_Button_P2_Up,
    wxOsmose_Button_P2_Down,
    wxOsmose_Button_P2_Left,
    wxOsmose_Button_P2_Right,
    wxOsmose_Button_P2_A,
    wxOsmose_Button_P2_B,
    wxOsmose_Button_Ok,
    wxOsmose_Button_Cancel,
    
    wxOsmose_Button_Pause,
    wxOsmose_Button_Quit,
    wxOsmose_Button_Screenshot,
    wxOsmose_Button_Soundshot,
    wxOsmose_Button_Tileshot,
    wxOsmose_Button_Debug,
    wxOsmose_Button_SaveState,
    wxOsmose_Button_LoadState,
    
    wxOsmose_Text_P1_Up,
    wxOsmose_Text_P1_Down,
    wxOsmose_Text_P1_Left,
    wxOsmose_Text_P1_Right,
    wxOsmose_Text_P1_A,
    wxOsmose_Text_P1_B,
    wxOsmose_Text_P2_Up,
    wxOsmose_Text_P2_Down,
    wxOsmose_Text_P2_Left,
    wxOsmose_Text_P2_Right,
    wxOsmose_Text_P2_A,
    wxOsmose_Text_P2_B,
    wxOsmose_Text_Pause,
    wxOsmose_Text_Quit,
    wxOsmose_Text_Screenshot,
    wxOsmose_Text_Soundshot,
    wxOsmose_Text_Tileshot,
    wxOsmose_Text_Debug,
    wxOsmose_Text_LoadState,
    wxOsmose_Text_SaveState,
    
    // Windows
    wxOsmose_ChangeAKeyDialog,
    wxOsmose_MainFrame,
    
    // it is important for the id corresponding to the "About" command to have
    // this standard value as otherwise it won't be handled properly under Mac
    // (where it is special and put into the "Apple" menu)
    wxOsmose_About = wxID_ABOUT
}; 
 
