/*///////////////////////////////////////////////////////////////////////////
// Name:        DebugDialog.cpp
// Purpose:     wxWindows wxOsmose Front-End to the Osmose Emulator
// Author:      Ferreira Yohann
// Modified by:
// Created:     25/01/2005
// Copyright:   (c) Ferreira Yohann
// Licence:     GPL
///////////////////////////////////////////////////////////////////////////*/

#include "debugconsole.h" /* header */

#include "enum.h" /* For constants enumeration constitency */

/* ----------------------------------------------------------------------------*/
/* Debug Dialog for Bruno                                                      */
/* ----------------------------------------------------------------------------*/

/* ----------------------------------------------------------------------------*/
/* event tables and other macros for wxWindows                                 */
/* ----------------------------------------------------------------------------*/

/* the event tables connect the wxWindows events with the functions (event    */
/* handlers) which process them. It can be also done at run-time, but for the */
/* simple menu events like this the static method is much simpler.            */
BEGIN_EVENT_TABLE(DebugDialog, wxDialog)
    
    EVT_BUTTON(wxOsmose_Button_LaunchRomDebug, DebugDialog::OnOpenRom)
    EVT_BUTTON(wxOsmose_Button_SeekInifile, DebugDialog::SeekIniFile)
    EVT_BUTTON(wxOsmose_Button_SeekRomfile, DebugDialog::SeekRomFile)
    
END_EVENT_TABLE()

/* ctor(s) */
DebugDialog::DebugDialog(wxWindow * Parent, const wxString& title, const wxPoint& pos, Configuration * Config)
: wxDialog (Parent, wxOsmose_DebugConsole, title, pos, wxSize(350,150))
{
	// Grab the config
	this->Config = Config;
	
	/* options */
	wxStaticText * OptionsText = 0;
	OptionsText = new wxStaticText(this, -1, _T("Options :"), wxPoint(10,30));
	OptionsTextCtrl = 0;
	OptionsTextCtrl = new wxTextCtrl(this, wxOsmose_TextCtrl_Options, _T(""), wxPoint(70,30), wxSize(200,20));
	wxButton * LaunchRomButton = new wxButton(this, wxOsmose_Button_LaunchRomDebug, _T("Run"), wxPoint(290,30), wxSize(30, 20));
	
	/* Inifile */
	wxStaticText * IniFileText = 0;
	IniFileText = new wxStaticText(this, -1, _T("Ini File :"), wxPoint(10,60));
	wxString wxOsmoseIniFullName = _T("");
	#ifdef __USE_UNIX98
	wxOsmoseIniFullName = Config->GetUserHomeDirectory();
	wxOsmoseIniFullName += _T("/.osmose/wxosmose.ini");
	#endif
	#ifdef _WIN32
	wxOsmoseIniFullName = wxGetCwd(); /* The current directory... */
	wxOsmoseIniFullName += _T("\wxosmose.ini"); 
	#endif
	IniFileTextCtrl = 0;
	IniFileTextCtrl = new wxTextCtrl(this, wxOsmose_TextCtrl_Inifile, wxOsmoseIniFullName, wxPoint(70,60), wxSize(200,20));
	wxButton * SeekIniFileButton = 0;
	SeekIniFileButton = new wxButton(this, wxOsmose_Button_SeekInifile, _T("..."), wxPoint(290,60), wxSize(30, 20));
	
	/* Rom */
	wxStaticText * RomFileText = 0;
	RomFileText = new wxStaticText(this, -1, _T("Rom Path :"), wxPoint(10,90));
	RomFileTextCtrl = 0;
	RomFileTextCtrl = new wxTextCtrl(this, wxOsmose_TextCtrl_RomPath, _T(""), wxPoint(70,90), wxSize(200,20));
	wxButton * SeekRomButton = 0;
	SeekRomButton = new wxButton(this, wxOsmose_Button_SeekRomfile, _T("..."), wxPoint(290,90), wxSize(30, 20));
	
	/* Executable */
	wxStaticText * ExecutableText = 0;
	ExecutableText = new wxStaticText(this, -1, wxString::Format(_T("Osmose : %s"), (Config->GetExecutableFilename()).c_str()), wxPoint(10,120));
	wxButton * EndDebugButton = 0;
	EndDebugButton = new wxButton(this, wxID_OK, _T("Close"), wxPoint(270,120), wxSize(60, 20));
	
} 

void DebugDialog::OnOpenRom(wxCommandEvent& WXUNUSED(event))
{
	if ( RomFileTextCtrl->GetLineLength(0) > 0 )
	{
		wxString Command = _T("\"");
		Command += Config->GetExecutableFilename();
		Command += _T("\" \"");
		Command += RomFileTextCtrl->GetLineText(0);
		Command += _T("\" ");
		Command += OptionsTextCtrl->GetLineText(0);
		if ( IniFileTextCtrl->GetLineLength(0) > 0 )
		{
			Command += _T(" -inifile \"");
			Command += IniFileTextCtrl->GetLineText(0);
			Command += _T("\"");
			
		}
		/*int ReturnCode =*/ wxExecute(Command, wxEXEC_SYNC);
	}
	else
	{
		wxLogMessage(_T("Pas de Roms  lancer."));
	}
}

void DebugDialog::SeekIniFile(wxCommandEvent& WXUNUSED(event))
{
	wxFileDialog IniFileDialog(this, _T("Choose the File to put as Ini"), _T(""), _T(""), _T("Every Text Files (*.*)|*.*"), wxOPEN | wxHIDE_READONLY );
	
	if ( IniFileDialog.ShowModal() == wxID_OK )
	{
		IniFileTextCtrl->Clear();
		IniFileTextCtrl->WriteText(IniFileDialog.GetPath());
	}
}

void DebugDialog::SeekRomFile(wxCommandEvent& WXUNUSED(event))
{
	wxFileDialog RomDialog(this, _T("Choose the ROM to open"), Config->GetLastOpenedDirectory(), _T(""), _T("ZIP files with SMS file within (*.zip)|*.zip|SMS files (*.sms)|*.sms"), wxOPEN | wxHIDE_READONLY );
	
	if ( RomDialog.ShowModal() == wxID_OK )
	{
		RomFileTextCtrl->Clear();
		RomFileTextCtrl->WriteText(RomDialog.GetPath());
	}
}
