#!/bin/bash

echo "Debian Package Creation...";

if [ $USER != "root" ]; # only root can create deb packages...
then
	echo "Sorry ! this must be run as root because only root can make Debian Packages !";
	echo "Aborting...";
	exit;
fi

make;

if [ ! -x ./wxosmose ]; # if tmw doesn't exist
then
	echo "Compilation failed somewhere. Please try to correct errors given by gcc output...";
	echo "You need the libwxgtk2.5-dev debian package to compile wxOsmOse."
	echo "Aborting...";
	exit;
fi

echo "wxOsmOse seems to have compiled successfully.";
echo "Now creating Debian Repository...";

rm -rf Debian;
mkdir Debian 0>/dev/null 1>/dev/null 2>/dev/null;

if [ ! -d ./datas ]; # if tmw doesn't exist
then
	echo "Can't find the datas folder...";
	echo "You need that directory, or sms roms won't be auto-detected...";
	echo "Aborting...";
	exit;
fi

if [ ! -d ./Debian ]; # if the Debian folder doesn't exist...
then
	echo "Can't create a Debian folder here...";
	echo "Have you got enough rights to do that ?"
	echo "Aborting...";
	exit;
fi

WXOSMOSE_VERSION=`grep "WXOSMOSE_VERSION" ./version.h | cut -d'"' -f2`;
MINIMUM_OSMOSE_VERSION=`grep "OSMOSE_MINIMUM_VERSION" ./version.h | cut -d'"' -f2`;
WXOSMOSE_SIZE=`ls -l wxosmose | cut -d' ' -f6`;

echo "Version :" $WXOSMOSE_VERSION;
mkdir `echo 'Debian/wxosmose_'$WXOSMOSE_VERSION'_i386'`;
cd `echo 'Debian/wxosmose_'$WXOSMOSE_VERSION'_i386'`;
mkdir DEBIAN;
mkdir usr;
mkdir usr/games;
mkdir usr/share;
mkdir usr/share/wxosmose;
cp -r ../../datas ./usr/share/wxosmose;
cp ../../wxosmose ./usr/share/wxosmose;

# Creating a good link to launch the game
touch ./usr/games/wxosmose;
echo "#!/bin/sh" >>./usr/games/wxosmose;
echo "cd /usr/share/wxosmose;" >>./usr/games/wxosmose;
echo "./wxosmose;" >>./usr/games/wxosmose;
echo "cd -" >>./usr/games/wxosmose;

chmod +x ./usr/games/wxosmose;
chmod +x ./usr/share/wxosmose/wxosmose;
# End of the link

echo "Creating Rules for the Debian package..."
#echo "Set the variables value at the begining of this script if you want to change something...";

touch DEBIAN/postinst;
echo "#!/bin/sh" >>DEBIAN/postinst;
echo 'if [ "$1" = "configure" ]; then' >>DEBIAN/postinst;
echo '    echo -n "";' >>DEBIAN/postinst;
echo 'fi' >>DEBIAN/postinst;

chmod 755 DEBIAN/postinst;
# End of postinst script...

touch DEBIAN/prerm;
echo '#!/bin/sh' >>DEBIAN/prerm;
echo 'if [ \( "$1" = "upgrade" -o "$1" = "remove" \) ]; then' >>DEBIAN/prerm;
echo '    rm -rf usr/share/wxosmose' >>DEBIAN/prerm
echo 'fi' >>DEBIAN/prerm;

chmod 755 DEBIAN/prerm;
# End of prerm script...

touch DEBIAN/control
echo 'Package: wxosmose' >>DEBIAN/control;
echo 'Version: '$WXOSMOSE_VERSION >>DEBIAN/control;
echo 'Section: games' >>DEBIAN/control;
echo 'Priority: optional' >>DEBIAN/control;
echo 'Architecture: i386' >>DEBIAN/control;
echo 'Depends: libsdl1.2debian (>= 1.2.7), libwxgtk2.5.3 (>= 2.5.3), osmose (>= '$MINIMUM_OSMOSE_VERSION')' >>DEBIAN/control;
echo 'Suggests: Nothing' >>DEBIAN/control;
echo 'Installed-Size: '$WXOSMOSE_SIZE >>DEBIAN/control;
echo 'Maintainer: Ferreira Yohann <bertram@cegetel.net>' >>DEBIAN/control;
echo 'Description: wxOsmOse is a front-end to the Master-System Emulator OsmOse.' >>DEBIAN/control;
echo ' It makes the OsmOse configuration an easy way !!' >>DEBIAN/control;
echo ' .' >>DEBIAN/control;
echo ' wxOsmose is released under the GPL v2 License.' >>DEBIAN/control;
echo ' .' >>DEBIAN/control;
echo ' Please submit bugs or any comments to:' >>DEBIAN/control;
echo ' Bertram@cegetel.net' >>DEBIAN/control;
# End of control file...

echo "Rules created..."
echo "Creating Debian Package..."
cd ..
chown -R root:root `echo 'wxosmose_'$WXOSMOSE_VERSION'_i386'`;
dpkg --build `echo 'wxosmose_'$WXOSMOSE_VERSION'_i386'`;
cp `echo 'wxosmose_'$WXOSMOSE_VERSION'_i386.deb'` ..;
cd ..
echo "Cleaning ...";
rm -rf Debian;
echo "Your Debian Package is normally ready :"
echo "Its name is : wxosmose_"$WXOSMOSE_VERSION"_i386.deb";
echo "Don't forget you need libwxgtk2.5.3 (>=2.5.3) and osmose (>="$MINIMUM_OSMOSE_VERSION") to install wxosmose.";
echo "End of Debian Creation...";

