VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ZipExtractionClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private fh As Long

Private Declare Function CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (dest As Any, src As Any, ByVal length As Long) As Long

Private Declare Function lstrcpy Lib "kernel32" Alias "lstrcpyA" (ByVal lpBuffer As String, ByVal lpString As Long) As Long

Private Declare Function lstrlen Lib "kernel32" Alias "lstrlenA" (ByVal lpString As Long) As Long

Private Declare Function ZLibVer Lib "zlib" Alias "zlibVersion" () As Long

Private Declare Function Compress Lib "zlib.dll" Alias "compress" (dest As Any, destLen As Any, src As Any, ByVal srcLen As Long) As Long

Private Declare Function Compress2 Lib "zlib.dll" Alias "compress2" (dest As Any, destLen As Any, src As Any, ByVal srcLen As Long, ByVal Level As Long) As Long

Private Declare Function UnCompress Lib "zlib.dll" Alias "uncompress" (dest As Any, destLen As Any, src As Any, ByVal srcLen As Long) As Long

Private Declare Function lCRC32 Lib "zlib.dll" Alias "crc32" (ByVal crc As Long, Buffer As Any, ByVal length As Long) As Long

Public Enum eZipError

   zeZLibNotInstalled = 1

   zeNotZipFile = 2

   zeNoOpenZipFile = 3

   zeUnsupportedCompressionMethod = 4

   zeChecksumError = 5

   zeFileNotFound = 10

   zeFileAlreadyExists = 11

   zeCantRemoveFile = 12

   zeCantCreateFolder = 13

End Enum

Private Type typCentralFileHeader

   CentralFileHeaderSigniature As Long

   VersionMadeBy As Integer

   VersionNeededToExtract As Integer

   GeneralPurposeBitFlag As Integer

   CompressionMethod As Integer

   LastModFileTime As Integer

   LastModFileDate As Integer

   CRC32 As Long

   CompressedSize As Long

   UnCompressedSize As Long

   FileNameLength As Integer

   ExtraFieldLength As Integer

   FileCommentLength As Integer

   DiskNumberStart As Integer

   InternalFileAttributes As Integer

   ExternalFileAttributes As Long

   RelativeOffsetOfLocalHeader As Long

End Type

Private Type typCenteralDirEnd

   EndOFCentralDirSignature As Long

   NumberOfThisDisk As Integer

   NumberOfDiskWithCentralDir As Integer

   EntriesInTheCentralDirThisOnDisk As Integer

   EntriesInTheCentralDir As Integer

   SizeOfCentralDir As Long

   OffSetOfCentralDir As Long

   ZipFileCommentLength As Integer

End Type

Private Type typLocalFileHeader

   LocalFileHeaderSignature As Long

   VersionNeededToExtract As Integer

   GeneralPurposeBitFlag As Integer

   CompressionMethod As Integer

   LastModFileTime As Integer

   LastModFileDate As Integer

   CRC32 As Long

   CompressedSize As Long

   UnCompressedSize As Long

   FileNameLength As Integer

   ExtraFieldLength As Integer

End Type

Private Const EndOFCentralDirSignature As Long = &H6054B50

Private Const CentralFileHeaderSigniature As Long = &H2014B50

Private Const LocalFileHeaderSignature As Long = &H4034B50

Private CentralFileHeader As typCentralFileHeader

Private CentralDirEnd As typCenteralDirEnd

Private CentralDirEndPos As Long

Public Event Progress(Percent As Long, Cancel As Boolean)

Public Event Status(Text As String)

Public Event ZipError(Number As eZipError, Description As String)
Public Function openzip(ZipPath As String) As Boolean

   RaiseEvent Status("Opening Zip")
   closezip

   If Not fileexists(ZipPath) Then
      RaiseEvent ZipError(zeFileNotFound, "The file " & ZipPath & " doesn't exist")
      Exit Function
   End If

   fh = FreeFile
   Open ZipPath For Binary As #fh
   
   CentralDirEndPos = getcentraldirendpos(fh)
   If CentralDirEndPos > 0 Then
      openzip = True
      RaiseEvent Status("Zip Opened")
   Else
      RaiseEvent ZipError(zeNotZipFile, "The file " & ZipPath & " is not a Zip file")
   End If
   
End Function

Public Sub closezip()
  If fh <> 0 Then
    Close #fh
    fh = 0
    RaiseEvent Status("Zip Closed")
  End If
  CentralDirEndPos = 0
End Sub
Public Function extract(FolderPath As String, Optional PreservePath As Boolean, Optional Overwrite As Boolean) As Boolean

  Dim l As Long, FileName As String, FilePos As Long, Cancel As Boolean

  If Len(zlibversion) = 0 Then
    Exit Function
  End If

  RaiseEvent Status("Extracting Files")

  If CentralDirEndPos = 0 Then RaiseEvent ZipError(zeNoOpenZipFile, "There is no Zip File Open"): Exit Function

  If Not folderexists(FolderPath) Then
    If Not createfolder(FolderPath) Then RaiseEvent ZipError(zeCantCreateFolder, "Can't create the folder " & FolderPath): Exit Function
  End If

   If readcentraldirend(CentralDirEndPos) Then
      Seek #fh, CentralDirEnd.OffSetOfCentralDir + 1
      For l = 1 To CentralDirEnd.EntriesInTheCentralDir
         readcentralfileheader FileName
         If CentralFileHeader.UnCompressedSize > 0 Then
            If PreservePath Then
               checkfolder FolderPath, getfilepath(FileName)
            Else
               FileName = getfilename(FileName)
            End If
            RaiseEvent Status("Extracting ...\" & FileName)
            FilePos = Seek(fh)
            If fileexists(FolderPath & "\" & FileName) Then
               If Overwrite Then
                  If removefile(FolderPath & "\" & FileName) Then
                     extractfile FolderPath & "\" & FileName
                  Else
                     RaiseEvent ZipError(zeCantRemoveFile, "Can't remove the file " & FolderPath & "\" & FileName)
                  End If
               Else
                  RaiseEvent ZipError(zeFileAlreadyExists, "The file " & FolderPath & "\" & FileName & " already exists")
               End If
            Else
               extractfile FolderPath & "\" & FileName
            End If
            Seek fh, FilePos
         End If
         DoEvents
         RaiseEvent Progress((l / CentralDirEnd.EntriesInTheCentralDir) * 100, Cancel)
         If Cancel Then
            Exit Function
         End If
      Next
      extract = True
   End If

   RaiseEvent Status("Extraction Complete")

End Function

Private Function getfilename(Path As String) As String
   
   Dim l As Long
   
   l = InStrRev(Path, "\")
   If l > 0 Then
      getfilename = Right$(Path, Len(Path) - l)
   Else
      getfilename = Path
   End If
   
End Function

Private Function getfilepath(Path As String) As String
   
   Dim l As Long
   
   l = InStrRev(Path, "\")
   If l > 0 Then
      getfilepath = Left$(Path, l - 1)
   End If
   
End Function

Private Sub checkfolder(ByVal FolderPath As String, CheckPath As String)

  Dim s() As String, v As Variant

  s = Split(CheckPath, "\")

  For Each v In s

    FolderPath = FolderPath & "\" & v

    If Not folderexists(FolderPath) Then

      Call MkDir(FolderPath)

    End If

  Next

End Sub
Private Sub readcentralfileheader(FileName As String)

  Dim ExtraField As String, Comment As String
   
  Get #fh, , CentralFileHeader

  If CentralFileHeader.CentralFileHeaderSigniature = CentralFileHeaderSigniature Then

    FileName = Space(CentralFileHeader.FileNameLength)

    Get #fh, , FileName

    FileName = Replace(FileName, "/", "\")

    ExtraField = Space(CentralFileHeader.ExtraFieldLength)

    Get #fh, , ExtraField

    Comment = Space(CentralFileHeader.FileCommentLength)

    Get #fh, , Comment

  End If

End Sub
Private Function readcentraldirend(Position As Long) As Boolean

  Dim l As Long, ZipComment As String
   
  Get #fh, Position, CentralDirEnd

  ZipComment = Space(CentralDirEnd.ZipFileCommentLength)

  Get #fh, , ZipComment
   
  readcentraldirend = CentralDirEnd.NumberOfThisDisk = CentralDirEnd.NumberOfDiskWithCentralDir

End Function
Private Function extractfile(Path As String) As Boolean

  Dim LocalFileHeader As typLocalFileHeader, b() As Byte, FileName As String, ExtraField As String

  Get #fh, CentralFileHeader.RelativeOffsetOfLocalHeader + 1, LocalFileHeader

  If LocalFileHeader.LocalFileHeaderSignature = LocalFileHeaderSignature Then

    FileName = Space(LocalFileHeader.FileNameLength)

    Get #fh, , FileName

    ExtraField = Space(LocalFileHeader.ExtraFieldLength)

    Get #fh, , ExtraField

    ReDim b(LocalFileHeader.CompressedSize - 1)

    Get #fh, , b

    If CentralFileHeader.CompressionMethod = 0 Then 'No Compression

      Call savefile(Path, b)

    ElseIf CentralFileHeader.CompressionMethod = 8 Then 'Deflate Method

      If uncompressbytes(b, LocalFileHeader.CompressedSize, LocalFileHeader.UnCompressedSize, LocalFileHeader.CRC32) Then

        Call savefile(Path, b)

      Else

        RaiseEvent ZipError(zeChecksumError, "Data checksum error in " & Path)

      End If

    Else

      RaiseEvent ZipError(zeUnsupportedCompressionMethod, "The compression Method for " & FileName & " is unsupported")

    End If

  End If
   
End Function
Private Function fileexists(Path) As Boolean

   fileexists = Not (Len(Dir$(Path, vbNormal)) = 0)

End Function
Private Function folderexists(Path) As Boolean

   folderexists = Not (Len(Dir$(Path, vbDirectory)) = 0)

End Function
Private Function createfolder(Path As String) As Boolean

  On Error GoTo eh

  Call MkDir(Path)

  createfolder = True

eh:

End Function
Private Function removefile(Path As String) As Boolean

  On Error GoTo eh
   
  Call Kill(Path)

  removefile = True
   
eh:

End Function
Private Function getcentraldirendpos(fh As Long) As Long

  Dim Data() As Byte, l As Long, m As Long

  ReDim Data(LOF(fh) - 1)

  Get #fh, , Data
   
  For l = UBound(Data) - 3 To LBound(Data) Step -1

    Call CopyMemory(m, Data(l), 4)

    If m = EndOFCentralDirSignature Then

      getcentraldirendpos = l + 1

      Exit Function

    End If

  Next

End Function
Private Function uncompressbytes(Buffer() As Byte, CompressedSize As Long, UnCompressedSize As Long, CRC32 As Long) As Boolean
   
  Dim b() As Byte, BufferSize As Long, FileSize As Long, crc As Long, fh As Long, r As Long

  ReDim b(UBound(Buffer) + 2)
   
  b(0) = 120

  b(1) = 156

  Call CopyMemory(b(2), Buffer(0), UBound(Buffer) + 1)

  FileSize = UBound(Buffer) + 3

  BufferSize = CentralFileHeader.UnCompressedSize * 1.01 + 12

  ReDim Buffer(BufferSize - 1) As Byte
   
  r = UnCompress(Buffer(0), BufferSize, b(0), FileSize)

  ReDim Preserve Buffer(CentralFileHeader.UnCompressedSize - 1)

  crc = lCRC32(0&, Buffer(0), UBound(Buffer) + 1)

  If crc = CRC32 Then

    uncompressbytes = True

  End If

End Function
Private Sub savefile(Path As String, Data() As Byte)

  Dim lfh As Long
   
  lfh = FreeFile

  Open Path For Binary As #lfh

  Put #lfh, , Data

  Close #lfh

End Sub
Private Function pointertostring(Pointer As Long) As String

  Dim l As Long, s As String
   
  l = lstrlen(Pointer)

  s = Space(l)

  l = lstrcpy(s, Pointer)

  If l > 0 Then

    pointertostring = s

  End If
   
End Function
Public Property Get zlibversion() As String

  On Error GoTo eh
   
  zlibversion = pointertostring(ZLibVer)

  Exit Property

eh:

  RaiseEvent ZipError(zeZLibNotInstalled, "Zlib is not installed")

End Property
Private Sub Class_Terminate()

  Call closezip
   
End Sub
