Attribute VB_Name = "modNES"
Option Explicit

DefLng A-Z

Global CLInput As Boolean

Global JoyInfo As tJoyInfo

Global Traced As Integer

Global JoyCaps As tJoyCaps

Global keystopress As Integer

Global Listenin As Boolean

Global ResizeYet As Boolean

Global LoadedROM As String

Global TheROMFile As String

Global saveMins As Integer

Global TraceLogShown As Boolean

Global saveMinsDone

Global exitbutton As Boolean

Global Header As String * 3

Global ROMCtrl As Byte

Global ROMCtrl2 As Byte

Global JOY_LT As Integer

Global JOY_RT As Integer

Global JOY_DN As Integer

Global JOY_UP As Integer

Global JOY_B As Integer

Global JOY_A As Integer

Global JOY_SEL As Integer

Global JOY_STA As Integer

Global JOY_WHICH As Integer

Global Const JOY_BUTTON1 = &H1

Global Const JOY_BUTTON2 = &H2

Global Const JOY_BUTTON3 = &H4

Global Const JOY_BUTTON4 = &H8

Global Const JOYERR_NOERROR = 0

Global Const JOYERR_PARMS = 165

Global Const JOYERR_UNPLUGGED = 167

Global Const JOYSTICK1 = 0

Global Const JOYSTICK2 = 1

Global Const MMSYSERR_NODRIVER = 6

Public a As Byte

Public accumulator As Long

Public addrmode(0 To &H100&) As Byte

Public addrmodeBase As Long

Public allowXor As Boolean

Public AndIt As Byte

Public AndIt2 As Byte

Public autospeed As Boolean

Public bank0(2047) As Byte

Public bank6(8191) As Byte

Public bank8(8191) As Byte

Public bankA(8191) As Byte

Public bankC(8191) As Byte

Public bankE(8191) As Byte

Public bank_regs(16) As Byte

Public ChannelWrite(3) As Boolean

Public chr1 As Byte

Public ChrCnt As Byte

Public ChrCount As Byte

Public ChrCount2 As Long

Public clockticks6502 As Long

Public cmd As Byte

Public codeaddy As Long

Public codecompval As Long

Public codeval As Long

Public CPal() As Long

Public CPUPaused As Boolean

Public CPURunning As Boolean

Public CurrentLine As Long

Public CurrVr As Byte

Public Data(4) As Byte

Public doSound As Boolean

Public EmphVal As Integer

Public FirstRead As Boolean

Public FourScreen As Byte

Public Frames As Long

Public FrameSkip As Long

Public gameImage() As Byte

Public gif As IPictureDisp

Public help As Long

Public HScroll As Byte

Public HScroll2 As Long

Public IdleAddr As Long

Public idleCheck(65535) As Byte

Public IdleDetect As Boolean

Public ind As Long

Public instruction(0 To &H100&) As Byte

Public Interlace As Long

Public IRQCounter As Long

Public Joypad1(7) As Byte

Public Joypad1_Count As Byte

Public Joypad2(7) As Byte

Public Joypad2_Count As Byte

Public Keyboard(255) As Byte

Public lastFrame(3)

Public LastRandDir As String

Public latch1 As Byte

Public latch2 As Byte

Public latch13 As Byte

Public Latch0FD As Byte

Public Latch0FE As Byte

Public Latch1FD As Byte

Public Latch1FE As Byte

Public map6_irqon As Byte

Public Map15_BankAddr As Byte

Public map15_swapaddr As Long

Public Map15_SwapReg As Byte

Public map17_irq As Long

Public map17_irqon As Boolean

Public map24_irqon As Byte

Public map24_irqv As Byte

Public map225_psel As Byte

Public map225_psize As Byte

Public Mapper As Byte

Public Mapper40_IRQEnabled As Byte

Public Mapper40_IRQCounter As Byte

Public MapperNames As Variant

Public MapSubP1 As Integer

Public MapSubP2 As Integer

Public maxCycles1 As Long

Public maxCycles As Long

Public maxIdle As Long

Public mdh As Long

Public midiOpened As Boolean

Public MIRQOn As Byte

Public mirror(3) As Byte

Public Mirroring As Byte

Public MirrorTypes(4) As String

Public MirrorXor As Long

Public MMC3_ChrAddr As Integer

Public MMC3_Command As Byte

Public MMC3_IrqOn As Boolean

Public MMC3_IrqVal As Byte

Public MMC3_PrgAddr As Byte

Public MMC3_TmpVal As Byte

Public MMC16_Irq As Long

Public MMC16_IrqOn As Byte

Public MMC19_IRQCount As Long

Public MMC32_Switch As Byte

Public MMC5Flag As Byte

Public MotionBlur As Boolean

Public MovieIndex As Integer

Public NameTable As Long

Public NetConnected As Boolean

Public NetListen As Boolean

Public nCycles As Long

Public nes_ButUp As Byte

Public nes_ButDn As Byte

Public nes_ButLt As Byte

Public nes_ButRt As Byte

Public nes_ButB As Byte

Public nes_ButBTurbo As Byte

Public nes_ButA As Byte

Public nes_ButATurbo As Byte

Public nes_ButSta As Byte

Public nes_ButSel As Byte

Public nes2_ButUp As Byte

Public nes2_ButDn As Byte

Public nes2_ButLt As Byte

Public nes2_ButRt As Byte

Public nes2_ButB As Byte

Public nes2_ButBTurbo As Byte

Public nes2_ButA As Byte

Public nes2_ButATurbo As Byte

Public nes2_ButSta As Byte

Public nes2_ButSel As Byte

Public NESPal(&HF) As Byte

Public newScroll As Boolean

Public nextchar As Byte

Public noScroll2006 As Boolean

Public nt(0 To 3, &H0 To &H3FF) As Byte

Public oldvBuffer16(256& * 240& - 1) As Integer

Public opcode As Byte

Public P As Byte

Public p8

Public pA

Public pal(255) As Long

Public pal16(255) As Integer

Public pal15(255) As Integer

Public pally As String

Public palName As String

Public PatternTable As Long

Public PC As Long

Public pE

Public Playing As Boolean

Public pow2(31) As Long

Public PPU_AddressIsHi As Boolean

Public PPU_Control1 As Byte

Public PPU_Control2 As Byte

Public PPU_Status As Byte

Public PPUAddress As Long

Public PPUAddress2 As Long

Public PPUAddressHi As Long

Public ppuLatch As Byte

Public prevBSSrc(7) As Long

Public prg As Byte

Public PrgCnt As Byte

Public PrgCount As Byte

Public PrgCount2 As Long

Public PrgSwitch1 As Byte

Public PrgSwitch2 As Byte

Public rc

Public rCycles As Long

Public readBuffer(4095) As Byte

Public readptr As Long

Public readsize As Long

Public realframes As Long

Public Record As Boolean

Public reg8 As Byte

Public regA As Byte

Public regC As Byte

Public regE As Byte

Public reg8000 As Byte

Public render As Boolean

Public romName As String

Public runchar As Byte

Public runlength As Byte

Public s As Byte

Public SaveCPU As Boolean

Public saveflags As Long

Public savepc As Long

Public ScrollToggle As Byte

Public sequence As Long

Public SlotIndex As Long

Public SlotSRAM As Long

Public SmartExec As Boolean

Public Smooth2x As Long

Public Sound(0 To &H15) As Byte

Public SoundCtrl As Byte

Public SpecialWrite6000 As Boolean

Public SpriteAddr As Long

Public SpriteAddress As Long

Public SpriteRAM(&HFF) As Byte

Public Sprites(63) As Sprite

Public SpritesChanged As Boolean

Public stopTones(3)

Public sum As Long

Public swap As Boolean

Public temp As Byte

Public Ticks(0 To &H100&) As Byte

Public tilebased As Boolean

Public tLook(65536 * 8 - 1) As Byte

Public tmpLatch As Byte

Public tones(3)

Public Train(&H1FF) As Byte

Public Trainer As Byte

Public UsesSRAM As Boolean

Public value As Long

Public vBuffer(256& * 241& - 1) As Byte

Public vBuffer16(256& * 240& - 1) As Integer

Public vBuffer2x16(512& * 480& - 1) As Integer

Public vBuffer2x32(512& * 480& - 1) As Long

Public vBuffer32(256& * 240& - 1) As Long

Public vlengths(31) As Long

Public volume(3)

Public VRAM(&H3FFF) As Byte

Public VROM() As Byte

Public VScroll As Long

Public VScroll2 As Long

Public VSUni As Boolean

Public writebuffer(4095) As Byte

Public writeptr As Long

Public X As Byte

Public Y As Byte

Public Const ADR_ABS As Long = 0

Public Const ADR_ABSX As Long = 1

Public Const ADR_ABSY  As Long = 2

Public Const ADR_IMM As Long = 3

Public Const ADR_IMP As Long = 4

Public Const ADR_INDABSX As Long = 5

Public Const ADR_IND As Long = 6

Public Const ADR_INDX As Long = 7

Public Const ADR_INDY As Long = 8

Public Const ADR_INDZP As Long = 9

Public Const ADR_REL As Long = 10

Public Const ADR_ZP As Long = 11

Public Const ADR_ZPX As Long = 12

Public Const ADR_ZPY As Long = 13

Public Const HWND_NOTOPMOST = -2

Public Const HWND_TOPMOST = -1

Public Const INS_ADC As Long = 0

Public Const INS_AND As Long = 1

Public Const INS_ASL As Long = 2

Public Const INS_ASLA As Long = 3

Public Const INS_BCC As Long = 4

Public Const INS_BCS As Long = 5

Public Const INS_BEQ As Long = 6

Public Const INS_BIT As Long = 7

Public Const INS_BMI As Long = 8

Public Const INS_BNE As Long = 9

Public Const INS_BPL As Long = 10

Public Const INS_BRK As Long = 11

Public Const INS_BVC As Long = 12

Public Const INS_BVS As Long = 13

Public Const INS_CLC As Long = 14

Public Const INS_CLD As Long = 15

Public Const INS_CLI As Long = 16

Public Const INS_CLV As Long = 17

Public Const INS_CMP As Long = 18

Public Const INS_CPX As Long = 19

Public Const INS_CPY As Long = 20

Public Const INS_DEC As Long = 21

Public Const INS_DEA As Long = 22

Public Const INS_DEX As Long = 23

Public Const INS_DEY As Long = 24

Public Const INS_EOR As Long = 25

Public Const INS_INC As Long = 26

Public Const INS_INX As Long = 27

Public Const INS_INY As Long = 28

Public Const INS_JMP As Long = 29

Public Const INS_JSR As Long = 30

Public Const INS_LDA As Long = 31

Public Const INS_LDX As Long = 32

Public Const INS_LDY As Long = 33

Public Const INS_LSR As Long = 34

Public Const INS_LSRA As Long = 35

Public Const INS_NOP As Long = 36

Public Const INS_ORA As Long = 37

Public Const INS_PHA As Long = 38

Public Const INS_PHP As Long = 39

Public Const INS_PLA As Long = 40

Public Const INS_PLP As Long = 41

Public Const INS_ROL As Long = 42

Public Const INS_ROLA As Long = 43

Public Const INS_ROR As Long = 44

Public Const INS_RORA As Long = 45

Public Const INS_RTI As Long = 46

Public Const INS_RTS As Long = 47

Public Const INS_SBC As Long = 48

Public Const INS_SEC As Long = 49

Public Const INS_SED As Long = 50

Public Const INS_SEI As Long = 51

Public Const INS_STA As Long = 52

Public Const INS_STX As Long = 53

Public Const INS_STY As Long = 54

Public Const INS_TAX As Long = 55

Public Const INS_TAY As Long = 56

Public Const INS_TSX As Long = 57

Public Const INS_TXA As Long = 58

Public Const INS_TXS As Long = 59

Public Const INS_TYA As Long = 60

Public Const INS_BRA As Long = 61

Public Const INS_INA As Long = 62

Public Const INS_PHX As Long = 63

Public Const INS_PLX As Long = 64

Public Const INS_PHY As Long = 65

Public Const INS_PLY As Long = 66

Public Const MAXPNAMELEN = 32

Public Const MAXOEMVXD = 128

Public Const PPU_InVBlank = &H80

Public Const PPU_Sprite0 = &H40

Public Const PPU_SpriteCount = &H20

Public Const PPU_Ignored = &H10

Public Const SRCCOPY = &HCC0020

Public Const SWP_NOMOVE = &H2

Public Const SWP_NOSIZE = &H1

Public Const FLAGS = SWP_NOMOVE Or SWP_NOSIZE

Public Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long

Public Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal hdc As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long

Public Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long

Public Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long

Public Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long

Public Declare Function GetWindowDC Lib "user32" (ByVal hwnd As Long) As Long

Public Declare Function midiOutClose Lib "winmm.dll" (ByVal hMidiOut As Long) As Long

Public Declare Function midiOutOpen Lib "winmm.dll" (lphMidiOut As Long, ByVal uDeviceID As Long, ByVal dwCallback As Long, ByVal dwInstance As Long, ByVal dwFlags As Long) As Long

Public Declare Function midiOutShortMsg Lib "winmm.dll" (ByVal hMidiOut As Long, ByVal dwMsg As Long) As Long

Public Declare Function OleCreatePictureIndirect Lib "olepro32.dll" (PicDesc As picBmp, RefIID As GUID, ByVal fPictureOwnsHandle As Long, IPic As IPicture) As Long

Public Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hdc As Long) As Long

Public Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long

Public Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

Public Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public Declare Function StretchBlt Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long

Public Declare Function StretchDIBits Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal dx As Long, ByVal dy As Long, ByVal SrcX As Long, ByVal SrcY As Long, ByVal wSrcWidth As Long, ByVal wSrcHeight As Long, lpBits As Any, lpBitsInfo As BITMAPINFO, ByVal wUsage As Long, ByVal dwRop As Long) As Long

Public Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long

Public Declare Function joyGetDevCaps Lib "winmm.dll" Alias "joyGetDevCapsA" (ByVal IDDevice As Integer, JCaps As tJoyCaps, ByVal CapSize As Integer) As Integer

Public Declare Function joyGetPos Lib "winmm.dll" (ByVal IDDevice As Integer, JPos As tJoyInfo) As Integer

Public Declare Sub MemCopy Lib "kernel32" Alias "RtlMoveMemory" (dest As Any, src As Any, ByVal cb&)

Public Declare Sub MemFill Lib "kernel32" Alias "RtlFillMemory" (destination As Any, ByVal length As Long, ByVal Fill As Byte)

Public Type BITMAPINFOHEADER

  biSize As Long

  biWidth As Long

  biHeight As Long

  biPlanes As Integer

  biBitCount As Integer

  biCompression As Long

  biSizeImage As Long

  biXPelsPerMeter As Long

  biYPelsPerMeter As Long

  biClrUsed As Long

  biClrImportant As Long

End Type

Public Type RGBQUAD

  rgbBlue As Byte

  rgbGreen As Byte

  rgbRed As Byte

  rgbReserved As Byte

End Type

Public Type GUID

  Data1 As Long

  Data2 As Integer

  Data3 As Integer

  Data4(7) As Byte

End Type

Public Type BITMAPINFO

  bmiHeader As BITMAPINFOHEADER

  bmiColor0 As Long

  bmiColor1 As Long

  bmiColor2 As Long

End Type

Public Type picBmp

  Size As Long

  Type As Long

  hBmp As Long

  hPal As Long

  Reserved As Long

End Type

Public Type Sprite

  X As Integer

  Y As Integer

  tileno As Byte

  attrib As Byte

End Type

Public Type tJoyInfo

  X As Long

  Y As Long

  Z As Long

  ButtonStates As Long

  ButtonDown(1 To 4) As Integer

End Type

Public Type tJoyCaps

  Mid As Integer

  Pid As Integer

  Pname As String * MAXPNAMELEN

  Xmin As Long

  Xmax As Long

  Ymin As Long

  Ymax As Long

  Zmin As Long

  Zmax As Long

  NumButtons As Long

  PeriodMin As Long

  PeriodMax As Long

  wRmin As Long

  wRmax As Long

  wUmin As Long

  wUmax As Long

  wVmin As Long

  wVmax As Long

  wCaps As Long

  wMaxAxes As Long

  wNumAxes As Long

  wMaxButtons As Long

  szRegKey As String * MAXPNAMELEN

  szOEMVxD As String * MAXOEMVXD

End Type
Public Sub savetext(Path As String, txtSave As TextBox)

  Dim TextString As String

  On Error Resume Next

  TextString$ = txtSave.Text

  Open Path$ For Output As #1

  Print #1, TextString$

  Close #1

End Sub
Public Sub loadtext(Path As String, txtLoad As TextBox)

  Dim TextString As String

  On Error Resume Next

  Open Path$ For Input As #1

  TextString$ = Input(LOF(1), #1)

  Close #1

  txtLoad.Text = TextString$

End Sub
Public Function getjoystickpos(IDDevice As Long, JoyInfo As tJoyInfo) As Integer

  Dim rc As Integer

  Static NotFirstTime As Integer

  If Not NotFirstTime Then

    NotFirstTime = False

    rc = joyGetDevCaps(IDDevice, JoyCaps, Len(JoyCaps))

    If rc <> 0 Then

      getjoystickpos = rc

      Exit Function

    End If

  End If

  rc = joyGetPos(IDDevice, JoyInfo)

  getjoystickpos = rc

  If rc <> 0 Then

    Exit Function

  End If

  JoyInfo.ButtonDown(1) = (JoyInfo.ButtonStates And JOY_BUTTON1) = JOY_BUTTON1

  JoyInfo.ButtonDown(2) = (JoyInfo.ButtonStates And JOY_BUTTON2) = JOY_BUTTON2

  JoyInfo.ButtonDown(3) = (JoyInfo.ButtonStates And JOY_BUTTON3) = JOY_BUTTON3

  JoyInfo.ButtonDown(4) = (JoyInfo.ButtonStates And JOY_BUTTON4) = JOY_BUTTON4

End Function
Public Function bintohex(BinNum As String) As String

  Dim BinLen As Integer, i As Integer, HexNum As Variant

  On Error GoTo errorhandler

  BinLen = Len(BinNum)

  For i = BinLen To 1 Step -1

    If Asc(Mid(BinNum, i, 1)) < 48 Or Asc(Mid(BinNum, i, 1)) > 49 Then

      HexNum = ""

    End If

    If Mid(BinNum, i, 1) And 1 Then

      HexNum = HexNum + 2 ^ Abs(i - BinLen)

    End If

  Next i

  bintohex = Hex(HexNum)

errorhandler:

End Function
Public Function ggrandomcode() As String

  ggrandomcode$ = ggrandomletter$ & ggrandomletter$ & ggrandomletter$ & ggrandomletter$ & ggrandomletter$ & ggrandomletter$

End Function
Public Function ggrandomletter() As String

  Randomize Timer

  a = Int(Rnd * 16) + 1

  Select Case a

    Case 1

      ggrandomletter$ = "A"

    Case 2

      ggrandomletter$ = "P"

    Case 3

      ggrandomletter$ = "Z"

    Case 4

      ggrandomletter$ = "L"

    Case 5

      ggrandomletter$ = "G"

    Case 6

      ggrandomletter$ = "I"

    Case 7

      ggrandomletter$ = "T"

    Case 8

      ggrandomletter$ = "Y"

    Case 9

      ggrandomletter$ = "E"

    Case 10

      ggrandomletter$ = "O"

    Case 11

      ggrandomletter$ = "X"

    Case 12

      ggrandomletter$ = "U"

    Case 13

      ggrandomletter$ = "K"

    Case 14

      ggrandomletter$ = "S"

    Case 15

      ggrandomletter$ = "V"

    Case 16

      ggrandomletter$ = "N"

  End Select

End Function
Public Function extractfilename(filea As String) As String

  Dim a As String, b As String

  a$ = filea$

  b$ = filea$

  Do

    a$ = Left(a$, Len(a$) - 1)

  Loop Until Right$(a$, 1) = "\"

  b$ = Mid$(b$, Len(a$) + 1)

  b$ = Left$(b$, Len(b$) - 4)

  extractfilename$ = b$

End Function
Public Sub savelastrominfo()

  On Error GoTo 1

  Dim msg As String, MType As String

  msg$ = "CHR-ROM: " & (ChrCount * 8) & "k" & vbCrLf

  msg$ = msg$ & "PRG-ROM: " & (PrgCount * 16) & "k" & vbCrLf

  msg$ = msg$ & "Mapper: #" & Mapper & vbCrLf

  Select Case Mirroring

    Case 0

      MType = "none"

    Case 1

      MType = "Horizontal"

    Case 2

      MType = "Vertical"

    Case 3

      MType = "One-Screen"

    Case 4

      MType = "Four-Screen"

  End Select

  msg$ = msg$ & "Mirroring: " & MType & vbCrLf

  msg$ = msg$ & "trainer: " & IIf(Trainer, "Yes", "No")

  frmNES.txtROMInfo.Text = msg$

  Call savetext(App.Path & "\lastrom.dat", frmNES.txtROMInfo)

  Call writeini("options", "lastrom", LCase$(romName))

1:

End Sub
Public Sub makedirectories()

  Call MkDir(App.Path & "\palettes")

  Call MkDir(App.Path & "\sram")

  Call MkDir(App.Path & "\traces")

  Call MkDir(App.Path & "\states")

  Call MkDir(App.Path & "\movies")

  Call MkDir(App.Path & "\snapshots")

  Call MkDir(App.Path & "\temp")

End Sub

Public Sub menuenable()

  frmNES.msave.Enabled = True

  frmNES.mrestore.Enabled = True

  frmNES.mnuStartRecord.Enabled = True

  frmNES.mnuPlayMovie.Enabled = True

  frmNES.mnuCPUPause.Enabled = True

  frmNES.mnuEmuReset.Enabled = True

  frmNES.mnuDebugWindow.Enabled = True

  frmNES.takesnapshot.Enabled = True

  frmNES.openhexviewer.Enabled = True

  frmNES.mnuTraceLogger.Enabled = True

  frmNES.jaw3.Enabled = True

  frmNES.fkaw.Enabled = True

  frmNES.maweiawe.Enabled = True

  frmNES.feefef.Enabled = True

  frmNES.mnumirroring.Enabled = True

  Select Case Mirroring

    Case 0

      frmNES.mnumirror0.Checked = True

    Case 1

      frmNES.mnumirror1.Checked = True

    Case 2

      frmNES.mnumirror2.Checked = True

    Case 3

      frmNES.mnumirror3.Checked = True

    Case 4

      frmNES.mnumirror4.Checked = True

  End Select

End Sub
Public Sub saveconfig()

  Call writeini("options", "mnurewind", CBool(frmNES.mnurewind.Checked))

  Call writeini("options", "disablebg", CBool(frmNES.disablebg.Checked))

  Call writeini("options", "usegp", CBool(frmNES.mnuUseGamepad.Checked))

  Call writeini("options", "joyb", CInt(JOY_B))

  Call writeini("options", "joya", CInt(JOY_A))

  Call writeini("options", "joysel", CInt(JOY_SEL))

  Call writeini("options", "joysta", CInt(JOY_STA))

  Call writeini("options", "joywhich", CInt(JOY_WHICH))

  Call writeini("options", "dosound", CBool(doSound))

  Call writeini("options", "mnuscale2x", CBool(frmNES.mnuscale2x.Checked))

  Call writeini("options", "mnu50scan", CBool(frmNES.mnu50scan.Checked))

  Call writeini("options", "mnu50horizon", CBool(frmNES.mnu50horizon.Checked))

  Call writeini("options", "autospeed", CBool(autospeed))

  Call writeini("options", "frameskip", CByte(FrameSkip))

  Call writeini("options", "mmutechecked", CBool(frmNES.mMute.Checked))

  Call writeini("options", "mmotionblurchecked", CBool(frmNES.mMotionBlur.Checked))

  Call writeini("options", "mnutrianglechecked", CBool(frmNES.mnuTriangle.Checked))

  Call writeini("options", "mnurectanglechecked", CBool(frmNES.mnuRectangle.Checked))

  Call writeini("options", "mnunoisechecked", CBool(frmNES.mnuNoise.Checked))

  Call writeini("joypad1", "up", CByte(nes_ButUp))

  Call writeini("joypad1", "down", CByte(nes_ButDn))

  Call writeini("joypad1", "left", CByte(nes_ButLt))

  Call writeini("joypad1", "right", CByte(nes_ButRt))

  Call writeini("joypad1", "b", CByte(nes_ButB))

  Call writeini("joypad1", "a", CByte(nes_ButA))

  Call writeini("joypad1", "select", CByte(nes_ButSel))

  Call writeini("joypad1", "start", CByte(nes_ButSta))

  Call writeini("joypad2", "up", CByte(nes2_ButUp))

  Call writeini("joypad2", "down", CByte(nes2_ButDn))

  Call writeini("joypad2", "left", CByte(nes2_ButLt))

  Call writeini("joypad2", "right", CByte(nes2_ButRt))

  Call writeini("joypad2", "b", CByte(nes2_ButB))

  Call writeini("joypad2", "a", CByte(nes2_ButA))

  Call writeini("joypad2", "select", CByte(nes2_ButSel))

  Call writeini("joypad2", "start", CByte(nes2_ButSta))

  Call writeini("palette", "which", pally$)

  Call writeini("options", "mnuontop", CBool(frmNES.mnuOnTop.Checked))

  Call writeini("options", "left", Val(frmNES.Left))

  Call writeini("options", "top", Val(frmNES.Top))

  Call writeini("options", "height", Val(frmNES.Height))

  Call writeini("options", "width", Val(frmNES.Width))

  Call writeini("options", "invert", CBool(frmNES.mnuinvert.Checked))

  Call writeini("options", "disablesprites", CBool(frmNES.disablesprites.Checked))

  Call writeini("options", "mnuvideo", CBool(frmNES.mnuvideo.Checked))

  If frmNES.mSmooth(0).Checked = True Then

    Call writeini("options", "mnusmooth", Val("0"))

  End If

  If frmNES.mSmooth(1).Checked = True Then

    Call writeini("options", "mnusmooth", Val("1"))

  End If

  If frmNES.mSmooth(2).Checked = True Then

    Call writeini("options", "mnusmooth", Val("2"))

  End If

End Sub
Public Function st(aa As Long, b As Long) As Long

  aa = b

  st = b

End Function
Public Function hasany(ByVal s As String, ParamArray P() As Variant) As Boolean

  Dim i As Long

  s = Replace(LCase(s), " ", "")

  For i = 0 To UBound(P)

    If InStr(s, P(i)) Then

      hasany = True

      Exit Function

    End If

  Next i

  hasany = False

End Function
Public Function createbitmappicture(ByVal hBmp As Long) As Picture

  Dim r As Long, Pic As picBmp, IPic As IPicture, IID_IDispatch As GUID

  With IID_IDispatch

    .Data1 = &H20400

    .Data4(0) = &HC0

    .Data4(7) = &H46

  End With

  With Pic

    .Size = Len(Pic)

    .Type = vbPicTypeBitmap

    .hBmp = hBmp

  End With

  r = OleCreatePictureIndirect(Pic, IID_IDispatch, 1, IPic)

  Set createbitmappicture = IPic

End Function
Public Function exportbmp(PBox As PictureBox) As Picture

  Dim hDCMemory As Long, hBmp As Long, hBmpPrev As Long, r As Long, hDCSrc As Long, hPal As Long, hPalPrev As Long, RasterCapsScrn As Long, HasPaletteScrn As Long, PaletteSizeScrn As Long, WidthPix As Single, HeightPix As Single

  WidthPix = PBox.ScaleWidth

  HeightPix = PBox.ScaleHeight

  hDCSrc = GetWindowDC(PBox.hwnd)

  hDCMemory = CreateCompatibleDC(hDCSrc)

  hBmp = CreateCompatibleBitmap(hDCSrc, WidthPix, HeightPix)

  hBmpPrev = SelectObject(hDCMemory, hBmp)

  r = BitBlt(hDCMemory, 0, 0, WidthPix, HeightPix, hDCSrc, 0, 0, vbSrcCopy)

  hBmp = SelectObject(hDCMemory, hBmpPrev)

  r = DeleteDC(hDCMemory)

  r = ReleaseDC(PBox.hwnd, hDCSrc)

  Set exportbmp = createbitmappicture(hBmp)

End Function
Public Sub indabsx6502()

  help = read6502(PC) + (read6502(PC + 1) * &H100&) + X

  savepc = read6502(help) + (read6502(help + 1) * &H100&)

End Sub
Public Sub indx6502()

  value = read6502(PC) And &HFF

  value = (value + X) And &HFF

  PC = PC + 1

  savepc = read6502(value) + (read6502(value + 1) * &H100&)

End Sub
Public Sub indy6502()

  value = read6502(PC)

  PC = PC + 1
      
  savepc = read6502(value) + (read6502(value + 1) * &H100&)

  If (Ticks(opcode) = 5) Then

    If ((savepc \ &H100&) = ((savepc + Y) \ &H100&)) Then

    Else

      clockticks6502 = clockticks6502 + 1

    End If

  End If

  savepc = savepc + Y

End Sub
Public Function supportedmapper(m As Byte) As Boolean

  Select Case m

    Case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 32, 33, 34, 40, 41, 45, 51, 57, 58, 60, 64, 65, 66, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 82, 83, 85, 88, 90, 91, 95, 99, 100, 101, 113, 118, 119, 121, 126, 142, 152, 160, 195, 200, 201, 203, 228, 229, 231, 232, 240, 243, 245, 248, 222

      supportedmapper = True

    Case Else

      supportedmapper = False

  End Select

End Function
Public Sub switchbytes(v As Byte, w As Byte)

  Dim av As Byte

  av = v

  v = w

  w = av

End Sub
Public Sub switchcontrols()

  Call switchbytes(nes_ButUp, nes2_ButUp)

  Call switchbytes(nes_ButDn, nes2_ButDn)

  Call switchbytes(nes_ButLt, nes2_ButLt)

  Call switchbytes(nes_ButRt, nes2_ButRt)

  Call switchbytes(nes_ButB, nes2_ButB)

  Call switchbytes(nes_ButA, nes2_ButA)

  Call switchbytes(nes_ButSel, nes2_ButSel)

  Call switchbytes(nes_ButSta, nes2_ButSta)

  frmNES.Caption = "olafnes - inputs switched"

End Sub
Public Sub trace(apc As Long, aopcode As Byte, avalue As Boolean, aa As Byte, ax As Byte, ay As Byte)

  If TraceLogShown = True Then

    If frmTraceLogger.mnuLast100Instructions.Checked = True And Traced >= 100 Then

      frmTraceLogger.Text1.Text = ""

      Traced = 0

    End If

    If frmTraceLogger.mnuLast500Instructions.Checked = True And Traced >= 500 Then

      frmTraceLogger.Text1.Text = ""

      Traced = 0

    End If

    If frmTraceLogger.mnuLast1000Instructions.Checked = True And Traced >= 1000 Then

      frmTraceLogger.Text1.Text = ""

      Traced = 0

    End If

    If frmTraceLogger.mnuLast2500Instructions.Checked = True And Traced >= 2500 Then

      frmTraceLogger.Text1.Text = ""

      Traced = 0

    End If

    If frmTraceLogger.mnuLast5000Instructions.Checked = True And Traced >= 5000 Then

      frmTraceLogger.Text1.Text = ""

      Traced = 0

    End If

    If frmTraceLogger.mnuLast10000Instructions.Checked = True And Traced >= 10000 Then

      frmTraceLogger.Text1.Text = ""

      Traced = 0

    End If

    If avalue = False Then

      DoEvents

      frmTraceLogger.Text1.Text = LCase$("$" & fixhex$(Hex$(apc)) & " [ opcode: #$" & fixhex$(Hex$(aopcode)) & ", a: #$" & fixhex$(Hex$(aa)) & ", x: #$" & fixhex$(Hex$(ax)) & ", y: #$" & fixhex$(Hex$(ay)) & " ]" & vbCrLf & frmTraceLogger.Text1.Text)

      DoEvents

      If frmTraceLogger.mnuTraceToFile.Checked = True Then

        Open App.Path & "\traces\" & romName$ & ".txt" For Append As #52

        DoEvents

        Print #52, LCase$("$" & fixhex$(Hex$(apc)) & " [ opcode: #$" & fixhex$(Hex$(aopcode)) & ", a: " & fixhex$(Hex$(aa)) & ", x: #$" & fixhex$(Hex$(ax)) & ", y: #$" & fixhex$(Hex$(ay)) & " ]")

        DoEvents

        Close #52

        DoEvents

      End If

    ElseIf avalue = True Then

      DoEvents

      frmTraceLogger.Text1.Text = LCase$("$" & fixhex$(Hex$(apc)) & " [ opcode: #$" & fixhex$(Hex$(aopcode)) & " $" & fixhex$(Hex$(avalue)) & ", a: #$" & fixhex$(Hex$(aa)) & ", x: #$" & fixhex$(Hex$(ax)) & ", y: #$" & fixhex$(Hex$(ay)) & " ]" & vbCrLf & frmTraceLogger.Text1.Text)

      DoEvents

      If frmTraceLogger.mnuTraceToFile.Checked = True Then

        Open App.Path & "\traces\" & romName$ & ".txt" For Append As #52

        DoEvents

        Print #52, LCase$("$" & fixhex$(Hex$(apc)) & " [ opcode: #$" & fixhex$(Hex$(aopcode)) & " $" & fixhex$(Hex$(avalue)) & ", a: #$" & fixhex$(Hex$(aa)) & ", x: #$" & fixhex$(Hex$(ax)) & ", y: #$" & fixhex$(Hex$(ay)) & " ]")

        DoEvents

        Close #52

        DoEvents

      End If

    End If

    Traced = Traced + 1

    DoEvents

  Else

    Traced = 32000

  End If

End Sub
Public Sub zpx6502()

  savepc = read6502(PC)

  savepc = savepc + X

  PC = PC + 1

  savepc = savepc And &HFF

End Sub
Public Sub exec6502()

  Dim f As Long, delay As Long, ti As Long, ti2 As Long, tme As Double

  Static tmr As Double, ptime As Double, facc As Double, pframe As Long

  f = Frames

  Do

    If frmNES.mnuCPUPause.Checked = True Then

      Do

        DoEvents

      Loop While frmNES.mnuCPUPause.Checked = True

    End If

    opcode = read6502(PC)

    PC = PC + 1

    If IdleDetect Then

      If idleCheck(PC) > 8 Then

        If CurrentLine > 240 Or CurrentLine < maxIdle Then

          idleCheck(PC) = idleCheck(PC) - 8

        Else

          clockticks6502 = clockticks6502 + CurrentLine \ 2

          rCycles = rCycles - CurrentLine \ 2

        End If

      End If

      If CurrentLine >= 231 And CurrentLine < 238 And idleCheck(PC) < 240 Then

        idleCheck(PC) = idleCheck(PC) + 1

      End If

    End If

    clockticks6502 = clockticks6502 + Ticks(opcode)

    Select Case instruction(opcode)

      Case INS_ADC

        Call adc6502

      Case INS_AND

        Call and6502

      Case INS_ASL

        Call asl6502

      Case INS_ASLA

        Call asla6502

      Case INS_BCC

        Call bcc6502

      Case INS_BCS

        Call bcs6502

      Case INS_BEQ

        Call beq6502

      Case INS_BIT

        Call bit6502

      Case INS_BMI

        Call bmi6502

      Case INS_BNE

        Call bne6502

      Case INS_BPL

        Call bpl6502

      Case INS_BRA

        Call bra6502

      Case INS_BRK

        Call brk6502

      Case INS_BVC

        Call bvc6502

      Case INS_BVS

        Call bvs6502

      Case INS_CLC

        Call clc6502

      Case INS_CLD

        Call cld6502

      Case INS_CLI

        Call cli6502

      Case INS_CLV

        Call clv6502

      Case INS_CMP

        Call cmp6502

      Case INS_CPX

        Call cpx6502

      Case INS_CPY

        Call cpy6502

      Case INS_DEA

        Call dea6502

      Case INS_DEC

        Call dec6502

      Case INS_DEX

        Call dex6502

      Case INS_DEY

        Call dey6502

      Case INS_EOR

        Call eor6502

      Case INS_INA

        Call ina6502

      Case INS_INC

        Call inc6502

      Case INS_INX

        Call inx6502

      Case INS_INY

        Call iny6502

      Case INS_JMP

        Call jmp6502

      Case INS_JSR

        Call jsr6502

      Case INS_LDA

        Call lda6502

      Case INS_LDX

        Call ldx6502

      Case INS_LDY

        Call ldy6502

      Case INS_LSR

        Call lsr6502

      Case INS_LSRA

        Call lsra6502

      Case INS_ORA

        Call ora6502

      Case INS_PHA

        Call pha6502

      Case INS_PHP

        Call php6502

      Case INS_PHX

        Call phx6502

      Case INS_PHY

        Call phy6502

      Case INS_PLA

        Call pla6502

      Case INS_PLP

        Call plp6502

      Case INS_PLX

        Call plx6502

      Case INS_PLY

        Call ply6502

      Case INS_ROL

        Call rol6502

      Case INS_ROLA

        Call rola6502

      Case INS_ROR

        Call ror6502

      Case INS_RORA

        Call rora6502

      Case INS_RTI

        Call rti6502

      Case INS_RTS

        Call rts6502

      Case INS_SBC

        Call sbc6502

      Case INS_SEC

        Call sec6502

      Case INS_SED

        Call sed6502

      Case INS_SEI

        Call sei6502

      Case INS_STA

        Call sta6502

      Case INS_STX

        Call stx6502

      Case INS_STY

        Call sty6502

      Case INS_TAX

        Call tax6502

      Case INS_TAY

        Call tay6502

      Case INS_TSX

        Call tsx6502

      Case INS_TXA

        Call txa6502

      Case INS_TYA

        Call tya6502

      Case INS_TXS

        Call txs6502

    End Select

    If clockticks6502 > maxCycles Then

      Select Case Mapper

        Case 4, 5, 45, 72, 74, 76, 88, 95, 118, 119, 232, 245, 248

          Call map4_hblank(CurrentLine, PPU_Control2)

        Case 6

          Call map6_hblank(CurrentLine)

        Case 16

          If (MMC16_IrqOn <> 0) Then

            MMC16_Irq = MMC16_Irq - 1

            If (MMC16_Irq = 0) Then

              Call irq6502

              MMC16_IrqOn = 0

            End If

          End If

        Case 17

          Call map17_doirq

        Case 19

          Call map19_irq

        Case 24, 26

          Call map24_irq

      End Select

      Call renderscanline(CurrentLine)

      If CurrentLine >= 240 Then

        If CurrentLine = 240 Then

          If render Then

            Call blitscreen

          End If

          Frames = Frames + 1

          If render Then

            realframes = realframes + 1

          End If

          DoEvents

          If Keyboard(0) <> &H41 Then

            Joypad1(1) = Keyboard(nes_ButB)

            Joypad1(0) = Keyboard(nes_ButA)

            Joypad2(1) = Keyboard(nes2_ButB)

            Joypad2(0) = Keyboard(nes2_ButA)

          ElseIf Frames And 2 Then

            Joypad1(0) = Keyboard(nes_ButA)

            Joypad1(1) = &H40

            Joypad2(0) = Keyboard(nes2_ButA)

            Joypad2(1) = &H40

          Else

            Joypad1(0) = &H40

            Joypad1(1) = Keyboard(nes_ButB)

            Joypad2(0) = &H40

            Joypad2(1) = Keyboard(nes2_ButB)

          End If

          Joypad1(2) = Keyboard(nes_ButSel)

          Joypad1(3) = Keyboard(nes_ButSta)

          Joypad1(4) = Keyboard(nes_ButUp)

          Joypad1(5) = Keyboard(nes_ButDn)

          Joypad1(6) = Keyboard(nes_ButLt)

          Joypad1(7) = Keyboard(nes_ButRt)

          Joypad2(2) = Keyboard(nes2_ButSel)

          Joypad2(3) = Keyboard(nes2_ButSta)

          Joypad2(4) = Keyboard(nes2_ButUp)

          Joypad2(5) = Keyboard(nes2_ButDn)

          Joypad2(6) = Keyboard(nes2_ButLt)

          Joypad2(7) = Keyboard(nes2_ButRt)

          If Record = True Then

            Put #1, , Joypad1

            Put #1, , Joypad2

          End If

          If Playing = True Then

            Get #1, , Joypad1

            Get #1, , Joypad2

            If EOF(1) Then

              Call stopplaying

              frmNES.mnuPlayMovie.Caption = "play"

              Playing = False

              frmNES.Caption = "olafnes - movie stopped"

              Call frmNES.mnuEmuReset_Click

              Exit Sub

            End If

          End If

        End If

        PPU_Status = &H80

        If CurrentLine = 240 And (PPU_Control1 And &H80) Then

          Call nmi6502

        End If

        If Mapper = 40 And Mapper40_IRQEnabled = 1 Then

          Mapper40_IRQCounter = (Mapper40_IRQCounter - 1) And 36

          If Mapper40_IRQCounter = 0 Then

            Call irq6502

          End If

        End If

      End If

      If frmNES.mMute.Checked = False Then

        If CurrentLine = 0 Or CurrentLine = 131 Then

          Call updatesounds

        End If

      End If

      If CurrentLine = 258 Then

        PPU_Status = &H0

      End If

      If CurrentLine = 262 Then

        If maxIdle < 240 And Not SpritesChanged Then

          maxIdle = maxIdle + 16

        Else

          If maxIdle > 8 Then

            maxIdle = maxIdle - 8

          End If

          SpritesChanged = False

        End If

        CurrentLine = 0

        If Keyboard(192) And 1 Then

          render = (Frames Mod 3) = 0

        Else

          If autospeed Then

            tme = Timer

            If tme - ptime < 0.2 And ptime < tme Then

              tmr = tmr - tme + ptime

            End If

            tmr = tmr + 0.01667

            ptime = tme

            render = True

            If tmr > 0 Then

              delay = 10000 * tmr * tmr

              For ti = 0 To delay

                For ti2 = 0 To 1000

                  vBuffer32(ti And 255) = ti2

                Next ti2

              Next ti

            Else

              If tmr < -1 Then

                tmr = -0.2

              End If

            End If

          End If

          render = (Frames Mod FrameSkip = 0)

        End If

        PPU_Status = &H0

      Else

        CurrentLine = CurrentLine + 1

      End If

      clockticks6502 = clockticks6502 - maxCycles

      If CurrentLine < 218 Or maxCycles1 > 114 Then

        maxCycles = maxCycles1

      Else

        maxCycles = 114

      End If

    End If

  Loop While CPURunning = True And Frames = f

End Sub
Public Sub setflags(ByVal value As Byte)

  If (value) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (value And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub indzp6502()

  value = read6502(PC)

  PC = PC + 1

  savepc = read6502(value) + (read6502(value + 1) * &H100&)

End Sub
Public Sub zpy6502()

  savepc = read6502(PC)

  savepc = savepc + Y

  PC = PC + 1

End Sub
Public Sub absy6502()

  Call trace(PC, opcode, False, a, X, Y)

  savepc = read6502(PC) + (read6502(PC + 1) * &H100&)

  PC = PC + 2

  If (Ticks(opcode) = 4) Then

    If ((savepc \ &H100&) = ((savepc + Y) \ &H100&)) Then

    Else

      clockticks6502 = clockticks6502 + 1

    End If

  End If

  savepc = savepc + Y

End Sub
Public Sub pause(Duration As Long)

  Dim Current As Long

  Current = Timer

  Do Until Timer - Current >= Duration

    DoEvents

  Loop

End Sub
Public Sub immediate6502()

  savepc = PC

  PC = PC + 1

End Sub
Public Sub indirect6502()

  help = read6502(PC) + (read6502(PC + 1) * &H100&)

  savepc = read6502(help) + (read6502(help + 1) * &H100&)

  PC = PC + 2

End Sub
Public Sub absx6502()

  Call trace(PC, opcode, False, a, X, Y)

  savepc = read6502(PC)

  savepc = savepc + (read6502(PC + 1) * &H100&)

  PC = PC + 2

  If (Ticks(opcode) = 4) Then

    If ((savepc \ &H100&) = ((savepc + X) \ &H100&)) Then

    Else

      clockticks6502 = clockticks6502 + 1

    End If

  End If

  savepc = savepc + X

End Sub
Public Sub abs6502()

  Call trace(PC, opcode, False, a, X, Y)

  savepc = read6502(PC) + (read6502(PC + 1) * &H100&)

  PC = PC + 2

End Sub
Public Sub relative6502()

  savepc = read6502(PC)

  PC = PC + 1

  If (savepc And &H80) Then

    savepc = (savepc - &H100&)

  End If

End Sub
Public Sub reset6502()

  On Error Resume Next

  Dim i As Long

  For i = 0 To 65535

    idleCheck(i) = 0

  Next i

  a = 0

  X = 0

  Y = 0

  P = &H20

  s = &HFF

  PC = read6502(&HFFFC&) + (read6502(&HFFFD&) * &H100&)

End Sub
Public Sub zp6502()

  savepc = read6502(PC)

  PC = PC + 1

End Sub
Public Sub irq6502()

  If (P And &H4) = 0 Then

    Call write6502(&H100& + s, (PC \ &H100&))

    s = (s - 1) And &HFF

    Call write6502(&H100& + s, (PC And &HFF))

    s = (s - 1) And &HFF

    Call write6502(&H100& + s, P)

    s = (s - 1) And &HFF

    P = P Or &H4

    PC = read6502(&HFFFE&) + (read6502(&HFFFF&) * &H100&)

    clockticks6502 = clockticks6502 + 7

  End If

End Sub
Public Sub nmi6502()

  Call write6502(s + &H100&, PC \ &H100&)

  s = (s - 1) And &HFF

  Call write6502(s + &H100&, PC And &HFF)

  s = (s - 1) And &HFF

  Call write6502(s + &H100&, P)

  P = P Or &H4

  s = (s - 1) And &HFF

  PC = read6502(&HFFFA&) + (read6502(&HFFFB&) * &H100&)

  clockticks6502 = clockticks6502 + 7

End Sub
Public Function fixhex(f As String) As String

  If Len(f$) = 1 Then

    fixhex$ = "0" & f$

  Else

    fixhex$ = f$

  End If

End Function
Private Sub preclose()

  If writeptr > 0 Then

    Dim b() As Byte, i As Long

    ReDim b(writeptr - 1)

    For i = 0 To writeptr - 1

      b(i) = writebuffer(i)

    Next i

    Put #2, , b

  End If

End Sub
Public Function readchar() As Byte

  If readptr = 0 Then

    If readsize >= 4096 Then

      Get #1, , readBuffer

    Else

      Dim b() As Byte, i As Long

      ReDim b(readsize - 1)

      Get #1, , b

      For i = 0 To readsize - 1

        readBuffer(i) = b(i)

      Next i

    End If

  End If

  readchar = readBuffer(readptr)

  readptr = (readptr + 1) And 4095

  readsize = readsize - 1

End Function
Private Sub scanrun()

  runchar = nextchar

  runlength = 0

  Do

    runlength = runlength + 1

    nextchar = readchar

  Loop Until nextchar <> runchar Or runlength = 255 Or readsize = 0

End Sub
Public Sub writechar(c As Byte)

  writebuffer(writeptr) = c

  writeptr = (writeptr + 1) And 4095

  If writeptr = 0 Then

    Put #2, , writebuffer

  End If

End Sub
Public Sub writerun()

  Dim i As Long

  For i = 1 To runlength

    Call writechar(runchar)

  Next i

End Sub
Public Sub midiclose()

  If midiOpened Then

    Call midiOutClose(mdh)

    midiOpened = False

  End If

End Sub
Public Sub midiopen()

  On Error Resume Next

  Dim i As Long, s As String

  If midiOutOpen(mdh, 0, 0, 0, 0) Then

    Call MkDir(App.Path & "\temp")

    Kill App.Path & "\temp\pmidi.tmp"

    Open App.Path & "\temp\pmidi.tmp" For Input As #4

    If Err.Number = 0 Then

      Line Input #4, s

      Input #4, i

      Call midiOutClose(i)

      Close #4

    End If

    If midiOutOpen(mdh, 0, 0, 0, 0) Then

      frmNES.Caption = "olafnes - error"

      Exit Sub

    End If

  End If

  Open App.Path & "\temp\pmidi.tmp" For Output As #4

  Close #4

  midiOpened = True

End Sub
Public Sub selectinstrument(ByVal channel As Long, ByVal patch As Long)

  If midiOpened Then

    Call midiOutShortMsg(mdh, &HC0 Or patch * 256 Or channel)

  End If

End Sub
Public Sub toneoff(ByVal channel As Long, ByVal tone As Long)

  If midiOpened Then

    Select Case tone

      Case Is < 0

        tone = 0

      Case Is > 127

        tone = 127

    End Select

    Call midiOutShortMsg(mdh, &H80 Or tone * 256 Or channel)

  End If

End Sub
Public Sub toneon(ByVal channel As Long, ByVal tone As Long, ByVal volume As Long)

  If midiOpened Then

    Select Case tone

      Case Is < 0

        tone = 0

      Case Is > 127

        tone = 127

    End Select

    Call midiOutShortMsg(mdh, &H90 Or tone * 256 Or channel Or volume * 65536)

  End If

End Sub
Public Sub fillarray(a() As Long, ParamArray b() As Variant)

  Dim i

  For i = 0 To UBound(a)

    a(i) = b(i)

  Next i

End Sub
Public Function gettone(ByVal freq) As Long

  Dim t As Long

  If frmNES.mMute.Checked = True Or freq <= 0 Then

    Exit Function

  End If
   
  freq = 111861 / (freq + 1)
    
  t = CLng(Log(freq / 8.176) * 17.31234)
    
  gettone = t

End Function
Public Sub papuinit()

  Call fillarray(vlengths, 5, 127, 10, 1, 19, 2, 40, 3, 80, 4, 30, 5, 7, 6, 13, 7, 6, 8, 12, 9, 24, 10, 48, 11, 96, 12, 36, 13, 8, 14, 16, 15)

  Call selectinstrument(0, 80)

  Call selectinstrument(1, 80)

  Call selectinstrument(2, 74)

  Call selectinstrument(3, 127)

End Sub
Public Sub playnoise(ch)

  Dim f, l, v

  If frmNES.mnuNoise.Checked = False Then

    Exit Sub

  End If

  If SoundCtrl And pow2(ch) Then

    v = 6

    l = vlengths(Sound(ch * 4 + 3) \ 8)

    If v > 0 Then

      f = (Sound(ch * 4 + 2) And 15) * 128

      If f > 1 Then

        If ChannelWrite(ch) Then

          ChannelWrite(ch) = False

          lastFrame(ch) = Frames + l

          Call playtone(ch, gettone(f), v)

        End If

      Else

        Call stoptone(ch)

      End If

    Else

      Call stoptone(ch)

    End If

  Else

    ChannelWrite(ch) = True

    Call stoptone(ch)

  End If

  If Frames >= lastFrame(ch) Then

    Call stoptone(ch)

  End If

End Sub
Public Sub playrect(ch)

  Dim f, l, v

  If frmNES.mnuRectangle.Checked = False Then

    Exit Sub

  End If

  If SoundCtrl And pow2(ch) Then

    v = (Sound(ch * 4 + 0) And 15)

    l = vlengths(Sound(ch * 4 + 3) \ 8)

    If v > 0 Then

      f = Sound(ch * 4 + 2) + (Sound(ch * 4 + 3) And 7) * 256

      If f > 1 Then

        If ChannelWrite(ch) Then

          ChannelWrite(ch) = False

          lastFrame(ch) = Frames + l

          Call playtone(ch, gettone(f), v)

        End If

      Else

        Call stoptone(ch)

      End If

    Else

      Call stoptone(ch)

    End If

  Else

    ChannelWrite(ch) = True

    Call stoptone(ch)

  End If

  If Frames >= lastFrame(ch) Then

    Call stoptone(ch)

  End If

End Sub
Public Sub playtone(channel, tone, v)

  If tone <> tones(channel) Or v < volume(channel) - 3 Or v > volume(channel) Or v = 0 Then

    If tones(channel) <> 0 Then

      toneoff channel, tones(channel)

      tones(channel) = 0

      volume(channel) = 0

    End If

    If doSound And tone > 0 And tone <= 127 And v > 0 Then

      volume(channel) = v

      tones(channel) = tone

      Call toneon(channel, tone, v * 8)

    End If

  End If

End Sub
Public Sub playtriangle(ch)

  Dim f, l, v

  If frmNES.mnuTriangle.Checked = False Then

    Exit Sub

  End If

  If SoundCtrl And pow2(ch) Then

    v = 6

    l = vlengths(Sound(ch * 4 + 3) \ 8)

    If v > 0 Then

      f = Sound(ch * 4 + 2) + (Sound(ch * 4 + 3) And 7) * 256

      If f > 1 Then

        If ChannelWrite(ch) Then

          ChannelWrite(ch) = False

          lastFrame(ch) = Frames + l

          Call playtone(ch, gettone(f), v)

        End If

      Else

        Call stoptone(ch)

      End If

    Else

      Call stoptone(ch)

    End If

  Else

    ChannelWrite(ch) = True

    Call stoptone(ch)

  End If

  If Frames >= lastFrame(ch) Then

    Call stoptone(ch)

  End If

End Sub
Public Sub reallystoptones()

  Dim i

  For i = 0 To 3

    If stopTones(i) <> 0 And stopTones(i) <> tones(i) Then

      toneoff i, stopTones(i)

      stopTones(i) = 0

    End If

  Next i

End Sub
Public Sub stopsound()

  Call stoptone(0)

  Call stoptone(1)

  Call stoptone(2)

  Call stoptone(3)

  Call reallystoptones

End Sub
Public Sub stoptone(channel)

  If tones(channel) <> 0 Then

    stopTones(channel) = tones(channel)

    tones(channel) = 0

    volume(channel) = 0

  End If

End Sub
Public Sub updatesounds()

  If doSound Then

    Call reallystoptones

    Call playrect(0)

    Call playrect(1)

    Call playtriangle(2)

    Call playnoise(3)

  Else

    Call stopsound

  End If

End Sub
Public Sub blit(Buffer(), Pic As PictureBox, imagewidth, imageheight)

  Dim bi As BITMAPINFO

  With bi.bmiHeader

    .biWidth = imagewidth

    .biHeight = -imageheight

    .biSize = 40

    .biBitCount = 32

    .biPlanes = 1

  End With

  Call StretchDIBits(Pic.hdc, 0, 0, Pic.ScaleWidth, Pic.ScaleHeight, 0, 0, imagewidth, imageheight, Buffer(0), bi, 0, vbSrcCopy)

End Sub
Public Sub blit15(Buffer() As Integer, Pic As PictureBox, imagewidth, imageheight)

  Dim bi As BITMAPINFO

  With bi.bmiHeader

    .biWidth = imagewidth

    .biHeight = -imageheight

    .biSize = 40

    .biBitCount = 16

    .biPlanes = 1

  End With

  Call StretchDIBits(Pic.hdc, 0, 0, Pic.ScaleWidth, Pic.ScaleHeight, 0, 0, imagewidth, imageheight, Buffer(0), bi, 0, vbSrcCopy)

End Sub
Public Sub blit16(Buffer() As Integer, Pic As PictureBox, imagewidth, imageheight)

  Dim bi As BITMAPINFO

  With bi.bmiHeader

    .biWidth = imagewidth

    .biHeight = -imageheight

    .biSize = 40

    .biBitCount = 16

    .biPlanes = 1

    .biCompression = 3

  End With

  bi.bmiColor0 = &HF800&

  bi.bmiColor1 = &H7E0&

  bi.bmiColor2 = &H1F&

  Call StretchDIBits(Pic.hdc, 0, 0, Pic.ScaleWidth, Pic.ScaleHeight, 0, 0, imagewidth, imageheight, Buffer(0), bi, 0, vbSrcCopy)

End Sub
Public Function getcolordepth(P As PictureBox)

  Static depth As Long

  If depth = 0 Then

    depth = 16

  End If

  P.PSet (0, 0), &H151515

  Select Case P.Point(0, 0)

    Case &H181418

      depth = 16

    Case &H181818

      depth = 15

    Case &H151515

      depth = 32

  End Select

  getcolordepth = depth

End Function
Public Sub loadstate(Index As Long)

  On Error Resume Next

  Dim f As String

  Call ChDir(App.Path)

  Call MkDir(App.Path & "\states")

  f = App.Path & "\states\" & LCase$(romName) + ".sv" + CStr(Index)

  If Dir$(f) = "" Then

    frmNES.Caption = "olafnes - error"

    Exit Sub

  End If

  Open f For Binary As #1

  Get #1, , a

  Get #1, , X

  Get #1, , Y

  Get #1, , PC

  Get #1, , savepc

  Get #1, , P

  Get #1, , s

  Get #1, , value

  Get #1, , sum

  Get #1, , FirstRead

  Get #1, , Joypad1

  Get #1, , Joypad1_Count

  Get #1, , Joypad2

  Get #1, , Joypad2_Count

  Get #1, , Mirroring

  Get #1, , Mapper

  Get #1, , Trainer

  Get #1, , MirrorXor

  Get #1, , HScroll

  Get #1, , VScroll

  Get #1, , bank_regs

  Get #1, , PPU_Control1

  Get #1, , PPU_Control2

  Get #1, , PPU_Status

  Get #1, , SpriteAddress

  Get #1, , PPUAddressHi

  Get #1, , PPUAddress

  Get #1, , PPU_AddressIsHi

  Get #1, , PatternTable

  Get #1, , NameTable

  Get #1, , reg8

  Get #1, , regA

  Get #1, , regC

  Get #1, , regE

  Get #1, , CurrentLine

  Get #1, , bank0

  Get #1, , bank6

  Get #1, , VRAM

  Get #1, , SpriteRAM

  Select Case Mapper

    Case 1, 121, 69, 142

      Get #1, , Data

      Get #1, , accumulator

      Get #1, , sequence

    Case 4, 45, 74, 5, 72, 76, 88, 95, 118, 119, 232, 245, 248

      Get #1, , MMC3_Command

      Get #1, , MMC3_PrgAddr

      Get #1, , MMC3_ChrAddr

      Get #1, , MMC3_IrqVal

      Get #1, , MMC3_TmpVal

      Get #1, , MMC3_IrqOn

      Get #1, , swap

      Get #1, , PrgSwitch1

      Get #1, , PrgSwitch2

    Case 9, 10, 77

      Get #1, , Latch0FD

      Get #1, , Latch0FE

      Get #1, , Latch1FD

      Get #1, , Latch1FE

    Case 13, 240

      Get #1, , latch13

    Case 15

      Get #1, , Map15_BankAddr

      Get #1, , Map15_SwapReg

    Case 16

      Get #1, , tmpLatch

      Get #1, , MMC16_IrqOn

      Get #1, , MMC16_Irq

    Case 17

      Get #1, , map17_irqon

      Get #1, , map17_irq

    Case 19

      Get #1, , tmpLatch

      Get #1, , MIRQOn

      Get #1, , MMC19_IRQCount

    Case 24, 26

      Get #1, , map24_irqv

      Get #1, , map24_irqon

      Get #1, , map24_irqv

    Case 32

      Get #1, , MMC32_Switch

    Case 40

      Get #1, , Mapper40_IRQEnabled

      Get #1, , Mapper40_IRQCounter

    Case 64

      Get #1, , cmd

      Get #1, , prg

      Get #1, , chr1

    Case 69

      Get #1, , reg8000

  End Select

  Get #1, , nt

  Close #1

  Call setupbanks

End Sub
Public Sub loadrewind(Index As String)

  On Error Resume Next

  Dim f As String

  Call ChDir(App.Path)

  f = App.Path & "\temp\" & LCase$(romName) + ".rw" + CStr(Index)

  If Dir$(f) = "" Then

    frmNES.Caption = "olafnes - error"

    Exit Sub

  End If

  Open f For Binary As #1

  Get #1, , a

  Get #1, , X

  Get #1, , Y

  Get #1, , PC

  Get #1, , savepc

  Get #1, , P

  Get #1, , s

  Get #1, , value

  Get #1, , sum

  Get #1, , FirstRead

  Get #1, , Joypad1

  Get #1, , Joypad1_Count

  Get #1, , Joypad2

  Get #1, , Joypad2_Count

  Get #1, , Mirroring

  Get #1, , Mapper

  Get #1, , Trainer

  Get #1, , MirrorXor

  Get #1, , HScroll

  Get #1, , VScroll

  Get #1, , bank_regs

  Get #1, , PPU_Control1

  Get #1, , PPU_Control2

  Get #1, , PPU_Status

  Get #1, , SpriteAddress

  Get #1, , PPUAddressHi

  Get #1, , PPUAddress

  Get #1, , PPU_AddressIsHi

  Get #1, , PatternTable

  Get #1, , NameTable

  Get #1, , reg8

  Get #1, , regA

  Get #1, , regC

  Get #1, , regE

  Get #1, , CurrentLine

  Get #1, , bank0

  Get #1, , bank6

  Get #1, , VRAM

  Get #1, , SpriteRAM

  Select Case Mapper

    Case 1, 121, 69, 142

      Get #1, , Data

      Get #1, , accumulator

      Get #1, , sequence

    Case 4, 45, 74, 5, 72, 76, 88, 95, 118, 119, 232, 245, 248

      Get #1, , MMC3_Command

      Get #1, , MMC3_PrgAddr

      Get #1, , MMC3_ChrAddr

      Get #1, , MMC3_IrqVal

      Get #1, , MMC3_TmpVal

      Get #1, , MMC3_IrqOn

      Get #1, , swap

      Get #1, , PrgSwitch1

      Get #1, , PrgSwitch2

    Case 9, 10, 77

      Get #1, , Latch0FD

      Get #1, , Latch0FE

      Get #1, , Latch1FD

      Get #1, , Latch1FE

    Case 13, 240

      Get #1, , latch13

    Case 15

      Get #1, , Map15_BankAddr

      Get #1, , Map15_SwapReg

    Case 16

      Get #1, , tmpLatch

      Get #1, , MMC16_IrqOn

      Get #1, , MMC16_Irq

    Case 17

      Get #1, , map17_irqon

      Get #1, , map17_irq

    Case 19

      Get #1, , tmpLatch

      Get #1, , MIRQOn

      Get #1, , MMC19_IRQCount

    Case 24, 26

      Get #1, , map24_irqv

      Get #1, , map24_irqon

      Get #1, , map24_irqv

    Case 32

      Get #1, , MMC32_Switch

    Case 40

      Get #1, , Mapper40_IRQEnabled

      Get #1, , Mapper40_IRQCounter

    Case 64

      Get #1, , cmd

      Get #1, , prg

      Get #1, , chr1

    Case 69

      Get #1, , reg8000

  End Select

  Get #1, , nt

  Close #1

  Call setupbanks

End Sub
Public Sub playmovie(Index As Integer)

  On Error Resume Next

  Dim f As String

  Call ChDir(App.Path)

  Call MkDir(App.Path & "\movies")

  f = App.Path & "\movies\" & LCase$(romName) + ".mv" + CStr(Index)

  Open f For Binary As #1

  Get #1, , a

  Get #1, , X

  Get #1, , Y

  Get #1, , PC

  Get #1, , savepc

  Get #1, , P

  Get #1, , s

  Get #1, , value

  Get #1, , sum

  Get #1, , FirstRead

  Get #1, , Joypad1

  Get #1, , Joypad1_Count

  Get #1, , Joypad2

  Get #1, , Joypad2_Count

  Get #1, , Mirroring

  Get #1, , Mapper

  Get #1, , Trainer

  Get #1, , MirrorXor

  Get #1, , HScroll

  Get #1, , VScroll

  Get #1, , bank_regs

  Get #1, , PPU_Control1

  Get #1, , PPU_Control2

  Get #1, , PPU_Status

  Get #1, , SpriteAddress

  Get #1, , PPUAddressHi

  Get #1, , PPUAddress

  Get #1, , PPU_AddressIsHi

  Get #1, , PatternTable

  Get #1, , NameTable

  Get #1, , reg8

  Get #1, , regA

  Get #1, , regC

  Get #1, , regE

  Get #1, , CurrentLine

  Get #1, , bank0

  Get #1, , bank6

  Get #1, , VRAM

  Get #1, , SpriteRAM

  Select Case Mapper

    Case 1, 121, 69, 142

      Get #1, , Data

      Get #1, , accumulator

      Get #1, , sequence

    Case 4, 45, 5, 74, 72, 76, 88, 95, 118, 119, 232, 245, 248

      Get #1, , MMC3_Command

      Get #1, , MMC3_PrgAddr

      Get #1, , MMC3_ChrAddr

      Get #1, , MMC3_IrqVal

      Get #1, , MMC3_TmpVal

      Get #1, , MMC3_IrqOn

      Get #1, , swap

      Get #1, , PrgSwitch1

      Get #1, , PrgSwitch2

    Case 9, 10, 77

      Get #1, , Latch0FD

      Get #1, , Latch0FE

      Get #1, , Latch1FD

      Get #1, , Latch1FE

    Case 13, 240

      Get #1, , latch13

    Case 15

      Get #1, , Map15_BankAddr

      Get #1, , Map15_SwapReg

    Case 16

      Get #1, , tmpLatch

      Get #1, , MMC16_IrqOn

      Get #1, , MMC16_Irq

    Case 17

      Get #1, , map17_irqon

      Get #1, , map17_irq

    Case 19

      Get #1, , tmpLatch

      Get #1, , MIRQOn

      Get #1, , MMC19_IRQCount

    Case 24, 26

      Get #1, , map24_irqv

      Get #1, , map24_irqon

      Get #1, , map24_irqv

    Case 32

      Get #1, , MMC32_Switch

    Case 40

      Get #1, , Mapper40_IRQEnabled

      Get #1, , Mapper40_IRQCounter

    Case 64

      Get #1, , cmd

      Get #1, , prg

      Get #1, , chr1

  End Select

  Get #1, , nt

  Playing = True

End Sub
Public Sub recordmovie(Index As Long)

  On Error Resume Next

  Dim f As String

  Call ChDir(App.Path)

  Call MkDir(App.Path & "\movies\")

  f = App.Path & "\movies\" & LCase$(romName) + ".mv" + CStr(Index)

  Open f For Binary As #1

  Put #1, , a

  Put #1, , X

  Put #1, , Y

  Put #1, , PC

  Put #1, , savepc

  Put #1, , P

  Put #1, , s

  Put #1, , value

  Put #1, , sum

  Put #1, , FirstRead

  Put #1, , Joypad1

  Put #1, , Joypad1_Count

  Put #1, , Joypad2

  Put #1, , Joypad2_Count

  Put #1, , Mirroring

  Put #1, , Mapper

  Put #1, , Trainer

  Put #1, , MirrorXor

  Put #1, , HScroll

  Put #1, , VScroll

  Put #1, , bank_regs

  Put #1, , PPU_Control1

  Put #1, , PPU_Control2

  Put #1, , PPU_Status

  Put #1, , SpriteAddress

  Put #1, , PPUAddressHi

  Put #1, , PPUAddress

  Put #1, , PPU_AddressIsHi

  Put #1, , PatternTable

  Put #1, , NameTable

  Put #1, , reg8

  Put #1, , regA

  Put #1, , regC

  Put #1, , regE

  Put #1, , CurrentLine

  Put #1, , bank0

  Put #1, , bank6

  Put #1, , VRAM

  Put #1, , SpriteRAM

  Select Case Mapper

    Case 1, 121, 69, 142

      Put #1, , Data

      Put #1, , accumulator

      Put #1, , sequence

    Case 4, 45, 5, 72, 74, 76, 88, 95, 118, 119, 232, 245, 248

      Put #1, , MMC3_Command

      Put #1, , MMC3_PrgAddr

      Put #1, , MMC3_ChrAddr

      Put #1, , MMC3_IrqVal

      Put #1, , MMC3_TmpVal

      Put #1, , MMC3_IrqOn

      Put #1, , swap

      Put #1, , PrgSwitch1

      Put #1, , PrgSwitch2

    Case 9, 10, 77

      Put #1, , Latch0FD

      Put #1, , Latch0FE

      Put #1, , Latch1FD

      Put #1, , Latch1FE

    Case 13, 240

      Put #1, , latch13

    Case 15

      Put #1, , Map15_BankAddr

      Put #1, , Map15_SwapReg

    Case 16

      Put #1, , tmpLatch

      Put #1, , MMC16_IrqOn

      Put #1, , MMC16_Irq

    Case 17

      Put #1, , map17_irqon

      Put #1, , map17_irq

    Case 19

      Put #1, , tmpLatch

      Put #1, , MIRQOn

      Put #1, , MMC19_IRQCount

    Case 24, 26

      Put #1, , map24_irqv

      Put #1, , map24_irqon

      Put #1, , map24_irqv

    Case 32

      Put #1, , MMC32_Switch

    Case 40

      Put #1, , Mapper40_IRQEnabled

      Put #1, , Mapper40_IRQCounter

    Case 64

      Put #1, , cmd

      Put #1, , prg

      Put #1, , chr1

  End Select

  Put #1, , nt

  Record = True

End Sub
Public Sub savestate(Index As Long)

  On Error Resume Next

  Dim f As String

  Call ChDir(App.Path)

  f = App.Path & "\states\" & LCase$(romName) & ".sv" + CStr(Index)

  Open f For Binary As #1

  Put #1, , a

  Put #1, , X

  Put #1, , Y

  Put #1, , PC

  Put #1, , savepc

  Put #1, , P

  Put #1, , s

  Put #1, , value

  Put #1, , sum

  Put #1, , FirstRead

  Put #1, , Joypad1

  Put #1, , Joypad1_Count

  Put #1, , Joypad2

  Put #1, , Joypad2_Count

  Put #1, , Mirroring

  Put #1, , Mapper

  Put #1, , Trainer

  Put #1, , MirrorXor

  Put #1, , HScroll

  Put #1, , VScroll

  Put #1, , bank_regs

  Put #1, , PPU_Control1

  Put #1, , PPU_Control2

  Put #1, , PPU_Status

  Put #1, , SpriteAddress

  Put #1, , PPUAddressHi

  Put #1, , PPUAddress

  Put #1, , PPU_AddressIsHi

  Put #1, , PatternTable

  Put #1, , NameTable

  Put #1, , reg8

  Put #1, , regA

  Put #1, , regC

  Put #1, , regE

  Put #1, , CurrentLine

  Put #1, , bank0

  Put #1, , bank6

  Put #1, , VRAM

  Put #1, , SpriteRAM

  Select Case Mapper

    Case 1, 121, 69, 142

      Put #1, , Data

      Put #1, , accumulator

      Put #1, , sequence

    Case 4, 45, 5, 72, 74, 76, 88, 95, 118, 119, 232, 245, 248

      Put #1, , MMC3_Command

      Put #1, , MMC3_PrgAddr

      Put #1, , MMC3_ChrAddr

      Put #1, , MMC3_IrqVal

      Put #1, , MMC3_TmpVal

      Put #1, , MMC3_IrqOn

      Put #1, , swap

      Put #1, , PrgSwitch1

      Put #1, , PrgSwitch2

    Case 9, 10, 77

      Put #1, , Latch0FD

      Put #1, , Latch0FE

      Put #1, , Latch1FD

      Put #1, , Latch1FE

    Case 13, 240

      Put #1, , latch13

    Case 15

      Put #1, , Map15_BankAddr

      Put #1, , Map15_SwapReg

    Case 16

      Put #1, , tmpLatch

      Put #1, , MMC16_IrqOn

      Put #1, , MMC16_Irq

    Case 17

      Put #1, , map17_irqon

      Put #1, , map17_irq

    Case 19

      Put #1, , tmpLatch

      Put #1, , MIRQOn

      Put #1, , MMC19_IRQCount

    Case 24, 26

      Put #1, , map24_irqv

      Put #1, , map24_irqon

      Put #1, , map24_irqv

    Case 32

      Put #1, , MMC32_Switch

    Case 40

      Put #1, , Mapper40_IRQEnabled

      Put #1, , Mapper40_IRQCounter

    Case 64

      Put #1, , cmd

      Put #1, , prg

      Put #1, , chr1

    Case 69

      Put #1, , reg8000

  End Select

  Put #1, , nt

  Close #1

  frmNES.Caption = "olafnes - state #" & CStr(Index) & " saved"

End Sub
Public Sub saverewind(Index As String)

  On Error Resume Next

  Dim f As String

  Call ChDir(App.Path)

  f = App.Path & "\temp\" & LCase$(romName) & ".rw" + CStr(Index)

  Open f For Binary As #1

  Put #1, , a

  Put #1, , X

  Put #1, , Y

  Put #1, , PC

  Put #1, , savepc

  Put #1, , P

  Put #1, , s

  Put #1, , value

  Put #1, , sum

  Put #1, , FirstRead

  Put #1, , Joypad1

  Put #1, , Joypad1_Count

  Put #1, , Joypad2

  Put #1, , Joypad2_Count

  Put #1, , Mirroring

  Put #1, , Mapper

  Put #1, , Trainer

  Put #1, , MirrorXor

  Put #1, , HScroll

  Put #1, , VScroll

  Put #1, , bank_regs

  Put #1, , PPU_Control1

  Put #1, , PPU_Control2

  Put #1, , PPU_Status

  Put #1, , SpriteAddress

  Put #1, , PPUAddressHi

  Put #1, , PPUAddress

  Put #1, , PPU_AddressIsHi

  Put #1, , PatternTable

  Put #1, , NameTable

  Put #1, , reg8

  Put #1, , regA

  Put #1, , regC

  Put #1, , regE

  Put #1, , CurrentLine

  Put #1, , bank0

  Put #1, , bank6

  Put #1, , VRAM

  Put #1, , SpriteRAM

  Select Case Mapper

    Case 1, 121, 69, 142

      Put #1, , Data

      Put #1, , accumulator

      Put #1, , sequence

    Case 4, 45, 5, 72, 74, 76, 88, 95, 118, 119, 232, 245, 248

      Put #1, , MMC3_Command

      Put #1, , MMC3_PrgAddr

      Put #1, , MMC3_ChrAddr

      Put #1, , MMC3_IrqVal

      Put #1, , MMC3_TmpVal

      Put #1, , MMC3_IrqOn

      Put #1, , swap

      Put #1, , PrgSwitch1

      Put #1, , PrgSwitch2

    Case 9, 10, 77

      Put #1, , Latch0FD

      Put #1, , Latch0FE

      Put #1, , Latch1FD

      Put #1, , Latch1FE

    Case 13, 240

      Put #1, , latch13

    Case 15

      Put #1, , Map15_BankAddr

      Put #1, , Map15_SwapReg

    Case 16

      Put #1, , tmpLatch

      Put #1, , MMC16_IrqOn

      Put #1, , MMC16_Irq

    Case 17

      Put #1, , map17_irqon

      Put #1, , map17_irq

    Case 19

      Put #1, , tmpLatch

      Put #1, , MIRQOn

      Put #1, , MMC19_IRQCount

    Case 24, 26

      Put #1, , map24_irqv

      Put #1, , map24_irqon

      Put #1, , map24_irqv

    Case 32

      Put #1, , MMC32_Switch

    Case 40

      Put #1, , Mapper40_IRQEnabled

      Put #1, , Mapper40_IRQCounter

    Case 64

      Put #1, , cmd

      Put #1, , prg

      Put #1, , chr1

    Case 69

      Put #1, , reg8000

  End Select

  Put #1, , nt

  Close #1

End Sub
Public Sub stopplaying()

  Playing = False

  frmNES.Caption = "olafnes - movie stopped"

  Close #1

End Sub
Public Sub stoprecording()

  Close #1

  frmNES.Caption = "olafnes - movie stopped"

  Record = False

End Sub
Public Sub loadconfig()

  On Error Resume Next

  Dim i

  For i = 0 To 30

    pow2(i) = 2 ^ i

  Next i

  frmNES.BackColor = vbBlack

  Call formcenter(frmNES)

  pow2(31) = -2147483648#

  Call makedirectories

  maxCycles1 = 114

  IdleDetect = True

  SmartExec = False

  NetConnected = False

  tilebased = True

  newScroll = True

  Call menudisable
  
  If fileexists(App.Path & "\lastrom.dat") Then

    Call loadtext(App.Path & "\lastrom.dat", frmNES.txtROMInfo)

  End If

  If readini("options", "winbg") <> "" Then

    frmNES.picScreen.Picture = LoadPicture(CStr(readini("options", "winbg")))

  End If

  If readini("options", "mnusmooth") = Val("") Then

    Smooth2x = 0

    Call frmNES.mSmooth_Click(CInt(Smooth2x))

  End If

  If readini("options", "mnusmooth") = Val("2") Then

    Smooth2x = 2

    Call frmNES.mSmooth_Click(CInt(Smooth2x))

  End If

  If readini("options", "mnusmooth") = Val("1") Then

    Smooth2x = 1

    Call frmNES.mSmooth_Click(CInt(Smooth2x))

  End If

  If readini("options", "mnusmooth") = Val("0") Then

    Smooth2x = 0

    Call frmNES.mSmooth_Click(CInt(Smooth2x))

  End If
  
  If readini("palette", "which") = "" Then

    Call writeini("palette", "which", App.Path & "\olafnes.pal")

  End If

  pally$ = readini("palette", "which")

  If readini("options", "dosound") = "" Then

    doSound = False

    Call writeini("options", "dosound", CBool(doSound))

  End If

  If readini("options", "frameskip") = "" Then

    FrameSkip = 1

    frmNES.mnufs(0).Checked = True

    Call writeini("options", "frameskip", CByte(FrameSkip))

  End If

  If readini("options", "autospeed") = "" Then

    autospeed = True

    Call writeini("options", "autospeed", True)

  End If

  If readini("options", "mmutechecked") = "" Then

    frmNES.mMute.Checked = True

    Call writeini("options", "mmutechecked", CBool(frmNES.mMute.Checked))

  End If

  If readini("options", "mmotionblurchecked") = "" Then

    frmNES.mMotionBlur.Checked = False

    Call writeini("options", "mmotionblurchecked", CBool(frmNES.mMotionBlur.Checked))

  End If

  If readini("options", "mnuscale2x") = "" Then

    frmNES.mnuscale2x.Checked = False

    Call writeini("options", "mnuscale2x", CBool(frmNES.mnuscale2x.Checked))

  End If

  If readini("options", "mnu50scan") = "" Then

    frmNES.mnu50scan.Checked = False

    Call writeini("options", "mnu50scan", CBool(frmNES.mnu50scan.Checked))

  End If

  If readini("options", "mnu50horizon") = "" Then

    frmNES.mnu50horizon.Checked = False

    Call writeini("options", "mnu50horizon", CBool(frmNES.mnu50horizon.Checked))

  End If

  If readini("options", "mnutrianglechecked") = "" Then

    frmNES.mnuTriangle.Checked = True

    Call writeini("options", "mnutrianglechecked", CBool(frmNES.mnuTriangle.Checked))

  End If

  If readini("options", "mnurectanglechecked") = "" Then

    frmNES.mnuRectangle.Checked = True

    Call writeini("options", "mnurectanglechecked", CBool(frmNES.mnuRectangle.Checked))

  End If

  If readini("options", "mnunoisechecked") = "" Then

    frmNES.mnuNoise.Checked = True

    Call writeini("options", "mnunoisechecked", CBool(frmNES.mnuNoise.Checked))

  End If

  If readini("options", "joyb") = "" Then

    JOY_B = 1

    Call writeini("options", "joyb", CInt(JOY_B))

  End If

  If readini("options", "joya") = "" Then

    JOY_A = 2

    Call writeini("options", "joya", CInt(JOY_A))

  End If

  If readini("options", "joysel") = "" Then

    JOY_SEL = 3

    Call writeini("options", "joysel", CInt(JOY_SEL))

  End If

  If readini("options", "joysta") = "" Then

    JOY_STA = 4

    Call writeini("options", "joysta", CInt(JOY_STA))

  End If

  If readini("options", "joywhich") = "" Then

    JOY_WHICH = 1

    Call writeini("options", "joywhich", CInt(JOY_WHICH))

  End If

  If readini("joypad1", "up") = "" Then

    nes_ButUp = vbKeyUp

    Call writeini("joypad1", "up", Val(nes_ButUp))

  End If

  If readini("joypad1", "down") = "" Then

    nes_ButDn = vbKeyDown

    Call writeini("joypad1", "down", Val(nes_ButDn))

  End If

  If readini("joypad1", "left") = "" Then

    nes_ButLt = vbKeyLeft

    Call writeini("joypad1", "left", Val(nes_ButLt))

  End If

  If readini("joypad1", "right") = "" Then

    nes_ButRt = vbKeyRight

    Call writeini("joypad1", "right", Val(nes_ButRt))

  End If

  If readini("joypad1", "b") = "" Then

    nes_ButB = CByte(vbKeyZ)

    Call writeini("joypad1", "b", Val(nes_ButB))

  End If

  If readini("joypad1", "a") = "" Then

    nes_ButA = CByte(vbKeyX)

    Call writeini("joypad1", "a", Val(nes_ButA))

  End If

  If readini("joypad1", "select") = "" Then

    nes_ButSel = CByte(vbKeyC)

    Call writeini("joypad1", "select", Val(nes_ButSel))

  End If

  If readini("joypad1", "start") = "" Then

    nes_ButSta = CByte(vbKeyV)

    Call writeini("joypad1", "start", Val(nes_ButSta))

  End If

  If readini("joypad2", "up") = "" Then

    nes2_ButUp = CByte(0)

    Call writeini("joypad2", "up", Val(nes2_ButUp))

  End If

  If readini("joypad2", "down") = "" Then

    nes2_ButDn = CByte(0)

    Call writeini("joypad2", "down", Val(nes2_ButDn))

  End If

  If readini("joypad2", "left") = "" Then

    nes2_ButLt = CByte(0)

    Call writeini("joypad2", "left", Val(nes2_ButLt))

  End If

  If readini("joypad2", "right") = "" Then

    nes2_ButRt = CByte(0)

    Call writeini("joypad2", "right", Val(nes2_ButRt))

  End If

  If readini("joypad2", "b") = "" Then

    nes2_ButB = CByte(0)

    Call writeini("joypad2", "b", Val(nes2_ButB))

  End If

  If readini("joypad2", "a") = "" Then

    nes2_ButA = CByte(0)

    Call writeini("joypad2", "a", Val(nes2_ButA))

  End If

  If readini("joypad2", "select") = "" Then

    nes2_ButSel = CByte(0)

    Call writeini("joypad2", "select", Val(nes2_ButSel))

  End If

  If readini("joypad2", "start") = "" Then

    nes2_ButSta = CByte(0)

    Call writeini("joypad2", "start", Val(nes2_ButSta))

  End If

  If readini("options", "mnuontop") = "" Then

    frmNES.mnuOnTop.Checked = False

    Call writeini("options", "mnuontop", CBool(frmNES.mnuOnTop.Checked))

  End If

  If readini("options", "left") = "" Then

    Call writeini("options", "left", Val(frmNES.Left))

  End If

  If readini("options", "top") = "" Then

    Call writeini("options", "top", Val(frmNES.Top))

  End If

  If readini("options", "height") = "" Then

    Call writeini("options", "height", Val(frmNES.Height))

  End If

  If readini("options", "width") = "" Then

    Call writeini("options", "width", Val(frmNES.Width))

  End If

  If readini("options", "invert") = "" Then

    Call writeini("options", "invert", CBool(frmNES.mnuinvert.Checked))

  End If

  If readini("options", "disablesprites") = "" Then

    frmNES.disablesprites.Checked = False

    Call writeini("options", "disablesprites", CBool(frmNES.disablesprites.Checked))

  End If

  If readini("options", "mnuvideo") = "" Then

    frmNES.mnuvideo.Checked = False

    Call writeini("options", "mnuvideo", CBool(frmNES.mnuvideo.Checked))

  End If

  If readini("options", "usegp") = "" Then

    frmNES.mnuUseGamepad.Checked = False

    Call writeini("options", "usegp", CBool(frmNES.mnuUseGamepad.Checked))

  End If
 
  If readini("options", "mnuontop") = CBool(True) Then

    frmNES.mnuOnTop.Checked = True

    Call formontop(frmNES)

  End If

  If readini("options", "mnuontop") = CBool(False) Then

    frmNES.mnuOnTop.Checked = False

  End If

  frmNES.mMute.Checked = CBool(readini("options", "mmutechecked"))

  frmNES.mMotionBlur.Checked = CBool(readini("options", "mmotionblurchecked"))

  MotionBlur = CBool(readini("options", "mmotionblurchecked"))

  frmNES.mnuTriangle.Checked = CBool(readini("options", "mnutrianglechecked"))

  frmNES.mnuRectangle.Checked = CBool(readini("options", "mnurectanglechecked"))

  frmNES.mnuNoise.Checked = CBool(readini("options", "mnunoisechecked"))

  frmNES.mnuinvert.Checked = CBool(readini("options", "invert"))

  frmNES.disablesprites.Checked = CBool(readini("options", "disablesprites"))

  frmNES.mnuvideo.Checked = CBool(readini("options", "mnuvideo"))

  frmNES.mnuscale2x.Checked = CBool(readini("options", "mnuscale2x"))

  frmNES.mnu50scan.Checked = CBool(readini("options", "mnu50scan"))

  frmNES.mnu50horizon.Checked = CBool(readini("options", "mnu50horizon"))

  If frmNES.mnuscale2x.Checked = True Then

    Call frmNES.mnuscale2x_Click

  End If

  If frmNES.mnu50scan.Checked = True Then

    Call frmNES.mnu50scan_Click

  End If

  If frmNES.mnu50horizon.Checked = True Then

    Call frmNES.mnu50horizon_Click

  End If

  frmNES.Left = Val(readini("options", "left"))

  frmNES.Top = Val(readini("options", "top"))

  frmNES.Height = Val(readini("options", "height"))

  frmNES.Width = Val(readini("options", "width"))

  autospeed = CBool(readini("options", "autospeed"))

  If autospeed = True Then

    frmNES.fpslimit.Checked = True

  End If

  doSound = CBool(readini("options", "dosound"))

  frmNES.mnurewind.Checked = CBool(readini("options", "mnurewind"))

  frmNES.disablebg.Checked = CBool(readini("options", "disablebg"))

  FrameSkip = CByte(readini("options", "frameskip"))

  frmNES.mnufs(CByte(FrameSkip) - 1).Checked = True

  JOY_B = CInt(readini("options", "joyb"))

  JOY_A = CInt(readini("options", "joya"))

  JOY_SEL = CInt(readini("options", "joysel"))

  JOY_STA = CInt(readini("options", "joysta"))

  JOY_WHICH = CInt(readini("options", "joywhich"))

  nes_ButUp = CByte(readini("joypad1", "up"))

  nes_ButDn = CByte(readini("joypad1", "down"))

  nes_ButLt = CByte(readini("joypad1", "left"))

  nes_ButRt = CByte(readini("joypad1", "right"))

  nes_ButB = CByte(readini("joypad1", "b"))

  nes_ButA = CByte(readini("joypad1", "a"))

  nes_ButSel = CByte(readini("joypad1", "select"))

  nes_ButSta = CByte(readini("joypad1", "start"))

  nes2_ButUp = CByte(readini("joypad2", "up"))

  nes2_ButDn = CByte(readini("joypad2", "down"))

  nes2_ButLt = CByte(readini("joypad2", "left"))

  nes2_ButRt = CByte(readini("joypad2", "right"))

  nes2_ButB = CByte(readini("joypad2", "b"))

  nes2_ButA = CByte(readini("joypad2", "a"))

  nes2_ButSel = CByte(readini("joypad2", "select"))

  nes2_ButSta = CByte(readini("joypad2", "start"))

  frmNES.mnuUseGamepad.Checked = CBool(readini("options", "usegp"))

  frmNES.mnu1second.Enabled = False

  frmNES.mnu2seconds.Enabled = False

  frmNES.mnu3seconds.Enabled = False

  frmNES.mnu4seconds.Enabled = False

  frmNES.mnu5seconds.Enabled = False

  frmNES.mnu6seconds.Enabled = False

  frmNES.mnu7seconds.Enabled = False

  frmNES.mnu8seconds.Enabled = False

  frmNES.mnu9seconds.Enabled = False

  frmNES.mnu10seconds.Enabled = False

  Call frmNES.mnu0_Click(Val(0))

  Call frmNES.mSaveSlots_Click(Val(0))

  Call frmNES.sramslot_Click(Val(0))

  Call midiopen

  Call papuinit

  Call filltlook

  frmNES.Caption = "olafnes"

End Sub
Public Sub formnotontop(FormName As Form)

  Call SetWindowPos(FormName.hwnd, HWND_NOTOPMOST, 0&, 0&, 0&, 0&, FLAGS)

End Sub
Public Function fileexists(sFileName As String) As Boolean

  If Len(sFileName$) = 0 Then

    fileexists = False

    Exit Function

  End If

  If Len(Dir$(sFileName$)) Then

    fileexists = True

  Else

    fileexists = False

  End If

End Function
Public Sub formcenter(a As Form)

  a.Left = Screen.Width / 2 - a.Width / 2

  a.Top = Screen.Height / 2 - a.Height / 2

End Sub
Public Sub formontop(FormName As Form)

  Call SetWindowPos(FormName.hwnd, HWND_TOPMOST, 0&, 0&, 0&, 0&, FLAGS)

End Sub
Public Sub writeini(Section As String, Key As String, KeyValue As String)

  On Error Resume Next

  Dim Directory As String

  Directory$ = App.Path & "\config.dat"

  Call WritePrivateProfileString(Section$, Key$, KeyValue$, Directory$)

End Sub
Public Function readini(Section As String, Key As String) As String

  Dim strBuffer As String, Directory As String

  strBuffer = String(750, Chr(0))

  Directory$ = App.Path & "\config.dat"

  readini$ = Left(strBuffer, GetPrivateProfileString(Section$, ByVal Key$, "", strBuffer, Len(strBuffer), Directory$))

End Function
Public Sub displayresize(r As Integer)

  ResizeYet = False

  frmNES.picScreen.Top = 0

  frmNES.picScreen.Left = 0

  frmNES.picScreen.Width = (256 * r) * 15

  frmNES.picScreen.Height = (240 * r) * 15

  frmNES.Width = 0

  frmNES.Height = 0

  Do

    DoEvents

    frmNES.Width = frmNES.Width + 1

  Loop Until frmNES.ScaleWidth = frmNES.picScreen.Width

  Do

    DoEvents

    frmNES.Height = frmNES.Height + 1

  Loop Until frmNES.ScaleHeight = frmNES.picScreen.Height

  ResizeYet = True

End Sub
Public Sub filltlook()

  Dim b1, b2, c, X

  For b1 = 0 To 255

    For b2 = 0 To 255

      For X = 0 To 7

        If b1 And pow2(X) Then

          c = 1

        Else

          c = 0

        End If

        If b2 And pow2(X) Then

          c = c + 2

        End If

        tLook(b1 * 2048 + b2 * 8 + X) = c

      Next X

    Next b2

  Next b1

End Sub
Public Sub blitscreen()

  On Error Resume Next
  
  Dim p01 As Integer, p10 As Integer, p21 As Integer, p12 As Integer, p01b As Long, p10b As Long, p21b As Long, p12b As Long, X, Y, k, b, c, fscan As Boolean, t As Long, i As Long, xcount

  Static mbt As Boolean, n As Long, count64 As Long, p16(31) As Integer, p32(31) As Long, colorDepth

  mbt = Not mbt

  n = 1 - n

  count64 = (count64 + 17) And 63

  If colorDepth = 0 Or (Frames And 63) = 0 Then

    colorDepth = getcolordepth(frmNES.picScreen)

  End If

  Select Case colorDepth

    Case 8

    Case 16

      If MotionBlur Then

        For i = 0 To 31

          p16(i) = (pal16(VRAM(i + &H3F00)) And &HF7DE&) \ 2

        Next i

        If mbt Then

          For i = 0 To 61439

            vBuffer16(i) = (vBuffer16(i) And &HF7DE&) \ 2 + p16(vBuffer(i)) + &H20

          Next i

        Else

          For i = 0 To 61439

            vBuffer16(i) = (vBuffer16(i) And &HF7DE&) \ 2 + p16(vBuffer(i)) + &H801

          Next i

        End If

      Else

        For i = 0 To 31

          p16(i) = pal16(VRAM(i + &H3F00))

        Next i

        If frmNES.mnu50scan.Checked = False And frmNES.mnu50horizon.Checked = False Then

          For i = 0 To 61439 Step 4

            vBuffer16(i) = p16(vBuffer(i))

            vBuffer16(i + 1) = p16(vBuffer(i + 1))

            vBuffer16(i + 2) = p16(vBuffer(i + 2))

            vBuffer16(i + 3) = p16(vBuffer(i + 3))

          Next i

        ElseIf frmNES.mnu50scan.Checked = True Then

          For i = 0 To 61439 Step 2

            vBuffer16(i) = p16(vBuffer(i))

            vBuffer16(i + 1) = vbBlack

          Next i

        ElseIf frmNES.mnu50horizon.Checked = True Then

          xcount = 0

          For i = 0 To 61439 Step 1

            If xcount < 254 Then

              vBuffer16(i) = p16(vBuffer(i))

            Else

              vBuffer16(i) = vbBlack

              If xcount = 255 * 2 Then

                xcount = -2

              End If

            End If

            xcount = xcount + 1

          Next i

        End If

      End If

      If frmNES.mnuscale2x.Checked = True Then

        i = 0

        For Y = 0 To 239 + 1

          For X = 0 To 255 + 1

              If vBuffer16((i - 256)) <> vBuffer16((i + 256)) And vBuffer16((i - 1)) <> vBuffer16((i + 1)) Then

                If vBuffer16((i - 1)) = vBuffer16((i - 256)) Then

                  vBuffer2x16(i * 2) = vBuffer16((i - 1))

                Else

                  vBuffer2x16(i * 2) = vBuffer16((i))

                End If

                If vBuffer16((i - 256)) = vBuffer16((i + 1)) Then

                  vBuffer2x16(i * 2 + 1) = vBuffer16((i + 1))

                Else

                  vBuffer2x16(i * 2 + 1) = vBuffer16((i))

                End If

                If vBuffer16((i - 1)) = vBuffer16((i + 256)) Then

                  vBuffer2x16(i * 2 + 255) = vBuffer16((i - 1))

                Else

                  vBuffer2x16(i * 2 + 255) = vBuffer16((i))

                End If

                If vBuffer16((i + 256)) = vBuffer16((i + 1)) Then

                  vBuffer2x16(i * 2 + 256) = vBuffer16((i + 1))

                Else

                  vBuffer2x16(i * 2 + 256) = vBuffer16((i))

                End If

              Else

                vBuffer2x16(i * 2) = vBuffer16((i))

                vBuffer2x16(i * 2 + 1) = vBuffer16((i))

                vBuffer2x16(i * 2 + 255) = vBuffer16((i))

                vBuffer2x16(i * 2 + 256) = vBuffer16((i))

              End If

            i = i + 1

           Next X

        Next Y

      End If

      If Smooth2x Then

        If Smooth2x = 1 Then

          For Y = 0 To 239

            i = Y * 256&

            k = Y * 1024&

            c = 0

            For X = 0 To 255

              b = vBuffer16(i)

              vBuffer2x16(k + 1) = b

              b = (b And &HF7DE&) \ 2

              vBuffer2x16(k) = b + c

              c = b

              i = i + 1

              k = k + 2

            Next X

          Next Y

          For Y = 0 To 238

            k = Y * 1024 + 512

            For X = 0 To 511

              vBuffer2x16(k) = (vBuffer2x16(k - 512) And &HF7DE&) \ 2 + (vBuffer2x16(k + 512) And &HF7DE&) \ 2

              k = k + 1

            Next X

          Next Y

        Else

          For Y = 1 To 238

            i = Y * 256&

            k = Y * 1024&

            c = vBuffer16(i - 1)

            p21 = vBuffer16(i)

            fscan = (Y And 63) = count64

            For X = IIf(X > 1, 0, 1) To 255

              b = vBuffer16(i + 1)

              If b <> oldvBuffer16(i + 1) Then

                If t <= 0 Then

                  c = vBuffer16(i - 1)

                  p21 = vBuffer16(i)

                End If

                t = 3

              End If

              If t > 0 Or fscan Then

                t = t - 1

                p01 = c

                c = p21

                p21 = b

                b = (c And &HF7DE&) \ 2

                p10 = vBuffer16(i - 256)

                p12 = vBuffer16(i + 256)

                If p01 = p10 And p12 = p21 Then

                  If p10 = p12 And vBuffer16(i - 257) = c Then

                    vBuffer2x16(k) = c

                    vBuffer2x16(k + 1) = (p10 And &HF7DE&) \ 2 + b

                    vBuffer2x16(k + 512) = (p12 And &HF7DE&) \ 2 + b

                    vBuffer2x16(k + 513) = c

                  Else

                    vBuffer2x16(k) = (p01 And &HF7DE&) \ 2 + b

                    vBuffer2x16(k + 1) = c

                    vBuffer2x16(k + 512) = c

                    vBuffer2x16(k + 513) = (p21 And &HF7DE&) \ 2 + b

                  End If

                ElseIf p10 = p21 And p01 = p12 Then

                  vBuffer2x16(k) = c

                  vBuffer2x16(k + 1) = (p10 And &HF7DE&) \ 2 + b

                  vBuffer2x16(k + 512) = (p12 And &HF7DE&) \ 2 + b

                  vBuffer2x16(k + 513) = c

                Else

                  vBuffer2x16(k) = c

                  vBuffer2x16(k + 1) = c

                  vBuffer2x16(k + 512) = c

                  vBuffer2x16(k + 513) = c

                End If

              End If

              i = i + 1

              k = k + 2

            Next X

          Next Y

          Call MemCopy(oldvBuffer16(0), vBuffer16(0), 122880)

        End If

        Call blit16(vBuffer2x16, frmNES.picScreen, 512, 480)

      Else

        If frmNES.mnuscale2x.Checked = False Then

          Call blit16(vBuffer16, frmNES.picScreen, 256, 240)

        Else

          Call blit16(vBuffer2x16, frmNES.picScreen, 512, 240)

        End If

      End If

    Case 15

      If MotionBlur Then

        For i = 0 To 31

          p16(i) = (pal15(VRAM(i + &H3F00)) And &H7BDE&) \ 2

        Next i

        If mbt Then

          For i = 0 To 61439

            vBuffer16(i) = (vBuffer16(i) And &H7BDE&) \ 2 + p16(vBuffer(i)) + &H20

          Next i

        Else

          For i = 0 To 61439

            vBuffer16(i) = (vBuffer16(i) And &H7BDE&) \ 2 + p16(vBuffer(i)) + &H401

          Next i

        End If

      Else

        For i = 0 To 31

          p16(i) = pal15(VRAM(i + &H3F00))

        Next i

        If frmNES.mnu50scan.Checked = False And frmNES.mnu50horizon.Checked = False Then

          For i = 0 To 61439 Step 4

            vBuffer16(i) = p16(vBuffer(i))

            vBuffer16(i + 1) = p16(vBuffer(i + 1))

            vBuffer16(i + 2) = p16(vBuffer(i + 2))

            vBuffer16(i + 3) = p16(vBuffer(i + 3))

          Next i

        ElseIf frmNES.mnu50scan.Checked = True Then

          For i = 0 To 61439 Step 2

            vBuffer16(i) = p16(vBuffer(i))

            vBuffer16(i + 1) = vbBlack

          Next i

        ElseIf frmNES.mnu50horizon.Checked = True Then

          xcount = 0

          For i = 0 To 61439 Step 1

            If xcount < 254 Then

              vBuffer16(i) = p16(vBuffer(i))

            Else

              vBuffer16(i) = vbBlack

              If xcount = 255 * 2 Then

                xcount = -2

              End If

            End If

            xcount = xcount + 1

          Next i

        End If

      End If

      If frmNES.mnuscale2x.Checked = True Then

        i = 0

        For Y = 0 To 239 + 1

          For X = 0 To 255 + 1

              If vBuffer16((i - 256)) <> vBuffer16((i + 256)) And vBuffer16((i - 1)) <> vBuffer16((i + 1)) Then

                If vBuffer16((i - 1)) = vBuffer16((i - 256)) Then

                  vBuffer2x16(i * 2) = vBuffer16((i - 1))

                Else

                  vBuffer2x16(i * 2) = vBuffer16((i))

                End If

                If vBuffer16((i - 256)) = vBuffer16((i + 1)) Then

                  vBuffer2x16(i * 2 + 1) = vBuffer16((i + 1))

                Else

                  vBuffer2x16(i * 2 + 1) = vBuffer16((i))

                End If

                If vBuffer16((i - 1)) = vBuffer16((i + 256)) Then

                  vBuffer2x16(i * 2 + 255) = vBuffer16((i - 1))

                Else

                  vBuffer2x16(i * 2 + 255) = vBuffer16((i))

                End If

                If vBuffer16((i + 256)) = vBuffer16((i + 1)) Then

                  vBuffer2x16(i * 2 + 256) = vBuffer16((i + 1))

                Else

                  vBuffer2x16(i * 2 + 256) = vBuffer16((i))

                End If

              Else

                vBuffer2x16(i * 2) = vBuffer16((i))

                vBuffer2x16(i * 2 + 1) = vBuffer16((i))

                vBuffer2x16(i * 2 + 255) = vBuffer16((i))

                vBuffer2x16(i * 2 + 256) = vBuffer16((i))

              End If

            i = i + 1

           Next X

        Next Y

      End If

      If Smooth2x Then

        If Smooth2x = 1 Then

          For Y = 0 To 239

            i = Y * 256&

            k = Y * 1024&

            c = 0

            For X = 0 To 255

              b = vBuffer16(i)

              vBuffer2x16(k + 1) = b

              b = (b And &H7BDE&) \ 2

              vBuffer2x16(k) = b + c

              c = b

              i = i + 1

              k = k + 2

            Next X

          Next Y

          For Y = 0 To 238

            k = Y * 1024 + 512

            For X = 0 To 511

              vBuffer2x16(k) = (vBuffer2x16(k - 512) And &H7BDE&) \ 2 + (vBuffer2x16(k + 512) And &H7BDE&) \ 2

              k = k + 1

            Next X

          Next Y

        Else

          For Y = 1 To 238

            i = Y * 256&

            k = Y * 1024&

            c = vBuffer16(i - 1)

            p21 = vBuffer16(i)

            fscan = (Y And 63) = count64

            For X = IIf(X > 1, 0, 1) To 255

              If vBuffer16(i + 2) <> oldvBuffer16(i + 2) Then

                If t <= 0 Then

                  c = vBuffer16(i - 1)

                  p21 = vBuffer16(i)

                End If

                t = 5

              End If

              If t > 0 Or fscan Then

                t = t - 1

                p01 = c

                c = p21

                p21 = vBuffer16(i + 1)

                b = (c And &H7BDE&) \ 2

                p10 = vBuffer16(i - 256)

                p12 = vBuffer16(i + 256)

                If p01 = p10 And p12 = p21 Then

                  If p10 = p12 And vBuffer16(i - 257) = c Then

                    vBuffer2x16(k) = c

                    vBuffer2x16(k + 1) = (p10 And &H7BDE&) \ 2 + b

                    vBuffer2x16(k + 512) = (p12 And &H7BDE&) \ 2 + b

                    vBuffer2x16(k + 513) = c

                  Else

                    vBuffer2x16(k) = (p01 And &H7BDE&) \ 2 + b

                    vBuffer2x16(k + 1) = c

                    vBuffer2x16(k + 512) = c

                    vBuffer2x16(k + 513) = (p21 And &H7BDE&) \ 2 + b

                  End If

                ElseIf p10 = p21 And p01 = p12 Then

                  vBuffer2x16(k) = c

                  vBuffer2x16(k + 1) = (p10 And &H7BDE&) \ 2 + b

                  vBuffer2x16(k + 512) = (p12 And &H7BDE&) \ 2 + b

                  vBuffer2x16(k + 513) = c

                Else

                  vBuffer2x16(k) = c

                  vBuffer2x16(k + 1) = c

                  vBuffer2x16(k + 512) = c

                  vBuffer2x16(k + 513) = c

                End If

              End If

              i = i + 1

              k = k + 2

            Next X

          Next Y

          Call MemCopy(oldvBuffer16(0), vBuffer16(0), 122880)

        End If

        Call blit15(vBuffer2x16, frmNES.picScreen, 512, 480)

      Else

        If frmNES.mnuscale2x.Checked = False Then

          Call blit15(vBuffer16, frmNES.picScreen, 256, 240)

        Else

          Call blit15(vBuffer2x16, frmNES.picScreen, 512, 240)

        End If

      End If

    Case Else

      If MotionBlur Then

        For i = 0 To 31

          p32(i) = (pal(VRAM(i + &H3F00)) And &HFEFEFE) \ 2

        Next i

        For i = 0 To 61439

          vBuffer32(i) = (vBuffer32(i) And &HFEFEFE) \ 2 + p32(vBuffer(i))

        Next i

      Else

        For i = 0 To 31

          p32(i) = pal(VRAM(i + &H3F00))

        Next i

        If frmNES.mnu50scan.Checked = False And frmNES.mnu50horizon.Checked = False Then

          For i = 0 To 61439 Step 4

            vBuffer32(i) = p32(vBuffer(i))

            vBuffer32(i + 1) = p32(vBuffer(i + 1))

            vBuffer32(i + 2) = p32(vBuffer(i + 2))

            vBuffer32(i + 3) = p32(vBuffer(i + 3))

          Next i

        ElseIf frmNES.mnu50scan.Checked = True Then

          For i = 0 To 61439 Step 2

            vBuffer32(i) = p32(vBuffer(i))

            vBuffer32(i + 1) = vbBlack

          Next i

        ElseIf frmNES.mnu50horizon.Checked = True Then

          xcount = 0

          For i = 0 To 61439 Step 1

            If xcount < 254 Then

              vBuffer32(i) = p32(vBuffer(i))

            Else

              vBuffer32(i) = vbBlack

              If xcount = 255 * 2 Then

                xcount = -2

              End If

            End If

            xcount = xcount + 1

          Next i

        End If

      End If

      If frmNES.mnuscale2x.Checked = True Then

        i = 0

        For Y = 0 To 239 + 1

          For X = 0 To 255 + 1

            If vBuffer32((i - 256)) <> vBuffer32((i + 256)) And vBuffer32((i - 1)) <> vBuffer32((i + 1)) Then

              If vBuffer32((i - 1)) = vBuffer32((i - 256)) Then

                vBuffer2x32(i * 2) = vBuffer32((i - 1))

              Else

                vBuffer2x32(i * 2) = vBuffer32((i))

              End If

              If vBuffer32((i - 256)) = vBuffer32((i + 1)) Then

                vBuffer2x32(i * 2 + 1) = vBuffer32((i + 1))

              Else

                vBuffer2x32(i * 2 + 1) = vBuffer32((i))

              End If

              If vBuffer32((i - 1)) = vBuffer32((i + 256)) Then

                vBuffer2x32(i * 2 + 255) = vBuffer32((i - 1))

              Else

                vBuffer2x32(i * 2 + 255) = vBuffer32((i))

              End If

              If vBuffer32((i + 256)) = vBuffer32((i + 1)) Then

                vBuffer2x32(i * 2 + 256) = vBuffer32((i + 1))

              Else

                vBuffer2x32(i * 2 + 256) = vBuffer32((i))

              End If

            Else

              vBuffer2x32(i * 2) = vBuffer32((i))

              vBuffer2x32(i * 2 + 1) = vBuffer32((i))

              vBuffer2x32(i * 2 + 255) = vBuffer32((i))

              vBuffer2x32(i * 2 + 256) = vBuffer32((i))

            End If

            i = i + 1

          Next X

        Next Y

      End If

      If Smooth2x Then

        If Smooth2x = 1 Then

          For Y = 0 To 239

            i = Y * 256&

            k = Y * 1024&

            c = 0

            For X = 0 To 255

              b = vBuffer32(i)

              vBuffer2x32(k + 1) = b

              b = (b And &HFEFEFE) \ 2

              vBuffer2x32(k) = b + c

              c = b

              i = i + 1

              k = k + 2

            Next X

          Next Y

          For Y = 0 To 238

            k = Y * 1024 + 512

            For X = 0 To 511

              vBuffer2x32(k) = (vBuffer2x32(k - 512) And &HFEFEFE) \ 2 + (vBuffer2x32(k + 512) And &HFEFEFE) \ 2

              k = k + 1

            Next X

          Next Y

        Else

          t = n

          For Y = 1 To 238

            i = Y * 256&

            k = Y * 1024&

            c = vBuffer32(i - 1)

            p21b = vBuffer32(i)

            t = 1 - t

            For X = IIf(X > 1, 0, 1) To 255

              t = 1 - t

              p01b = c

              c = p21b

              p21b = vBuffer32(i + 1)

              If t Or c <> vBuffer2x32(k) Then

                b = (c And &HFEFEFE) \ 2

                p10b = vBuffer32(i - 256)

                p12b = vBuffer32(i + 256)

                If p01b = p10b And p12b = p21b Then

                  If p10b = p12b And vBuffer32(i - 257) = c Then

                    vBuffer2x32(k) = c

                    vBuffer2x32(k + 1) = (p10b And &HFEFEFE) \ 2 + b

                    vBuffer2x32(k + 512) = (p12b And &HFEFEFE) \ 2 + b

                    vBuffer2x32(k + 513) = c

                  Else

                    vBuffer2x32(k) = (p01b And &HFEFEFE) \ 2 + b

                    vBuffer2x32(k + 1) = c

                    vBuffer2x32(k + 512) = c

                    vBuffer2x32(k + 513) = (p21b And &HFEFEFE) \ 2 + b

                  End If

                ElseIf p10b = p21b And p01b = p12b Then

                  vBuffer2x32(k) = c

                  vBuffer2x32(k + 1) = (p10b And &HFEFEFE) \ 2 + b

                  vBuffer2x32(k + 512) = (p12b And &HFEFEFE) \ 2 + b

                  vBuffer2x32(k + 513) = c

                Else

                  vBuffer2x32(k) = c

                  vBuffer2x32(k + 1) = c

                  vBuffer2x32(k + 512) = c

                  vBuffer2x32(k + 513) = c

                End If

              End If

              i = i + 1

              k = k + 2

            Next X

          Next Y

        End If

        Call blit(vBuffer2x32, frmNES.picScreen, 512, 480)

      Else

        If frmNES.mnuscale2x.Checked = False Then

          Call blit(vBuffer32, frmNES.picScreen, 256, 240)

        Else

          Call blit(vBuffer2x32, frmNES.picScreen, 512, 240)

        End If

      End If

  End Select

End Sub
Public Sub renderscanline(ByVal Scanline As Long)

  On Error GoTo 14

  Dim TileRow As Byte, TileYOffset As Long, TileCounter As Long, Color As Long, TileIndex As Byte, Byte1 As Byte, Byte2 As Byte, LookUp As Byte, addToCol As Long, pixel As Long, X As Long, aa As Long, m As Long, sc As Long, atrtab As Long, Y As Long, v As Long, nt2 As Byte, h As Long

  Static phs As Long, pvs As Long

  If frmNES.mnuvideo.Checked = True Then

    Exit Sub

  End If

  Call domirror

  If Scanline > 239 Then

    Exit Sub

  ElseIf Scanline = 0 Then

    If render Then

      Call MemFill(vBuffer(0), 256& * 240&, 16)

    End If

    Static pm, pmx

    If MirrorXor <> pmx Then

      If MirrorXor = 0 Then

        Mirroring = 2

      ElseIf MirrorXor = &H400& Then

        Mirroring = 0

      Else

        Mirroring = 1

      End If

    ElseIf pm <> Mirroring Then

      If Mirroring = 0 And MirrorXor <> &H400& Then

        MirrorXor = &H400&

      ElseIf Mirroring = 1 And MirrorXor <> &H800& Then

        MirrorXor = &H800&

      ElseIf Mirroring = 2 And MirrorXor <> 0 Then

        MirrorXor = &H800&

      End If

    End If

    pm = Mirroring

    pmx = MirrorXor

  End If

  If ((PPU_Control2 And 16) = 0 And newScroll) Or Not render Then

    If Scanline > SpriteRAM(0) + 8 Then

      PPU_Status = PPU_Status Or 64

    End If

    Exit Sub

  End If

  If newScroll Then

    If Scanline = 0 Then

      PPUAddress = PPUAddress2

    Else

      PPUAddress = (PPUAddress And &HFBE0&) Or (PPUAddress2 And &H41F&)

    End If

    NameTable = &H2000& + (PPUAddress And &HC00)

    nt2 = (NameTable And &HC00&) \ &H400&

    HScroll = (PPUAddress And 31) * 8 + HScroll2

    VScroll = (PPUAddress \ 32 And 31) * 8 Or ((PPUAddress \ &H1000&) And 7)

    VScroll = VScroll - Scanline

    v = PPUAddress

    If (v And &H7000&) = &H7000& Then

      v = v And &H8FFF&

      If (v And &H3E0&) = &H3A0& Then

        v = v Xor &H800&

        v = v And &HFC1F&

      Else

        If (v And &H3E0&) = &H3E0& Then

          v = v And &HFC1F&

        Else

          v = v + &H20&

        End If

      End If

    Else

      v = v + &H1000&

    End If

    PPUAddress = v And &HFFFF&

  End If

  If Keyboard(219) And 1 Then

    VScroll = Frames Mod 240

  End If

  If Keyboard(221) And 1 Then

    HScroll = Frames And 255

  End If

  If Scanline < 8 Then

    PPU_Status = PPU_Status And &H3F

  End If

  If Scanline = 239 Then

    PPU_Status = PPU_Status Or &H80

  End If

  If Not render Then

    If PPU_Status And &H40 Then

      Exit Sub

    End If

    If Scanline > SpriteRAM(0) + 8 Then

      PPU_Status = PPU_Status Or &H40

    End If

    Exit Sub

  End If

  If tilebased Then

    If PPU_Control1 And &H20 Then

      h = 16

    Else

      h = 8

    End If

    If (PPU_Status And &H40) = 0 Then

      If Scanline > SpriteRAM(0) + h Then

        PPU_Status = PPU_Status Or &H40

      End If

    End If

    If Scanline = 0 Then

      Call drawsprites(True)

    ElseIf Scanline = 236 Then

      Call drawsprites(False)

    End If

  Else

  End If

  sc = Scanline + VScroll

  If newScroll And sc >= 240 Then

    sc = sc - 1

  End If

  If sc > 480 Then

    sc = sc - 480

  End If

  TileRow = (sc \ 8) Mod 30

  TileYOffset = sc And 7

  If (Not tilebased) Or VScroll <> pvs Or HScroll <> phs Or TileYOffset = 0 Then

    If TileYOffset = 0 Then

      pvs = VScroll

      phs = HScroll

    End If

    If Not newScroll Then

      If sc < 240 Then

        NameTable = &H2000& + (&H400& * (PPU_Control1 And &H3))

        nt2 = (NameTable And &HC00&) \ &H400&

      Else

        NameTable = &H2000& + (&H400& * (PPU_Control1 And &H3)) Xor &H800

        nt2 = (NameTable And &HC00&) \ &H400&

      End If

    End If

    atrtab = &H3C0

    PatternTable = (PPU_Control1 And &H10) * &H100&

    For TileCounter = HScroll \ 8 To 31

      TileIndex = nt(mirror(nt2), TileCounter + TileRow * 32)

      Select Case Mapper

        Case 9, 10, 77

          If PatternTable = &H0 Then
  
            Call map9_latch(TileIndex, False)
  
          ElseIf PatternTable = &H1000& Then
  
            Call map9_latch(TileIndex, True)
  
          End If

      End Select

      X = TileCounter * 8 - HScroll + 7

      If X < 7 Then

        m = X

      Else

        m = 7

      End If

      X = X + Scanline * 256&

      LookUp = nt(mirror(nt2), (&H3C0& + TileCounter \ 4 + (TileRow \ 4) * &H8&))

      Select Case (TileCounter And 2) Or (TileRow And 2) * 2

        Case 0

          addToCol = LookUp * 4 And 12

        Case 2

          addToCol = LookUp And 12

        Case 4

          addToCol = LookUp \ 4 And 12

        Case 6

          addToCol = LookUp \ 16 And 12

      End Select

      If tilebased And TileYOffset = 0 Then

        For Y = 0 To 7

          Byte1 = VRAM(PatternTable + TileIndex * 16 + Y)

          Byte2 = VRAM(PatternTable + TileIndex * 16 + 8 + Y)

          aa = Byte1 * 2048& + Byte2 * 8

          For pixel = m To 0 Step -1

            Color = tLook(aa + pixel)

            If Color And frmNES.disablebg.Checked = False Then

              vBuffer(X - pixel) = Color Or addToCol

            End If

          Next pixel

          X = X + 256

        Next Y

      Else

        Byte1 = VRAM(PatternTable + TileIndex * 16 + TileYOffset)

        Byte2 = VRAM(PatternTable + TileIndex * 16 + 8 + TileYOffset)

        aa = Byte1 * 2048& + Byte2 * 8

        For pixel = m To 0 Step -1

          Color = tLook(aa + pixel)

          If Color And frmNES.disablebg.Checked = False Then

            vBuffer(X - pixel) = Color Or addToCol

          End If

        Next pixel

      End If

    Next TileCounter

    If newScroll Then

      NameTable = NameTable Xor &H400

      nt2 = (NameTable And &HC00&) \ &H400&

    Else

      If sc < 240 Then

        NameTable = &H2000& + (&H400& * (PPU_Control1 And &H3)) Xor &H400

        nt2 = (NameTable And &HC00&) \ &H400&

      Else

        NameTable = &H2000& + (&H400& * (PPU_Control1 And &H3)) Xor &HC00

        nt2 = (NameTable And &HC00&) \ &H400&

      End If

    End If

    atrtab = &H3C0

    For TileCounter = 0 To HScroll \ 8

      TileIndex = nt(mirror(nt2), TileCounter + TileRow * 32)

      Select Case Mapper

        Case 9, 10, 77

          If PatternTable = &H0 Then
  
            Call map9_latch(TileIndex, False)
  
          ElseIf PatternTable = &H1000& Then
  
            Call map9_latch(TileIndex, True)
  
          End If

      End Select

      X = TileCounter * 8 + 256 - HScroll + 7

      If X > 255 Then

        m = X - 255

      Else

        m = 0

      End If

      X = X + Scanline * 256&

      LookUp = nt(mirror(nt2), (&H3C0& + TileCounter \ 4 + (TileRow \ 4) * &H8&))

      Select Case (TileCounter And 2) Or (TileRow And 2) * 2

        Case 0

          addToCol = LookUp * 4 And 12

        Case 2

          addToCol = LookUp And 12

        Case 4

          addToCol = LookUp \ 4 And 12

        Case 6

        addToCol = LookUp \ 16 And 12

      End Select

      If tilebased And TileYOffset = 0 Then

        For Y = 0 To 7

          Byte1 = VRAM(PatternTable + TileIndex * 16 + Y)

          Byte2 = VRAM(PatternTable + TileIndex * 16 + 8 + Y)

          aa = Byte1 * 2048& + Byte2 * 8

          For pixel = 7 To m Step -1

            Color = tLook(aa + pixel)

            If Color And frmNES.disablebg.Checked = False Then

              vBuffer(X - pixel) = Color Or addToCol

            End If

          Next pixel

          X = X + 256

        Next Y

      Else

        Byte1 = VRAM(PatternTable + (TileIndex * 16) + TileYOffset)

        Byte2 = VRAM(PatternTable + (TileIndex * 16) + 8 + TileYOffset)

        aa = Byte1 * 2048& + Byte2 * 8

        For pixel = 7 To m Step -1

          Color = tLook(aa + pixel)

          If Color And frmNES.disablebg.Checked = False Then

            vBuffer(X - pixel) = Color Or addToCol

          End If

        Next pixel

      End If

    Next TileCounter

  End If

25:

  If Not tilebased Then

    Call rendersprites(Scanline - 1)

  End If

  Exit Sub

14:

End Sub
Public Sub rendersprites(ByVal Scanline As Long)

  Dim solid(264) As Boolean, TileRow As Byte, TileYOffset As Long, TileCounter As Long, Color As Byte, TileIndex As Byte, Byte1 As Byte, Byte2 As Byte, addToCol As Long, h As Byte, minX As Long, X1 As Long, y1 As Long, ptable As Long, spr As Long, SpriteAddr As Integer, i As Long, X As Long, aa As Long, v As Long, ontop As Boolean, attr As Byte

  If frmNES.mnuvideo.Checked = True Or frmNES.disablesprites.Checked = True Or (PPU_Control2 And 16) = 0 Then

    Exit Sub

  End If

  TileRow = Scanline \ 8

  TileYOffset = Scanline And 7

  If PPU_Control1 And &H20 Then

    h = 16

  Else

    h = 8

  End If

  If PPU_Control1 And &H8 Then

    If h = 8 Then

      PatternTable = &H1000&

    End If

  Else

    If h = 8 Then

      PatternTable = &H0

    End If

  End If

  If PPU_Control2 And &H8 Then

    minX = 0

  Else

    minX = 8

  End If

  i = Scanline * 256&

  For spr = 0 To 63

    SpriteAddr = 4 * spr

    y1 = SpriteRAM(SpriteAddr) + 1

    If y1 <= Scanline And y1 > Scanline - h Then

      attr = SpriteRAM(SpriteAddr + 2)

      ontop = (attr And 32) = 0

      X1 = SpriteRAM(SpriteAddr + 3)

      If X1 >= minX Then

        If render And X1 < 256 Then '248

          addToCol = &H10 + (attr And 3) * 4

          TileIndex = SpriteRAM(SpriteAddr + 1)

          If Mapper = 9 Or Mapper = 10 Or Mapper = 77 Then

            If PatternTable = &H0 Then

              Call map9_latch(TileIndex, False)

            ElseIf PatternTable = &H1000& Then

              Call map9_latch(TileIndex, True)

            End If

          End If

          If h = 16 Then

            If TileIndex And 1 Then

              PatternTable = &H1000

              TileIndex = TileIndex Xor 1

            Else

              PatternTable = 0

            End If

          End If

          If attr And 128 Then

            v = y1 - Scanline - 1

          Else

            v = Scanline - y1

          End If

          v = v And h - 1

          If v >= 8 Then

            v = v + 8

          End If

          Byte1 = VRAM(PatternTable + (TileIndex * 16) + v)

          Byte2 = VRAM(PatternTable + (TileIndex * 16) + 8 + v)

          If spr = 0 And (PPU_Status And 64) = 0 Then

            If attr And 64 Then

              aa = i + X1

              For X = 0 To 7

                If Byte1 And pow2(X) Then

                  Color = 1

                Else

                  Color = 0

                End If

                If Byte2 And pow2(X) Then

                  Color = Color + 2

                End If

                If Color Then

                  If vBuffer(aa + X) And 3 And (PPU_Status And 64) = 0 Then

                    PPU_Status = PPU_Status Or 64

                    If ontop Then

                      vBuffer(aa + X) = addToCol Or Color

                    End If

                  Else

                    vBuffer(aa + X) = addToCol Or Color

                  End If

                  solid(X1 + X) = True

                End If

              Next X

            Else

              aa = i + X1 + 7

              For X = 7 To 0 Step -1

                If Byte1 And pow2(X) Then

                  Color = 1

                Else

                  Color = 0

                End If

                If Byte2 And pow2(X) Then

                  Color = Color + 2

                End If

                If Color Then

                  If vBuffer(aa - X) And 3 And (PPU_Status And 64) = 0 Then

                    PPU_Status = PPU_Status Or 64

                    If ontop Then

                      vBuffer(aa - X) = addToCol Or Color

                    End If

                  Else

                    vBuffer(aa - X) = addToCol Or Color

                  End If

                  solid(X1 + 7 - X) = True

                End If

              Next X

            End If

          Else

            If attr And 64 Then

              aa = i + X1

              For X = 0 To 7

                If Byte1 And pow2(X) Then

                  Color = 1

                Else

                  Color = 0

                End If

                If Byte2 And pow2(X) Then

                  Color = Color + 2

                End If

                If Color Then

                  If Not solid(X1 + X) Then

                    If ontop Then

                      vBuffer(aa + X) = addToCol Or Color

                    ElseIf (vBuffer(aa + X) And 3) = 0 Then

                      vBuffer(aa + X) = addToCol Or Color

                    End If

                    solid(X1 + X) = True

                  End If

                End If

              Next X

            Else

              aa = i + X1 + 7

              For X = 7 To 0 Step -1

                If Byte1 And pow2(X) Then

                  Color = 1

                Else

                  Color = 0

                End If

                If Byte2 And pow2(X) Then

                  Color = Color + 2

                End If

                If Color Then

                  If Not solid(X1 + 7 - X) Then

                    If ontop Then

                      vBuffer(aa - X) = addToCol Or Color

                    ElseIf (vBuffer(aa - X) And 3) = 0 Then

                      vBuffer(aa - X) = addToCol Or Color

                    End If

                    solid(X1 + 7 - X) = True

                  End If

                End If

              Next X

            End If

          End If

        End If

        If spr = 0 Then

          If Scanline = y1 + h - 1 Then

            PPU_Status = PPU_Status Or &H40

          End If

        End If

      End If

    End If

  Next spr

End Sub
Public Sub map6_write(address As Long, value As Byte)

  If address < &H42FC& Then

    Exit Sub

  End If

  Select Case address

    Case &H42FC& To &H42FD&

    Case &H42FE&

      If value And &H20 Then

        NameTable = &H2400&

      Else

        NameTable = &H2000&

      End If

    Case &H42FF&

      Mirroring = (value And &H20) \ &H20

      Call domirror

    Case &H4501&

      map6_irqon = 0

    Case &H4502&

      tmpLatch = value

    Case &H4503&

      IRQCounter = (value * &H100&) + tmpLatch

      map6_irqon = 1

    Case &H8000& To &HFFFF&

      reg8 = (value And &HF) * 2

      regA = reg8 + 1

      Call select8kvrom(value And &H3)

      Call setupbanks

  End Select

End Sub
Public Function map6_hblank(Scanline) As Byte

  If (map6_irqon <> 0) Then

    IRQCounter = IRQCounter + 1

    If (IRQCounter >= &HFFFF&) Then

      IRQCounter = 0

      Call irq6502

    End If

  End If

End Function
Public Sub map90_write(address As Long, value As Byte)

  Select Case address

    Case &H8000&

      reg8 = value

    Case &H8001&

      regA = value

    Case &H8002&

      regC = value

    Case &H8003&

      regE = value

  End Select

  If address >= &H8000& And address <= &H8003& Then

    Call setupbanks

  End If

End Sub
Public Sub map24_write(address As Long, value As Byte)

  Select Case address

    Case &H8000&

      reg8 = value * 2

      regA = reg8 + 1

      Call setupbanks

    Case &HB003&

      Mirroring = ((value And &HC) \ &H4)

    Case &HC000&

      regC = value

      Call setupbanks

    Case &HD000& To &HD003&

      Call select1kvrom(value, (address And &H3))

    Case &HE000& To &HE003&

      Call select1kvrom(value, (address And &H3) + 4)

    Case &HF000&

      map24_irqv = value

    Case &HF001&

      map24_irqon = (value And &H1)

    Case &HF002&

      map24_irqv = 0

  End Select

End Sub
Public Sub map24_irq()

  If map24_irqon = 0 Then

    Exit Sub

  End If

  map24_irqv = map24_irqv + 1

  If (map24_irqv = &HFF) And (map24_irqon) Then

    map24_irqon = 0

    map24_irqv = 0

    Call irq6502

  End If

End Sub
Public Sub map13_write(address As Long, value As Byte)

  Dim prg_bank As Byte

  prg_bank = (value And &H30) \ 16

  reg8 = prg_bank * 4

  regA = reg8 + 1

  regC = reg8 + 2

  regE = reg8 + 3

  Call setupbanks

  Call select4kvrom(0, 2)

  Call select4kvrom(value And &H3, 3)

  latch13 = value

End Sub
Public Sub map16_write(address As Long, value As Byte)

  Select Case (address And &HD)

    Case &H0 To &H7

      Call select1kvrom(value, address And &H7)

    Case &H8

      reg8 = value * 2

      regA = reg8 + 1

      Call setupbanks

    Case &H9

      Mirroring = (value And &H1)

    Case &HA

      If value Then

        MMC16_IrqOn = 1

      Else

        MMC16_IrqOn = 0

      End If

    Case &HB

      tmpLatch = value

    Case &HC

      MMC16_Irq = (value * &H100&) + tmpLatch

    Case &HD

  End Select

End Sub
Public Sub map65_write(address As Long, value As Byte)

  Select Case address

    Case &H8000&

      reg8 = value

      Call setupbanks

    Case &H9003&

    Case &H9005&

    Case &H9006&

    Case &HA000&

      regA = value

      Call setupbanks

    Case &HB000& To &HB007&

      Call select1kvrom(value, address And &H7)

    Case &HC000&

      regC = value

      Call setupbanks

  End Select

End Sub
Public Sub map19_write(address As Long, value As Byte)

  If address < &H5000& Then

    Exit Sub

  End If

  Select Case address

    Case &H5000& To &H57FF&

      tmpLatch = value

    Case &H5800& To &H5FFF&

      If value And &H80 Then

        MIRQOn = 1

      Else

        MIRQOn = 0

      End If

      MMC19_IRQCount = ((value And &H7F) * &H100&) + tmpLatch

    Case &H8000& To &H87FF&

      Call select1kvrom(value, 0)

    Case &H8800& To &H8FFF&

      Call select1kvrom(value, 1)

    Case &H9000& To &H97FF&

      Call select1kvrom(value, 2)

    Case &H9800& To &H9FFF&

      Call select1kvrom(value, 3)

    Case &HA000& To &HA7FF&

      Call select1kvrom(value, 4)

    Case &HA800& To &HAFFF&

      Call select1kvrom(value, 5)

    Case &HB000& To &HB7FF&

      Call select1kvrom(value, 6)

    Case &HB800& To &HBFFF&

      Call select1kvrom(value, 7)

    Case &HC000& To &HC7FF&

      If value < &HE0 Then

        Call select1kvrom(value, 8)

      End If

    Case &HC800& To &HC8FF&

      If value < &HE0 Then

        Call select1kvrom(value, 9)

      End If

    Case &HD000& To &HD7FF&

      If value < &HE0 Then

        Call select1kvrom(value, 10)

      End If

    Case &HD800& To &HD8FF&

      If value < &HE0 Then

        Call select1kvrom(value, 11)

      End If

    Case &HE000& To &HE7FF&

      reg8 = value

      Call setupbanks

    Case &HE800& To &HEFFF&

      regA = value

      Call setupbanks

    Case &HF000& To &HF7FF&

      regC = value

      Call setupbanks

  End Select

End Sub
Public Sub map19_irq()

  If MIRQOn = 1 Then

    MMC19_IRQCount = MMC19_IRQCount + 1

    If MMC19_IRQCount = &H7FFF& Then

      Call irq6502

    End If

  End If

End Sub
Public Sub map64_write(address As Long, value As Byte)

  Select Case address

    Case &H8000&

      cmd = value And &HF

      prg = (value And &H40)

      chr1 = (value And &H80)

    Case &H8001&

      Select Case cmd

        Case 0

          If (chr1) Then

            Call select1kvrom(value, 4)

            Call select1kvrom(value + 1, 5)

          Else

            Call select1kvrom(value, 0)

            Call select1kvrom(value, 1)

          End If

        Case 1

          If (chr1) Then

            Call select1kvrom(value, 6)

            Call select1kvrom(value + 1, 7)

          Else

            Call select1kvrom(value, 2)

            Call select1kvrom(value + 1, 3)

          End If

        Case 2

          If (chr1) Then

            Call select1kvrom(value, 0)

          Else

            Call select1kvrom(value, 4)

          End If

        Case 3

          If (chr1) Then

            Call select1kvrom(value, 1)

          Else

            Call select1kvrom(value, 5)

          End If

        Case 4

          If (chr1) Then

            Call select1kvrom(value, 2)

          Else

            Call select1kvrom(value, 6)

          End If

        Case 5

          If (chr1) Then

            Call select1kvrom(value, 3)

          Else

            Call select1kvrom(value, 7)

          End If

        Case 6

          If (prg) Then

            regA = value

          Else

            reg8 = value

          End If

          Call setupbanks

        Case 7

          If (prg) Then

            regC = value

          Else

            reg8 = value

          End If

          Call setupbanks

        Case 8

          Call select1kvrom(value, 1)

        Case 9

          Call select1kvrom(value, 3)

        Case &HF

          If (prg) Then

            reg8 = value

          Else

            regC = value

          End If

          Call setupbanks

      End Select

    Case &HA000&

      Mirroring = (value And &H1)

      Call domirror

  End Select

End Sub
Public Sub domirror()

  MirrorXor = (((Mirroring + 1) Mod 3) * &H400&)

  Select Case Mirroring

    Case 0

      mirror(0) = 0

      mirror(1) = 0

      mirror(2) = 1

      mirror(3) = 1

    Case 1

      mirror(0) = 0

      mirror(1) = 1

      mirror(2) = 0

      mirror(3) = 1

    Case 2

      mirror(0) = 0

      mirror(1) = 0

      mirror(2) = 0

      mirror(3) = 0

    Case 4

      mirror(0) = 0

      mirror(1) = 1

      mirror(2) = 2

      mirror(3) = 3

  End Select

End Sub
Public Function read6502(ByVal address As Long) As Byte

  Dim tmp As Byte, ret As Byte

  Select Case address

    Case &H0 To &H1FFF&

      read6502 = bank0(address And &H7FF&)

    Case &H2000& To &H3FFF&

      Select Case (address And &H7&)

        Case &H0&

          read6502 = ppuLatch

        Case &H1&

          read6502 = ppuLatch

        Case &H2&

          ScrollToggle = 0

          PPU_AddressIsHi = True

          ret = (ppuLatch And &H1F) Or PPU_Status

          If (ret And &H80) Then

            PPU_Status = (PPU_Status And &H60)

          End If

          read6502 = ret

        Case &H4&

          tmp = ppuLatch

          ppuLatch = SpriteRAM(SpriteAddress)

          SpriteAddress = (SpriteAddress + 1) And &HFF

          read6502 = tmp

        Case &H5&

          read6502 = ppuLatch

        Case &H6&

          read6502 = ppuLatch

        Case &H7&

          tmp = ppuLatch

          If Mapper = 9 Or Mapper = 77 And PPUAddress < &H2000& Then

            Call map9_latch(tmp, (PPUAddress And &H1000&))

          End If

          If PPUAddress >= &H2000& And PPUAddress <= &H2FFF& Then

            ppuLatch = nt(mirror((PPUAddress And &HC00&) \ &H400&), PPUAddress And &H3FF&)

          Else

            ppuLatch = VRAM(PPUAddress And &H3FFF&)

          End If

          If (PPU_Control1 And &H4) Then

            PPUAddress = PPUAddress + 32

          Else

            PPUAddress = PPUAddress + 1

          End If

          PPUAddress = (PPUAddress And &H3FFF&)

          read6502 = tmp

      End Select

    Case &H4000& To &H4013&, &H4015&

      If frmNES.mMute.Checked = False Then

        read6502 = Sound(address - &H4000&)

      End If

    Case &H4016&

      read6502 = Joypad1(Joypad1_Count)

      Joypad1_Count = (Joypad1_Count + 1) And 7

    Case &H4017&

      read6502 = Joypad2(Joypad2_Count)

      Joypad2_Count = (Joypad2_Count + 1) And 7

    Case &H6000& To &H7FFF&

      read6502 = bank6(address And &H1FFF&)

    Case &H8000& To &H9FFF&

      read6502 = bank8(address And &H1FFF&)

    Case &HA000& To &HBFFF&

      read6502 = bankA(address And &H1FFF&)

    Case &HC000& To &HDFFF&

      read6502 = bankC(address And &H1FFF&)

    Case &HE000& To &HFFFF&

      read6502 = bankE(address And &H1FFF&)

  End Select

End Function
Public Sub write6502(ByVal address As Long, ByVal value As Byte)

  On Error GoTo 14

  Dim n

  If address >= &H2000& And address <= &H3FFF& Then

    ppuLatch = value

  End If

  Select Case address

    Case &H0& To &H1FFF&

      bank0(address And &H7FF&) = value

    Case &H2000& To &H3FFF&

      Select Case (address And &H7)

        Case &H0&

          PPU_Control1 = value

          PPUAddress2 = (PPUAddress2 And &HF3FF&) Or (value And 3) * &H400&

        Case &H1&

          PPU_Control2 = value

        Case &H2&

          ppuLatch = value

        Case &H3&

          SpriteAddress = value

        Case &H4&

          SpriteRAM(SpriteAddress) = value

          SpriteAddress = (SpriteAddress + 1) And &HFF

          SpritesChanged = True

        Case &H5&

          If PPU_AddressIsHi Then

            HScroll2 = value And 7

            PPUAddress2 = (PPUAddress2 And &HFFE0&) Or value \ 8

            If Not newScroll Then

              HScroll = value

            End If

            PPU_AddressIsHi = False

          Else

            PPUAddress2 = (PPUAddress2 And &H8C1F&) Or (value And &HF8) * 4 Or (value And 7) * &H1000&

            If Not newScroll Then

              VScroll = value

              If VScroll > 240 Then

                VScroll = 0

              End If

            End If

            PPU_AddressIsHi = True

          End If

        Case &H6&

          If PPU_AddressIsHi Then

            PPUAddress = (PPUAddress And &HFF) Or ((value And &H3F) * &H100&)

            PPU_AddressIsHi = False

          Else

            PPUAddress = (PPUAddress And &H7F00&) Or value

            PPU_AddressIsHi = True

          End If

          If Not newScroll Then

            If PPU_Control2 And 16 Then

              HScroll = (PPUAddress And 31) * 8 + HScroll2

              VScroll = (PPUAddress \ 32 And 31) * 8 Or (PPUAddress \ &H1000& And 7)

              If CurrentLine < 240 Then

                VScroll = VScroll - CurrentLine

              End If

            End If

          End If

        Case &H7&

          ppuLatch = value

          If Mapper = 9 Or Mapper = 77 Then

            If PPUAddress <= &H1FFF& And PPUAddress >= &H0& Then

              Call map9_latch(value, (PPUAddress And &H1000&))

            End If

          End If

          If PPUAddress >= &H2000& And PPUAddress <= &H2FFF& Then

            nt(mirror((PPUAddress And &HC00&) \ &H400&), PPUAddress And &H3FF&) = value

          Else

            VRAM(PPUAddress) = value

            If (PPUAddress And &HFFEF&) = &H3F00& Then VRAM(PPUAddress Xor 16) = value

          End If

          If (PPU_Control1 And &H4) Then

            PPUAddress = (PPUAddress + 32)

          Else

            PPUAddress = (PPUAddress + 1)

          End If

          PPU_AddressIsHi = True

          PPUAddress = (PPUAddress And &H3FFF&)

      End Select

    Case &H4000& To &H4013&

      If frmNES.mMute.Checked = False Then

        Sound(address - &H4000&) = value

        n = (address - &H4000&) \ 4

        If n < 4 Then

          ChannelWrite(n) = True

        End If

      End If

    Case &H4014&

      Call MemCopy(SpriteRAM(0), bank0(value * &H100&), &HFF)

      SpritesChanged = True

    Case &H4015&

      If frmNES.mMute.Checked = False Then

        SoundCtrl = value

      End If

    Case &H6000& To &H7FFF&

      If SpecialWrite6000 Then

        Call mapperwrite(address, value)

      Else

        bank6(address And &H1FFF&) = value

      End If

    Case &H8000& To &HFFFF&

      Call mapperwrite(address, value)

  End Select

  Exit Sub

14:

End Sub
Public Function ggaddy(ggcode As String) As Long

  Dim ggval As String

  Select Case Len(ggcode$)

    Case 6

      ggval$ = ggdecode(ggcode$)
  
      ggcode$ = Right$(Left$(ggval$, 14), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 15), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 16), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 17), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 22), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 23), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 24), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 5), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 10), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 11), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 12), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 13), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 18), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 19), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 20), 1)
  
      ggaddy& = CLng("&h" & bintohex$(ggcode$))

    Case 8

      ggval$ = ggdecode(ggcode$)
  
      ggcode$ = Right$(Left$(ggval$, 14), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 15), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 16), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 17), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 22), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 23), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 24), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 5), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 10), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 11), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 12), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 13), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 18), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 19), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggval$, 20), 1)

  End Select

End Function
Public Function ggval(ggcode As String) As Long

  Dim ggvral As String

  Select Case Len(ggcode$)

    Case 6

      ggvral$ = ggdecode(ggcode$)
  
      ggcode$ = Left$(ggvral$, 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 6), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 7), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 8), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 21), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 2), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 3), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 4), 1)
  
      ggval& = CLng("&h" & bintohex$(ggcode$))
  
    Case 8

      ggvral$ = ggdecode(ggcode$)
  
      ggcode$ = Left$(ggvral$, 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 6), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 7), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 8), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 28), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 2), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 3), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 4), 1)
  
      ggval& = CLng("&h" & bintohex$(ggcode$))

  End Select

End Function
Public Function ggcompval(ggcode As String) As Long

  Dim ggvral As String

  Select Case Len(ggcode$)

    Case 8

      ggvral$ = ggdecode(ggcode$)
  
      ggcode$ = Right$(Left$(ggvral$, 25), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 30), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 31), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 32), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 21), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 26), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 27), 1)
  
      ggcode$ = ggcode$ & Right$(Left$(ggvral$, 28), 1)
  
      ggcompval& = CLng("&h" & bintohex$(ggcode$))
  
  End Select

End Function
Public Function ggdecode(ggcode As String) As String

  ggcode$ = UCase$(ggcode$)

  ggcode$ = Replace$(ggcode$, "A", "0000")

  ggcode$ = Replace$(ggcode$, "P", "0001")

  ggcode$ = Replace$(ggcode$, "Z", "0010")

  ggcode$ = Replace$(ggcode$, "L", "0011")

  ggcode$ = Replace$(ggcode$, "G", "0100")

  ggcode$ = Replace$(ggcode$, "I", "0101")

  ggcode$ = Replace$(ggcode$, "T", "0110")

  ggcode$ = Replace$(ggcode$, "Y", "0111")

  ggcode$ = Replace$(ggcode$, "E", "1000")

  ggcode$ = Replace$(ggcode$, "O", "1001")

  ggcode$ = Replace$(ggcode$, "X", "1010")

  ggcode$ = Replace$(ggcode$, "U", "1011")

  ggcode$ = Replace$(ggcode$, "K", "1100")

  ggcode$ = Replace$(ggcode$, "S", "1101")

  ggcode$ = Replace$(ggcode$, "V", "1110")

  ggcode$ = Replace$(ggcode$, "N", "1111")

  ggdecode$ = ggcode$

End Function
Public Sub map11_write(address As Long, value As Byte)

  reg8 = 4 * (value And &HF)

  regA = reg8 + 1

  regC = reg8 + 2

  regE = reg8 + 3

  Call setupbanks

  Call select8kvrom(value And &HF0)

End Sub
Public Sub map15_write(address As Long, value As Byte)

  'unfinished:mirroring

  Map15_BankAddr = (value And &H3F) * 2

  Select Case (address And &H3)

    Case &H0

      map15_swapaddr = (value And &H80)

      reg8 = Map15_BankAddr

      regA = Map15_BankAddr + 1

      regC = Map15_BankAddr + 2

      regE = Map15_BankAddr + 3

      Call setupbanks

      Mirroring = (value And &H40) \ &H40

    Case &H1

      Map15_SwapReg = (value And &H80)

      regC = Map15_BankAddr

      regE = Map15_BankAddr + 1

      Call setupbanks

    Case &H2

      If (value And &H80) Then

        reg8 = Map15_BankAddr + 1

        regA = Map15_BankAddr + 1

        regC = Map15_BankAddr + 1

        regE = Map15_BankAddr + 1

      Else

        reg8 = Map15_BankAddr

        regA = reg8

        regC = regA

        regE = regC
      End If

      Call setupbanks

    Case &H3

      Map15_SwapReg = (value And &H80)

      regC = Map15_BankAddr

      regE = Map15_BankAddr + 1

      Call setupbanks

      Mirroring = (value And &H40&) \ &H40&

  End Select

End Sub
Public Sub map18_write(address As Long, value As Byte)

  address = (address And &HF003&)

  Select Case address

    Case &H8000&

  End Select

End Sub
Public Sub map32_write(address As Long, value As Byte)

  Select Case address

    Case &H8000& To &H8FFF&

      If (MMC32_Switch And &H2) = 2 Then

        regC = value

        Call setupbanks

      Else

        reg8 = value

        Call setupbanks

      End If

    Case &H9000& To &H9FFF&

      Mirroring = (value And &H1)

      MMC32_Switch = value

      Call domirror

    Case &HA000& To &HAFFF&

      regA = value

      Call setupbanks

    Case &HBFF0&

      Call select1kvrom(value, 0)

    Case &HBFF1&

      Call select1kvrom(value, 1)

    Case &HBFF2&

      Call select1kvrom(value, 2)

    Case &HBFF3&

      Call select1kvrom(value, 3)

    Case &HBFF4&

      Call select1kvrom(value, 4)

    Case &HBFF5&

      Call select1kvrom(value, 5)

    Case &HBFF6&

      Call select1kvrom(value, 6)

    Case &HBFF7&

      Call select1kvrom(value, 7)

  End Select

End Sub
Public Sub map33_write(address As Long, value As Byte)

  Select Case address

    Case &H8000&

      reg8 = value

      Call setupbanks

    Case &H8001&

      regA = value

      Call setupbanks

    Case &H8002&

      Call select2kvrom(value, 0)

    Case &H8003&

      Call select2kvrom(value, 2)

    Case &HA000&

      Call select1kvrom(value, 4)

    Case &HA001&

      Call select1kvrom(value, 5)

    Case &HA002&

      Call select1kvrom(value, 6)

    Case &HA003&

      Call select1kvrom(value, 7)

    Case &HC000, &HC001, &HE000&

  End Select

End Sub
Public Sub map34_write(address As Long, value As Byte)

  Select Case address

    Case &H7FFD&

      reg8 = 4 * (value)

      regA = reg8 + 1

      regC = regA + 1

      regE = regC + 1

      Call setupbanks

    Case &H7FFE&

      Call select4kvrom(value, 0)

    Case &H7FFF&

      Call select4kvrom(value, 1)

    Case &H8000& To &HFFFF&

      reg8 = 4 * (value)

      regA = reg8 + 1

      regC = regA + 1

      regE = regC + 1

      Call setupbanks

  End Select

End Sub
Public Sub map40_write(address As Long, value As Byte)

  Select Case (address And &HE000&)

    Case &H8000&

      Mapper40_IRQEnabled = 0

      Mapper40_IRQCounter = 36

    Case &HA000&

      Mapper40_IRQEnabled = 1

    Case &HE000&

      regC = value

      Call setupbanks

  End Select

End Sub
Public Sub map66_write(address As Long, value As Byte)

  reg8 = (value \ &H10) And &H3

  regA = reg8 + 1

  regC = reg8 + 2

  regE = reg8 + 3

  Call setupbanks

  Call select8kvrom(value And &H3)

End Sub
Public Sub map68_write(address As Long, value As Byte)

  Select Case address

    Case &H8000&

      Call select2kvrom(value, 0)

    Case &H9000&

      Call select2kvrom(value, 1)

    Case &HA000&

      Call select2kvrom(value, 2)

    Case &HB000&

      Call select2kvrom(value, 3)

    Case &HE000&

      Mirroring = (value And &H3)

      Call domirror

    Case &HF000&

      reg8 = (value * 2)

      regA = (value * 2) + 1

      Call setupbanks

  End Select

End Sub
Public Sub map71_write(address As Long, value As Byte)

  Select Case address

    Case &H8000& To &HBFFF&

    Case &HC000& To &HFFFF&

      reg8 = (value * 2)

      regA = (value * 2) + 1

      Call setupbanks

  End Select

End Sub
Public Sub map78_write(address As Long, value As Byte)

  Dim vromptr As Byte, romptr As Byte

  vromptr = (value \ &H10&) And &HF

  romptr = value And &HF

  Call select8kvrom(vromptr)

  reg8 = (romptr * 2)

  regA = (romptr * 2) + 1

  Call setupbanks

End Sub
Public Sub map91_write(address As Long, value As Byte)

  Select Case address

    Case &H6000& To &H6FFF&

      Call select2kvrom(value, address And &H3)

    Case &H7000& To &H7FFB&

      Select Case address And &H1

        Case 0

          reg8 = value

          Call setupbanks

        Case 1

          regA = value

          Call setupbanks

      End Select

  End Select

End Sub
Public Sub mapperwrite(ByVal address As Long, ByVal value As Byte)

  Select Case Mapper

    Case 1, 69, 121, 142

      Call map1_write(address, value)

    Case 2, 79

      Call map2_write(address, value)

    Case 3, 41, 83, 101

      Call map3_write(address, value)

    Case 4, 45, 5, 74, 72, 76, 88, 95, 118, 119, 232, 245, 248

      Call map4_write(address, value)

    Case 6

      Call map6_write(address, value)

    Case 7, 8, 14, 51, 60, 58, 231, 113

      Call map7_write(address, value)

    Case 66, 229

      Call map66_write(address, value)

    Case 9, 10, 77

      Call map9_write(address, value)

    Case 11, 57, 200, 201, 203

      Call map11_write(address, value)

    Case 13, 240

      Call map13_write(address, value)

    Case 15

      Call map15_write(address, value)

    Case 16

      Call map16_write(address, value)

    Case 17

      Call map17_write(address, value)

    Case 18

      Call map18_write(address, value)

    Case 19

      Call map19_write(address, value)

    Case 21, 22, 25, 75

      Call map22_write(address, value)

    Case 23, 73, 222

      Call map23_write(address, value)

    Case 24, 26

      Call map24_write(address, value)

    Case 32

      Call map32_write(address, value)

    Case 33, 85

      Call map33_write(address, value)

    Case 34

      Call map34_write(address, value)

    Case 40

      Call map40_write(address, value)

    Case 64

      Call map64_write(address, value)

    Case 65

      Call map65_write(address, value)

    Case 68

      Call map68_write(address, value)

    Case 70, 82

      Call map2_write(address, value)

    Case 71

      Call map71_write(address, value)

    Case 78

      Call map78_write(address, value)

    Case 90, 160

      Call map90_write(address, value)

    Case 99, 100, 151, 152

      Call map151_write(address, value)

    Case 91

      Call map91_write(address, value)

  End Select

End Sub
Public Sub map22_write(address As Long, value As Byte)

  Select Case address

    Case &H8000&

      reg8 = value

      Call setupbanks

    Case &H9000&

      Mirroring = (value And &H3)

    Case &HA000&

      regA = value

      Call setupbanks

    Case &HB000&

      Call select1kvrom(value \ 2, 0)

    Case &HB001&

      Call select1kvrom(value \ 2, 1)

    Case &HC000&

      Call select1kvrom(value \ 2, 2)

    Case &HC001&

      Call select1kvrom(value \ 2, 3)

    Case &HD000&

      Call select1kvrom(value \ 2, 4)

    Case &HD001&

      Call select1kvrom(value \ 2, 5)

    Case &HE000&

      Call select1kvrom(value \ 2, 6)

    Case &HE001&

      Call select1kvrom(value \ 2, 7)

  End Select

End Sub
Public Function loadnes(ByVal FileName As String) As Byte

  On Error GoTo errorhandler

  Dim FileNum As Integer, i As Long, PrgMark As Long, startat As Integer, ChoseIt As Byte, banks As Byte, NESType As Byte

  Mapper = 0

  frmNES.Caption = "olafnes"

  tmpLatch = 0

  FileNum = FreeFile

  Erase VRAM, VROM, gameImage, bank8, bankA, bankC, bankE, bank0, bank6, Joypad1, Joypad2

  SpecialWrite6000 = False

  If Dir$(FileName) = "" Then

    loadnes = 0

    Exit Function

  End If

  Close #1

  PrgCount = 0

  PrgCount2 = 0

  ChrCount = 0

  ChrCount2 = 0

  If LCase$(Right$(FileName$, 4)) = ".nes" Then

    Open FileName For Binary As #FileNum

    Get #FileNum, , Header

    If Header <> "NES" Then

      loadnes = 0

      Close #FileNum

      Exit Function

    End If

    Get #FileNum, 5, PrgCount

    PrgCount2 = PrgCount

    Get #FileNum, 6, ChrCount

    ChrCount2 = ChrCount

    Get #FileNum, 7, ROMCtrl

    Get #FileNum, 8, ROMCtrl2

    Get #FileNum, 8, NESType

    Mapper = (ROMCtrl And &HF0) \ 16

    Mapper = Mapper + ROMCtrl2

    If Mapper <> 0 And (ChrCount = 1 And PrgCount = 2) Then

      Mapper = 0

    End If

    If Mapper <> 0 And (ChrCount = 1 And PrgCount = 1) Then

      Mapper = 0

    End If

    Trainer = ROMCtrl And &H4

    Mirroring = ROMCtrl And &H1

    FourScreen = ROMCtrl And &H8

    If ROMCtrl And &H2 Then

      UsesSRAM = True

    End If

    PrgMark = (PrgCount2 * &H4000&) - 1

    If Trainer Then

      Get #FileNum, 17, Train

    End If

    ReDim gameImage(PrgMark) As Byte

    If Trainer Then

      startat = 529

    Else

      startat = 17

    End If

    Get #FileNum, startat, gameImage

    ReDim VROM(ChrCount2 * &H2000&) As Byte

    PrgMark = &H4000& * PrgCount2 + startat

    If ChrCount2 Then

      Get #FileNum, PrgMark, VROM

    End If

  End If

  If frmNES.GameGenieCodes.ListCount <> 0 Then

    frmNES.GameGenieCodes.ListIndex = 0

    Do

      If Len(frmNES.GameGenieCodes.Text) = 6 Then

        codeaddy& = ggaddy&(frmNES.GameGenieCodes.Text)

        codeval& = ggval&(frmNES.GameGenieCodes.Text)

        gameImage(codeaddy&) = CByte(codeval)

      End If

      If frmNES.GameGenieCodes.ListIndex = frmNES.GameGenieCodes.ListCount - 1 Then

        GoTo 152

      End If

      frmNES.GameGenieCodes.ListIndex = frmNES.GameGenieCodes.ListIndex + 1

    Loop

  End If

152:

  If frmNES.List1.ListCount <> 0 Then

    frmNES.List1.ListIndex = 0

    frmNES.List2.ListIndex = 0

    Do

      codeaddy& = CLng(frmNES.List1.Text)

      codeval& = CLng(frmNES.List2.Text)

      gameImage(codeaddy&) = CByte(codeval&)

      If frmNES.List1.ListIndex = frmNES.List1.ListCount - 1 Then

        GoTo 115

      End If

      frmNES.List1.ListIndex = frmNES.List1.ListIndex + 1

      frmNES.List2.ListIndex = frmNES.List1.ListIndex

    Loop

  End If

115:

  Call mmc_reset

  If MapSubP1 <> -4 And MapSubP2 <> -4 Then

    Select Case Mapper

      Case MapSubP1

        Mapper = MapSubP2

    End Select

  End If

  Select Case Mapper

    Case 0, 2, 3, 12, 21, 22, 23, 25, 26, 32, 33, 70, 73, 75, 83, 79, 126, 195, 228, 41, 243, 85, 101, 82, 222

      If ChrCount Then

        Call select8kvrom(0)

      End If

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

    Case 5, 99, 100, 150, 151, 152

      If ChrCount Then

        Call select8kvrom(0)

      End If

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

    Case 1, 69, 121, 142

      Call select8kvrom(0)

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

      sequence = 0

      accumulator = 0

      Erase Data

      Data(0) = &H1F

      Data(3) = 0

    Case 4, 45, 5, 72, 74, 76, 88, 95, 118, 119, 232, 245, 248

      swap = False

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call map4_sync

      MMC3_IrqVal = 0

      MMC3_IrqOn = False

      MMC3_TmpVal = 0

      If ChrCount Then

        Call select8kvrom(0)

      End If

    Case 6

      reg8 = &H0

      regA = &H1

      regC = &H7

      regE = &H8

      Call setupbanks

      If ChrCount Then

        Call select8kvrom(0)

      End If

    Case 7, 8, 14, 51, 58, 231, 60, 51, 113

      reg8 = 0

      regA = 1

      regC = 2

      regE = 3

      Call setupbanks

      Call select8kvrom(0)

    Case 9, 10, 77

      reg8 = 0

      regA = &HFD

      regC = &HFE

      regE = &HFF

      Call setupbanks

      latch1 = &HFE

      latch2 = &HFE

      Call select8kvrom(0)

    Case 11, 57, 200, 201, 203

      reg8 = 0

      regA = 1

      regC = 2

      regE = 3

      Call setupbanks

      Call select8kvrom(0)

    Case 13, 240

      reg8 = 0

      regA = 1

      regC = 2

      regE = 3

      Call setupbanks

      Call select4kvrom(0, 0)

      Call select4kvrom(0, 1)

      latch13 = 0

    Case 15

      reg8 = 0

      regA = 1

      regC = 2

      regE = 3

      Call setupbanks

    Case 16

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

      MMC16_Irq = 0

      MMC16_IrqOn = 0

      SpecialWrite6000 = True

    Case 17

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

      map17_irq = 0

      map17_irqon = False

    Case 18

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

      map17_irq = 0

      map17_irqon = False

    Case 19

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

      Call select8kvrom(ChrCount - 1)

    Case 24

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

      map24_irqv = 0

      map24_irqon = 0

    Case 34

      SpecialWrite6000 = True

      reg8 = 0

      regA = 1

      regC = 2

      regE = 3

      Call setupbanks

      If ChrCount Then

        Call select8kvrom(0)

      End If

    Case 40

      ChoseIt = 6

      ChoseIt = maskbankaddress(ChoseIt)

      UsesSRAM = True

      Call MemCopy(bank6(0), gameImage(ChoseIt * &H2000&), &H2000&)

      reg8 = &HFC

      regA = &HFD

      regC = &HFE

      regE = &HFF

      Call setupbanks

      Call select8kvrom(0)

      Mapper40_IRQEnabled = 0

      Mapper40_IRQCounter = 0

    Case 64

      banks = PrgCount * 2

      reg8 = &HFF

      regA = reg8

      regC = reg8

      regE = reg8

      Call setupbanks

      If ChrCount Then

        Call select8kvrom(0)

      End If

      cmd = 0

      chr1 = 0

      prg = 0

    Case 65

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

    Case 66, 229

      reg8 = 0

      regA = 1

      regC = 2

      regE = 3

      Call setupbanks

      Call select8kvrom(0)

      Call setupbanks

    Case 68

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call select8kvrom(0)

      Call setupbanks

      UsesSRAM = True

    Case 69

      reg8 = 0

      regA = 1

      regC = 2

      regE = &HFF

      Call setupbanks

      Call select8kvrom(0)

    Case 71

      reg8 = 0

      regA = 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

    Case 78

      regC = &HFE

      regE = &HFF

      Call setupbanks

      Call map78_write(0, 0)

    Case 90, 160

      reg8 = &HFC

      regA = &HFD

      regC = &HFE

      regE = &HFF

      Call setupbanks

    Case 91

      SpecialWrite6000 = True

      reg8 = &HFE

      regA = &HFF

      regC = &HFE

      regE = &HFF

      Call select8kvrom(0)

      Call setupbanks

    Case Else

      frmNES.Caption = "olafnes - #" & Mapper & " unsupported"

      Erase gameImage, VROM

      Close #FileNum

      loadnes = 0

      Exit Function

  End Select

  Call reset6502

  If Mirroring = 1 Then

    MirrorXor = &H800&

  Else

    MirrorXor = &H400&

  End If

  If FourScreen Then

    Mirroring = 4

  End If

  Call domirror

  Close #FileNum

  CurrentLine = 0

  For i = 0 To 7

    Joypad1(i) = &H40

    Joypad2(i) = &H40

  Next i

  FileNum = FreeFile

  If UsesSRAM = True Then

    If Dir(App.Path & "\sram\" & romName & ".sr" & CStr(SlotSRAM)) <> "" Then

      Open App.Path & "\sram\" & romName & ".sr" & CStr(SlotSRAM) For Binary Access Read As #FileNum

      Get #FileNum, , bank6

      Close #FileNum

    End If

    frmNES.savesramf.Enabled = True

    frmNES.sramload.Enabled = True

  End If

  Frames = 0

  CPUPaused = False

  ScrollToggle = 1

  frmNES.mnuFileRomInfo.Enabled = True

  frmNES.mnuFileFree.Enabled = True

  loadnes = 1

  Exit Function

errorhandler:

  Call frmNES.mnuFileFree_Click

  frmNES.Caption = "olafnes - error"

End Function
Public Function getfromini(Section As String, Key As String, Directory As String) As String

  Dim strBuffer As String

  strBuffer = String(750, Chr(0))

  Key$ = LCase$(Key$)

  Section$ = LCase$(Section$)

  getfromini$ = Left(strBuffer, GetPrivateProfileString(Section$, ByVal Key$, "", strBuffer, Len(strBuffer), Directory$))

End Function
Public Sub writetoini(Section As String, Key As String, KeyValue As String, Directory As String)

  Call WritePrivateProfileString(LCase$(Section$), LCase$(Key$), LCase$(KeyValue$), Directory$)

End Sub
Public Sub map17_write(address As Long, value As Byte)

  Select Case address

    Case &H42FE

    Case &H42FF

    Case &H4501

      map17_irqon = (value And &H1)

    Case &H4502

      map17_irq = &HFF00&

      map17_irq = map17_irq Or value

    Case &H4503

      map17_irq = &HFF

      map17_irq = map17_irq Or value * &H100&

      map17_irqon = 1

    Case &H4504

      reg8 = value

      Call setupbanks

    Case &H4505

      regA = value

      Call setupbanks

    Case &H4506

      regC = value

      Call setupbanks

    Case &H4507

      regE = value

      Call setupbanks

    Case &H4510 To &H4517

      Call select1kvrom(value, address - &H4510)

  End Select

End Sub
Public Sub map17_doirq()

  If map17_irqon Then

    map17_irq = (map17_irq + 1)

    If map17_irq = &H10000 Then

      Call irq6502

      map17_irqon = False

      map17_irq = 0

    End If

  End If

End Sub
Public Sub map23_write(address As Long, value As Byte)

  'unfinished

  Select Case address

    Case &H8000&

      reg8 = value

      Call setupbanks

    Case &H9000&

      MirrorXor = pow2((value And &H3) + 10) '&H400& * pow2(value And &H3)

    Case &HA000&

      regA = value

      Call setupbanks

    Case &HA000&

      regA = value

      Call setupbanks

  End Select

End Sub
Public Sub map1_write(address As Long, value As Byte)

  Dim bank_select As Long

  If (value And &H80) Then

    Data(0) = Data(0) Or &HC

    accumulator = Data((address \ &H2000&) And 3)

    sequence = 5

  Else

    If value And 1 Then

      accumulator = accumulator Or pow2(sequence)

    End If

    sequence = sequence + 1

  End If

  If (sequence = 5) Then

    Data(address \ &H2000& And 3) = accumulator

    sequence = 0

    accumulator = 0

    If (PrgCount = &H20) Then

      bank_select = (Data(1) And &H10) * 2

    Else

      bank_select = 0

    End If

    If Data(0) And 2 Then

      Mirroring = (Data(0) And 1) Xor 1

    Else

      Mirroring = 2

    End If

    Call domirror

    Select Case Mirroring

      Case 0

        MirrorXor = &H400

      Case 1

        MirrorXor = &H800

      Case 2

        MirrorXor = 0

    End Select

    If (Data(0) And 8) = 0 Then

      reg8 = 4 * (Data(3) And 15) + bank_select

      regA = 4 * (Data(3) And 15) + bank_select + 1

      regC = 4 * (Data(3) And 15) + bank_select + 2

      regE = 4 * (Data(3) And 15) + bank_select + 3

      Call setupbanks

    ElseIf (Data(0) And 4) Then

      reg8 = ((Data(3) And 15) * 2) + bank_select

      regA = ((Data(3) And 15) * 2) + bank_select + 1

      regC = &HFE

      regE = &HFF

      Call setupbanks

    Else

      reg8 = 0

      regA = 1

      regC = ((Data(3) And 15) * 2) + bank_select

      regE = ((Data(3) And 15) * 2) + bank_select + 1

      Call setupbanks

    End If

    If (Data(0) And &H10) Then

      Call select4kvrom(Data(1), 0)

      Call select4kvrom(Data(2), 1)

    Else

      Call select8kvrom(Data(1) \ 2)

    End If

  End If

End Sub
Public Sub map2_write(address As Long, value As Byte)

  reg8 = (value * 2)

  regA = reg8 + 1

  Call setupbanks

End Sub
Public Sub map3_write(address As Long, value As Byte)

  Call select8kvrom(value)

End Sub
Public Sub map151_write(address As Long, value As Byte)

  Select Case address

    Case &H8000&

      Call select8kvrom(&H8000&)

    Case &HA000&

      Call select8kvrom(&HA000&)

    Case &HC000&

      Call select8kvrom(&HC000&)

    Case &HE000&

      Call select8kvrom(&H0&)

    Case &HF000&

      Call select8kvrom(&H1000&)

  End Select

End Sub
Public Sub map4_write(address As Long, value As Byte)

  Select Case address

    Case &H8000&

      MMC3_Command = value And &H7

      If value And &H80 Then

        MMC3_ChrAddr = &H1000&

      Else

        MMC3_ChrAddr = 0

      End If

      If value And &H40 Then

        swap = 1

      Else

        swap = 0

      End If

    Case &H8001&

      Select Case MMC3_Command

        Case 0

          Call select1kvrom(value, 0)

          Call select1kvrom(value + 1, 1)

        Case 1

          Call select1kvrom(value, 2)

          Call select1kvrom(value + 1, 3)

        Case 2

          Call select1kvrom(value, 4)

        Case 3

          Call select1kvrom(value, 5)

        Case 4

          Call select1kvrom(value, 6)

        Case 5

          Call select1kvrom(value, 7)

        Case 6

          PrgSwitch1 = value

          Call map4_sync

        Case 7

          PrgSwitch2 = value

          Call map4_sync

      End Select

    Case &HA000&

      If value And 1 Then

        Mirroring = 0

      Else

        Mirroring = 1

      End If

      Call domirror

    Case &HA001&

      If value Then

        UsesSRAM = True

      Else

        UsesSRAM = False

      End If

    Case &HC000&

      MMC3_IrqVal = value

    Case &HC001&

      MMC3_TmpVal = value

    Case &HE000&

      MMC3_IrqOn = False

      MMC3_IrqVal = MMC3_TmpVal

    Case &HE001&

      MMC3_IrqOn = True

  End Select

End Sub
Public Function map4_hblank(Scanline, two As Byte) As Boolean

  If Scanline = 0 Then

    MMC3_IrqVal = MMC3_TmpVal

  ElseIf Scanline > 239 Then

    Exit Function

  ElseIf MMC3_IrqOn And (two And &H18) Then

    MMC3_IrqVal = (MMC3_IrqVal - 1) And &HFF

    If (MMC3_IrqVal = 0) Then

      Call irq6502

      MMC3_IrqVal = MMC3_TmpVal

    End If

  End If

End Function
Public Sub map7_write(address As Long, value As Byte)

  reg8 = 4 * (value And &HF)

  regA = reg8 + 1

  regC = reg8 + 2

  regE = reg8 + 3

  Call setupbanks

  Mirroring = 2

  Call domirror

End Sub
Public Sub map9_write(address As Long, value As Byte)

  Static bnk As Long

  Select Case (address And &HF000&)

    Case &HA000&

      If Mapper = 9 Or Mapper = 77 Then

        reg8 = value

      ElseIf Mapper = 10 Then

        reg8 = value * 2

        regA = reg8 + 1

      End If

      Call setupbanks

    Case &HB000&

      Latch0FD = value

      If latch1 = &HFD Then

        Call select4kvrom(value, 0)

      End If

    Case &HC000&

      Latch0FE = value

      If latch1 = &HFE Then

        Call select4kvrom(value, 0)

      End If

    Case &HD000&

      Latch1FD = value

      If latch2 = &HFD Then

        Call select4kvrom(value, 1)

      End If

    Case &HE000&

      Latch1FE = value

      If latch2 = &HFE Then

        Call select4kvrom(value, 1)

      End If

    Case &HF000&

      If (value And 1) Then

        Mirroring = 0

      ElseIf (value And 1) = 0 Then

        Mirroring = 1

      End If

  End Select

End Sub
Public Sub map9_latch(TileNum As Byte, Hi As Boolean)

  If Mapper <> 9 Then

    Exit Sub

  End If

  If (TileNum = &HFD) Then

    If (Hi = False) Then

      Call select4kvrom(Latch0FD, 0)

      latch1 = &HFD

    ElseIf (Hi = True) Then

      Call select4kvrom(Latch1FD, 1)

      latch2 = &HFD

    End If

  ElseIf (TileNum = &HFE) Then

    If (Hi = False) Then

      Call select4kvrom(Latch0FE, 0)

      latch1 = &HFE

    ElseIf (Hi = True) Then

      Call select4kvrom(Latch1FE, 1)

      latch2 = &HFE

    End If

  End If

End Sub
Public Sub drawsprites(ontop As Boolean)

  Dim SpritePattern As Long, spr As Long, X1 As Long, y1 As Long, Byte1 As Byte, Byte2 As Byte, Color As Byte, sa As Long, h As Long, i As Long, X As Long, Y As Long, attrib As Long, tileno As Long, pal As Long, aa As Long

  If frmNES.mnuvideo.Checked = True Or frmNES.disablesprites.Checked = True Or (PPU_Control2 And 16) = 0 Then

    Exit Sub

  End If

  SpritePattern = (PPU_Control1 And &H8) * &H200&
    
  If PPU_Control1 And &H20 Then

    h = 16

  Else

    h = 8

  End If
    
  SpriteAddr = 0
    
  For spr = 63 To 0 Step -1

    SpriteAddr = 4 * spr

    attrib = SpriteRAM(SpriteAddr + 2)

    If (attrib And 32) = 0 Xor ontop Then

      X = SpriteRAM(SpriteAddr + 3)

      Y = SpriteRAM(SpriteAddr)

      If Y < 239 And X < 248 Then

        tileno = SpriteRAM(SpriteAddr + 1)

        If h = 16 Then

          SpritePattern = (tileno And 1) * &H1000

          tileno = tileno Xor (tileno And 1)

        End If

        sa = SpritePattern + 16 * tileno

        i = Y * 256& + X + 256

        pal = 16 + (attrib And 3) * 4

        If attrib And 128 Then

          If attrib And 64 Then

            For y1 = h - 1 To 0 Step -1

              If y1 >= 8 Then

                Byte1 = VRAM(sa + 8 + y1)

                Byte2 = VRAM(sa + 16 + y1)

              Else

                Byte1 = VRAM(sa + y1)

                Byte2 = VRAM(sa + y1 + 8)

              End If

              aa = Byte1 * 2048& + Byte2 * 8

              For X1 = 0 To 7

                Color = tLook(X1 + aa)

                If Color Then

                  vBuffer(i + X1) = Color Or pal

                End If

              Next X1

              i = i + 256

              If i >= 256& * 240 Then

                Exit For

              End If

            Next y1

          Else

            i = i + 7

            For y1 = h - 1 To 0 Step -1

              If y1 >= 8 Then

                Byte1 = VRAM(sa + 8 + y1)

                Byte2 = VRAM(sa + 16 + y1)

              Else

                Byte1 = VRAM(sa + y1)

                Byte2 = VRAM(sa + y1 + 8)

              End If

              aa = Byte1 * 2048& + Byte2 * 8

              For X1 = 7 To 0 Step -1

                Color = tLook(X1 + aa)

                If Color Then

                  vBuffer(i - X1) = Color Or pal

                End If

              Next X1

              i = i + 256

              If i >= 256& * 240 Then

                Exit For

              End If

            Next y1

          End If

        Else

          If attrib And 64 Then

            For y1 = 0 To h - 1

              If y1 = 8 Then

                sa = sa + 8

              End If

              Byte1 = VRAM(sa + y1)

              Byte2 = VRAM(sa + y1 + 8)

              aa = Byte1 * 2048& + Byte2 * 8

              For X1 = 0 To 7

                Color = tLook(X1 + aa)

                If Color Then

                  vBuffer(i + X1) = Color Or pal

                End If

              Next X1

              i = i + 256

              If i >= 256& * 240 Then

                Exit For

              End If

            Next y1

          Else

            i = i + 7

            For y1 = 0 To h - 1

              If y1 = 8 Then

                sa = sa + 8

              End If

              Byte1 = VRAM(sa + y1)

              Byte2 = VRAM(sa + y1 + 8)

              aa = Byte1 * 2048& + Byte2 * 8

              For X1 = 7 To 0 Step -1

                Color = tLook(X1 + aa)

                If Color Then

                  vBuffer(i - X1) = Color Or pal

                End If

              Next X1

              i = i + 256

              If i >= 256& * 240 Then

                Exit For

              End If

            Next y1

          End If

        End If

      End If

    End If

  Next spr

End Sub
Public Sub loadpal(file As String)

  On Error Resume Next

  Dim n As Long, r As Byte, g As Byte, b As Byte, FileNum As Integer

  FileNum = FreeFile

  Open file For Binary As #FileNum

  For n = 0 To 63

    Get #FileNum, , r

    Get #FileNum, , g

    Get #FileNum, , b

    pal(n) = rgb2(r, g, b)

    pal16(n) = rgb16(r, g, b)

    pal15(n) = rgb15(r, g, b)

    pal(n + 64) = pal(n)

    pal(n + 128) = pal(n)

    pal(n + 192) = pal(n)

    pal16(n + 64) = pal16(n)

    pal16(n + 128) = pal16(n)

    pal16(n + 192) = pal16(n)

    pal15(n + 64) = pal15(n)

    pal15(n + 128) = pal15(n)

    pal15(n + 192) = pal15(n)

  Next n

  Close #FileNum

End Sub
Public Sub genpal()

  On Error Resume Next

  Dim n As Long, r As Byte, g As Byte, b As Byte

  For n = 0 To 63

    r = Int(Rnd * 255) + 1

    r = r - 1

    g = Int(Rnd * 255) + 1

    g = g - 1

    b = Int(Rnd * 255) + 1

    b = b - 1

    pal(n) = rgb2(r, g, b)

    pal16(n) = rgb16(r, g, b)

    pal15(n) = rgb15(r, g, b)

    pal(n + 64) = pal(n)

    pal(n + 128) = pal(n)

    pal(n + 192) = pal(n)

    pal16(n + 64) = pal16(n)

    pal16(n + 128) = pal16(n)

    pal16(n + 192) = pal16(n)

    pal15(n + 64) = pal15(n)

    pal15(n + 128) = pal15(n)

    pal15(n + 192) = pal15(n)

  Next n

  frmNES.Caption = "olafnes - palette generated"

End Sub
Public Sub invertpal2(file As String)

  On Error Resume Next

  Dim n As Long, r As Byte, g As Byte, b As Byte, FileNum As Integer

  FileNum = FreeFile

  Open file For Binary As #FileNum

  For n = 0 To 63

    Get #FileNum, , r

    Get #FileNum, , g

    Get #FileNum, , b

    pal(n) = rgb2(r, g, b)

    pal16(n) = rgb16(r, g, b)

    pal15(n) = rgb15(r, g, b)

    pal(n + 64) = pal(n)

    pal(n + 128) = pal(n)

    pal(n + 192) = pal(n)

    pal16(n + 64) = pal16(n)

    pal16(n + 128) = pal16(n)

    pal16(n + 192) = pal16(n)

    pal15(n + 64) = pal15(n)

    pal15(n + 128) = pal15(n)

    pal15(n + 192) = pal15(n)

  Next n

  Close #FileNum

End Sub
Public Sub invertpal(file As String)

  On Error Resume Next

  Dim n As Long, r As Byte, g As Byte, b As Byte, FileNum As Integer

  FileNum = FreeFile

  Open file For Binary As #FileNum

  For n = 0 To 63

    Get #FileNum, , r

    Get #FileNum, , g

    Get #FileNum, , b

    r = (255 - r)

    g = (255 - g)

    b = (255 - b)

    pal(n) = rgb2(r, g, b)

    pal16(n) = rgb16(r, g, b)

    pal15(n) = rgb15(r, g, b)

    pal(n + 64) = pal(n)

    pal(n + 128) = pal(n)

    pal(n + 192) = pal(n)

    pal16(n + 64) = pal16(n)

    pal16(n + 128) = pal16(n)

    pal16(n + 192) = pal16(n)

    pal15(n + 64) = pal15(n)

    pal15(n + 128) = pal15(n)

    pal15(n + 192) = pal15(n)

  Next n

  Close #FileNum

End Sub
Public Function rgb2(ByVal b As Long, ByVal g As Long, ByVal r As Long) As Long

  rgb2 = RGB(r, g, b)

End Function
Function rgb16(ByVal b As Long, ByVal g As Long, ByVal r As Long) As Long

  Dim c As Long

  c = (r \ 8) + (g \ 4) * 32 + (b \ 8) * 2048

  If c > 32767 Then

    c = c - 65536

  End If

  rgb16 = c

End Function
Public Function rgb15(ByVal b As Long, ByVal g As Long, ByVal r As Long) As Long

  rgb15 = (r \ 8) + (g \ 8) * 32 + (b \ 8) * 1024

End Function
Public Sub copybanks(dest, src, Count)

  On Error Resume Next

  Dim i

  Select Case Mapper

    Case 4, 45, 5, 74, 72, 76, 88, 95, 118, 119, 232, 245, 248 And allowXor

      For i = 0 To Count - 1

        Call MemCopy(VRAM(MMC3_ChrAddr Xor (dest + i) * &H400), VROM((src + i) * &H400), &H400)

      Next i

    Case Else

      Call MemCopy(VRAM(dest * &H400), VROM(src * &H400), Count * &H400)

  End Select

End Sub
Public Sub bankswitch(ByVal dest, ByVal src, ByVal Count)

  Dim aa, b, c

  aa = 0

  c = 0

  allowXor = Count <= 2

  For b = 0 To Count - 1

    If prevBSSrc(dest + b) <> src + b Then

      c = c + 1

      prevBSSrc(dest + b) = src + b

    Else

      If c > 0 Then

        Call copybanks(dest + aa, src + aa, c)

      End If

      aa = b + 1

      c = 0

    End If

  Next b

  If c > 0 Then

    Call copybanks(dest + aa, src + aa, c)

  End If

End Sub
Public Sub mmc_reset()

  On Error Resume Next

  Dim i As Long

  p8 = -1

  pA = -1

  rc = -1

  pE = -1

  For i = 0 To 7

    prevBSSrc(i) = -1

  Next i

End Sub
Public Sub map4_sync()

  If swap Then

    reg8 = &HFE

    regA = PrgSwitch2

    regC = PrgSwitch1

    regE = &HFF

  Else

    reg8 = PrgSwitch1

    regA = PrgSwitch2

    regC = &HFE

    regE = &HFF

  End If

  Call setupbanks

End Sub
Public Function maskbankaddress(bank As Byte)

  Dim i As Byte

  If bank >= PrgCount * 2 Then

    i = &HFF

    Do

      i = i \ 2

    Loop While (bank And i) >= PrgCount * 2

    maskbankaddress = (bank And i)

  Else

    maskbankaddress = bank

  End If

End Function
Public Function maskvrom(page As Byte, ByVal mask As Long) As Byte

  Dim i As Long

  If mask = 0 Then

    mask = 256

  End If

  If mask And mask - 1 Then

    i = 1

    Do

      i = i + i

    Loop While i < mask

  Else

    i = mask

  End If

  i = (page And (i - 1))

  If i >= mask Then

    i = mask - 1

  End If

  maskvrom = i

End Function
Public Sub setupbanks()

  On Error Resume Next

  reg8 = maskbankaddress(reg8)

  regA = maskbankaddress(regA)

  regC = maskbankaddress(regC)

  regE = maskbankaddress(regE)

  If p8 <> reg8 Then

    Call MemCopy(bank8(0), gameImage(reg8 * &H2000&), &H2000&)

  End If

  If pA <> regA Then

    Call MemCopy(bankA(0), gameImage(regA * &H2000&), &H2000&)

  End If

  If rc <> regC Then

    Call MemCopy(bankC(0), gameImage(regC * &H2000&), &H2000&)

  End If

  If pE <> regE Then

    Call MemCopy(bankE(0), gameImage(regE * &H2000&), &H2000&)

  End If

  p8 = reg8

  pA = regA

  rc = regC

  pE = regE

End Sub
Public Sub select8kvrom(val1 As Byte)

  val1 = maskvrom(val1, ChrCount)

  Call bankswitch(0, val1 * 8, 8)

End Sub
Public Sub select4kvrom(val1 As Byte, bank As Byte)

  val1 = maskvrom(val1, ChrCount * 2)

  Call bankswitch(bank * 4, val1 * 4, 4)

End Sub
Public Sub select2kvrom(val1 As Byte, bank As Byte)

  val1 = maskvrom(val1, ChrCount * 4)

  Call bankswitch(bank * 2, val1 * 2, 2)

End Sub
Public Sub select1kvrom(val1 As Byte, bank As Byte)

  val1 = maskvrom(val1, ChrCount * 8)

  Call bankswitch(bank, val1, 1)

End Sub
Public Function init6502()

  Ticks(&H0) = 7

  instruction(&H0) = INS_BRK

  addrmode(&H0) = ADR_IMP

  Ticks(&H1) = 6

  instruction(&H1) = INS_ORA

  addrmode(&H1) = ADR_INDX

  Ticks(&H2) = 2

  instruction(&H2) = INS_NOP

  addrmode(&H2) = ADR_IMP

  Ticks(&H3) = 2

  instruction(&H3) = INS_NOP

  addrmode(&H3) = ADR_IMP

  Ticks(&H4) = 3

  instruction(&H4) = INS_NOP

  addrmode(&H4) = ADR_ZP

  Ticks(&H5) = 3

  instruction(&H5) = INS_ORA

  addrmode(&H5) = ADR_ZP

  Ticks(&H6) = 5

  instruction(&H6) = INS_ASL

  addrmode(&H6) = ADR_ZP

  Ticks(&H7) = 2

  instruction(&H7) = INS_NOP

  addrmode(&H7) = ADR_IMP

  Ticks(&H8) = 3

  instruction(&H8) = INS_PHP

  addrmode(&H8) = ADR_IMP

  Ticks(&H9) = 3

  instruction(&H9) = INS_ORA

  addrmode(&H9) = ADR_IMM

  Ticks(&HA) = 2

  instruction(&HA) = INS_ASLA

  addrmode(&HA) = ADR_IMP

  Ticks(&HB) = 2

  instruction(&HB) = INS_NOP

  addrmode(&HB) = ADR_IMP

  Ticks(&HC) = 4

  instruction(&HC) = INS_NOP

  addrmode(&HC) = ADR_ABS

  Ticks(&HD) = 4

  instruction(&HD) = INS_ORA

  addrmode(&HD) = ADR_ABS

  Ticks(&HE) = 6

  instruction(&HE) = INS_ASL

  addrmode(&HE) = ADR_ABS

  Ticks(&HF) = 2

  instruction(&HF) = INS_NOP

  addrmode(&HF) = ADR_IMP

  Ticks(&H10) = 2

  instruction(&H10) = INS_BPL

  addrmode(&H10) = ADR_REL

  Ticks(&H11) = 5

  instruction(&H11) = INS_ORA

  addrmode(&H11) = ADR_INDY

  Ticks(&H12) = 3

  instruction(&H12) = INS_ORA

  addrmode(&H12) = ADR_INDZP

  Ticks(&H13) = 2

  instruction(&H13) = INS_NOP

  addrmode(&H13) = ADR_IMP

  Ticks(&H14) = 3

  instruction(&H14) = INS_NOP

  addrmode(&H14) = ADR_ZP

  Ticks(&H15) = 4

  instruction(&H15) = INS_ORA

  addrmode(&H15) = ADR_ZPX

  Ticks(&H16) = 6

  instruction(&H16) = INS_ASL

  addrmode(&H16) = ADR_ZPX

  Ticks(&H17) = 2

  instruction(&H17) = INS_NOP

  addrmode(&H17) = ADR_IMP

  Ticks(&H18) = 2

  instruction(&H18) = INS_CLC

  addrmode(&H18) = ADR_IMP

  Ticks(&H19) = 4

  instruction(&H19) = INS_ORA

  addrmode(&H19) = ADR_ABSY

  Ticks(&H1A) = 2

  instruction(&H1A) = INS_INA

  addrmode(&H1A) = ADR_IMP

  Ticks(&H1B) = 2

  instruction(&H1B) = INS_NOP

  addrmode(&H1B) = ADR_IMP

  Ticks(&H1C) = 4

  instruction(&H1C) = INS_NOP

  addrmode(&H1C) = ADR_ABS

  Ticks(&H1D) = 4

  instruction(&H1D) = INS_ORA

  addrmode(&H1D) = ADR_ABSX

  Ticks(&H1E) = 7

  instruction(&H1E) = INS_ASL

  addrmode(&H1E) = ADR_ABSX

  Ticks(&H1F) = 2

  instruction(&H1F) = INS_NOP

  addrmode(&H1F) = ADR_IMP

  Ticks(&H20) = 6

  instruction(&H20) = INS_JSR

  addrmode(&H20) = ADR_ABS

  Ticks(&H21) = 6

  instruction(&H21) = INS_AND

  addrmode(&H21) = ADR_INDX

  Ticks(&H22) = 2

  instruction(&H22) = INS_NOP

  addrmode(&H22) = ADR_IMP

  Ticks(&H23) = 2

  instruction(&H23) = INS_NOP

  addrmode(&H23) = ADR_IMP

  Ticks(&H24) = 3

  instruction(&H24) = INS_BIT

  addrmode(&H24) = ADR_ZP

  Ticks(&H25) = 3

  instruction(&H25) = INS_AND

  addrmode(&H25) = ADR_ZP

  Ticks(&H26) = 5

  instruction(&H26) = INS_ROL

  addrmode(&H26) = ADR_ZP

  Ticks(&H27) = 2

  instruction(&H27) = INS_NOP

  addrmode(&H27) = ADR_IMP

  Ticks(&H28) = 4

  instruction(&H28) = INS_PLP

  addrmode(&H28) = ADR_IMP

  Ticks(&H29) = 3

  instruction(&H29) = INS_AND

  addrmode(&H29) = ADR_IMM

  Ticks(&H2A) = 2

  instruction(&H2A) = INS_ROLA

  addrmode(&H2A) = ADR_IMP

  Ticks(&H2B) = 2

  instruction(&H2B) = INS_NOP

  addrmode(&H2B) = ADR_IMP

  Ticks(&H2C) = 4

  instruction(&H2C) = INS_BIT

  addrmode(&H2C) = ADR_ABS

  Ticks(&H2D) = 4

  instruction(&H2D) = INS_AND

  addrmode(&H2D) = ADR_ABS

  Ticks(&H2E) = 6

  instruction(&H2E) = INS_ROL

  addrmode(&H2E) = ADR_ABS

  Ticks(&H2F) = 2

  instruction(&H2F) = INS_NOP

  addrmode(&H2F) = ADR_IMP

  Ticks(&H30) = 2

  instruction(&H30) = INS_BMI

  addrmode(&H30) = ADR_REL

  Ticks(&H31) = 5

  instruction(&H31) = INS_AND

  addrmode(&H31) = ADR_INDY

  Ticks(&H32) = 3

  instruction(&H32) = INS_AND

  addrmode(&H32) = ADR_INDZP

  Ticks(&H33) = 2

  instruction(&H33) = INS_NOP

  addrmode(&H33) = ADR_IMP

  Ticks(&H34) = 4

  instruction(&H34) = INS_BIT

  addrmode(&H34) = ADR_ZPX

  Ticks(&H35) = 4

  instruction(&H35) = INS_AND

  addrmode(&H35) = ADR_ZPX

  Ticks(&H36) = 6

  instruction(&H36) = INS_ROL

  addrmode(&H36) = ADR_ZPX

  Ticks(&H37) = 2

  instruction(&H37) = INS_NOP

  addrmode(&H37) = ADR_IMP

  Ticks(&H38) = 2

  instruction(&H38) = INS_SEC

  addrmode(&H38) = ADR_IMP

  Ticks(&H39) = 4

  instruction(&H39) = INS_AND

  addrmode(&H39) = ADR_ABSY

  Ticks(&H3A) = 2

  instruction(&H3A) = INS_DEA

  addrmode(&H3A) = ADR_IMP

  Ticks(&H3B) = 2

  instruction(&H3B) = INS_NOP

  addrmode(&H3B) = ADR_IMP

  Ticks(&H3C) = 4

  instruction(&H3C) = INS_BIT

  addrmode(&H3C) = ADR_ABSX

  Ticks(&H3D) = 4

  instruction(&H3D) = INS_AND

  addrmode(&H3D) = ADR_ABSX

  Ticks(&H3E) = 7

  instruction(&H3E) = INS_ROL

  addrmode(&H3E) = ADR_ABSX

  Ticks(&H3F) = 2

  instruction(&H3F) = INS_NOP

  addrmode(&H3F) = ADR_IMP

  Ticks(&H40) = 6

  instruction(&H40) = INS_RTI

  addrmode(&H40) = ADR_IMP

  Ticks(&H41) = 6

  instruction(&H41) = INS_EOR

  addrmode(&H41) = ADR_INDX

  Ticks(&H42) = 2

  instruction(&H42) = INS_NOP

  addrmode(&H42) = ADR_IMP

  Ticks(&H43) = 2

  instruction(&H43) = INS_NOP

  addrmode(&H43) = ADR_IMP

  Ticks(&H44) = 2

  instruction(&H44) = INS_NOP

  addrmode(&H44) = ADR_IMP

  Ticks(&H45) = 3

  instruction(&H45) = INS_EOR

  addrmode(&H45) = ADR_ZP

  Ticks(&H46) = 5

  instruction(&H46) = INS_LSR

  addrmode(&H46) = ADR_ZP

  Ticks(&H47) = 2

  instruction(&H47) = INS_NOP

  addrmode(&H47) = ADR_IMP

  Ticks(&H48) = 3

  instruction(&H48) = INS_PHA

  addrmode(&H48) = ADR_IMP

  Ticks(&H49) = 3

  instruction(&H49) = INS_EOR

  addrmode(&H49) = ADR_IMM

  Ticks(&H4A) = 2

  instruction(&H4A) = INS_LSRA

  addrmode(&H4A) = ADR_IMP

  Ticks(&H4B) = 2

  instruction(&H4B) = INS_NOP

  addrmode(&H4B) = ADR_IMP

  Ticks(&H4C) = 3

  instruction(&H4C) = INS_JMP

  addrmode(&H4C) = ADR_ABS

  Ticks(&H4D) = 4

  instruction(&H4D) = INS_EOR

  addrmode(&H4D) = ADR_ABS

  Ticks(&H4E) = 6

  instruction(&H4E) = INS_LSR

  addrmode(&H4E) = ADR_ABS

  Ticks(&H4F) = 2

  instruction(&H4F) = INS_NOP

  addrmode(&H4F) = ADR_IMP

  Ticks(&H50) = 2

  instruction(&H50) = INS_BVC

  addrmode(&H50) = ADR_REL

  Ticks(&H51) = 5

  instruction(&H51) = INS_EOR

  addrmode(&H51) = ADR_INDY

  Ticks(&H52) = 3

  instruction(&H52) = INS_EOR

  addrmode(&H52) = ADR_INDZP

  Ticks(&H53) = 2

  instruction(&H53) = INS_NOP

  addrmode(&H53) = ADR_IMP

  Ticks(&H54) = 2

  instruction(&H54) = INS_NOP

  addrmode(&H54) = ADR_IMP

  Ticks(&H55) = 4

  instruction(&H55) = INS_EOR

  addrmode(&H55) = ADR_ZPX

  Ticks(&H56) = 6

  instruction(&H56) = INS_LSR

  addrmode(&H56) = ADR_ZPX

  Ticks(&H57) = 2

  instruction(&H57) = INS_NOP

  addrmode(&H57) = ADR_IMP

  Ticks(&H58) = 2

  instruction(&H58) = INS_CLI

  addrmode(&H58) = ADR_IMP

  Ticks(&H59) = 4

  instruction(&H59) = INS_EOR

  addrmode(&H59) = ADR_ABSY

  Ticks(&H5A) = 3

  instruction(&H5A) = INS_PHY

  addrmode(&H5A) = ADR_IMP

  Ticks(&H5B) = 2

  instruction(&H5B) = INS_NOP

  addrmode(&H5B) = ADR_IMP

  Ticks(&H5C) = 2

  instruction(&H5C) = INS_NOP

  addrmode(&H5C) = ADR_IMP

  Ticks(&H5D) = 4

  instruction(&H5D) = INS_EOR

  addrmode(&H5D) = ADR_ABSX

  Ticks(&H5E) = 7

  instruction(&H5E) = INS_LSR

  addrmode(&H5E) = ADR_ABSX

  Ticks(&H5F) = 2

  instruction(&H5F) = INS_NOP

  addrmode(&H5F) = ADR_IMP

  Ticks(&H60) = 6

  instruction(&H60) = INS_RTS

  addrmode(&H60) = ADR_IMP

  Ticks(&H61) = 6

  instruction(&H61) = INS_ADC

  addrmode(&H61) = ADR_INDX

  Ticks(&H62) = 2

  instruction(&H62) = INS_NOP

  addrmode(&H62) = ADR_IMP

  Ticks(&H63) = 2

  instruction(&H63) = INS_NOP

  addrmode(&H63) = ADR_IMP

  Ticks(&H64) = 3

  instruction(&H64) = INS_NOP

  addrmode(&H64) = ADR_ZP

  Ticks(&H65) = 3

  instruction(&H65) = INS_ADC

  addrmode(&H65) = ADR_ZP

  Ticks(&H66) = 5

  instruction(&H66) = INS_ROR

  addrmode(&H66) = ADR_ZP

  Ticks(&H67) = 2

  instruction(&H67) = INS_NOP

  addrmode(&H67) = ADR_IMP

  Ticks(&H68) = 4

  instruction(&H68) = INS_PLA

  addrmode(&H68) = ADR_IMP

  Ticks(&H69) = 3

  instruction(&H69) = INS_ADC

  addrmode(&H69) = ADR_IMM

  Ticks(&H6A) = 2

  instruction(&H6A) = INS_RORA

  addrmode(&H6A) = ADR_IMP

  Ticks(&H6B) = 2

  instruction(&H6B) = INS_NOP

  addrmode(&H6B) = ADR_IMP

  Ticks(&H6C) = 5

  instruction(&H6C) = INS_JMP

  addrmode(&H6C) = ADR_IND

  Ticks(&H6D) = 4

  instruction(&H6D) = INS_ADC

  addrmode(&H6D) = ADR_ABS

  Ticks(&H6E) = 6

  instruction(&H6E) = INS_ROR

  addrmode(&H6E) = ADR_ABS

  Ticks(&H6F) = 2

  instruction(&H6F) = INS_NOP

  addrmode(&H6F) = ADR_IMP

  Ticks(&H70) = 2

  instruction(&H70) = INS_BVS

  addrmode(&H70) = ADR_REL

  Ticks(&H71) = 5

  instruction(&H71) = INS_ADC

  addrmode(&H71) = ADR_INDY

  Ticks(&H72) = 3

  instruction(&H72) = INS_ADC

  addrmode(&H72) = ADR_INDZP

  Ticks(&H73) = 2

  instruction(&H73) = INS_NOP

  addrmode(&H73) = ADR_IMP

  Ticks(&H74) = 4

  instruction(&H74) = INS_NOP

  addrmode(&H74) = ADR_ZPX

  Ticks(&H75) = 4

  instruction(&H75) = INS_ADC

  addrmode(&H75) = ADR_ZPX

  Ticks(&H76) = 6

  instruction(&H76) = INS_ROR

  addrmode(&H76) = ADR_ZPX

  Ticks(&H77) = 2

  instruction(&H77) = INS_NOP

  addrmode(&H77) = ADR_IMP

  Ticks(&H78) = 2

  instruction(&H78) = INS_SEI

  addrmode(&H78) = ADR_IMP

  Ticks(&H79) = 4

  instruction(&H79) = INS_ADC

  addrmode(&H79) = ADR_ABSY

  Ticks(&H7A) = 4

  instruction(&H7A) = INS_PLY

  addrmode(&H7A) = ADR_IMP

  Ticks(&H7B) = 2

  instruction(&H7B) = INS_NOP

  addrmode(&H7B) = ADR_IMP

  Ticks(&H7C) = 6

  instruction(&H7C) = INS_JMP

  addrmode(&H7C) = ADR_INDABSX

  Ticks(&H7D) = 4

  instruction(&H7D) = INS_ADC

  addrmode(&H7D) = ADR_ABSX

  Ticks(&H7E) = 7

  instruction(&H7E) = INS_ROR

  addrmode(&H7E) = ADR_ABSX

  Ticks(&H7F) = 2

  instruction(&H7F) = INS_NOP

  addrmode(&H7F) = ADR_IMP

  Ticks(&H80) = 2

  instruction(&H80) = INS_BRA

  addrmode(&H80) = ADR_REL

  Ticks(&H81) = 6

  instruction(&H81) = INS_STA

  addrmode(&H81) = ADR_INDX

  Ticks(&H82) = 2

  instruction(&H82) = INS_NOP

  addrmode(&H82) = ADR_IMP

  Ticks(&H83) = 2

  instruction(&H83) = INS_NOP

  addrmode(&H83) = ADR_IMP

  Ticks(&H84) = 2

  instruction(&H84) = INS_STY

  addrmode(&H84) = ADR_ZP

  Ticks(&H85) = 2

  instruction(&H85) = INS_STA

  addrmode(&H85) = ADR_ZP

  Ticks(&H86) = 2

  instruction(&H86) = INS_STX

  addrmode(&H86) = ADR_ZP

  Ticks(&H87) = 2

  instruction(&H87) = INS_NOP

  addrmode(&H87) = ADR_IMP

  Ticks(&H88) = 2

  instruction(&H88) = INS_DEY

  addrmode(&H88) = ADR_IMP

  Ticks(&H89) = 2

  instruction(&H89) = INS_BIT

  addrmode(&H89) = ADR_IMM

  Ticks(&H8A) = 2

  instruction(&H8A) = INS_TXA

  addrmode(&H8A) = ADR_IMP

  Ticks(&H8B) = 2

  instruction(&H8B) = INS_NOP

  addrmode(&H8B) = ADR_IMP

  Ticks(&H8C) = 4

  instruction(&H8C) = INS_STY

  addrmode(&H8C) = ADR_ABS

  Ticks(&H8D) = 4

  instruction(&H8D) = INS_STA

  addrmode(&H8D) = ADR_ABS

  Ticks(&H8E) = 4

  instruction(&H8E) = INS_STX

  addrmode(&H8E) = ADR_ABS

  Ticks(&H8F) = 2

  instruction(&H8F) = INS_NOP

  addrmode(&H8F) = ADR_IMP

  Ticks(&H90) = 2

  instruction(&H90) = INS_BCC

  addrmode(&H90) = ADR_REL

  Ticks(&H91) = 6

  instruction(&H91) = INS_STA

  addrmode(&H91) = ADR_INDY

  Ticks(&H92) = 3

  instruction(&H92) = INS_STA

  addrmode(&H92) = ADR_INDZP

  Ticks(&H93) = 2

  instruction(&H93) = INS_NOP

  addrmode(&H93) = ADR_IMP

  Ticks(&H94) = 4

  instruction(&H94) = INS_STY

  addrmode(&H94) = ADR_ZPX

  Ticks(&H95) = 4

  instruction(&H95) = INS_STA

  addrmode(&H95) = ADR_ZPX

  Ticks(&H96) = 4

  instruction(&H96) = INS_STX

  addrmode(&H96) = ADR_ZPY

  Ticks(&H97) = 2

  instruction(&H97) = INS_NOP

  addrmode(&H97) = ADR_IMP

  Ticks(&H98) = 2

  instruction(&H98) = INS_TYA

  addrmode(&H98) = ADR_IMP

  Ticks(&H99) = 5

  instruction(&H99) = INS_STA

  addrmode(&H99) = ADR_ABSY

  Ticks(&H9A) = 2

  instruction(&H9A) = INS_TXS

  addrmode(&H9A) = ADR_IMP

  Ticks(&H9B) = 2

  instruction(&H9B) = INS_NOP

  addrmode(&H9B) = ADR_IMP

  Ticks(&H9C) = 4

  instruction(&H9C) = INS_NOP

  addrmode(&H9C) = ADR_ABS

  Ticks(&H9D) = 5

  instruction(&H9D) = INS_STA

  addrmode(&H9D) = ADR_ABSX

  Ticks(&H9E) = 5

  instruction(&H9E) = INS_NOP

  addrmode(&H9E) = ADR_ABSX

  Ticks(&H9F) = 2

  instruction(&H9F) = INS_NOP

  addrmode(&H9F) = ADR_IMP

  Ticks(&HA0) = 3

  instruction(&HA0) = INS_LDY

  addrmode(&HA0) = ADR_IMM

  Ticks(&HA1) = 6

  instruction(&HA1) = INS_LDA

  addrmode(&HA1) = ADR_INDX

  Ticks(&HA2) = 3

  instruction(&HA2) = INS_LDX

  addrmode(&HA2) = ADR_IMM

  Ticks(&HA3) = 2

  instruction(&HA3) = INS_NOP

  addrmode(&HA3) = ADR_IMP

  Ticks(&HA4) = 3

  instruction(&HA4) = INS_LDY

  addrmode(&HA4) = ADR_ZP

  Ticks(&HA5) = 3

  instruction(&HA5) = INS_LDA

  addrmode(&HA5) = ADR_ZP

  Ticks(&HA6) = 3

  instruction(&HA6) = INS_LDX

  addrmode(&HA6) = ADR_ZP

  Ticks(&HA7) = 2

  instruction(&HA7) = INS_NOP

  addrmode(&HA7) = ADR_IMP

  Ticks(&HA8) = 2

  instruction(&HA8) = INS_TAY

  addrmode(&HA8) = ADR_IMP

  Ticks(&HA9) = 3

  instruction(&HA9) = INS_LDA

  addrmode(&HA9) = ADR_IMM

  Ticks(&HAA) = 2

  instruction(&HAA) = INS_TAX

  addrmode(&HAA) = ADR_IMP

  Ticks(&HAB) = 2

  instruction(&HAB) = INS_NOP

  addrmode(&HAB) = ADR_IMP

  Ticks(&HAC) = 4

  instruction(&HAC) = INS_LDY

  addrmode(&HAC) = ADR_ABS

  Ticks(&HAD) = 4

  instruction(&HAD) = INS_LDA

  addrmode(&HAD) = ADR_ABS

  Ticks(&HAE) = 4

  instruction(&HAE) = INS_LDX

  addrmode(&HAE) = ADR_ABS

  Ticks(&HAF) = 2

  instruction(&HAF) = INS_NOP

  addrmode(&HAF) = ADR_IMP

  Ticks(&HB0) = 2

  instruction(&HB0) = INS_BCS

  addrmode(&HB0) = ADR_REL

  Ticks(&HB1) = 5

  instruction(&HB1) = INS_LDA

  addrmode(&HB1) = ADR_INDY

  Ticks(&HB2) = 3

  instruction(&HB2) = INS_LDA

  addrmode(&HB2) = ADR_INDZP

  Ticks(&HB3) = 2

  instruction(&HB3) = INS_NOP

  addrmode(&HB3) = ADR_IMP

  Ticks(&HB4) = 4

  instruction(&HB4) = INS_LDY

  addrmode(&HB4) = ADR_ZPX

  Ticks(&HB5) = 4

  instruction(&HB5) = INS_LDA

  addrmode(&HB5) = ADR_ZPX

  Ticks(&HB6) = 4

  instruction(&HB6) = INS_LDX

  addrmode(&HB6) = ADR_ZPY

  Ticks(&HB7) = 2

  instruction(&HB7) = INS_NOP

  addrmode(&HB7) = ADR_IMP

  Ticks(&HB8) = 2

  instruction(&HB8) = INS_CLV

  addrmode(&HB8) = ADR_IMP

  Ticks(&HB9) = 4

  instruction(&HB9) = INS_LDA

  addrmode(&HB9) = ADR_ABSY

  Ticks(&HBA) = 2

  instruction(&HBA) = INS_TSX

  addrmode(&HBA) = ADR_IMP

  Ticks(&HBB) = 2

  instruction(&HBB) = INS_NOP

  addrmode(&HBB) = ADR_IMP

  Ticks(&HBC) = 4

  instruction(&HBC) = INS_LDY

  addrmode(&HBC) = ADR_ABSX

  Ticks(&HBD) = 4

  instruction(&HBD) = INS_LDA

  addrmode(&HBD) = ADR_ABSX

  Ticks(&HBE) = 4

  instruction(&HBE) = INS_LDX

  addrmode(&HBE) = ADR_ABSY

  Ticks(&HBF) = 2

  instruction(&HBF) = INS_NOP

  addrmode(&HBF) = ADR_IMP

  Ticks(&HC0) = 3

  instruction(&HC0) = INS_CPY

  addrmode(&HC0) = ADR_IMM

  Ticks(&HC1) = 6

  instruction(&HC1) = INS_CMP

  addrmode(&HC1) = ADR_INDX

  Ticks(&HC2) = 2

  instruction(&HC2) = INS_NOP

  addrmode(&HC2) = ADR_IMP

  Ticks(&HC3) = 2

  instruction(&HC3) = INS_NOP

  addrmode(&HC3) = ADR_IMP

  Ticks(&HC4) = 3

  instruction(&HC4) = INS_CPY

  addrmode(&HC4) = ADR_ZP

  Ticks(&HC5) = 3

  instruction(&HC5) = INS_CMP

  addrmode(&HC5) = ADR_ZP

  Ticks(&HC6) = 5

  instruction(&HC6) = INS_DEC

  addrmode(&HC6) = ADR_ZP

  Ticks(&HC7) = 2

  instruction(&HC7) = INS_NOP

  addrmode(&HC7) = ADR_IMP

  Ticks(&HC8) = 2

  instruction(&HC8) = INS_INY

  addrmode(&HC8) = ADR_IMP

  Ticks(&HC9) = 3

  instruction(&HC9) = INS_CMP

  addrmode(&HC9) = ADR_IMM

  Ticks(&HCA) = 2

  instruction(&HCA) = INS_DEX

  addrmode(&HCA) = ADR_IMP

  Ticks(&HCB) = 2

  instruction(&HCB) = INS_NOP

  addrmode(&HCB) = ADR_IMP

  Ticks(&HCC) = 4

  instruction(&HCC) = INS_CPY

  addrmode(&HCC) = ADR_ABS

  Ticks(&HCD) = 4

  instruction(&HCD) = INS_CMP

  addrmode(&HCD) = ADR_ABS

  Ticks(&HCE) = 6

  instruction(&HCE) = INS_DEC

  addrmode(&HCE) = ADR_ABS

  Ticks(&HCF) = 2

  instruction(&HCF) = INS_NOP

  addrmode(&HCF) = ADR_IMP

  Ticks(&HD0) = 2

  instruction(&HD0) = INS_BNE

  addrmode(&HD0) = ADR_REL

  Ticks(&HD1) = 5

  instruction(&HD1) = INS_CMP

  addrmode(&HD1) = ADR_INDY

  Ticks(&HD2) = 3

  instruction(&HD2) = INS_CMP

  addrmode(&HD2) = ADR_INDZP

  Ticks(&HD3) = 2

  instruction(&HD3) = INS_NOP

  addrmode(&HD3) = ADR_IMP

  Ticks(&HD4) = 2

  instruction(&HD4) = INS_NOP

  addrmode(&HD4) = ADR_IMP

  Ticks(&HD5) = 4

  instruction(&HD5) = INS_CMP

  addrmode(&HD5) = ADR_ZPX

  Ticks(&HD6) = 6

  instruction(&HD6) = INS_DEC

  addrmode(&HD6) = ADR_ZPX

  Ticks(&HD7) = 2

  instruction(&HD7) = INS_NOP

  addrmode(&HD7) = ADR_IMP

  Ticks(&HD8) = 2

  instruction(&HD8) = INS_CLD

  addrmode(&HD8) = ADR_IMP

  Ticks(&HD9) = 4

  instruction(&HD9) = INS_CMP

  addrmode(&HD9) = ADR_ABSY

  Ticks(&HDA) = 3

  instruction(&HDA) = INS_PHX

  addrmode(&HDA) = ADR_IMP

  Ticks(&HDB) = 2

  instruction(&HDB) = INS_NOP

  addrmode(&HDB) = ADR_IMP

  Ticks(&HDC) = 2

  instruction(&HDC) = INS_NOP

  addrmode(&HDC) = ADR_IMP

  Ticks(&HDD) = 4

  instruction(&HDD) = INS_CMP

  addrmode(&HDD) = ADR_ABSX

  Ticks(&HDE) = 7

  instruction(&HDE) = INS_DEC

  addrmode(&HDE) = ADR_ABSX

  Ticks(&HDF) = 2

  instruction(&HDF) = INS_NOP

  addrmode(&HDF) = ADR_IMP

  Ticks(&HE0) = 3

  instruction(&HE0) = INS_CPX

  addrmode(&HE0) = ADR_IMM

  Ticks(&HE1) = 6

  instruction(&HE1) = INS_SBC

  addrmode(&HE1) = ADR_INDX

  Ticks(&HE2) = 2

  instruction(&HE2) = INS_NOP

  addrmode(&HE2) = ADR_IMP

  Ticks(&HE3) = 2

  instruction(&HE3) = INS_NOP

  addrmode(&HE3) = ADR_IMP

  Ticks(&HE4) = 3

  instruction(&HE4) = INS_CPX

  addrmode(&HE4) = ADR_ZP

  Ticks(&HE5) = 3

  instruction(&HE5) = INS_SBC

  addrmode(&HE5) = ADR_ZP

  Ticks(&HE6) = 5

  instruction(&HE6) = INS_INC

  addrmode(&HE6) = ADR_ZP

  Ticks(&HE7) = 2

  instruction(&HE7) = INS_NOP

  addrmode(&HE7) = ADR_IMP

  Ticks(&HE8) = 2

  instruction(&HE8) = INS_INX

  addrmode(&HE8) = ADR_IMP

  Ticks(&HE9) = 3

  instruction(&HE9) = INS_SBC

  addrmode(&HE9) = ADR_IMM

  Ticks(&HEA) = 2

  instruction(&HEA) = INS_NOP

  addrmode(&HEA) = ADR_IMP

  Ticks(&HEB) = 2

  instruction(&HEB) = INS_NOP

  addrmode(&HEB) = ADR_IMP

  Ticks(&HEC) = 4

  instruction(&HEC) = INS_CPX

  addrmode(&HEC) = ADR_ABS

  Ticks(&HED) = 4

  instruction(&HED) = INS_SBC

  addrmode(&HED) = ADR_ABS

  Ticks(&HEE) = 6

  instruction(&HEE) = INS_INC

  addrmode(&HEE) = ADR_ABS

  Ticks(&HEF) = 2

  instruction(&HEF) = INS_NOP

  addrmode(&HEF) = ADR_IMP

  Ticks(&HF0) = 2

  instruction(&HF0) = INS_BEQ

  addrmode(&HF0) = ADR_REL

  Ticks(&HF1) = 5

  instruction(&HF1) = INS_SBC

  addrmode(&HF1) = ADR_INDY

  Ticks(&HF2) = 3

  instruction(&HF2) = INS_SBC

  addrmode(&HF2) = ADR_INDZP

  Ticks(&HF3) = 2

  instruction(&HF3) = INS_NOP

  addrmode(&HF3) = ADR_IMP

  Ticks(&HF4) = 2

  instruction(&HF4) = INS_NOP

  addrmode(&HF4) = ADR_IMP

  Ticks(&HF5) = 4

  instruction(&HF5) = INS_SBC

  addrmode(&HF5) = ADR_ZPX

  Ticks(&HF6) = 6

  instruction(&HF6) = INS_INC

  addrmode(&HF6) = ADR_ZPX

  Ticks(&HF7) = 2

  instruction(&HF7) = INS_NOP

  addrmode(&HF7) = ADR_IMP

  Ticks(&HF8) = 2

  instruction(&HF8) = INS_SED

  addrmode(&HF8) = ADR_IMP

  Ticks(&HF9) = 4

  instruction(&HF9) = INS_SBC

  addrmode(&HF9) = ADR_ABSY

  Ticks(&HFA) = 4

  instruction(&HFA) = INS_PLX

  addrmode(&HFA) = ADR_IMP

  Ticks(&HFB) = 2

  instruction(&HFB) = INS_NOP

  addrmode(&HFB) = ADR_IMP

  Ticks(&HFC) = 2

  instruction(&HFC) = INS_NOP

  addrmode(&HFC) = ADR_IMP

  Ticks(&HFD) = 4

  instruction(&HFD) = INS_SBC

  addrmode(&HFD) = ADR_ABSX

  Ticks(&HFE) = 7

  instruction(&HFE) = INS_INC

  addrmode(&HFE) = ADR_ABSX

  Ticks(&HFF) = 2

  instruction(&HFF) = INS_NOP

  addrmode(&HFF) = ADR_IMP

End Function
Public Sub adc6502()

  Call trace(PC, opcode, True, a, X, Y)

  Dim tmp As Long
      
  Call adrmode(opcode)

  value = read6502(savepc)

  saveflags = (P And &H1)

  sum = a

  sum = (sum + value) And &HFF

  sum = (sum + saveflags) And &HFF
      
  If (sum > &H7F) Or (sum < -&H80) Then

    P = P Or &H40

  Else

    P = (P And &HBF)

  End If
      
  sum = a + (value + saveflags)

  If (sum > &HFF) Then

    P = P Or &H1

  Else

    P = (P And &HFE)

  End If
      
  a = sum And &HFF

  If (P And &H8) Then

    P = (P And &HFE)

    If ((a And &HF) > &H9) Then

      a = (a + &H6) And &HFF

    End If

    If ((a And &HF0) > &H90) Then

      a = (a + &H60) And &HFF

      P = P Or &H1

    End If

  Else

    clockticks6502 = clockticks6502 + 1

  End If

  Call setflags(a)

End Sub
Public Sub adrmode(opcode As Byte)

  Call trace(PC, opcode, False, a, X, Y)

  Select Case addrmode(opcode)

    Case ADR_ABS

      savepc = read6502(PC) + (read6502(PC + 1) * &H100&)

      PC = PC + 2

    Case ADR_ABSX

      Call absx6502

    Case ADR_ABSY

      Call absy6502

    Case ADR_IMP

    Case ADR_IMM

      savepc = PC

      PC = PC + 1

    Case ADR_INDABSX

      Call indabsx6502

    Case ADR_IND

      Call indirect6502

    Case ADR_INDX

      Call indx6502

    Case ADR_INDY

      Call indy6502

    Case ADR_INDZP

      Call indzp6502

    Case ADR_REL

      savepc = read6502(PC)

      PC = PC + 1

      If (savepc And &H80) Then

        savepc = savepc - &H100&

      End If

    Case ADR_ZP

      savepc = read6502(PC)

      savepc = savepc And &HFF

      PC = PC + 1

    Case ADR_ZPX

      Call zpx6502

    Case ADR_ZPY

      Call zpy6502

    Case Else

  End Select

End Sub
Public Sub and6502()

  Call trace(PC, opcode, True, a, X, Y)

  Call adrmode(opcode)

  value = read6502(savepc)

  a = (a And value)

  Call setflags(a)

End Sub
Public Sub asl6502()

  Call trace(PC, opcode, True, a, X, Y)

  Call adrmode(opcode)

  value = read6502(savepc)

  P = (P And &HFE) Or ((value \ 128) And &H1)

  value = (value * 2) And &HFF
  
  Call write6502(savepc, (value And &HFF))

  Call setflags(value)

End Sub
Public Sub asla6502()

  Call trace(PC, opcode, False, a, X, Y)

  P = (P And &HFE) Or ((a \ 128) And &H1)

  a = (a * 2) And &HFF

  Call setflags(a)

End Sub
Public Sub bcc6502()

  Call trace(PC, opcode, False, a, X, Y)

  If ((P And &H1) = 0) Then

    Call adrmode(opcode)

    PC = PC + savepc

    clockticks6502 = clockticks6502 + 1

  Else

    PC = PC + 1

  End If

End Sub
Public Sub bcs6502()

  Call trace(PC, opcode, False, a, X, Y)

  If (P And &H1) Then

    Call adrmode(opcode)

    PC = PC + savepc

    clockticks6502 = clockticks6502 + 1

  Else

    PC = PC + 1

  End If

End Sub
Public Sub beq6502()

  Call trace(PC, opcode, False, a, X, Y)

  If (P And &H2) Then

    Call adrmode(opcode)

    PC = PC + savepc

    clockticks6502 = clockticks6502 + 1

  Else

    PC = PC + 1

  End If

End Sub
Public Sub bit6502()

  Call trace(PC, opcode, True, a, X, Y)

  Call adrmode(opcode)

  value = read6502(savepc)
  
  If (value And a) Then

    P = (P And &HFD)

  Else

    P = P Or &H2

  End If

  P = ((P And &H3F) Or (value And &HC0))

End Sub
Public Sub bmi6502()

  Call trace(PC, opcode, False, a, X, Y)

  If (P And &H80) Then

    Call adrmode(opcode)

    PC = PC + savepc

    clockticks6502 = clockticks6502 + 1

  Else

    PC = PC + 1

  End If

End Sub
Public Sub bne6502()

  Call trace(PC, opcode, False, a, X, Y)

  If ((P And &H2) = 0) Then

    Call adrmode(opcode)

    PC = PC + savepc

  Else

    PC = PC + 1

  End If

End Sub
Public Sub bpl6502()

  Call trace(PC, opcode, False, a, X, Y)

  If ((P And &H80) = 0) Then

    Call adrmode(opcode)

    PC = PC + savepc

  Else

    PC = PC + 1

  End If

End Sub
Public Sub brk6502()

  Call trace(PC, opcode, False, a, X, Y)

  PC = PC + 1

  Call write6502(&H100& + s, (PC \ &H100&) And &HFF)

  s = (s - 1) And &HFF

  Call write6502(&H100& + s, (PC And &HFF))

  s = (s - 1) And &HFF

  Call write6502(&H100& + s, P)

  s = (s - 1) And &HFF

  P = P Or &H14

  PC = read6502(&HFFFE&) + (read6502(&HFFFF&) * &H100&)

End Sub
Public Sub bvc6502()

  Call trace(PC, opcode, False, a, X, Y)

  If ((P And &H40) = 0) Then

    Call adrmode(opcode)

    PC = PC + savepc

    clockticks6502 = clockticks6502 + 1

  Else

    PC = PC + 1

  End If

End Sub
Public Sub bvs6502()

  Call trace(PC, opcode, False, a, X, Y)

  If (P And &H40) Then

    Call adrmode(opcode)

    PC = PC + savepc

    clockticks6502 = clockticks6502 + 1

  Else

    PC = PC + 1

  End If

End Sub
Public Sub clc6502()

  Call trace(PC, opcode, False, a, X, Y)

  P = P And &HFE

End Sub
Public Sub cld6502()

  Call trace(PC, opcode, False, a, X, Y)

  P = P And &HF7

End Sub
Public Sub cli6502()

  Call trace(PC, opcode, False, a, X, Y)

  P = P And &HFB

End Sub
Public Sub clv6502()

  Call trace(PC, opcode, False, a, X, Y)

  P = P And &HBF

End Sub
Public Sub cmp6502()

  Call trace(PC, opcode, True, a, X, Y)

  Call adrmode(opcode)

  value = read6502(savepc)
  
  If (a + &H100 - value) > &HFF Then

    P = P Or &H1

  Else

    P = (P And &HFE)

  End If
  
  value = (a + &H100 - value) And &HFF

  Call setflags(value)

End Sub
Public Sub cpx6502()

  Call trace(PC, opcode, True, a, X, Y)

  Call adrmode(opcode)

  value = read6502(savepc)

  If (X + &H100 - value > &HFF) Then

    P = P Or &H1

  Else

    P = (P And &HFE)

  End If
  
  value = (X + &H100 - value) And &HFF

  Call setflags(value)

End Sub
Public Sub cpy6502()

  Call trace(PC, opcode, True, a, X, Y)

  Call adrmode(opcode)

  value = read6502(savepc)
      
  If (Y + &H100 - value > &HFF) Then

    P = (P Or &H1)

  Else

    P = (P And &HFE)

  End If

  value = (Y + &H100 - value) And &HFF

  Call setflags(value)

End Sub
Public Sub dec6502()

  Call trace(PC, opcode, True, a, X, Y)

  Call adrmode(opcode)

  Call write6502((savepc), (read6502(savepc) - 1) And &HFF)

  value = read6502(savepc)

  If (value) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (value And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub dex6502()

  Call trace(PC, opcode, False, a, X, Y)

  X = (X - 1) And &HFF

  If (X) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (X And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub dey6502()

  Call trace(PC, opcode, False, a, X, Y)

  Y = (Y - 1) And &HFF

  If (Y) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (Y And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub eor6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)

  a = a Xor read6502(savepc)

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub inc6502()

  Call trace(PC, opcode, True, a, X, Y)

  Call adrmode(opcode)

  Call write6502((savepc), (read6502(savepc) + 1) And &HFF)

  value = read6502(savepc)

  If (value) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (value And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub inx6502()

  Call trace(PC, opcode, False, a, X, Y)

  X = (X + 1) And &HFF

  If (X) Then

    P = P And &HFD

  Else

    P = P Or &H2
  End If

  If (X And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub iny6502()

  Call trace(PC, opcode, False, a, X, Y)

  Y = (Y + 1) And &HFF

  If (Y) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (Y And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub jmp6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)

  PC = savepc

End Sub
Public Sub jsr6502()

  Call trace(PC, opcode, False, a, X, Y)

  PC = PC + 1

  Call write6502(s + &H100&, (PC \ &H100&))

  s = (s - 1) And &HFF

  Call write6502(s + &H100&, (PC And &HFF))

  s = (s - 1) And &HFF

  PC = PC - 1

  Call adrmode(opcode)

  PC = savepc

End Sub
Public Sub lda6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)
  
  a = read6502(savepc)

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub ldx6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)

  X = read6502(savepc)

  If (X) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (X And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub ldy6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)

  Y = read6502(savepc)

  If (Y) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (Y And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub lsr6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)

  value = read6502(savepc)

  P = ((P And &HFE) Or (value And &H1))

  value = (value \ 2) And &HFF

  Call write6502(savepc, value And &HFF)

  If (value) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (value And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub lsra6502()

  Call trace(PC, opcode, False, a, X, Y)

  P = (P And &HFE) Or (a And &H1)

  a = (a \ 2) And &HFF

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub nop6502()

  Call trace(PC, opcode, False, a, X, Y)

End Sub
Public Sub ora6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)

  a = a Or read6502(savepc)

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub pha6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call write6502(&H100& + s, a)

  s = (s - 1) And &HFF

End Sub
Public Sub php6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call write6502(&H100& + s, P)

  s = (s - 1) And &HFF

End Sub
Public Sub pla6502()

  Call trace(PC, opcode, False, a, X, Y)

  s = (s + 1) And &HFF

  a = read6502(s + &H100)

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub plp6502()

  Call trace(PC, opcode, False, a, X, Y)

  s = (s + 1) And &HFF

  P = read6502(s + &H100) Or &H20

End Sub
Public Sub rol6502()

  Call trace(PC, opcode, True, a, X, Y)

  saveflags = (P And &H1)

  Call adrmode(opcode)

  value = read6502(savepc)

  P = (P And &HFE) Or ((value \ 128) And &H1)

  value = (value * 2) And &HFF

  value = value Or saveflags

  Call write6502(savepc, value And &HFF)

  If (value) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (value And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub rola6502()

  Call trace(PC, opcode, False, a, X, Y)

  saveflags = (P And &H1)

  P = (P And &HFE) Or ((a \ 128) And &H1)

  a = (a * 2) And &HFF

  a = a Or saveflags

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub ror6502()

  Call trace(PC, opcode, True, a, X, Y)

  saveflags = (P And &H1)

  Call adrmode(opcode)

  value = read6502(savepc)

  P = (P And &HFE) Or (value And &H1)

  value = (value \ 2) And &HFF

  If (saveflags) Then

    value = value Or &H80

  End If

  Call write6502(savepc, value And &HFF)

  If (value) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (value And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub rora6502()

  Call trace(PC, opcode, False, a, X, Y)

  saveflags = (P And &H1)

  P = (P And &HFE) Or (a And &H1)

  a = (a \ 2) And &HFF

  If (saveflags) Then

    a = a Or &H80

  End If

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub rti6502()

  Call trace(PC, opcode, False, a, X, Y)

  s = (s + 1) And &HFF

  P = read6502(s + &H100&) Or &H20

  s = (s + 1) And &HFF

  PC = read6502(s + &H100&)

  s = (s + 1) And &HFF

  PC = PC + (read6502(s + &H100) * &H100&)

End Sub
Public Sub rts6502()

  Call trace(PC, opcode, False, a, X, Y)

  s = (s + 1) And &HFF

  PC = read6502(s + &H100)

  s = (s + 1) And &HFF

  PC = PC + (read6502(s + &H100) * &H100&)

  PC = PC + 1

End Sub
Public Sub sbc6502()

  Call trace(PC, opcode, True, a, X, Y)

  Call adrmode(opcode)

  value = read6502(savepc) Xor &HFF

  saveflags = (P And &H1)

  sum = a

  sum = (sum + value) And &HFF

  sum = (sum + (saveflags * 16)) And &HFF

  If ((sum > &H7F) Or (sum <= -&H80)) Then

    P = P Or &H40

  Else

    P = P And &HBF

  End If

  sum = a + (value + saveflags)

  If (sum > &HFF) Then

    P = P Or &H1

  Else

    P = P And &HFE

  End If

  a = sum And &HFF

  If (P And &H8) Then

    a = (a - &H66) And &HFF

    P = P And &HFE

    If ((a And &HF) > &H9) Then

      a = (a + &H6) And &HFF

    End If

    If ((a And &HF0) > &H90) Then

      a = (a + &H60) And &HFF

      P = P Or &H1

    End If

  Else

    clockticks6502 = clockticks6502 + 1

  End If

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub sec6502()

  Call trace(PC, opcode, False, a, X, Y)

  P = P Or &H1

End Sub
Public Sub sed6502()

  Call trace(PC, opcode, False, a, X, Y)

  P = P Or &H8

End Sub
Public Sub sei6502()

  Call trace(PC, opcode, False, a, X, Y)

  P = P Or &H4

End Sub
Public Sub sta6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)

  Call write6502(savepc, a)

End Sub
Public Sub stx6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)

  Call write6502(savepc, X)

End Sub
Public Sub sty6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)

  Call write6502(savepc, Y)

End Sub
Public Sub tax6502()

  Call trace(PC, opcode, False, a, X, Y)

  X = a

  If (X) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (X And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub tay6502()

  Call trace(PC, opcode, False, a, X, Y)

  Y = a

  If (Y) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (Y And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub tsx6502()

  Call trace(PC, opcode, False, a, X, Y)

  X = s

  If (X) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (X And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub txa6502()

  Call trace(PC, opcode, False, a, X, Y)

  a = X

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub txs6502()

  Call trace(PC, opcode, False, a, X, Y)

  s = X

End Sub

Public Sub tya6502()

  Call trace(PC, opcode, False, a, X, Y)

  a = Y

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub bra6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call adrmode(opcode)

  PC = PC + savepc

  clockticks6502 = clockticks6502 + 1

End Sub
Public Sub dea6502()

  Call trace(PC, opcode, False, a, X, Y)

  a = (a - 1) And &HFF

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub ina6502()

  Call trace(PC, opcode, False, a, X, Y)

  a = (a + 1) And &HFF

  If (a) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (a And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub phx6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call write6502(&H100 + s, X)

  s = (s - 1) And &HFF

End Sub

Public Sub plx6502()

  Call trace(PC, opcode, False, a, X, Y)

  s = (s + 1) And &HFF

  X = read6502(s + &H100)

  If (X) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (X And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Sub phy6502()

  Call trace(PC, opcode, False, a, X, Y)

  Call write6502(&H100 + s, Y)

  s = (s - 1) And &HFF

End Sub
Public Sub ply6502()

  Call trace(PC, opcode, False, a, X, Y)

  s = (s + 1) And &HFF

  Y = read6502(s + &H100)

  If (Y) Then

    P = P And &HFD

  Else

    P = P Or &H2

  End If

  If (Y And &H80) Then

    P = P Or &H80

  Else

    P = P And &H7F

  End If

End Sub
Public Function getdir(f As String) As String

  Dim g As String

  g$ = f$

  Do

    g$ = Left$(g$, Len(g$) - 1)

  Loop Until Right$(g$, 1) = "\"

  getdir$ = g$

End Function
Public Sub formproportional()

  Do

    frmNES.picScreen.Height = frmNES.picScreen.Height + 1

    frmNES.picScreen.Width = frmNES.picScreen.Width + 1

  Loop Until frmNES.picScreen.Height = frmNES.ScaleHeight

  frmNES.picScreen.Top = 0

  frmNES.picScreen.Left = (frmNES.ScaleWidth / 2) - (frmNES.picScreen.Width / 2)

End Sub
Public Sub menudisable()

  frmNES.mnu1second.Enabled = False

  frmNES.mnu2seconds.Enabled = False

  frmNES.mnu3seconds.Enabled = False

  frmNES.mnu4seconds.Enabled = False

  frmNES.mnu5seconds.Enabled = False

  frmNES.mnu6seconds.Enabled = False

  frmNES.mnu7seconds.Enabled = False

  frmNES.mnu8seconds.Enabled = False

  frmNES.mnu9seconds.Enabled = False

  frmNES.mnu10seconds.Enabled = False

  frmNES.jaw3.Enabled = False

  frmNES.fkaw.Enabled = False

  frmNES.maweiawe.Enabled = False

  frmNES.feefef.Enabled = False

  frmNES.msave.Enabled = False

  frmNES.mrestore.Enabled = False

  frmNES.mnuStartRecord.Enabled = False

  frmNES.mnuPlayMovie.Enabled = False

  frmNES.mnuCPUPause.Enabled = False

  frmNES.openhexviewer.Enabled = False

  frmNES.mnuTraceLogger.Enabled = False

  frmNES.mnuEmuReset.Enabled = False

  frmNES.mnuFileRomInfo.Enabled = False

  frmNES.mnuFileFree.Enabled = False

  frmNES.mnuDebugWindow.Enabled = False

  frmNES.takesnapshot.Enabled = False

  frmNES.mnumirroring.Enabled = False

  frmNES.mnumirror1.Checked = False

  frmNES.mnumirror2.Checked = False

  frmNES.mnumirror3.Checked = False

  frmNES.mnumirror4.Checked = False

  frmNES.mnumirror0.Checked = False

  frmNES.savesramf.Enabled = False

  frmNES.sramload.Enabled = False

  frmNES.mnucloseconnection.Enabled = False

End Sub
