/*

typedef struct {
	u32 id;
	u32 sram_crc;
	u32 flags;
	u32 whatever;
} emu_config;

typedef struct {
	u32 crc;
	u8 playcount;
	u8 flags;
	u32 controls1;
	u32 controls2;
	u16 sramsize;
} game_config;

#define SRAM_ID 0x12344321
#define workspace (game_config*)0x2000000;
#define MAX_GAMES 255			//number of game settings to remember

//initialize (at rom menu):  compress current sram, etc
void sram_init() {
	emu_config *settings=(emu_config*)workspace;
	memcpy(0xe000000,workspace,0x1000);

	if(config->id!=SRAM_ID) {
		memset(workspace,0,0x1000);
		config->id=SRAM_ID;
	}

	if(config->sram_crc) {
		scan workspace for crc
		if(game exists) {
			compress, store
		}
		clear temp sram area
		config->sram_crc=0;		
	}
}

void load_settings(romheader *rh) {
	game=find_crc(..)
	if(game)
		if(game->sramsize)
			unpack sram
			emu_config->sram_crc=??
	else
		add new game
}

void save_settings(?) {	//game settings changed, save 'em (called from ingame menu)
	(game still active, work with sram directly)
}

game_config *find_crc(u32 crc) {
	int i=MAX_GAMES;
	game_config *game=workspace;
	do {
		game++;
	} while(i-- && game->crc!=crc);
	return i?game:0;
}
*/