	INCLUDE equates.h
	INCLUDE io.h
	INCLUDE debug.h

	EXPORT resetmem
	EXPORT readmem8_tbl
	EXPORT rom00_R8
	EXPORT rom00_R16
	EXPORT openb_R
	EXPORT empty_R
	EXPORT empty_W
	EXPORT snes_rom_ptr

	AREA iwram, CODE, READWRITE

; See read/write macros in 65816mac.h for calling conventions.
;--------------------------------------------------
openb_R
	adr r1,openbus
	ldrb r0,[r7,#-1]
	strb r0,[r1,#1]
	strb r0,[r1,#2]
	strb r0,[r1,#3]
;	mov r0,#0
	bx lr
openbus
	DCB 0x0,0x0,0x0,0x0
;----------------------------------------------------------------------------
junk_R
 [ DEBUG
	DEBUGERROR 0x44414552,r12 ;"READ"
 ]
empty_R
	mov r0,#0
empty_W
	mov pc,lr
;----------------------------------------------------------------------------
ram8K_R8
	bic r1,r12,#0x00ff0000
	orr r1,r1,#SNES_RAM
	ldrb r0,[r1]
	mov pc,lr
ram8K_R16
	bic r0,r12,#0x00ff0000
	orr r0,r0,#SNES_RAM
	ldrb r1,[r0]
	ldrb r0,[r0,#1]
	mov pc,lr
;----------------------------------------------------------------------------
ram8K_W8
	bic r1,r12,#0x00ff0000
	orr r1,r1,#SNES_RAM
	strb r0,[r1]
	mov pc,lr
ram8K_W16
	bic r1,r12,#0x00ff0000
	orr r1,r1,#SNES_RAM
	strb r0,[r1]
	mov r0,r0,lsr#8
	strb r0,[r1,#1]
	mov pc,lr
;----------------------------------------------------------------------------
ram128K_R8
	bic r1,r12,#0x00fe0000
	orr r1,r1,#SNES_RAM
	ldrb r0,[r1]
	mov pc,lr
ram128K_R16
	bic r0,r12,#0x00fe0000
	orr r0,r0,#SNES_RAM
	ldrb r1,[r0]
	ldrb r0,[r0,#1]
	mov pc,lr
;----------------------------------------------------------------------------
ram128K_W8
	bic r1,r12,#0x00fe0000
	orr r1,r1,#SNES_RAM
	strb r0,[r1]
	mov pc,lr
ram128K_W16
	bic r1,r12,#0x00fe0000
	orr r1,r1,#SNES_RAM
	strb r0,[r1]
	mov r0,r0,lsr#8
	strb r0,[r1,#1]
	mov pc,lr
;----------------------------------------------------------------------------
sram30_R8	;306000-3f7fff, b06000-bf7fff
sram70_R8	;700000-7d7fff
	mov r0,r12,lsl#19		;8k sram
	mov r1,#SNES_SRAM
	ldrb r0,[r1,r0,lsr#19]!
	mov pc,lr
sram30_R16	;306000-3f7fff, b06000-bf7fff
sram70_R16
	mov r1,r12,lsl#19
	mov r0,#SNES_SRAM
	ldrb r1,[r0,r1,lsr#19]!
	ldrb r0,[r0,#1]
	mov pc,lr
;----------------------------------------------------------------------------
sram30_W8	;306000-3f7fff, b06000-bf7fff
sram70_W8	;700000-7d7fff
	nop ;mov r2,r12,lsl#19 (resetmem changes this)
	mov r1,#SNES_SRAM
	strb r0,[r1,r2,lsr#19]! ;(and this)
	mov pc,lr
sram30_W16	;306000-3f7fff, b06000-bf7fff
sram70_W16
	nop ;mov r2,r12,lsl#19
	mov r1,#SNES_SRAM
	strb r0,[r1,r2,lsr#19]!
	mov r0,r0,lsr#8
	strb r0,[r1,#1]
	mov pc,lr
;----------------------------------------------------------------------------
rom00_R8			% 20	;initialized by resetmem
rom00_R16			% 24
rom80_R8			% 20
rom80_R16			% 24

snes_rom_ptr		DCD 0
snes_rom_ptr_sub8000	DCD 0	;snes_rom_ptr - 0x8000
snes_rom_ptr_sub408000	DCD 0	;snes_rom_ptr - 0x408000
;----------------------------------------------------------------------------
	AREA rom, CODE, READONLY
resetmem			;called from hardreset, r0=rom_ptr, r1=flags

;	mov r11,r11
	ldr r2,=snes_rom_ptr	;init ptrs
	str r0,[r2],#4
	sub r3,r0,#0x8000
	str r3,[r2],#4
	sub r3,r3,#0x400000
	str r3,[r2],#4

	tst r1,#HIROM		;cart type?
	subeq r0,r0,#0x8000
	ldr r2,=0xFFD8		;SRAM size
	ldrb r2,[r0,r2]!
	cmp r2,#7
	movpl r2,#0

	tst r1,#SRAM		;got SRAM?
	ldr r5,=sram70write
	ldreq r0,[r5]
	ldrne r0,[r5,r2,lsl#2]!
	ldr r3,=sram70_W8
	ldr r4,=sram70_W16
	str r0,[r3],#8
	str r0,[r4],#8
	ldrne r0,[r5,#32]
	str r0,[r3]
	str r0,[r4]

	ldr r5,=sram70read1
	ldr r0,[r5,r2,lsl#2]!
	ldr r3,=sram70_R8
	str r0,[r3],#8
	ldrne r0,[r5,#32]
	str r0,[r3]
	ldr r5,=sram70read2
	ldr r0,[r5,r2,lsl#2]!
	ldr r3,=sram70_R16
	str r0,[r3],#8
	ldrne r0,[r5,#32]
	str r0,[r3]

	tst r1,#HIROM		;cart type?

	adreq r11,rom00_mode20_R8
	adrne r11,rom00_mode21_R8
	ldr r12,=rom00_R8
	ldmia r11,{r0-r10}	;(44 bytes)
	stmia r12,{r0-r10}

	adreq r11,rom80_mode20_R8
	adrne r11,rom80_mode21_R8
	ldr r12,=rom80_R8
	ldmia r11,{r0-r10}	;(44 bytes)
	stmia r12,{r0-r10}

	fill 0x2000000,zero,0x20000	;clear ram
ret
sram70write
	mov pc,lr
	mov r2,r12,lsl#21			;2kB SRAM
	mov r2,r12,lsl#20			;4kB
	mov r2,r12,lsl#19			;8kB
	mov r2,r12,lsl#18			;16kB
	mov r2,r12,lsl#17			;32kB
	mov r2,r12,lsl#16			;64kB
	mov r2,r12,lsl#15			;128kB

	mov pc,lr
	strb r0,[r1,r2,lsr#21]!
	strb r0,[r1,r2,lsr#20]!
	strb r0,[r1,r2,lsr#19]!
	strb r0,[r1,r2,lsr#18]!
	strb r0,[r1,r2,lsr#17]!
	strb r0,[r1,r2,lsr#16]!
	strb r0,[r1,r2,lsr#15]!

sram70read1
	mov r0,r12,lsl#31		;0k sram
	mov r0,r12,lsl#21		;2k sram
	mov r0,r12,lsl#20		;4k sram
	mov r0,r12,lsl#19		;8k sram
	mov r0,r12,lsl#18		;16k sram
	mov r0,r12,lsl#17		;32k sram
	mov r0,r12,lsl#16		;64k sram
	mov r0,r12,lsl#15		;128k sram

	ldrb r0,[r1,r0,lsr#31]!	;0k sram
	ldrb r0,[r1,r0,lsr#21]!	;2k sram
	ldrb r0,[r1,r0,lsr#20]!	;4k sram
	ldrb r0,[r1,r0,lsr#19]!	;8k sram
	ldrb r0,[r1,r0,lsr#18]!	;16k sram
	ldrb r0,[r1,r0,lsr#17]!	;32k sram
	ldrb r0,[r1,r0,lsr#16]!	;64k sram
	ldrb r0,[r1,r0,lsr#15]!	;128k sram
sram70read2
	mov r1,r12,lsl#31		;0k sram
	mov r1,r12,lsl#21		;2k sram
	mov r1,r12,lsl#20		;4k sram
	mov r1,r12,lsl#19		;8k sram
	mov r1,r12,lsl#18		;16k sram
	mov r1,r12,lsl#17		;32k sram
	mov r1,r12,lsl#16		;64k sram
	mov r1,r12,lsl#15		;128k sram

	ldrb r1,[r0,r1,lsr#31]!	;0k sram
	ldrb r1,[r0,r1,lsr#21]!	;2k sram
	ldrb r1,[r0,r1,lsr#20]!	;4k sram
	ldrb r1,[r0,r1,lsr#19]!	;8k sram
	ldrb r1,[r0,r1,lsr#18]!	;16k sram
	ldrb r1,[r0,r1,lsr#17]!	;32k sram
	ldrb r1,[r0,r1,lsr#16]!	;64k sram
	ldrb r1,[r0,r1,lsr#15]!	;128k sram
zero	DCD 0
;----------------------------------------------------------------------------
rom00_mode20_R8	;008000-7dffff
	ldr r1,[pc,#(snes_rom_ptr_sub8000-rom00_R8-8)]
	mov r0,r12,lsl#16
	add r0,r12,r0,lsr#16
	ldrb r0,[r1,r0,lsr#1]!
	mov pc,lr
rom00_mode20_R16
	ldr r0,[pc,#(snes_rom_ptr_sub8000-rom00_R16-8)]
	mov r1,r12,lsl#16
	add r1,r12,r1,lsr#16
	ldrb r1,[r0,r1,lsr#1]!
	ldrb r0,[r0,#1]
	mov pc,lr
;----------------------------------------------------------------------------
rom00_mode21_R8	;008000-3fffff
	ldr r1,[pc,#(snes_rom_ptr-rom00_R8-8)]
	bic r0,r12,#0xc00000
	ldrb r0,[r1,r0]!
	mov pc,lr
	nop ;make same size as lorom20_R8
rom00_mode21_R16
	ldr r1,[pc,#(snes_rom_ptr-rom00_R16-8)]
	bic r0,r12,#0xc00000
	ldrb r1,[r0,r1]!
	ldrb r0,[r0,#1]
	mov pc,lr
;----------------------------------------------------------------------------
rom80_mode20_R8	;80xxxx-ffxxxx
	ldr r1,[pc,#(snes_rom_ptr_sub408000-rom80_R8-8)]
	mov r0,r12,lsl#16
	add r0,r12,r0,lsr#16
	ldrb r0,[r1,r0,lsr#1]!
	mov pc,lr
rom80_mode20_R16
	ldr r0,[pc,#(snes_rom_ptr_sub408000-rom80_R16-8)]
	mov r1,r12,lsl#16
	add r1,r12,r1,lsr#16
	ldrb r1,[r0,r1,lsr#1]!
	ldrb r0,[r0,#1]
	mov pc,lr
;----------------------------------------------------------------------------
rom80_mode21_R8
	ldr r1,[pc,#(snes_rom_ptr-rom80_R8-8)]
	bic r0,r12,#0xc00000
	ldrb r0,[r1,r0]!
	mov pc,lr
	nop ;make same size as lorom20_R8
rom80_mode21_R16
	ldr r1,[pc,#(snes_rom_ptr-rom80_R16-8)]
	bic r0,r12,#0xc00000
	ldrb r1,[r0,r1]!
	ldrb r0,[r0,#1]
	mov pc,lr
;----------------------------------------------------------------------------
	LTORG

	MACRO
	REPT $count,$w0,$w1,$w2,$w3,$w4,$w5,$w6,$w7
	LCLA cnt
cnt 	SETA $count
	WHILE cnt > 0
	DCD $w0,$w1,$w2,$w3,$w4,$w5,$w6,$w7
cnt 	SETA cnt-1
	WEND
	MEND

readmem8_tbl
	REPT 0x30,ram8K_R8,io_R8,io_R8,junk_R,rom00_R8,rom00_R8,rom00_R8,rom00_R8			;00-2f
	REPT 0x10,ram8K_R8,io_R8,io_R8,sram30_R8,rom00_R8,rom00_R8,rom00_R8,rom00_R8			;30-3f
	REPT 0x30,junk_R,junk_R,junk_R,junk_R,rom00_R8,rom00_R8,rom00_R8,rom00_R8			;40-6f
	REPT 14,sram70_R8,sram70_R8,sram70_R8,sram70_R8,rom00_R8,rom00_R8,rom00_R8,rom00_R8		;70-7d
	REPT 2,ram128K_R8,ram128K_R8,ram128K_R8,ram128K_R8,ram128K_R8,ram128K_R8,ram128K_R8,ram128K_R8	;7e-7f
	REPT 0x30,ram8K_R8,io_R8,io_R8,junk_R,rom80_R8,rom80_R8,rom80_R8,rom80_R8			;80-af
	REPT 0x10,ram8K_R8,io_R8,io_R8,sram30_R8,rom80_R8,rom80_R8,rom80_R8,rom80_R8			;b0-bf
	REPT 0x40,rom80_R8,rom80_R8,rom80_R8,rom80_R8,rom80_R8,rom80_R8,rom80_R8,rom80_R8		;c0-ff
readmem16_tbl
	REPT 0x30,ram8K_R16,io_R16,io_R16,junk_R,rom00_R16,rom00_R16,rom00_R16,rom00_R16
	REPT 0x10,ram8K_R16,io_R16,io_R16,sram30_R16,rom00_R16,rom00_R16,rom00_R16,rom00_R16
	REPT 0x30,junk_R,junk_R,junk_R,junk_R,rom00_R16,rom00_R16,rom00_R16,rom00_R16
	REPT 14,sram70_R16,sram70_R16,sram70_R16,sram70_R16,rom00_R16,rom00_R16,rom00_R16,rom00_R16
	REPT 2,ram128K_R16,ram128K_R16,ram128K_R16,ram128K_R16,ram128K_R16,ram128K_R16,ram128K_R16,ram128K_R16
	REPT 0x30,ram8K_R16,io_R16,io_R16,junk_R,rom80_R16,rom80_R16,rom80_R16,rom80_R16
	REPT 0x10,ram8K_R16,io_R16,io_R16,sram30_R16,rom80_R16,rom80_R16,rom80_R16,rom80_R16
	REPT 0x40,rom80_R16,rom80_R16,rom80_R16,rom80_R16,rom80_R16,rom80_R16,rom80_R16,rom80_R16
writemem8_tbl
	REPT 0x30,ram8K_W8,io_W8,io_W8,empty_W,empty_W,empty_W,empty_W,empty_W
	REPT 0x10,ram8K_W8,io_W8,io_W8,sram30_W8,empty_W,empty_W,empty_W,empty_W
	REPT 0x30,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W
	REPT 14,sram70_W8,sram70_W8,sram70_W8,sram70_W8,empty_W,empty_W,empty_W,empty_W
	REPT 2,ram128K_W8,ram128K_W8,ram128K_W8,ram128K_W8,ram128K_W8,ram128K_W8,ram128K_W8,ram128K_W8
	REPT 0x30,ram8K_W8,io_W8,io_W8,empty_W,empty_W,empty_W,empty_W,empty_W
	REPT 0x10,ram8K_W8,io_W8,io_W8,sram30_W8,empty_W,empty_W,empty_W,empty_W
	REPT 0x40,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W
writemem16_tbl
	REPT 0x30,ram8K_W16,io_W16,io_W16,empty_W,empty_W,empty_W,empty_W,empty_W
	REPT 0x10,ram8K_W16,io_W16,io_W16,sram30_W16,empty_W,empty_W,empty_W,empty_W
	REPT 0x30,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W
	REPT 14,sram70_W16,sram70_W16,sram70_W16,sram70_W16,empty_W,empty_W,empty_W,empty_W
	REPT 2,ram128K_W16,ram128K_W16,ram128K_W16,ram128K_W16,ram128K_W16,ram128K_W16,ram128K_W16,ram128K_W16
	REPT 0x30,ram8K_W16,io_W16,io_W16,empty_W,empty_W,empty_W,empty_W,empty_W
	REPT 0x10,ram8K_W16,io_W16,io_W16,sram30_W16,empty_W,empty_W,empty_W,empty_W
	REPT 0x40,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W
	END
