#include <stdio.h>
#include <string.h>
#include "gba_defs.h"

//------------------------
void copy_65816_state(void *);	//65816.s
void run(void);			//65816.s
void debugstep(int);		//65816.s
void interrupthandler(void);	//gba.s

//------------------------

void debug(void);
void initcrap(romheader *r);

u32 *userdata;	//points to user data (end of rom)
u32 *romdata;	//points to end of gfx data

//Y B X A L R Start Sel
//L R Left Right Start Sel B A

#ifdef __DEBUG
const u8 debugkeys[]={0xff,0x01,0xff,0x02,0x08,0x04,0x08,0x04};
//const u8 debugkeys[]={0x02,0x01,0xff,0xff,0xff,0xff,0x08,0x04};//X,A,L,R disabled disabled
//const u8 debugkeys[]={0x02,0x01,0xff,0xff,0x08,0x04,0x08,0x04};//X,A disabled, L,R joined with start,sel
#endif
const u8 defaultkeys[]={0x02,0x01,0x80,0x40,0x84,0x44,0x08,0x04};

void C_entry(u32 *p) {
	romheader *r;
	userdata=p;

#ifdef __DEBUG
	set_keyconfig(debugkeys);
#else
	set_keyconfig(defaultkeys);
#endif
	do {
		r=romchooser();
		initcrap(r);
		hardreset(r+1,r->flags);

		INTR_VECT=(void*)interrupthandler;
		REG_IE=0x41;		//vblank, timer3 interrupt enable
		REG_IME=1;		//master interrupt enable
#ifdef __DEBUG
		restore_gfx(r);
		debug();
#else
		REG_DISPSTAT=0x0008;		//vblank interrupt enable
		do {
			restore_gfx(r);
			run();
		} while(!settings(r));
#endif
	} while(1);
}

void initcrap(romheader *r) {
	u32 i,flags;

	romflags1=flags=r->flags;
	romflags2=r->moreflags;

	i=r->autoscroll_val2;
	i=(i&0x1ffff)+0x2000000;
	autoscroll_ptr2=i;
	i=r->autoscroll_val1;
	i=(i&0x1ffff)+0x2000000;
	i|=(flags&(AUTOSCROLL_DIFF|AUTOSCROLL16))<<17;
	autoscroll_ptr1=i;
	autoscroll_scale=i=r->autoscroll_scale;
	autoscroll_offset=r->autoscroll_offset+32-((112*i)>>8);
}

const u16 rates[]={0,0,0x937e,0x7e02,0x7ac1,0x71db,0x6010,0x5955};	//5.00, 5.99, 6.14, 6.55, 7.37, 7.68

void set_throttle_timer(u8 rate) {		//set GBA timer and timing vars
	u8 i;
	throttle_type=rate;	
	if(rate>1) i=64;
	else i=rate^1;		//see io.s for valid throttle_intr values
	throttle_intr=i;
	if(rate>1) {	
		REG_TM2CNT_H=0;			///timer off
		REG_TM3CNT_H=0;
		REG_TM2CNT_L=rates[rate];		//65536-(clockrate/720)
		REG_TM3CNT_L=0xfff4;
		REG_TM2CNT_H=0x0080;		//timer on
		REG_TM3CNT_H=0x00c4;
	}
}

u32 readpad(void) {
	return ((REG_P1^0x3ff)&0x3ff);
}

void waitframe(void) {
	while(REG_DISPSTAT&1);	//while(outsidevblank)
	while(!(REG_DISPSTAT&1));	//while(insidevblank)
}

#ifdef __DEBUG

void debug(void) {
	int nonstop=0;	//toggle runmode by pushing start+select
	u32 key;
	while(1) {
		if(readpad()==(START_BUTTON|SELECT_BUTTON)) {
			while(readpad());
			nonstop^=1;
			set_keyconfig(nonstop?defaultkeys:debugkeys);
		}
		copy_65816_state((void*)0x2030000);
		if(nonstop) {
			debugstep(100);
		} else {
			if(key==L_BUTTON) {
				while((readpad()&(L_BUTTON|R_BUTTON))==L_BUTTON);
			}
			do {
				key=readpad();
			} while((!(key&(L_BUTTON|R_BUTTON))) && (key!=(START_BUTTON|SELECT_BUTTON)));
			key&=(L_BUTTON|R_BUTTON);
			if(key==R_BUTTON)
				debugstep(100);
			else if(key==L_BUTTON) {
				debugstep(1);
			} else {
				debugstep(15);
				waitframe();
			}
		}
	}
}

#endif