	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE 65816mac.h
	INCLUDE spc.h
	INCLUDE debug.h
	INCLUDE tables.h
	INCLUDE 65816.h

	EXPORT reset_io
	EXPORT io_R8
	EXPORT io_R16
	EXPORT io_W8
	EXPORT io_W16
	EXPORT pre_vblank_process
	EXPORT post_vblank_process
	EXPORT mid_frame_process
	EXPORT oam
	EXPORT DMAtable
	EXPORT autoscroll_ptr1
	EXPORT autoscroll_ptr2
	EXPORT autoscroll_scale
	EXPORT autoscroll_offset
	EXPORT snespad
	EXPORT gamma
	EXPORT throttle_intr
	EXPORT throttle_type
	EXPORT romflags1
	EXPORT romflags2
	EXPORT keyconfig
	EXPORT restore_gfx
	EXPORT gbarotscale

 EXPORT vrammap
 EXPORT encodeBG3CHR2
 EXPORT encodeOBJCHR
 EXPORT encodeBG12CHR4
 EXPORT encodeBG1SCR
 EXPORT encodeBG3SCR
 EXPORT bg3chroffset
;--------------------------------------------------
	AREA iwram, CODE, READWRITE
	MAP 0,r2

romvars	;miscellaneous storage (for routines in rom, etc)

bg1scrbase	DCB 0	;(i)
bg1scrbase_r2 # 1
bg1scrsize	DCB 0	;1,2,2,4
bg1scrsize_r2 # 1
bg2scrbase	DCB 0
bg2scrbase_r2 # 1
bg2scrsize	DCB 0
bg2scrsize_r2 # 1

bg1chroffset	DCD 0	;add to SNES vram address to get GBA address
bg1chroffset_r2 # 4
bg3chroffset	DCD 0	;6000000-2020000+OBJCHRBASE-BG3CHRBASE
bg3chroffset_r2 # 4
bgXblanktile	DCD 0	;what to use as a blank tile for doubled BG
bgXblanktile_r2 # 4

bg1sc_offset	DCD 0	;SNESaddr+offset=GBAaddr
bg1sc_offset_r2 # 4
bg2sc_offset	DCD 0
bg2sc_offset_r2 # 4
bg3sc_offset	DCD 0
bg3sc_offset_r2 # 4
bgXsc_offset	DCD 0
bgXsc_offset_r2 # 4
bg1sc_chroffset	DCD 0	;add to tile# in scr data
bg1sc_chroffset_r2 # 4
bg2sc_chroffset	DCD 0
bg2sc_chroffset_r2 # 4
bg3sc_chroffset	DCD 0
bg3sc_chroffset_r2 # 4
bgXsc_chroffset	DCD 0
bgXsc_chroffset_r2 # 4

bg3scrbase	DCB 0	;(i)
bg3scrbase_r2 # 1
bg3scrsize	DCB 0	;1,2,2,4
bg3scrsize_r2 # 1
bg3chrbase	DCB 0	;(0..31)*4
bg3chrbase_r2 # 1
objchrbase	DCB 0
objchrbase_r2 # 1
			;vars that affect vrammap (update vrammap when ??? != new_???)
bgmode		DCB 0
bgmode_r2 # 1
objsel		DCB 0
objsel_r2 # 1
bg1sc		DCB 0
bg1sc_r2 # 1
bg2sc		DCB 0
bg2sc_r2 # 1
bg3sc		DCB 0
bg3sc_r2 # 1
bg12nba		DCB 0
bg12nba_r2 # 1
bg34nba		DCB 0
bg34nba_r2 # 1
update_vrammap	DCB 0	;nonzero when vrammap needs to change
update_vrammap_r2 # 1

new_bgmode	DCB 0	;(i)
new_bgmode_r2 # 1
new_objsel	DCB 0
new_objsel_r2 # 1
new_bg1sc	DCB 0
new_bg1sc_r2 # 1
new_bg2sc	DCB 0
new_bg2sc_r2 # 1
new_bg3sc	DCB 0	;(i)
new_bg3sc_r2 # 1
new_bg12nba	DCB 0
new_bg12nba_r2 # 1
new_bg34nba	DCB 0
new_bg34nba_r2 # 1
new_update_vrammap DCB 0
new_update_vrammap_r2 # 1

tm		DCB 0	;things that affect priority (bgmode should be here too.. oh well)
tm_r2 # 1
ts		DCB 0
ts_r2 # 3
		ALIGN
new_tm		DCB 0
new_tm_r2 # 1
new_ts		DCB 0
new_ts_r2 # 3
		ALIGN

romflags1	DCD 0	;copy of flags from rom header
romflags1_r2 # 4
romflags2	DCD 0	;copy of moreflags from rom header
romflags2_r2 # 4
bg1chrbase	DCB 0
bg1chrbase_r2 # 1
bg2chrbase	DCB 0
bg2chrbase_r2 # 1
bgXscrsize	DCB 0
bgXscrsize_r2 # 1
inidisp		DCB 0	;2100
inidisp_r2 # 1
cgadsub		DCB 0	;2131
cgadsub_r2 # 1
		ALIGN ;- - -safe to align now, not using # map stuff

hvbjoy		DCB 0	;(i)
priorityrotation	DCB 0	;(for sprites)

		ALIGN
throttle_intr	DCB 1	;which interrupt to wait for (0=none, 1=vblank, 64=timer3)
throttle_type	DCB 0	;0=vblank 1=none 2-?=timer
	ALIGN

m7a		DCW 0	;mode7 params
m7b		DCW 0
m7c		DCW 0
m7d		DCW 0
m7x		DCW 0
m7y		DCW 0
mpy		DCD 0	;mode7 multiply result

gbarotscale		;the gba rot scale values (copied to  regs during vblank irq)
		DCD 0,0,0,0

autoscroll_ptr1	DCD 0	;address|(flags<<17)
autoscroll_ptr2	DCD 0	;address
autoscroll_scale	DCD 0
autoscroll_offset	DCD 0

;--------------------------------------------------
pre_vblank_process
	stmfd sp!,{lr}

	ldrb r1,inidisp	;reset oamaddr if not forced vblank
	tst r1,#0x80
	ldreq r0,oamaddr_save
	bic r0,r0,#0xfe00
	mov r0,r0,lsl#23
	streq r0,oamaddr
;- - - - - - - - - - - - - - - - - - - - - - - - - -
	bl readkeyinput		;r1=snespad (return with this for easy menukey check)

	ldmfd sp!,{pc}
;--------------------------------------------------
post_vblank_process		;called by 65816.s at end of vblank

	stmfd sp!,{r3-r8,lr}
pf0
;- - - - - - - - - - - - - - - -autoscroll
	ldr r2,autoscroll_ptr1
	movs r1,r2,lsl#11			;c=(16bit) n=(diff)
	ldrb r1,[r2]
	 ldrcssb r0,[r2,#1]
	 orrcs r1,r1,r0,lsl#8
	bpl pf1				;difference?
	ldr r2,autoscroll_ptr2
	ldrb r3,[r2]
	 ldrcssb r0,[r2,#1]
	 orrcs r3,r3,r0,lsl#8
	sub r1,r1,r3
pf1
	;r1=sprite pos
	ldr r2,autoscroll_scale
	ldr r3,autoscroll_offset
	mul r6,r2,r1
	adds r6,r3,r6,asr#8
	movmi r6,#0
	cmp r6,#64
	movgt r6,#64
;- - - - - - - - - - - - - - - - - do BG scroll
	ldrb r2,bgmode
	and r2,r2,#7
	cmp r2,#7
	bne normalscroll

	adr lr,scroll_ret
	ldr pc,=mode7scroll

normalscroll
	mov r4,#REG_BASE
	ldr r5,=bg1hofs
	ldrh r0,romflags1+2
	movs r0,r0,lsl#21		;c=BG2double  n=BG1double

	 ldrh r1,[r5],#2
	 add r1,r1,#8
	 strh r1,[r4,#REG_BG0HOFS]
	 strmih r1,[r4,#REG_BG3HOFS]
	ldrh r1,[r5],#2
	add r1,r1,r6
	strh r1,[r4,#REG_BG0VOFS]
	strmih r1,[r4,#REG_BG3VOFS]
	 ldrh r1,[r5],#2
	 add r1,r1,#8
	 strh r1,[r4,#REG_BG1HOFS]
	 strcsh r1,[r4,#REG_BG3HOFS]
	ldrh r1,[r5],#2
	add r1,r1,r6
	strh r1,[r4,#REG_BG1VOFS]
	strcsh r1,[r4,#REG_BG3VOFS]
	 ldrh r1,[r5],#2
	 add r1,r1,#8
	 strh r1,[r4,#REG_BG2HOFS]
	ldrh r1,[r5],#2
	add r1,r1,r6
	strh r1,[r4,#REG_BG2VOFS]
scroll_ret
;- - - - - - - - - - - - - - - - - - - - - - - - - - sprites
	sub r6,r6,#1	;sprites are off by 1 from BG
	adr r0,oam	;snes OAM data starts here
	adr r12,oam_hi

;	ldrb r2,priorityrotation
;	and r2,r2,#0xfe
;	mov r1,#AGB_OAM+0x800000
;	sub r1,r1,r2,lsl#2	;start copying sprites here
	mov r1,#AGB_OAM
	mov r7,#-128		;sprite count

objsizeselect
	mov r5,#0	;<- r5 = sprite size setting (modified by w2101)
; ........ ......SX VHPPCCCN NNNNNNNN YYYYYYYY XXXXXXXX <- SNES
; 0CCCPPNN NNNNNNNN SSVH000X XXXXXXXX 00000000 YYYYYYYY <- GBA

ps0 ;for(i=0 to 127)
	tst r7,#0x0f
	ldreq r2,[r12],#4	;r2=extra bits (read every 16th sprite)

	ldr r3,[r0],#4
	rsb r4,r6,r3,lsr#8	;Y-autoscroll
	and r4,r4,#0xff	
	strh r4,[r1],#2

	bic r4,r3,#0x0000ff00
	movs r2,r2,lsr#1
	orrcs r4,r4,#0x100	;r4=???????????????????????XXXXXXXXX
 	orr r4,r4,#0x200			;<<this will messes up rot/scale param
	sub r4,r4,#8			;x-=8
	bic r4,r4,#0xfe000000
	and lr,r4,#0x01f00000	;r4=0000000NNNNNNNNN000000?XXXXXXXXX
	add r4,r4,lr		;make sprite area 32 tiles across (SNES 2D mapping is 16 tiles across, GBA is 32)

	movs r2,r2,lsr#1
	orrcc r4,r4,r5,lsl#14
	orrcs r4,r4,r5,lsr#16	;size

	and lr,r3,#0xc0000000
	orr r4,r4,lr,lsr#18	;VH

	ands lr,r3,#0x30000000
	moveq lr,#0x10000000
	rsb lr,lr,#0x40000000
	orr r4,r4,lr,lsr#2	;PP (0->3  1->3  2->2  3->1)

	and lr,r3,#0x0e000000
	orr r4,r4,lr,lsl#3	;CCC
	strh r4,[r1],#2
	mov r4,r4,lsr#16
	strh r4,[r1],#4

	adds r7,r7,#1
	bne ps0
;- - - - - - - - - - - - - - - - - - - - - - - - - -
 [ DEBUG
	ldr r1,=FRAMECOUNT
	ldr r0,[r1]
	add r0,r0,#1
	str r0,[r1]	
 ]
	ldr r1,=vcount
	ldrh r0,HVtimerlatch_r1
	str r0,HVtimer_r1
;- - - - - - - - - - - - - - - - - - - - - - - - - -
	adr r0,bgmode		;bgmode=first of "vrammap vars"
	ldmia r0,{r1-r4}
	eors r1,r1,r3			;check if any vars that affect vrammap have changed
	eoreqs r2,r2,r4
	beq %F0				;nothing changed - abort

	stmia r0,{r3-r4}			;update vars
	and r0,r3,#7			;r0=bgmode
	adr lr,%F0
	ldr pc,=update_modeX_vrammap
0
;- - - - - - - - - - - - - - - - -
;	adr r0,tm		;same thing for priority...
;	ldmia r0,{r1-r2}
;	eors r1,r1,r2
;	beq %F0				;nothing changed - abort

;	stmia r0,{r2}			;update vars
;	adr lr,%F0
;	ldr pc,=set_priority
;0
;- - - - - - - - - - - - - - - - - - - - - - - - - -
	ldmfd sp!,{r3-r8,pc}
;--------------------------------------------------

oamaddr_save DCD 0	;copied to oamaddr at vblank
oamaddr DCD 0
oam 	% 512
oam_hi	% 32

w2102	;OAMADDL
	strb r0,oamaddr_save
		ldrb r1,oamaddr_save+1
		tst r1,#0x80
		strneb r0,priorityrotation
	and r0,r0,#0xff
	and r1,r1,#1
0	orr r0,r0,r1,lsl#8
	mov r0,r0,lsl#23
	str r0,oamaddr
	mov pc,lr

w2103	;OAMADDH
	strb r0,oamaddr_save+1
	and r1,r0,#1
	ldrb r0,oamaddr_save
	b %B0

;--------------------------------------------------
w2104	;OAMDATA (Write, read is ROM)
	ldr r1,oamaddr
	add r2,r1,#0x00400000
	str r2,oamaddr
	adr r2,oam
	tst r1,#0x80000000
	bicne r1,r1,#0x78000000 	;&=0x87c00000	(don't go beyond oam_hi)
	strb r0,[r2,r1,lsr#22]
	mov pc,lr
;--------------------------------------------------
w2116	;VMADDL
	and r0,r0,#0xff
	ldr r1,vmaddr
	and r1,r1,#0xfe00
	orr r1,r1,r0,lsl#1
	strh r1,vmaddr
	mov pc,lr
w2117	;VMADDH
;	and r0,r0,#0xff
	ldr r1,vmaddr
	bic r1,r1,#0xfe00
	orr r1,r1,r0,lsl#9
	strh r1,vmaddr
	mov pc,lr

vmaddr	DCD 0x2020000
;--------------------------------------------------
r2139	;VMDATAL(r)
	ldrb r0,vmtempR
vdatLR1
	mov pc,lr	;or stmfd sp!,{r2,lr} (SMC from 2115)
	ldr r1,vmaddr
vdatLR2	add r2,r1,#2	;or add r2,r1,#??? (SMC from 2115)
	strh r2,vmaddr
	ldrh r2,[r1]
	strh r2,vmtempR
	ldmfd sp!,{r2,pc}
;--------------------------------------------------
r213A	;VMDATAH(r)
	ldrb r0,vmtempR+1
vdatHR1
	stmfd sp!,{r2,lr}		;or mov pc,lr (SMC from 2115)
	ldr r1,vmaddr
vdatHR2	add r2,r1,#2	;or add r2,r1,#??? (SMC from 2115)
	strh r2,vmaddr
	ldrh r2,[r1]
	strh r2,vmtempR
	ldmfd sp!,{r2,pc}
;--------------------------------------------------
w2118	;VMDATAL
	ldr r1,vmaddr
	strb r0,[r1]
vdataLO	mov pc,lr	;or add r2,r1,#??? (SMC from 2115)
	strh r2,vmaddr
	and r0,r1,#0xf800
	adr r2,vrammap
	ldr pc,[r2,r0,lsr#9]

w2119	;VMDATAH
	ldr r1,vmaddr
	strb r0,[r1,#1]
vdataHI	add r2,r1,#2	;or mov pc,lr (SMC from 2115)
	strh r2,vmaddr
	and r0,r1,#0xf800
	ldr pc,[pc,r0,lsr#9]	;call with r1=addr written

vmtempR	DCD 0
vrammap	;jump table for handling different areas of SNES VRAM
	DCD empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W
;--------------------------------------------------
encodeBG12CHR4
	sub r1,r1,#0x1e
	tst r1,#0x1e
	movne pc,lr		;wait til complete tile is written

	ldr r0,bg1chroffset
	add r0,r0,r1
	b %F0
;--------------------------------------------------
encodeOBJCHR		;4-bit CHR encode
	sub r1,r1,#0x1e
	tst r1,#0x1f
	movne pc,lr		;wait til complete tile is written

	bic r0,r1,#0x003c000	;200xxxx
	and r2,r0,#0x3e00
	add r0,r0,r2
	add r0,r0,#0x0010000
	add r0,r0,#0x4000000	;6xxxxxx=AGB CHR address
0	mov r2,#1		;1 tile
encodeCHR4
	;r0=dst (GBA VRAM)
	;r1=src (SNES VRAM)
	;r2=tile count
	stmfd sp!,{r3-r8,lr}
	mov lr,#0x1e
	orr lr,lr,#0x1e00	;00001111000011110
	mov r7,lr,lsl#4   ;11110000111100000
	ldr r8,=chr4table
ec0
	ldrh r3,[r1],#2
	ldrh r4,[r1,#14]
	and r5,lr,r3,lsr#3	;pix0-3 plane0,1 (1111....0000....)
	and r6,r7,r4,lsl#1	;pix0-3 plane2,3 (3333....2222....)
	and r3,lr,r3,lsl#1	;pix4-7 plane0,1 (....1111....0000)
	and r4,r7,r4,lsl#5	;pix4-7 plane2,3 (....3333....2222)
	orr r5,r6,r5
	orr r3,r3,r4
	ldrh r5,[r8,r5]
	ldrh r3,[r8,r3]
	orr r5,r5,r3,lsl#16
	str r5,[r0],#4
	tst r0,#0x1f
	bne ec0

	add r1,r1,#16
	subs r2,r2,#1
	bne ec0
	ldmfd sp!,{r3-r8,pc}
;--------------------------------------------------
encodeBG3CHR2
	sub r1,r1,#0x0e	;r1=snes vram
	tst r1,#0x0e
	movne pc,lr		;wait til complete tile is written

	ldr r0,bg3chroffset	;600?000-4040000-base*2
	add r0,r0,r1,lsl#1
	mov r2,#1
encodeCHR2
	;r0=dst (GBA VRAM)
	;r1=src (SNES VRAM)
	;r2=tile count
	stmfd sp!,{r3-r4,lr}
	ldr r4,=0x33333333
	ldr lr,=chr4table
ec2
	ldrh r3,[r1],#2
	add r3,r3,r3		;r3 lsl#1
	ldrh r3,[lr,r3]		;........babababa
	orr r3,r3,r3,lsl#18	;abababa.babababa
	and r3,r4,r3,lsr#2	;.a.a.a.a.b.b.b.b
	str r3,[r0],#4

	tst r0,#0x1f
	bne ec2

	subs r2,r2,#1
	bne ec2
	ldmfd sp!,{r3-r4,pc}
;--------------------------------------------------
encodeBG3SCR	;r1=SNES vram addr
	stmfd sp!,{r3-r5,lr}
	ldr r3,bg3sc_chroffset
	ldr r0,bg3sc_offset
	add r0,r0,r1
	mov r2,#1		;#tiles
encodeBG3SCR2
	;r0=dst (AGB VRAM)
	;r1=src (SNES VRAM)
	;r2=tile count
	;r3=tile offset
	;{r3-r5,lr} on stack
	;VHPC CCNN NNNNNNNN <- SNES
	;CCCC VHNN NNNNNNNN <- GBA
esc1
	ldrh r5,[r1],#2
	add r4,r5,r3
	bic r4,r4,#0xfc00	;=000000NNNNNNNNNN
	and lr,r5,#0xc000
	orr r4,r4,lr,lsr#4;=0000VHNNNNNNNNNN
	and lr,r5,#0x1c00
	orr r4,r4,lr,lsl#2;=0CCCVHNNNNNNNNNN
	strh r4,[r0],#2

	subs r2,r2,#1
	bne esc1
	ldmfd sp!,{r3-r5,pc}
;------------
encodeBG2SCR			;r1=SNES vram addr
	mov r2,#1
encodeBG2SCR_r2			;r1=SNES vram addr, r2=tile count
	ldr r0,bg2sc_offset
	stmfd sp!,{r3-r5,lr}
	ldr r3,bg2sc_chroffset
	b encodeBG12SCR
encodeBG1SCR			;r1=SNES vram addr
	mov r2,#1
encodeBG1SCR_r2			;r1=SNES vram addr, r2=tile count
	ldr r0,bg1sc_offset
	stmfd sp!,{r3-r5,lr}
	ldr r3,bg1sc_chroffset
encodeBG12SCR
	add r0,r0,r1
	;r0=dst (AGB VRAM)
	;r1=src (SNES VRAM)
	;r2=tile count
	;r3=tile offset
	;VHPC CCNN NNNNNNNN <- SNES
	;CCCC VHNN NNNNNNNN <- GBA
esc0
	ldrh r5,[r1],#2
	add r4,r5,r3
	bic r4,r4,#0xfc00	;=000000NNNNNNNNNN
	and lr,r5,#0xc000
	orr r4,r4,lr,lsr#4;=0000VHNNNNNNNNNN
	and lr,r5,#0x1c00
	orr r4,r4,lr,lsl#2;=0CCCVHNNNNNNNNNN
	orr r4,r4,#0x8000	;=1CCCVHNNNNNNNNNN
	strh r4,[r0],#2

	subs r2,r2,#1
	bne esc0
	ldmfd sp!,{r3-r5,pc}	;exit with r0,r1 at end of data
;--====---===
encodeBGXSCR		;r1=SNES vram addr
	mov r2,#1		;#tiles
encodeBGXSCR_r2		;r1=SNES vram addr, r2=tile count
	ldr r0,bgXsc_offset
	stmfd sp!,{r3-r7,lr}
	ldr r3,bgXsc_chroffset
	ldr r6,bgXblanktile
	ldrb r7,bgXscrsize
	add r0,r0,r1
	add r7,r0,r7,lsl#11
	;r0=dst (AGB VRAM)
	;r1=src (SNES VRAM)
	;r2=tile count
	;r3=tile offset
	;r6=
	;r7=
	;VHPC CCNN NNNNNNNN <- SNES
	;CCCC VHNN NNNNNNNN <- GBA
bg2x0
	ldrh r5,[r1],#2
	add r4,r5,r3
	bic r4,r4,#0xfc00	;=000000NNNNNNNNNN
	and lr,r5,#0xc000
	orr r4,r4,lr,lsr#4;=0000VHNNNNNNNNNN
	and lr,r5,#0x1c00
	orr r4,r4,lr,lsl#2;=0CCCVHNNNNNNNNNN
	orr r4,r4,#0x8000	;=1CCCVHNNNNNNNNNN

	tst r5,#0x2000	;P?
	streqh r4,[r0],#2
	streqh r6,[r7],#2
	strneh r4,[r7],#2
	strneh r6,[r0],#2

	subs r2,r2,#1
	bne bg2x0
	ldmfd sp!,{r3-r7,pc}	;exit with r0,r1 at end of data
;--------------------------------------------------
encodeMODE7	;r1=snes vram addr
	sub r1,r1,#2
	tst r1,#2
	movne pc,lr		;do 2 words at a time (much easier)
	mov r2,#2

encodeM7	;r1=src (SNES VRAM), r2=word count

	ldr r0,=0x6000000-0x1010000
	add r0,r0,r1,lsr#1	;r0=dst (AGB VRAM)

	stmfd sp!,{r3-r5,lr}
	mov lr,#0xff
	orr lr,lr,#0xff0000	;=00FF00FF
	add r5,r0,#0x4000		;r0=SCR ptr, r5=CHR ptr
em7
	ldr r3,[r1],#4		;=ABCD
	and r4,r3,lr		;=0B0D
	and r3,lr,r3,lsr#8 	;=0A0C
	orr r4,r4,r4,lsr#8	;=0BBD
	orr r3,r3,r3,lsr#8	;=0AAC
	strh r4,[r0],#2
	strh r3,[r5],#2

	subs r2,r2,#2
	bne em7
	ldmfd sp!,{r3-r5,pc}
;--------------------------------------------------
w210d	;BG1HOFS
	ldrb r1,bg1hofs+1
	orr r1,r1,r0,lsl#8
	strh r1,bg1hofs
	mov pc,lr
;--------------------------------------------------
w210e	;BG1VOFS
	ldrb r1,bg1vofs+1
	orr r1,r1,r0,lsl#8
	strh r1,bg1vofs
	mov pc,lr
;--------------------------------------------------
w210f	;BG2HOFS
	ldrb r1,bg2hofs+1
	orr r1,r1,r0,lsl#8
	strh r1,bg2hofs
	mov pc,lr
;--------------------------------------------------
w2110	;BG2VOFS
	ldrb r1,bg2vofs+1
	orr r1,r1,r0,lsl#8
	strh r1,bg2vofs
	mov pc,lr
;--------------------------------------------------
w2111	;BG3HOFS
	ldrb r1,bg3hofs+1
	orr r1,r1,r0,lsl#8
	strh r1,bg3hofs
	mov pc,lr
;--------------------------------------------------
w2112	;BG3VOFS
	ldrb r1,bg3vofs+1
	orr r1,r1,r0,lsl#8
	strh r1,bg3vofs
	mov pc,lr

bg1hofs	DCW 0
bg1vofs	DCW 0
bg2hofs	DCW 0
bg2vofs	DCW 0
bg3hofs	DCW 0
bg3vofs	DCW 0
;--------------------------------------------------
w2121	;CGADD
	and r0,r0,#0xff
	add r0,r0,r0
	strh r0,cgaddr
	mov pc,lr
;--------------------------------------------------
r213B	;CGDATA(r)
	ldr r1,cgaddr
	add r0,r1,#1
	bic r0,r0,#0x200
	str r0,cgaddr

	ldr r0,=0x1010200		;palette is at 6010200
	ldrb r0,[r1,r0]
	mov pc,lr
;--------------------------------------------------
w2122	;CGDATA(w)
	ldr r2,cgaddr
	add r2,r2,#1
	bic r1,r2,#0x200
	str r1,cgaddr

	tst r2,#1
	strneb r0,cgtemp
	movne pc,lr

	stmfd sp!,{r3,lr}
	ldrb r1,cgtemp
	orr r0,r1,r0,lsl#8	;r0=color data

	ldr r1,=0x10101fe
	strh r0,[r2,r1]		;keep copy of palette in 6010200+
set_palette			;r0=colordata r2=5000000+color+2
	ldr lr,=gamma3
	ldrb r1,gamma
	add lr,lr,r1,lsl#5

	and r1,r0,#0x001f
	ldrb r3,[lr,r1]

	and r1,r0,#0x03e0
	ldrb r1,[lr,r1,lsr#5]
	orr r3,r3,r1,lsl#5

	and r1,r0,#0x7c00
	ldrb r1,[lr,r1,lsr#10]
	orr r0,r3,r1,lsl#10
				;r0 holds our color (finally)
palettewrite
	nop			;this code is replaced by restore_gfx (changes depending on the gfx mode)
	nop
	nop
	nop
	nop
	add r3,r3,r1,lsl#2
	strh r0,[r3,-r1]		;sneaky sneaky
	ldmfd sp!,{r3,pc}		;exit with r2 from set_palette unchanged

cgaddr	DCD AGB_PALETTE
cgtemp	DCB 0
gamma	DCB 0	;0,1

	ALIGN
;--------------------------------------------------
w420B	;MDMAEN (start general purpose DMA)
	stmfd sp!,{r3-r9,r11-r12,lr}
	mov r11,#0	;r11=cycle counter
	adr r3,DMAtable	;r3=DMA table
	and r4,r0,#0xff	;r4=channel mask
	b next3
next1
	ldr r5,[r3]		;r5=param
	ldr r6,[r3,#4]
	and r7,r5,#0xff00		;r7=B address<<8
	mov r12,r5,lsr#16
	and r8,r6,#0xff
	orr r12,r12,r8,lsl#16	;r12=A address
	mov r6,r6,lsl#8
	movs r6,r6,lsr#16
	orreq r6,r6,#0x10000	;r6=count

	add r0,r12,r6
	strh r0,[r3,#2]
	mov r0,r0,lsr#16
	strh r0,[r3,#4]		;store Aaddress+count
 [ DEBUG
	bl DMA_logging
 ]
	mov r0,#CPUCYCLE
	mla r11,r6,r0,r11		;count cycles spent

	tst r5,#0x80
	bne B_to_A
A_to_B
	translateR12		;(r10=snes_memtbl)
	stmfd sp!,{r10}
	mov r8,r1		;r8=read ptr
	ldr r0,=B_bus_write
	add r7,r0,r7,lsr#6	;r7=write ptr

	tst r5,#0x08
	movne r12,#0		;r12=source fixed/increment
	moveq r12,#1
	tst r5,#0x10
	rsbne r12,r12,#0		;inc/dec

	adr r0,dmamode
	and r5,r5,#7
	add r0,r0,r5,lsl#2
	ldr r9,[r7]		;r9=1st write
	ldrb r1,[r0,#1]
	ldr r10,[r7,r1,lsl#2]	;r10=2nd write
	ldrb r1,[r0,#2]
	ldr r5,[r7,r1,lsl#2]	;r5=3rd write
	ldrb r1,[r0,#3]
	ldr r7,[r7,r1,lsl#2]	;r7=4th write
dmaloop
	adr lr,%F0
	ldrb r0,[r8],r12
;	mov pc,r9
	bx r9					;!some of the IO ports are coded in thumb!
0	subs r6,r6,#1
	beq next4

	adr lr,%F1
	ldrb r0,[r8],r12
;	mov pc,r10
	bx r10
1	subs r6,r6,#1
	beq next4

	adr lr,%F2
	ldrb r0,[r8],r12
;	mov pc,r5
	bx r5
2	subs r6,r6,#1
	beq next4

	adr lr,%F3
	ldrb r0,[r8],r12
;	mov pc,r7
	bx r7
3	subs r6,r6,#1
	bne dmaloop
	b next4

B_to_A
 [ DEBUG
	DEBUGERROR 0x420B,r0
 ]
	b next2
next4
	ldmfd sp!,{r10}		
next2
	add r3,r3,#16
next3
	movs r4,r4,lsr#1
	bcs next1
	bne next2

	mov r0,r11
	ldmfd sp!,{r3-r9,r11-r12,lr}
 [ :LNOT:SNES9X
	add snes_cycles,snes_cycles,r0	;eat cycles
 ]
	mov pc,lr

dmamode	DCB 0,0,0,0
	DCB 0,1,0,1
	DCB 0,0,0,0
	DCB 0,0,1,1
	DCB 0,1,2,3
	DCB 0,0,0,0
	DCB 0,0,0,0
	DCB 0,0,0,0
 [ DEBUG
DMA_log_addr DCD 0x2038000
DMA_logging	;r6=byte count, r7=B address<<8, r12=A address, r5(lsb)=param
;	tst r5,#0x80
;	movne pc,lr
;	cmp r7,#0x0400		;2104?
;	movne pc,lr
;	ldrh r1,oamaddr
;	mov r1,r1,lsl#16
;	mov r1,r1,lsr#16
;	cmp r1,#0x6000
;	movmi pc,lr
;	cmp r1,#0x8000
;	movhs pc,lr	

;	ldr r0,DMA_log_addr
;	strb r5,[r0]		;0=param
;	str r6,[r0,#4]		;4=count
;	str r12,[r0,#8]		;8=src
;	strh r1,[r0,#12]		;c=

;	add r0,r0,#16
;	bic r0,r0,#0x200
;	str r0,DMA_log_addr

;	bic r2,r0,#0xff
;	bic r2,r2,#0x700
;	ldr r1,[r2,#-4]
;	add r1,r1,#1
;	str r1,[r2,#-4]
;	str r0,[r2,#-8]

	mov pc,lr
 ]
;--------------------------------------------------
r2180
	ldr r1,wmaddr
	ldrb r0,[r1],#1
	bic r1,r1,#0x20000
	str r1,wmaddr
	mov pc,lr
;--------------------------------------------------
w2180
	ldr r1,wmaddr
	strb r0,[r1],#1
	bic r1,r1,#0x20000
	str r1,wmaddr
	mov pc,lr

wmaddr	DCD 0x2000000
;--------------------------------------------------
r4212	;HVBJOY
	ldr r0,=vcount
	ldr r1,[r0]
	
	ldrb r0,hvbjoy
	eor r0,r0,#0x40	;keep flipping hblank/control flags (don't care about them right now)
	strb r0,hvbjoy

	cmp r1,#225			;241
	orrhs r0,r0,#0x81
	cmp r1,#229			;244, Controller flag is only set between vblank and 3 scanlines forward.
	bichs r0,r0,#0x01

	mov pc,lr
;--------------------------------------------------
w4202	;MULT-A
	strb r0,multA
	mov pc,lr

w4203	;MULT-B
	ldrb r1,multA
	and r0,r0,#0xff
	mul r0,r1,r0
	strh r0,product
	mov pc,lr

r4216	;PRODUCT-L, REMAINDER-L
	ldrb r0,product
	mov pc,lr

r4217	;PRODUCT-H, REMAINDER-H
	ldrb r0,product+1
	mov pc,lr

product	DCW 0
multA	DCB 0
	ALIGN
;--------------------------------------------------
w4204	;DIV-L
	strb r0,divC
	mov pc,lr

w4205	;DIV-H
	strb r0,divC+1
	mov pc,lr

w4206	;DIV-B
	ldrh r1,divC
	ands r0,r0,#0xff
	subeq r2,r0,#1
	beq div0			;div by 0: quotient=-1, remainder=dividend

	stmfd sp!,{r3}		;unsigned divide - r2=r1/r0, r1=remainder
	mov r3,r0
	cmp r3,r1,lsr#1
div1	addls r3,r3,r3
	cmp r3,r1,lsr#1
	bls div1
	mov r2,#0
div2	cmp r1,r3
	subcs r1,r1,r3
	adc r2,r2,r2
	mov r3,r3,lsr#1
	cmp r3,r0
	bhs div2
	ldmfd sp!,{r3}
div0
	strh r2,divA
	strh r1,product
	mov pc,lr

r4214	;DIVA-L
	ldrb r0,divA
	mov pc,lr

r4215	;DIVA-H
	ldrb r0,divA+1
	mov pc,lr

divC	DCW 0
divA	DCW 0
	ALIGN
;--------------------------------------------------
	;BYsSUDLR AXLR0000<- SNES
	;000000LR DULRSsBA<- GBA
readkeyinput
	mov r1,#REG_BASE
	orr r2,r1,#0x130
	ldrh r0,[r2]

	ldr r2,autoscroll_offset 
	tst r0,#0x084     ;select+down 
	addeq r2,r2,#2 
	tst r0,#0x044     ;select+up 
	subeq r2,r2,#2 
	str r2,autoscroll_offset

	mov r2,#-1
	eor r0,r0,r2

	str r2,snespad_shift	;* dirty hack.  should be checking D0 in NMITIMEN

	tst r0,#0x40
	orrne r1,r1,#0x0800	;Up
	tst r0,#0x20
	orrne r1,r1,#0x0200	;Left
	tst r0,#0x10
	orrne r1,r1,#0x0100	;Right
	tst r0,#0x80
	orrne r1,r1,#0x0400	;Down

	and r2,r0,#0x3f
	and r12,r0,#0x300
	orr r0,r2,r12,lsr#2	;=LRlrSsBA

keyconfig
	and r2,r0,#0x00
	cmp r2,#0x00
	orreq r1,r1,#0x4000	;Y
	and r2,r0,#0x00
	cmp r2,#0x00
	orreq r1,r1,#0x8000	;B
	and r2,r0,#0
	cmp r2,#0
	orreq r1,r1,#0x0040	;X
	and r2,r0,#0
	cmp r2,#0
	orreq r1,r1,#0x0080	;A
	and r2,r0,#0
	cmp r2,#0
	orreq r1,r1,#0x0020	;L
	and r2,r0,#0
	cmp r2,#0
	orreq r1,r1,#0x0010	;R
	and r2,r0,#0
	cmp r2,#0
	orreq r1,r1,#0x1000	;Start
	and r2,r0,#0
	cmp r2,#0
	orreq r1,r1,#0x2000	;Select

	cmp r0,#0x0f		;sel+start+A+B
;	cmp r0,#0x0c		;sel+start

	moveq r1,#0x80000000	;80000000 = go to menu
	str r1,snespad
	mov pc,lr

snespad_shift DCD 0 ;for NES-style reading.  keep next to snespad (see w4016)
snespad	DCD 0
snes4016 DCB 0		; to keep tabs on writes to 4016
snesIOP  DCB 0		; for 4201 & 4213
	ALIGN
;--------------------------------------------------
w43XX	;DMA
	ldr r1,=writeIO_tbl
	sub r1,r12,r1
	adr r2,DMAtable-0x300
	strb r0,[r2,r1,lsr#2]
	mov pc,lr
	
DMAtable % 0x7c
;--------------------------------------------------
io_R8
	mov r0,r12,lsl#18
	ldr r1,=readIO_tbl
	ldr r0,[r1,r0,lsr#16]!	;r1=readIO_tbl offset (r43XX expects this)
	bx r0
io_R16
 [ SAFE
	stmfd sp!,{r12,lr}	;r12 is supposed to be preserved for RMW instructions
 |
	stmfd sp!,{lr}
 ]
	adr lr,_rd0
	mov r0,r12,lsl#18
	ldr r12,=readIO_tbl
	ldr r1,[r12,r0,lsr#16]!	;r12=readIO_tbl offset (blah)
	bx r1
_rd0	stmfd sp!,{r0}
	adr lr,_rd1
	ldr r1,[r12,#4]!
	bx r1
_rd1
 [ SAFE
	ldmfd sp!,{r1,r12,pc}
 |
	ldmfd sp!,{r1,pc}
 ]
;--------------------------------------------------
io_W8
	mov r1,r12,lsl#18
 [ DEBUG					;count i/o writes in 203xxxx
	ldr r12,=0x2030000
	ldrb r2,[r12,r1,lsr#18]!
	add r2,r2,#1
	strb r2,[r12]
 ]
	ldr r12,=writeIO_tbl
	ldr r1,[r12,r1,lsr#16]!	;r12=writeIO_tbl offset (w43XX expects this)
	bx r1
io_W16
	stmfd sp!,{r0,lr}
	mov r1,r12,lsl#18
 [ DEBUG					;count i/o writes in 203xxxx
	ldr r12,=0x2030000
	ldrb r2,[r12,r1,lsr#18]!
	add r2,r2,#1
	strb r2,[r12]
	ldrb r2,[r12,#1]!
	add r2,r2,#1
	strb r2,[r12]
 ]
	ldr r12,=writeIO_tbl
	adr lr,_w0
	ldr r1,[r12,r1,lsr#16]!	;r12 here too..
	bx r1
_w0	ldmfd sp!,{r0,lr}
	mov r0,r0,lsr#8
	ldr r1,[r12,#4]!		;yep
	bx r1
;*************************************************************************************
	AREA rom, CODE, READONLY
	CODE16
;--------------------------------------------------
w4201	;WRIO
	ldr r1,=snesIOP
	strb r0,[r1]
	bx lr
;--------------------------------------------------
w420D	;MEMSEL
	lsr r0,r0,#1
	ldr r0,=SLOWROM_CYCLESPERLINE*CYCLE
	ldr r1,=cycles_per_line
	bcc %F0
	ldr r0,=FASTROM_CYCLESPERLINE*CYCLE
0	str r0,[r1]
	bx lr
;--------------------------------------------------
r4210	;RDNMI
		; bit7 = NMI flag by VBlank
		; bit0-3 = CPU Version number (1,2)
	ldr r1,=vcount
	ldrb r0,rdnmi_r1
	strb snes_a,rdnmi_r1	;clear bit after it's read
	mov r1,#0x01			;version
	orr r0,r1
	bx lr
;--------------------------------------------------
r4211	;TIMEUP
	ldr r1,=timeup
	ldrb r0,[r1]
	strb snes_a,[r1]
	bx lr
;--------------------------------------------------
r4213	;RDIO
	ldr r1,=snesIOP
	ldrb r0,[r1]
	bx lr
;--------------------------------------------------
r4218	;JOY1L
	ldr r1,=snespad
	ldrb r0,[r1]
	bx lr
r4219	;JOY1H
	ldr r1,=snespad+1
	ldrb r0,[r1]
	bx lr
r421A	;JOY2L
r421B	;JOY2H
r421C	;JOY3L
r421D	;JOY3H
r421E	;JOY4L
r421F	;JOY4H
	mov r0,#0
	bx lr
;--------------------------------------------------
w2100	;INIDISP		(force blank, screen brightness)
	ldr r1,=inidisp
	strb r0,[r1]
	bx lr
;--------------------------------------------------
w2131	;CGADSUB
;	mov r11,r11
	ldr r1,=cgadsub
	strb r0,[r1]
	bx lr
;--------------------------------------------------
r2131	;CGADSUB
	ldr r1,=cgadsub
	ldrb r0,[r1]
	bx lr
;--------------------------------------------------
r2134	;MPY (mode7 multiply result)
	ldr r1,=mpy
	ldrb r0,[r1]
	bx lr
r2135
	ldr r1,=mpy
	ldrb r0,[r1,#1]
	bx lr
r2136
	ldr r1,=mpy
	ldrb r0,[r1,#2]
	bx lr
;--------------------------------------------------
r213E	;STAT77
		; bit7 = more than 35*8 sprite pixel
		; bit6 = more than 33 sprites
		; bit5 = master/slave (0)
		; bit0-3 = PPU1 Version number (1)
	mov r0,#1
	bx lr
;--------------------------------------------------
	LTORG
;*************************************************************************************
	CODE32
;--------------------------------------------------
r43XX	;DMA
	ldr r0,=readIO_tbl
	subs r1,r1,r0		;either r1 or 12 is readIO_tbl offset, depending on whether it's a 8bit or 16bit read
	submi r1,r12,r0
	ldr r0,=DMAtable-0x300
	ldrb r0,[r0,r1,lsr#2]
	mov pc,lr
;--------------------------------------------------
w2106	;MOSAIC
	mov r2,#REG_BASE

	and r1,r0,#0xf0
	orr r1,r1,r1,lsr#4
	strh r1,[r2,#REG_MOSAIC]

	ldrh r1,[r2,#REG_BG0CNT]
	tst r0,#1
	biceq r1,r1,#0x40 ;clr mosaic
	orrne r1,r1,#0x40 ;set mosaic
	strh r1,[r2,#REG_BG0CNT]

	ldrh r1,[r2,#REG_BG1CNT]
	tst r0,#2
	biceq r1,r1,#0x40 ;clr mosaic
	orrne r1,r1,#0x40 ;set mosaic
	strh r1,[r2,#REG_BG1CNT]

	ldrh r1,[r2,#REG_BG2CNT]
	tst r0,#4
	biceq r1,r1,#0x40 ;clr mosaic
	orrne r1,r1,#0x40 ;set mosaic
	strh r1,[r2,#REG_BG2CNT]
	mov pc,lr
;--------------------------------------------------
w2115	;VMAINC
 [ DEBUG
	tst r0,#0x0c
	beq %F0
	mov r11,r11
	DEBUGERROR 0x2115,r0	;error on funky 8-by-* increment modes
0
 ]
	tst r0,#0x80		;increment on low or hi write?
	and r0,r0,#3
	adr r2,vmainc
	ldreq r0,[r2,r0,lsl#2]
	ldreq r1,[r2,#-4]
	ldrne r1,[r2,r0,lsl#2]
	ldrne r0,[r2,#-4]
	ldr r2,=vdatLR1
	str r0,[r2,#vdataLO-vdatLR1]
	str r1,[r2,#vdataHI-vdatLR1]
	str r0,[r2,#vdatLR2-vdatLR1]
	str r1,[r2,#vdatHR2-vdatLR1]
	ldreq r0,vmback
	ldrne r1,vmback
	str r0,[r2]
	str r1,[r2,#vdatHR1-vdatLR1]

	mov pc,lr
vmainc
	add r2,r1,#2
	add r2,r1,#64
	add r2,r1,#256
	add r2,r1,#256
vmback
	stmfd sp!,{r2,lr}
;--------------------------------------------------
r2137	;SLHV (latch H/V count)
	stmfd sp!,{r2}
	ldr r2,=cycles_per_line
	ldr r2,[r2]
	add r2,r9,r2			;r9=cycles, r0=cycles left
	mov r2,r2,lsr#6			;21864/64=341
	ldr r1,=vcount
	ldr r0,vcount_r1
	str r0,vcount_latch_r1
	str r2,hcount_latch_r1

	mov r0,#0
	ldmfd sp!,{r2}
	mov pc,lr
;--------------------------------------------------
r2138	;OAMDATA (read)
	stmfd sp!,{r2}
 [ DEBUG
	DEBUGERROR 0x2138,r0
 ]
	ldr r2,=oamaddr
	ldr r0,[r2]
	add r1,r0,#0x00400000
	str r1,[r2]
	ldr r1,=oam
	tst r0,#0x80000000
	bicne r0,r0,#0x78000000 	;&=0x87c00000	(don't go beyond oam_hi)
	ldrb r0,[r1,r0,lsr#22]
	ldmfd sp!,{r2}
	mov pc,lr

	LTORG
;--------------------------------------------------
r213C	;OPHCT	(hcount)
	ldr r1,=hcount_latch
	ldr r0,[r1]
	eors r0,r0,#0x80000000
	str r0,[r1]
	movpl r0,r0,lsr#8
	and r0,r0,#0xff
	mov pc,lr
;--------------------------------------------------
r213D	;OPVCT	(vcount)
	ldr r1,=vcount_latch
	ldr r0,[r1]
	eors r0,r0,#0x80000000
	str r0,[r1]
	movpl r0,r0,lsr#8
	and r0,r0,#0xff
	mov pc,lr
;--------------------------------------------------
r213F	;STAT78
		; bit7 = even/odd field
		; bit6 = external latch
		; bit4 = NTSC(0)/PAL(1)
		; bit0-3 = PPU2 Version number (1,2,3)
	ldr r1,=vcount_latch
	strb snes_a,[r1,#3]		;reset latch to low read first
	ldr r0,=romflags1
	ldr r1,[r0]
	tst r1,#2			;PAL game?
	mov r0,#0x01		;Version
	orrne r0,r0,#0x10	;PAL bit
	mov pc,lr
;--------------------------------------------------
w4207	;HTIME
	ldr r1,=vcount
	strb r0,htimetemp_r1
 [ SAFE
	b fixup_htimer
 |
	mov pc,lr
 ]
w4208
	ldr r1,=vcount
	strb r0,htimetemp_r1+1
fixup_htimer
	ldrh r2,htimetemp_r1
	sub r2,r2,#256
	cmp r2,#83
	mov r2,#0
	movgt r2,#-1	;r2=htime>339?-1:0
	strh r2,adjusted_htime_r1

	ldrb r0,nmitimen_r1
set_all			;r0=nmitimen, r2=adjusted_htime
	tst r0,#0x10		;if HTIME interrupt disabled
	cmpne r2,#-1		;or HTIME>339
	ldreqh r0,adjusted_vtime_r1
	beq set_vtime			;setup vtime interrupt

	DEBUGERROR 0x4207,r2

;	strh r2,HVtimerlatch_r1	;=0
;	str r2,HVtimer_r1		;=0
	mov pc,lr
;--------------------------------------------------
w4209	;VTIME
	ldr r1,=vcount
	strb r0,vtimetemp_r1
 [ SAFE
	b fixup_vtimer
 |
	mov pc,lr
 ]
w420A
	ldr r1,=vcount
	strb r0,vtimetemp_r1+1
fixup_vtimer
	mov r2,#256
	add r2,r2,#6	;r2=262
	ldrh r0,vtimetemp_r1
	cmp r0,r2
	addeq r0,r0,#1	;don't allow VTIME=262
	cmp r0,#0	;fix VTIME=0
	moveq r0,r2	;(timeout() sees line 0 as 262)
	strh r0,adjusted_vtime_r1

	ldr r2,HVtimer_r1
	cmp r2,#0		;if HVtimer=0
	moveq pc,lr		;	do nothing... HTIME is active (takes priority over VTIME)
set_vtime
	strh r0,HVtimerlatch_r1
	ldr r2,vcount_r1
	cmp r0,r2
	strhi r0,HVtimer_r1	;	;else	HVtimer = vtime
	mov pc,lr
;--------------------------------------------------
w4200	;NMITIMEN
	ldr r1,=vcount
	strb r0,nmitimen_r1
 [ DEBUG
	and r0,r0,#0xff
	DEBUGINFO NMIT,r0
 ]
	ldrsh r2,adjusted_htime_r1
	b set_all
;--------------------------------------------------
w2105	;BGMODE
;	mov r11,r11
 [ DEBUG
	tst r0,#0xf0	;check for 16x16 tiles (Super Punch Out!, Super SWIV)
	beq no16
	DEBUGERROR 0x2105,r0
no16
	and r1,r0,#0xff
	DEBUGINFO MODE,r1
 ]
	ldr r2,=romvars
	strb r0,new_bgmode_r2		;fix mode3 (Turrican2)

	mov pc,lr
;--------------------------------------------------
w212C	;TM
	DEBUGINFO TM,r0

	ldr r2,=romvars
	strb r0,new_tm_r2
	mov pc,lr
;--------------------------------------------------
w212D	;TS
	DEBUGINFO TS,r0

	ldr r2,=romvars
	strb r0,new_ts_r2
	mov pc,lr	
;--------------------------------------------------
w212E	;TMW
	DEBUGINFO TMW,r0
	mov pc,lr
;--------------------------------------------------
w212F	;TSW
	DEBUGINFO TSW,r0
	mov pc,lr
;--------------------------------------------------
w2130	;CGSWSEL
	DEBUGINFO CGSW,r0
	mov pc,lr
;--------------------------------------------------
w2101	;OBJSEL   SSS000NN

	ldr r2,=romvars
	strb r0,new_objsel_r2

 [ DEBUG
	tst r0,#0x18
	beq %F0
	DEBUGERROR 0x2101,r0		;unsupported feature (OBJ name select)
0
 ]
				;set OBJ CHR location
	and r1,r0,#3
	mov r1,r1,lsl#5		;xxooo00
	strb r1,objchrbase_r2
 [ DEBUG
	mov r2,r1,lsr#2
	mov r1,#0xff
	mov r1,r1,lsl r2
	DEBUGINFO OBJC,r1
 ]
				;set OBJ sizes
	and r1,r0,#0xe0
	adr r2,objsizes
	ldr r1,[r2,r1,lsr#3]
	ldr r2,=objsizeselect
	str r1,[r2]		;modify sprite code inside post_vblank_process

	mov pc,lr

objsizes
	mov r5,#0x40000000	;8x8/16x16
	mov r5,#0x80000000	;8x8/32x32
	mov r5,#0xc0000000	;8x8/64x64
	mov r5,#0x80000001	;16x16/32x32
	mov r5,#0xc0000001	;16x16/64x64
	mov r5,#0xc0000002	;32x32/64x64
	mov r5,#0xc0000001	;16x32/32x64	undocumented
	mov r5,#0x80000001	;16x32/32x32	undocumented
;--------------------------------------------------
w2107	;BG1SC
	;         0BBBBBSS <- SNES
	;SS0BBBBB 0000CCPP <- GBA

	ldr r2,=romvars
	strb r0,new_bg1sc_r2

	and r1,r0,#0x7c
	strb r1,bg1scrbase_r2

	and r1,r0,#3
	cmp r1,#2
	addne r1,r1,#1
	strb r1,bg1scrsize_r2	;1/2/2/4

 [ DEBUG
	mov r2,#1
	mov r2,r2,lsl r1
	sub r2,r2,#1
	and r0,r0,#0x7c
	mov r1,r0,lsr#2
	mov r1,r2,lsl r1
	DEBUGINFO BG1S,r1
 ]
	mov pc,lr
;--------------------------------------------------
w2108	;BG2SC
	;         0BBBBBSS <- SNES
	;SS0BBBBB 0000CCPP <- GBA
	
	ldr r2,=romvars
	strb r0,new_bg2sc_r2

	and r1,r0,#0x7c
	strb r1,bg2scrbase_r2

	and r1,r0,#3
	cmp r1,#2
	addne r1,r1,#1		;1,2,2,4
	strb r1,bg2scrsize_r2

 [ DEBUG
	mov r2,#1
	mov r2,r2,lsl r1
	sub r2,r2,#1
	and r0,r0,#0x7c
	mov r1,r0,lsr#2
	mov r1,r2,lsl r1
	DEBUGINFO BG2S,r1
 ]
	mov pc,lr
;--------------------------------------------------
w2109	;BG3SC
	;         0BBBBBSS <- SNES
	;SS0BBBBB 0000CCPP <- GBA
	
	ldr r2,=romvars
	strb r0,new_bg3sc_r2

	and r1,r0,#0x7c
	strb r1,bg3scrbase_r2

	and r1,r0,#3
	cmp r1,#2
	addne r1,r1,#1		;1,2,2,4
	strb r1,bg3scrsize_r2

 [ DEBUG
	mov r2,#1
	mov r2,r2,lsl r1
	sub r2,r2,#1
	and r0,r0,#0x7c
	mov r1,r0,lsr#2
	mov r1,r2,lsl r1
	DEBUGINFO BG3S,r1
 ]
	mov pc,lr
;--------------------------------------------------
w210b	;BG12NBA
	ldr r2,=romvars
	strb r0,new_bg12nba_r2

	and r1,r0,#0x07
	mov r1,r1,lsl#4		;(0..31)*4
	strb r1,bg1chrbase_r2
	and r1,r0,#0x70
	strb r1,bg2chrbase_r2
 [ DEBUG
	and r1,r0,#7
	mov r1,r1,lsl#2
	and r0,r0,#0x70
	mov r0,r0,lsr#2

	ldr r2,=0xffff
	mov r1,r2,lsl r1
	DEBUGINFO BG1C,r1
	mov r0,r2,lsl r0
	DEBUGINFO BG2C,r0
 ]
	mov pc,lr
;--------------------------------------------------
w210c	;BG34NBA
	ldr r2,=romvars
	strb r0,new_bg34nba_r2

	and r1,r0,#7
	mov r1,r1,lsl#4		;(0..31)*4
	strb r1,bg3chrbase_r2

 [ DEBUG
	and r1,r0,#7
	mov r1,r1,lsl#2
	ldr r2,=0xff
	mov r1,r2,lsl r1
	DEBUGINFO BG3C,r1
 ]
	mov pc,lr

;--------
set_priority
	ldr r2,=romvars
	mov r1,#REG_BASE
	ldrb r4,tm_r2
	ldrb r6,ts_r2
	ldrb r7,romflags1_r2+3
	ldrb r5,bgmode_r2
	tst r5,#4
	beq no7prio
	and r7,r4,#1
	and r4,r4,#0x10
	orr r4,r4,r7,lsl#2
	and r7,r6,#1
	and r6,r6,#0x10
	orr r6,r6,r7,lsl#2
	b bgr_on_off	;dirty hack... don't process priority for mode7
no7prio
	;---BG3

	eor r7,r7,#0x10
	tst r7,#0x10	;force low?
	tstne r4,#4	;TM?
	tstne r5,#8	;BG3 high priority?
	ldrh r0,[r1,#REG_BG2CNT]
		bic r0,r0,#3	;TM&HiPri:  pri=0
		orreq r0,r0,#3	;!TM|LoPri: pri=3
	strh r0,[r1,#REG_BG2CNT]

	;---BG2

	tst r4,#2	;TM?
	ldrh r0,[r1,#REG_BG1CNT]
		bic r0,r0,#3
		orrne r0,r0,#2	;TM: pri=2
		orreq r0,r0,#3	;TS: pri=3
	strh r0,[r1,#REG_BG1CNT]

	;---BG1

	tst r4,#1	;TM?
	ldrh r0,[r1,#REG_BG0CNT]
		bic r0,r0,#3
		orrne r0,r0,#2	;TM: pri=2
		orreq r0,r0,#3	;TS: pri=3
	strh r0,[r1,#REG_BG0CNT]

	;---turn screens on/off
bgr_on_off
	orr r4,r4,r6		;r4=TM|TS
	and r4,r4,#0x17		;no BG4
	and r7,r7,#0x0c
	tst r4,r7,lsr#2
	orrne r4,r4,#8		;GBA BG3 enable if double BG is on
	ldrb r6,inidisp_r2
	tst r6,#0x80
	bicne r4,r4,#0x1f
	ldrh r0,[r1,#REG_DISPCNT]
		bic r0,r0,#0x1f00
		orr r0,r0,r4,lsl#8
	strh r0,[r1,#REG_DISPCNT]

	mov pc,lr
;--------------------------------------------------
;update vrammap and refresh all gba vram whenever anything that might alter the vram layout has changed
update_modeX_vrammap		;r0=mode
	cmp r0,#7
	beq update_mode7_vrammap
;--------------------------------------------------
update_mode1_vrammap	;called from post_vblank_process, r0-r8,r12 are safe to use
	stmfd sp!,{r9,lr}

	DEBUGCOUNT VNEW

 ldr r1,=0x20300ff
foo
 ldrb r0,[r1]
 cmp r0,#0xaa
 beq foo
	mov r3,#REG_BASE
	ldrh r0,[r3,#REG_DISPCNT]
	tst r0,#2		;first time in this mode?
	blne mode1_restore

	ldr r2,=romvars
	sub sp,sp,#44*4		;32 words+8 for overflow
	mov r6,sp		;r6=temporary vrammap

;- - - - -pass 1: set up vram layers

	mov r3,r6
	mov r4,#32
	ldr r0,=empty_W		;clear..
	bl copy8
	bl copy8
	bl copy8
	bl copy8

	ldr r9,romflags2_r2
uv0
	ldrb r1,bg1chrbase_r2	;BG1 CHR
	add r3,r6,r1
	mov r4,#16
	ldr r0,=encodeBG12CHR4
	bl xcopy8
	bl copy8

	ldrb r1,bg2chrbase_r2	;BG2 CHR
	add r3,r6,r1
	mov r4,#16
	;ldr r0,=encodeBG12CHR4 (same)
	bl xcopy8
	bl copy8

	ldrb r1,bg3chrbase_r2	;BG3 CHR2
	add r3,r6,r1
	mov r4,#8
	ldr r0,=encodeBG3CHR2
	bl xcopy8

	ldrb r1,objchrbase_r2	;OBJ CHR
	add r3,r6,r1
	mov r4,#8
	ldr r0,=encodeOBJCHR
	bl xcopy8

	ldr r1,=0x40404060
	eor r9,r9,r1		;flip CHR priority
	tst r9,#0x20		;do 2 passes for CHR layers
	bne uv0

	ldr r9,romflags1_r2	;get "double" flags

	ldrb r0,bg1scrbase_r2	;BG1 SCR
	ldrb r4,bg1scrsize_r2
	add r3,r6,r0
	tst r9,#0x4000000		;double BG?
	ldreq r0,=encodeBG1SCR
	ldrne r0,=encodeBGXSCR
	bl copy4

	ldrb r0,bg2scrbase_r2	;BG2 SCR
	ldrb r4,bg2scrsize_r2
	add r3,r6,r0
	tst r9,#0x8000000		;double BG?
	ldreq r0,=encodeBG2SCR
	ldrne r0,=encodeBGXSCR
	bl copy4

	ldrb r0,bg3scrbase_r2	;BG3 SCR
	ldrb r4,bg3scrsize_r2
	add r3,r6,r0
	ldr r0,=encodeBG3SCR
	bl copy4

;- - - - -pass 2: map SNES vram to GBA vram and redraw

    ;merge BG1+BG2 CHR areas

	ldrb r8,bg1chrbase_r2
	ldrb r9,bg2chrbase_r2	;keep copies of original base for later
	cmp r8,r9
	addmi r3,r6,r8
	addmi r4,r6,r9
	addpl r3,r6,r9
	addpl r4,r6,r8		;r3,r4=chr base for bg1&2.  r3<r4
	add r4,r4,#16*4		;r3=CHR start, r4=CHR end    !!! DOESN'T ACCOUNT FOR WRAPPING !!!

	sub r5,r3,r6
	sub r8,r8,r5
	sub r9,r9,r5		;r8,r9=new base ptrs (shifted to start of vram)

	ldr r1,=encodeBG12CHR4	;find how much of CHR area is really used and adjust pointers
	bl find_start_end

	ldr r7,=0x6000000-0x2020000
	sub r1,r7,r3,lsl#9
	str r1,bg1chroffset_r2		;this will be added to snes address to get GBA vram address

	add r7,r7,r0,lsl#9	;r7=end of BG1/2 CHR

		;redraw
		movs r2,r0,lsl#4		;do 64*#blocks tiles
		mov r0,#0x6000000		;=GBAaddr
		sub r1,r0,r1		;=SNESaddr
		adr lr,bc2
		ldr r12,=encodeCHR4
		bxne r12
bc2		ldr r2,=romvars

	subs r8,r8,r5		;adjust base by unused portion
		movpl r3,r8
		movmi r3,#0
	sub r8,r8,r3
	subs r9,r9,r5
		movpl r4,r9
		movmi r4,#0
	sub r9,r9,r4		;r3,r4=bg1,2 chr base.  r8,r9=tile offset

	mov r1,#REG_BASE		;set BG1 CHR base
	ldrh r0,[r1,#REG_BG0CNT]
	bic r0,r0,#0x0c
	mov r5,r3,lsr#5
	orr r0,r0,r5,lsl#2	;base is rounded down to nearest 8th (difference will be added to the tile# in scr data)
	strh r0,[r1,#REG_BG0CNT]

	mov r8,r8,lsl#4		;=how far old base is from shifted base
	and r3,r3,#0x1c
	add r3,r8,r3,lsl#4	;adjust for misaligned base
	str r3,bg1sc_chroffset_r2	;this will be added to tile# in scr data

	ldrh r0,[r1,#REG_BG1CNT]	;set BG2 CHR base
	bic r0,r0,#0x0c
	mov r5,r4,lsr#5
	orr r0,r0,r5,lsl#2	;base is rounded down to nearest 8th (difference will be added to the tile# in scr data)
	strh r0,[r1,#REG_BG1CNT]

	mov r8,r9,lsl#4		;=how far old base is from shifted base
	and r4,r4,#0x1c
	add r8,r8,r4,lsl#4	;adjust for misaligned base
	str r8,bg2sc_chroffset_r2	;this will be added to tile# in scr data

	;---more double BG stuff.  r3=bg1sc_chroffset, r8=bg2sc_chroffset
	ldrh r9,romflags1_r2+2
	tst r9,#0xc00
	beq uv1
	tst r9,#0x400
	movne r8,r3
	str r8,bgXsc_chroffset_r2
	add r8,r8,r9
	strh r8,bgXblanktile_r2
uv1	;---

    ;BG1 SCR (r9 is still romflags1+2, z=BG1double?)
	and r3,r7,#0xff00	;scr base
	ldrb r5,bg1sc_r2
	and r5,r5,#3	;scr size

	ldrb r4,bg1scrsize_r2
	strneb r4,bgXscrsize_r2

	mov r1,#REG_BASE
	ldrh r0,[r1,#REG_BG0CNT]
		and r0,r0,#0xff
		orr r0,r0,r3,lsr#3	;scr base
		orr r0,r0,r5,lsl#14	;scr size
	strh r0,[r1,#REG_BG0CNT]
	add r0,r0,r4,lsl#8
	bic r0,r0,#3
	orr r0,r0,#1			;extra BG is always pri1
	strneh r0,[r1,#REG_BG3CNT]

	ldrb r0,bg1scrbase_r2
	sub r3,r7,r0,lsl#9
	streq r3,bg1sc_offset_r2		;this will be added to snes address to get GBA vram address
	strne r3,bgXsc_offset_r2

		;redraw
		add r0,r7,#0x2000000
		add r0,r0,#0x0020000	;r0=GBAaddr

	add r7,r7,r4,lsl#11		;r7=end of used vram
	addne r7,r7,r4,lsl#11		;double size?

		sub r1,r0,r3		;r1=SNESaddr
		mov r2,r4,lsl#10		;1k*(scrsize) tiles
		adr lr,sc11
		ldreq pc,=encodeBG1SCR_r2
		ldrne pc,=encodeBGXSCR_r2
sc11		ldr r2,=romvars

    ;BG2 SCR (r9 is still romflags1)
	tst r9,#0x800		;BG2 double?

	and r3,r7,#0xff00	;scr base
	ldrb r5,bg2sc_r2
	and r5,r5,#3	;scr size

	ldrb r4,bg2scrsize_r2
	strneb r4,bgXscrsize_r2

	mov r1,#REG_BASE
	ldrh r0,[r1,#REG_BG1CNT]
		and r0,r0,#0xff
		orr r0,r0,r3,lsr#3	;scr base
		orr r0,r0,r5,lsl#14	;scr size
	strh r0,[r1,#REG_BG1CNT]
	add r0,r0,r4,lsl#8
	bic r0,r0,#3
	orr r0,r0,#1			;extra BG is always pri1
	strneh r0,[r1,#REG_BG3CNT]

	ldrb r0,bg2scrbase_r2
	sub r3,r7,r0,lsl#9
	streq r3,bg2sc_offset_r2		;this will be added to snes address to get GBA vram address
	strne r3,bgXsc_offset_r2

		;redraw
		add r0,r7,#0x2000000
		add r0,r0,#0x0020000	;r0=GBAaddr

	add r7,r7,r4,lsl#11		;r7=end of used vram
	addne r7,r7,r4,lsl#11		;double size?

		sub r1,r0,r3		;r1=SNESaddr
		mov r2,r4,lsl#10		;1k*(scrsize) tiles
		adr lr,sc21
		ldreq pc,=encodeBG2SCR_r2
		ldrne pc,=encodeBGXSCR_r2
sc21		ldr r2,=romvars

    ;BG3 SCR

	and r3,r7,#0xff00	;scr base
	ldrb r4,bg3sc_r2
	and r4,r4,#3	;scr size

	mov r1,#REG_BASE
	ldrh r0,[r1,#REG_BG2CNT]
;		and r0,r0,#0xff
		bic r0,r0,#0xdf00
		orr r0,r0,r3,lsr#3	;scr base
		orr r0,r0,r4,lsl#14	;scr size
	strh r0,[r1,#REG_BG2CNT]

	ldrb r0,bg3scrbase_r2
	sub r3,r7,r0,lsl#9
	str r3,bg3sc_offset_r2		;this will be added to snes address to get GBA vram address

		;redraw
		add r0,r7,#0x2000000
		add r0,r0,#0x0020000	;r0=GBAaddr

	ldrb r4,bg3scrsize_r2
	add r7,r7,r4,lsl#11

		sub r1,r0,r3		;r1=SNESaddr
		mov r4,r4,lsl#10		;1k*(scrsize) tiles
		adr lr,sc31
		stmfd sp!,{r0,r1,r4,lr}	;save these for later (can't redraw until bg3sc_chroffset is set)

    ;BG3 CHR (takes up the most space, so it gets whatever's left)

	ldrb r8,bg3chrbase_r2
	add r3,r8,r6
	add r4,r3,#8*4
	ldr r1,=encodeBG3CHR2	;find how much of CHR area is really used and adjust pointers
	bl find_start_end

	mov r1,#REG_BASE		;set BG base
	ldrh r8,[r1,#REG_BG2CNT]
	bic r8,r8,#0x0c
	and r9,r7,#0xc000
	orr r8,r8,r9,lsr#12	;base is rounded down to nearest 8th (difference will be added to the tile# in scr data)
	strh r8,[r1,#REG_BG2CNT]

	and r9,r7,#0x3800
	mov r9,r9,lsr#5		;adjust misaligned base
	sub r9,r9,r5,lsl#5	;r5 is still (r3 difference) from find_start_end
	str r9,bg3sc_chroffset_r2	;this will be added to tile# in scr data

	sub r9,r7,r3,lsl#10
	ldr r8,=0x2020000
	sub r9,r9,r8
	str r9,bg3chroffset_r2	;SNESaddr+offset=GBAaddr

	add r7,r7,r0,lsl#10		;limit chr size so it can't overlap into sprite area
	add r7,r7,#0x10000		;!!The add screws up some games!!
	ldr r5,=empty_W			;r4=last snes bank, r7=end of chr (3FFxxxx)
b33
	cmp r6,r4
	beq b34
	cmp r7,#0x4000000
	strhi r5,[r4,#-4]!
	subhi r7,r7,#4096
	bhi b33
b34
		;redraw

	;r3=chr start (from find_start_end)
	mov r5,r0			;r5=total chr size (from find_start_end)
	add r7,r8,r3,lsl#9		;r7=snes ptr
	add r8,r9,r7,lsl#1		;r8=gba ptr
	ldr r4,=encodeBG3CHR2
	ldr r9,=encodeCHR2
b30
		ldr r0,[r6,r3]
		cmp r0,r4		;wrong type?
		bne b32
			mov r1,r7		;r1=snes src
			mov r0,r8		;r0=gba dst
b31			mov r2,#128		;128 tiles are one 2k block
			adr lr,b32
			bx r9
b32				;next block
	add r7,r7,#0x800
	add r8,r8,#0x1000
	add r3,r3,#4
	subs r5,r5,#4
	bhi b30

		;redraw BG3 SCR
		ldr r2,=romvars
		ldr r3,bg3sc_chroffset_r2
		ldmfd sp,{r0-r2}
		ldr r12,=encodeBG3SCR2
		bx r12
sc31

;- - - - -third pass: redraw everything

	ldr r5,=vrammap		;r5=old map, r6=new map

	;----OBJ CHR (8 blocks)

	ldr r2,=romvars
	ldrb r3,objchrbase_r2
	ldr r4,=encodeOBJCHR
	ldr r7,=0x2020000
	add r7,r7,r3,lsl#9		;2020000+base*4000
	ldr r8,=0x6010000
ob0		ldr r0,[r6,r3]
		ldr r1,[r5,r3]
		cmp r0,r4		;wrong type?
		bne ob2
		cmp r0,r1		;same as old?
		beq ob2
			mov r1,r7		;r1=snes src
			mov r0,r8
			;64 tiles in a 'block' of vram.  split up into 4 rows of 16
ob1			mov r2,#16
			ldr r12,=encodeCHR4
			adr lr,ob3
			bx r12
ob3			add r0,r0,#0x200		;next row
			tst r0,#0xf00
			bne ob1
ob2				;next block
	add r7,r7,#0x800
	add r8,r8,#0x1000
	add r3,r3,#4
	tst r3,#0x1c
	bne ob0

;- - - - - - - - - -done! (finally)

	mov r0,r6
	mov r1,r5
	mov r2,#32
	swi 0xc0000		;copy temp vrammap to vrammap

	add sp,sp,#44*4
	ldmfd sp!,{r9,pc}

xcopy8			;fill up vrammap: r4=count, r0=fillval, r3=vrammap ptr
			;r9:  D0-D6 subtracted from r4, D7=add to r3 (0=remove blocks from top, 1=remove blocks from bottom)
	and r1,r9,#0x7f
	sub r4,r4,r1
	movs r9,r9,ror#8
	addcs r3,r3,r1,lsl#2
copy8
	subs r4,r4,#1
	strpl r0,[r3],#4
	subs r4,r4,#1
	strpl r0,[r3],#4
	subs r4,r4,#1
	strpl r0,[r3],#4
	subs r4,r4,#1
	strpl r0,[r3],#4
copy4
	subs r4,r4,#1
	strpl r0,[r3],#4
	subs r4,r4,#1
	strpl r0,[r3],#4
	subs r4,r4,#1
	strpl r0,[r3],#4
	subs r4,r4,#1
	strpl r0,[r3],#4
	mov pc,lr

find_start_end			;r3=range start, r4=range end, r1=type
	mov r5,r3
find2
	cmp r3,r4
	beq find1
	ldr r0,[r4,#-4]!
	cmp r0,r1
	bne find2
	add r4,r4,#4
find0			;r4>r3, r4 points to a match
	ldr r0,[r3],#4
	cmp r0,r1
	bne find0
	sub r3,r3,#4
find1	sub r0,r4,r3
	sub r5,r3,r5
	sub r3,r3,r6
	mov pc,lr		;return with r3=first base where [r6,r3]=type, r5=difference in r3, r0=size of block (r4-r3)
;--------------------------------------------------
update_mode7_vrammap	;called from post_vblank_process, r0-r8,r12 are safe to use
	stmfd sp!,{r9,lr}

	DEBUGCOUNT VNEW

	mov r3,#REG_BASE
	ldrh r0,[r3,#REG_DISPCNT]
	tst r0,#2		;first time in this mode?
	bleq mode7_restore

	ldr r2,=romvars

	sub sp,sp,#44*4		;32 words+8 for overflow
	mov r6,sp		;r6=temporary vrammap

;- - - - -pass 1: set up vram layers

	mov r3,r6
	mov r4,#32
	ldr r0,=empty_W		;clear..
	bl copy8
	bl copy8
	bl copy8
	bl copy8

	ldrb r1,objchrbase_r2	;OBJ CHR, do this before the mode7 stuff (Actraiser).
	add r3,r6,r1
	mov r4,#8
	ldr r0,=encodeOBJCHR
	bl copy8

	;ldrb r1,bg1chrbase_r2	;mode7 chr+scr
	;add r3,r6,r1
	mov r3,r6
	mov r4,#16
	ldr r0,=encodeMODE7
	bl copy8
	bl copy8

;- - - - -pass 2: map SNES vram to GBA vram and redraw

	;BG1

	mov r1,#0x2000000
	add r1,r1,#0x0020000		;r1=snes vram
	mov r2,#16384		;whole screen
	adr lr,u7_0
	ldr pc,=encodeM7
u7_0
	

;- - - - -third pass: redraw everything

	ldr r5,=vrammap		;r5=old map, r6=new map

	;----OBJ CHR (8 blocks)

	ldr r2,=romvars
	ldrb r3,objchrbase_r2
	ldr r4,=encodeOBJCHR
	ldr r7,=0x2020000
	add r7,r7,r3,lsl#9		;2020000+base*4000
	ldr r8,=0x6010000
ob70		ldr r0,[r6,r3]
		ldr r1,[r5,r3]
		cmp r0,r4		;wrong type?
		bne ob72
		cmp r0,r1		;same as old?
		beq ob72
			mov r1,r7		;r1=snes src
			mov r0,r8
			;64 tiles in a 'block' of vram.  split up into 4 rows of 16
ob71			mov r2,#16
			ldr r12,=encodeCHR4
			adr lr,ob73
			bx r12
ob73			add r0,r0,#0x200		;next row
			tst r0,#0xf00
			bne ob71
ob72				;next block
	add r7,r7,#0x800
	add r8,r8,#0x1000
	add r3,r3,#4
	tst r3,#0x1c
	bne ob70

;- - - - - - - - - -done! (finally)

	mov r0,r6
	mov r1,r5
	mov r2,#32
	swi 0xc0000		;copy temp vrammap to vrammap

	add sp,sp,#44*4
	ldmfd sp!,{r9,pc}
;--------------------------------------------------
w211A	;M7SEL
	mov r1,#REG_BASE
	ldrh r2,[r1,#REG_BG2CNT]
	bic r2,r2,#0x2000
	tst r0,#0xc0
	orreq r2,r2,#0x2000
	strh r2,[r1,#REG_BG2CNT]
	mov pc,lr
;--------------------------------------------------
w211B	;MODE7 A

	ldr r2,=m7a
	ldrb r1,[r2,#1]
	orr r1,r1,r0,lsl#8
	strh r1,[r2]
	mov pc,lr

w211C	;MODE7 B

	ldr r2,=m7a
	ldrb r1,[r2,#3]
	orr r1,r1,r0,lsl#8
	strh r1,[r2,#2]
			;(multiply)
	ldrsh r1,[r2]
	mov r0,r0,lsl#24
	mov r0,r0,asr#24
	mul r0,r1,r0
	str r0,[r2,#12]
	mov pc,lr

w211D	;MODE7 C

	ldr r2,=m7a
	ldrb r1,[r2,#5]
	orr r1,r1,r0,lsl#8
	strh r1,[r2,#4]
	mov pc,lr

w211E	;MODE7 D

	ldr r2,=m7a
	ldrb r1,[r2,#7]
	orr r1,r1,r0,lsl#8
	strh r1,[r2,#6]
	mov pc,lr

w211F	;MODE7 X

	ldr r2,=m7a
	ldrb r1,[r2,#9]
	orr r1,r1,r0,lsl#8
	strh r1,[r2,#8]
	mov pc,lr

w2120	;MODE7 Y

	ldr r2,=m7a
	ldrb r1,[r2,#11]
	orr r1,r1,r0,lsl#8
	strh r1,[r2,#10]
	mov pc,lr
;--------------------------------------------
mode7scroll	;called from post_vblank
; stmfd sp!,{r9}
; ldr r9,=0x2033000
	ldr r12,=m7a
	ldrsh r0,[r12],#2	;A
	ldrsh r1,[r12],#2	;B
	ldrsh r2,[r12],#2	;C
	ldrsh r3,[r12],#2	;D
	ldrh r4,[r12],#2
	ldrh r5,[r12],#2
	mov r4,r4,lsl#19
	mov r4,r4,asr#19	;X0
	mov r5,r5,lsl#19
	mov r5,r5,asr#19	;Y0
	ldr r12,=bg1hofs
	ldrsh r7,[r12],#2
	ldrsh r8,[r12],#2
	add r7,r7,#8
	add r8,r8,r6
; stmia r9!,{r0-r5,r7,r8}
	sub r7,r7,r4	;X1-X0
	sub r8,r8,r5	;Y1-Y0
	ldr r12,=gbarotscale
	strh r0,[r12],#2		;REG_BG2PA
	strh r1,[r12],#2		;REG_BG2PB
	strh r2,[r12],#2		;REG_BG2PC
	strh r3,[r12],#2		;REG_BG2PD
; stmia r9!,{r7-r8}
	mul r0,r7,r0	;A*(X1-X0)
	mul r2,r7,r2	;C*(X1-X0)
	add r0,r0,r4,lsl#8
	add r2,r2,r5,lsl#8
	mla r1,r8,r1,r0	;A*(X1-X0)+B*(Y1-Y0)+X0
	mla r3,r8,r3,r2	;C*(X1-X0)+D*(Y1-Y0)+Y0
; stmia r9!,{r1,r3}
	str r1,[r12],#4			;REG_BG2X_L
	str r3,[r12],#4			;REG_BG2Y_L
; ldmfd sp!,{r9}
	mov pc,lr
;--------------------------------------------------
w2181	;WMADDR
	ldr r1,=wmaddr
	strb r0,[r1]
	mov pc,lr
w2182
	ldr r1,=wmaddr
	strb r0,[r1,#1]
	mov pc,lr
w2183
	and r0,r0,#1
	ldr r1,=wmaddr
	strb r0,[r1,#2]
	mov pc,lr
;--------------------------------------------------
w4016	;(joypad reset)
;	mov r11,r11
	ldr r2,=snespad_shift
	ldrb r1,[r2,#8]			;snes4016
	strb r0,[r2,#8]			;snes4016
	eor r0,r0,r1
	and r0,r0,r1
	tst r0,#1
	moveq pc,lr

	ldrh r1,[r2,#4]
	sub r1,r1,#0x10000
	mov r1,r1,ror#16
	str r1,[r2]

	mov pc,lr
;--------------------------------------------------
r4016	;(joypad read, NES style)
;	mov r11,r11
	ldr r1,=snespad_shift
	ldr r0,[r1]
	movs r0,r0,lsl#1
	orr r0,r0,#1
	str r0,[r1]

	movcc r0,#0
	movcs r0,#1
	mov pc,lr
;--------------------------------------------------
r4017	;(joypad read, NES style)
;	ldr r1,=snespad_shift
;	ldr r0,[r1]
;	movs r0,r0,lsl#1
;	orr r0,r0,#1
;	str r0,[r1]

;	movcc r0,#0
;	movcs r0,#1
	mov r0,#0
	mov pc,lr


;--------------------------------------------------
mid_frame_process		;called by 65816.s at line 120

	stmfd sp!,{r3-r8,lr}
;--------------------------------------------------
FadeNBlend
	ldr r2,=inidisp
	ldrb r0,[r2]

	mov r2,#REG_BASE
	and r0,r0,#15
	rsb r1,r0,#15
	strh r1,[r2,#REG_COLEY]
	cmp r1,#0
	beq endFade
doFade
	mov r1,#0xFF
	strh r1,[r2,#REG_BLDMOD]
	b endFadeNBlend
endFade
;--------------------------------------------------
	ldr r1,=cgadsub
	ldrb r0,[r1]
	tst r0,#0x3F
	beq doFade
	b endFadeNBlend		;Blending isn't right yet...
	mov r1,#0x10
	orr r1,r1,r1,lsl#8
	tst r0,#0x40		;1/2 add
	movne r1,r1,lsr#1
	strh r1,[r2,#REG_COLEV]
	and r0,r0,#0x37
	ldr r1,=ts
	ldrb r1,[r1]
	and r0,r0,r1
;	ldr r1,=tm
;	ldrb r1,[r1]
	orr r0,r0,#0x3f00
	orr r0,r0,#0x40		;Blending
	strh r0,[r2,#REG_BLDMOD]

endFadeNBlend
;- - - - - - - - - - - - - - - - -
	ldr r0,=tm		;same thing for priority...
	ldmia r0,{r1-r2}
	eors r1,r1,r2
;	beq %F0				;nothing changed - abort

	stmia r0,{r2}			;update vars
	adr lr,%F0
	ldr pc,=set_priority
0
;- - - - - - - - - - - - - - - - - - - - - - - - - -
	ldmfd sp!,{r3-r8,pc}
;--------------------------------------------------
reset_io			;r0-r12 are safe to trash

	fill 0x2020000,zero,0x10000	;clear snes vram
	fill oam,zero,0x220		;clear snes OAM
	fill vrammap,empty,32*4		;clear vram map

	adr r2,varlist
rp0	ldmia r2!,{r0,r1}
	cmp r0,#0
	strne r1,[r0]
	bne rp0

	mov pc,lr

varlist	DCD new_bgmode,0			;bgmode,objsel,bg1sc,bg2sc
	DCD new_bg3sc,0			;bg3sc,
	;DCD new_tm,0			;tm,ts
	DCD bg1scrbase,0x01000100		;1base,1size,2base,2size
	DCD bg3scrbase,0x0100
	DCD hvbjoy,0

	DCD vcount,261
	DCD HVtimer,-1
	DCD vtimetemp,0	;+htimetemp
	DCD HVtimerlatch,0x0000ffff	;+rdnmi +nmitimen
	DCD adjusted_vtime,0xffff0106	;+htime
	DCD cycles_per_line,SLOWROM_CYCLESPERLINE*CYCLE

zero	DCD 0
empty	DCD empty_W

;--------------------------------------------------
;called from main() - (re)initialize all gfx stuff

restore_gfx
	ldr r2,=romvars
	mov r0,#-1
	strb r0,update_vrammap_r2		;restore vram
	fill vrammap,empty,32*4		;invalidate all vram

	ldr r2,=romvars
	ldrb r0,bgmode_r2
	and r0,r0,#7
	cmp r0,#7
	beq mode7_restore

mode1_restore		;called by update_mode1_vrammap
	stmfd sp!,{lr}

	adr r12,mode1palettecode		;set palette code
	ldmia r12,{r0-r3,lr}
	ldr r12,=palettewrite
	stmia r12,{r0-r3,lr}

	mov r3,#REG_BASE
	ldr r2,=romvars
	mov r0,#-1
	strb r0,tm_r2			;restore BG priorities

	ldr r0,=2_0001111100100000		;BG0|BG1|BG2|BG3|OBJ|MODE0|no hblank obj process;
	strh r0,[r3,#REG_DISPCNT]
	mov r0,#1
	strh r0,[r3,#REG_BG3CNT]		;BGX pri1
	mov r0,#2
	strh r0,[r3,#REG_BG0CNT]		;BG1 pri2
	strh r0,[r3,#REG_BG1CNT]		;BG2 pri2
	mov r0,#3
	strh r0,[r3,#REG_BG2CNT]		;BG3 pri3

	ldr r12,=set_palette		;palette restore
	ldr r3,=0x1010200
	ldr r2,=AGB_PALETTE
	adr lr,m1r0
	stmfd sp,{r3,lr}
m1r0	tst r2,#0x200
	bne m1r1
	sub sp,sp,#8
	ldrh r0,[r2,r3]
	add r2,r2,#2
	bx r12
m1r1
	ldmfd sp!,{lr}
	bx lr

mode1palettecode
	strh r0,[r2,#0xfe]	;write to GBA palette
	sub r3,r2,#2
	tst r3,#0xfc0		;color 0-31?
	ldmnefd sp!,{r3,pc}
	and r1,r3,#0x38		;split up lower colors for 2-bit tileset

mode7_restore		;called by update_mode7_vramamp
	stmfd sp!,{lr}

	adr r12,mode7palettecode		;set palette code
	ldmia r12,{r0-r3,lr}
	ldr r12,=palettewrite
	stmia r12,{r0-r3,lr}

	mov r3,#REG_BASE
	ldr r2,=romvars
	mov r0,#-1
	strb r0,tm_r2			;restore BG priorities

	ldr r0,=2_0001010000100010		;BG2|OBJ|MODE2|no hblank obj process;
	strh r0,[r3,#REG_DISPCNT]
	ldrh r0,[r3,#REG_BG2CNT]
	and r0,r0,#0x2000		;save overflow bit
	ldr r2,=0xc086			;pri2 scrbase0 chrbase1 256color 1k*1k
	orr r0,r0,r2
	strh r0,[r3,#REG_BG2CNT]

	ldr r12,=set_palette		;palette restore
	ldr r3,=0x1010200
	ldr r2,=AGB_PALETTE
	adr lr,m7r0
	stmfd sp,{r3,lr}
m7r0	tst r2,#0x200
	bne m7r1
	sub sp,sp,#8
	ldrh r0,[r2,r3]
	add r2,r2,#2
	bx r12
m7r1
	ldmfd sp!,{lr}
	bx lr

mode7palettecode
	strh r0,[r2,#-2]		;write GBA palette
	sub r3,r2,#2
	tst r3,#0x100		;color 80-ff? (sprite pal)
	strneh r0,[r2,#0xfe]
	ldmfd sp!,{r3,pc}
;--------------------------------------------------

	LTORG
	ALIGN 4

gamma3	DCB 0,2,4,6,7,8,9,10,11,13,14,15,15,16,17,18,19,20,21,22,22,23,24,25,26,26,27,28,29,30,30,31
gamma5	DCB 0,7,9,11,13,14,15,16,17,18,19,20,20,21,22,23,23,24,24,25,26,26,27,27,28,28,29,29,30,30,31,31

	MACRO
	REPT $count,$w0,$w1,$w2,$w3,$w4,$w5,$w6,$w7
	LCLA count2
count2 	SETA $count
	WHILE count2 > 0
	DCD $w0,$w1,$w2,$w3,$w4,$w5,$w6,$w7
count2 	SETA count2-1
	WEND
	MEND

;READ:	return r0=data, r1=trash, r2=unchanged, r12=unchanged
;WRITE:	return r0=trash, r1=trash, r2=trash, r12=unchanged
;THUMB routines return with BX LR

readIO_tbl
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R			;4000
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,r4016,r4017
	REPT 0x03d, empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R			;4200
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD r4210,r4211,r4212,r4213,r4214,r4215,r4216,r4217
	DCD r4218,r4219,r421A,r421B,r421C,r421D,r421E,r421F
	REPT 0x01c, empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R	;4220
	DCD r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX							;4300
	DCD r43XX,r43XX,r43XX,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX							;4310
	DCD r43XX,r43XX,r43XX,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX							;4320
	DCD r43XX,r43XX,r43XX,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX							;4330
	DCD r43XX,r43XX,r43XX,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX							;4340
	DCD r43XX,r43XX,r43XX,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX							;4350
	DCD r43XX,r43XX,r43XX,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX							;4360
	DCD r43XX,r43XX,r43XX,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX,r43XX							;4370
	DCD r43XX,r43XX,r43XX,empty_R,empty_R,empty_R,empty_R,empty_R
	REPT 0x190, empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R	;4380
	REPT 0x200, empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R	;5000
	REPT 0x020, openb_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R	;2000
B_bus_read
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R			;2100
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R			;2120
	DCD empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R
	DCD empty_R,empty_R,empty_R,empty_R,r2134,r2135,r2136,r2137					;2130
	DCD r2138,r2139,r213A,r213B,r213C,r213D,r213E,r213F
	DCD r2140,r2141,r2142,r2143,empty_R,empty_R,empty_R,empty_R					;2140
	REPT 0x007, empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R	;2148
	DCD r2180,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R			;2180
	REPT 0x1cf, empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R	;2188
	REPT 0x200, empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R,empty_R	;3000

writeIO_tbl
	DCD empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W			;4000
	DCD empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,w4016,empty_W
	REPT 0x03d, empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD w4200,w4201,w4202,w4203,w4204,w4205,w4206,w4207							;4200
	DCD w4208,w4209,w420A,w420B,empty_W,w420D,empty_W,empty_W
	DCD empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W			;4210
	DCD empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W
	REPT 0x01c, empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W	;4220
	DCD w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX							;4300
	DCD w43XX,w43XX,w43XX,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX							;4310
	DCD w43XX,w43XX,w43XX,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX							;4320
	DCD w43XX,w43XX,w43XX,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX							;4330
	DCD w43XX,w43XX,w43XX,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX							;4340
	DCD w43XX,w43XX,w43XX,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX							;4350
	DCD w43XX,w43XX,w43XX,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX							;4360
	DCD w43XX,w43XX,w43XX,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX,w43XX							;4370
	DCD w43XX,w43XX,w43XX,empty_W,empty_W,empty_W,empty_W,empty_W
	REPT 0x190, empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W	;4380
	REPT 0x200, empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W	;5000
	REPT 0x020, empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W	;2000
B_bus_write	;don't expect temp regs (r12, etc) to have their usual values (changes with DMA)
	DCD w2100,w2101,w2102,w2103,w2104,w2105,w2106,w2107							;2100
	DCD w2108,w2109,empty_W,w210b,w210c,w210d,w210e,w210f
	DCD w2110,w2111,w2112,empty_W,empty_W,w2115,w2116,w2117						;2110
	DCD w2118,w2119,w211A,w211B,w211C,w211D,w211E,w211F
	DCD w2120,w2121,w2122,empty_W,empty_W,empty_W,empty_W,empty_W				;2120
	DCD empty_W,empty_W,empty_W,empty_W,w212C,w212D,w212E,w212F
	DCD w2130,w2131,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W				;2130
	DCD empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W
	DCD w2140,w2141,w2142,w2143,empty_W,empty_W,empty_W,empty_W					;2140
	REPT 0x007, empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W	;2148
	DCD w2180,w2181,w2182,w2183,empty_W,empty_W,empty_W,empty_W					;2180
	REPT 0x1cf, empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W	;2188
	REPT 0x200, empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W,empty_W	;3000
;--------------------------------------------------
	END