#ifndef GBA_HEADER
#define GBA_HEADER

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;
typedef volatile unsigned char vu8;
typedef volatile unsigned short vu16;
typedef volatile unsigned long vu32;

typedef void (*fptr)(void);


typedef struct {
	char title[32];	//ROM title
	u32 romsize;	//ROM size
	u32 crc32;
	u32 flags;
	u32 moreflags;
	u32 autoscroll_val1;
	u32 autoscroll_val2;
	u32 autoscroll_scale;
	int autoscroll_offset;
} romheader;

extern u32 *userdata;		//main.c
extern u32 *romdata;		//main.c
void waitframe(void);		//main.c
u32 readpad(void);		//main.c
void set_throttle_timer(u8);	//main.c
romheader *romchooser(void);	//menus.c
int settings(romheader*);		//menus.c
void set_keyconfig(const u8*);	//menus.c
void hardreset(void *,u32 flags);	//65816.s
void restore_gfx(romheader *r);	//io.s
extern u8 gamma;			//io.s
extern u8 throttle_intr;		//io.s
extern u8 throttle_type;		//io.s
extern u32 autoscroll_ptr1;	//io.s
extern u32 autoscroll_ptr2;	//io.s
extern u32 autoscroll_scale;	//io.s
extern u32 autoscroll_offset;	//io.s
extern u8 keyconfig;		//io.s
extern u32 romflags1;		//io.s
extern u32 romflags2;		//io.s

#define HIROM 1
#define PAL 2
#define SRAM 4
#define AUTOSCROLL_DIFF 8		//scroll by val1 or (val1-val2)?
#define AUTOSCROLL16 16		//use 16bit value for autoscroll

#define AGB_PALETTE (u8*)0x5000000
#define AGB_VRAM (u8*)0x6000000
#define AGB_OAM (u8*)0x7000000
#define AGB_SRAM (u8*)0xe000000
#define INTR_VECT *(void**)0x3007FFC

#define REG_DISPCNT *(vu32*)0x4000000
#define MODE0 0
#define MODE1 1
#define MODE2 2
#define MODE3 3
#define MODE4 4
#define MODE5 5
#define OBJ_H_STOP 0x20
#define OBJ_1D 0x40
#define FORCE_BLANK 0x80
#define BG0_EN 0x100
#define BG1_EN 0x200
#define BG2_EN 0x400
#define BG3_EN 0x800
#define OBJ_EN 0x1000
#define WINDOW0_EN 0x2000
#define WINDOW1_EN 0x4000
#define OBJ_WINDOW_EN 0x8000

#define REG_DISPSTAT *(vu16*)0x4000004
#define SCANLINE *(vu8*)0x4000005
#define VBLANK 1
#define HBLANK 2
#define VCOUNT_HIT 4
#define V_IRQ 8
#define H_IRQ 16
#define VCOUNT_IRQ 32

#define REG_BG0HOFS *(u16*)0x4000010
#define REG_BG0VOFS *(u16*)0x4000012
#define REG_BG1HOFS *(u16*)0x4000014
#define REG_BG1VOFS *(u16*)0x4000016
#define REG_BG2HOFS *(u16*)0x4000018
#define REG_BG2VOFS *(u16*)0x400001a
#define REG_BG3HOFS *(u16*)0x400001c
#define REG_BG3VOFS *(u16*)0x400001e
#define REG_BG0CNT *(u16*)0x4000008
#define REG_BG1CNT *(u16*)0x400000a
#define REG_BG2CNT *(u16*)0x400000c
#define REG_BG3CNT *(u16*)0x400000e
#define COLOR16 0x0000
#define COLOR256 0x0080
#define SIZE256x256 0x0000
#define SIZE512x256 0x4000
#define SIZE256x512 0x8000
#define SIZE512x512 0xC000

#define REG_VCOUNT *(volatile u16*)0x4000006

#define REG_IE *(vu16*)0x4000200
#define REG_IF *(vu16*)0x4000202
#define REG_IME *(vu16*)0x4000208

#define REG_P1 *(vu16*)0x4000130
#define A_BUTTON 1
#define B_BUTTON 2
#define SELECT_BUTTON 4
#define START_BUTTON 8
#define DPAD_RIGHT 16
#define DPAD_LEFT 32
#define DPAD_UP 64
#define DPAD_DOWN 128
#define R_BUTTON 256
#define L_BUTTON 512

#define REG_DM0CNT_H *(u16*)0x40000ba
#define REG_DM1CNT_H *(u16*)0x40000c6
#define REG_DM2CNT_H *(u16*)0x40000d2
#define REG_DM3CNT_H *(u16*)0x40000de
#define REG_MOSAIC *(u16*)0x400004c
#define REG_BLDCNT *(u16*)0x4000050
#define REG_BLDALPHA *(u16*)0x4000052
#define REG_BLDY *(u16*)0x4000054
#define REG_SGCNT0_L *(u16*)0x4000080
#define REG_SGBIAS *(u16*)0x4000088
#define REG_BG2X *(u32*)0x4000028
#define REG_BG2Y *(u32*)0x400002c
#define REG_BG2PA *(u16*)0x4000020
#define REG_BG2PB *(u16*)0x4000022
#define REG_BG2PC *(u16*)0x4000024
#define REG_BG2PD *(u16*)0x4000026

#define REG_SIOMULTI0 *(vu16*)0x4000120
#define REG_SIOMULTI1 *(vu16*)0x4000122
#define REG_SIOCNT *(vu16*)0x4000128
#define REG_SIOMLT_SEND *(vu16*)0x400012a
#define REG_RCNT *(vu16*)0x4000134
#define REG_TM0CNT_L *(vu16*)0x4000100
#define REG_TM0CNT_H *(vu16*)0x4000102
#define REG_TM1CNT_L *(vu16*)0x4000104
#define REG_TM1CNT_H *(vu16*)0x4000106
#define REG_TM2CNT_L *(vu16*)0x4000108
#define REG_TM2CNT_H *(vu16*)0x400010a
#define REG_TM3CNT_L *(vu16*)0x400010c
#define REG_TM3CNT_H *(vu16*)0x400010e
#endif
