	AREA iwram, CODE, READWRITE

	INCLUDE io.h
	INCLUDE equates.h
;	INCLUDE spc_multi.h

	EXPORT interrupthandler
;----------------------------------------------------------------------------
interrupthandler		;r0-r3,r12 are safe to use
;----------------------------------------------------------------------------
	mov r2,#REG_BASE
	ldr r1,[r2,#REG_IE]!
	and r1,r1,r1,lsr#16	;r1=IE&IF

	strh r1,[r2,#2]			;unhandled interrupt
	mov r2,#0x4000000
	ldrh r0,[r2,#-8]		;3007FF8, BIOS IRQ wait stuff.
	orr r0,r1,r0
	strh r0,[r2,#-8]
	
	ands r0,r1,#0x01
	bne vblankinterrupt

	;ands r0,r1,#0x10
	;bne timer1interrupt

	;ands r0,r1,#0x??
	;bne serialinterrupt

	bx lr

vblankinterrupt
	mov r12,#REG_BASE
	adr r1,gbarotscale
	ldr r0,[r1],#4
	str r0,[r12,#REG_BG2PA]
	ldr r0,[r1],#4
	str r0,[r12,#REG_BG2PC]
	ldr r0,[r1],#4
	str r0,[r12,#REG_BG2X_L]
	ldr r0,[r1],#4
	str r0,[r12,#REG_BG2Y_L]

	bx lr
;---------------------------
	END