		GBLL SAFE

SAFE		SETL {TRUE}	;sacrifice speed for accuracy (use more bounds checking, etc)
;SAFE		SETL {FALSE}

;DEBUG		SETL {FALSE}/{TRUE}  (defined in project settings)
;----------------------------------------------------------------------------

HIROM		EQU 1		;rom flags
PAL		EQU 2
SRAM		EQU 4

SNES_RAM		EQU 0x2000000
SNES_VRAM	EQU 0x2020000
SNES_SRAM	EQU 0xe000000

AGB_IRQVECT	EQU 0x3007FFC
AGB_PALETTE	EQU 0x5000000
AGB_VRAM		EQU 0x6000000
AGB_OAM		EQU 0x7000000

REG_BASE		EQU 0x4000000
REG_DISPCNT	EQU 0x00
REG_DISPSTAT	EQU 0x04
REG_VCOUNT	EQU 0x06
REG_BG0CNT	EQU 0x08
REG_BG1CNT	EQU 0x0a
REG_BG2CNT	EQU 0x0c
REG_BG3CNT	EQU 0x0e
REG_BG0HOFS	EQU 0x10
REG_BG0VOFS	EQU 0x12
REG_BG1HOFS	EQU 0x14
REG_BG1VOFS	EQU 0x16
REG_BG2HOFS	EQU 0x18
REG_BG2VOFS	EQU 0x1a
REG_BG3HOFS	EQU 0x1c
REG_BG3VOFS	EQU 0x1e
REG_BG2PA	EQU 0x20
REG_BG2PB	EQU 0x22
REG_BG2PC	EQU 0x24
REG_BG2PD	EQU 0x26
REG_BG2X_L	EQU 0x28
REG_BG2X_H	EQU 0x2a
REG_BG2Y_L	EQU 0x2c
REG_BG2Y_H	EQU 0x2e
REG_WINOUT	EQU 0x4a
REG_MOSAIC	EQU 0x4c
REG_BLDMOD	EQU 0x50
REG_COLEV	EQU 0x52
REG_COLEY		EQU 0x54
REG_SG1CNT_L	EQU 0x60
REG_SG1CNT_H	EQU 0x62
REG_SG1CNT_X	EQU 0x64
REG_SG2CNT_L	EQU 0x68
REG_SG2CNT_H	EQU 0x6C
REG_SG3CNT_L	EQU 0x70
REG_SG3CNT_H	EQU 0x72
REG_SG3CNT_X	EQU 0x74
REG_SG4CNT_L	EQU 0x78
REG_SG4CNT_H	EQU 0x7c
REG_SGCNT_L	EQU 0x80
REG_SGCNT_H	EQU 0x82
REG_SGCNT_X	EQU 0x84
REG_SGBIAS	EQU 0x88
REG_SGWR0_L	EQU 0x90
REG_FIFO_A_L	EQU 0xA0
REG_FIFO_A_H	EQU 0xA2
REG_FIFO_B_L	EQU 0xA4
REG_FIFO_B_H	EQU 0xA6
REG_DM0SAD	EQU 0xB0
REG_DM0DAD	EQU 0xB4
REG_DM0CNT_L	EQU 0xB8
REG_DM0CNT_H	EQU 0xBA
REG_DM1SAD	EQU 0xBC
REG_DM1DAD	EQU 0xC0
REG_DM1CNT_L	EQU 0xC4
REG_DM1CNT_H	EQU 0xC6
REG_DM2SAD	EQU 0xC8
REG_DM2DAD	EQU 0xCC
REG_DM2CNT_L	EQU 0xD0
REG_DM2CNT_H	EQU 0xD2
REG_DM3SAD	EQU 0xD4
REG_DM3DAD	EQU 0xD8
REG_DM3CNT_L	EQU 0xDC
REG_DM3CNT_H	EQU 0xDE
REG_TM0CNT_L	EQU 0x100
REG_TM0CNT_H	EQU 0x102
REG_TM1CNT_L	EQU 0x104
REG_TM1CNT_H	EQU 0x106
REG_TM2CNT_L	EQU 0x108
REG_TM2CNT_H	EQU 0x10a
REG_TM3CNT_L	EQU 0x10c
REG_TM3CNT_H	EQU 0x10e
REG_IE		EQU 0x200
REG_IF		EQU 0x4000202
REG_P1		EQU 0x4000130
REG_P1CNT	EQU 0x132
REG_WAITCNT	EQU 0x4000204

;----------------------------------------------------------------------------
SLOWROM_CYCLESPERLINE EQU 1023		;170.5*6 (2.68MHz)
FASTROM_CYCLESPERLINE EQU 1364		;227.333*6 (3.58MHz)

MULTIPLIER	EQU 6
CYCLESHIFT	EQU 4
 [ SNES9X
CYCLE		EQU 1
 |
CYCLE		EQU 16 ;one cycle (1<<CYCLESHIFT)
 ]
CPUCYCLE		EQU CYCLE*MULTIPLIER

SNES_RESET_VECTOR EQU 0xfffc
SNES_NMI_VECTOR	EQU 0xffea
SNES_BRK_VECTOR	EQU 0xffe6
SNES_COP_VECTOR	EQU 0xffe4
SNES_IRQ_VECTOR	EQU 0xffee

	MACRO
	fill $dst,$src,$count	;fast mem clear (r0-r3 killed)
	adr r0,$src
	ldr r1,=$dst
	ldr r2,=$count/4
	orr r2,r2,#0x01000000
	swi 0x0c0000
	MEND

;--------debug stuff-------------------------------------------------------

FRAMECOUNT EQU 0x203002c
INFOBASE	EQU 0x2030040

ERR0	EQU 0
ERR1	EQU 1
IRQS	EQU 2
BG1C	EQU 3
VNEW	EQU 4
BG2C	EQU 5
LINE	EQU 6
BG3C	EQU 7
NMIT	EQU 8
OBJC	EQU 9
MODE	EQU 10
BG1S	EQU 11
TM	EQU 12
BG2S	EQU 13
TS	EQU 14
BG3S	EQU 15
TMW	EQU 16
TSW	EQU 18
CGSW	EQU 20
TIME	EQU 21
ASUB	EQU 22

	MACRO
	DEBUGINFO $index,$reg
 [ DEBUG
	stmfd sp!,{r7-r10,lr}
	mov r7,$reg
	ldr r8,=$index
	adr lr,%F0
	ldr pc,=debuginfo
0	ldmfd sp!,{r7-r10,lr}
 ]
	MEND

	MACRO
	DEBUGCOUNT $index
 [ DEBUG
	stmfd sp!,{r7-r10,lr}
	ldr r8,=$index
	adr lr,%F0
	ldr pc,=debugcount
0	ldmfd sp!,{r7-r10,lr}
 ]
	MEND

	MACRO
	DEBUGERROR $addr,$reg
	DEBUGINFO ERR0,$reg
 [ DEBUG
	ldr r1,=$addr
 ]
	DEBUGINFO ERR1,r1
	MEND

;----------------------------------------------------------------------------
		END
