 [ SNES9X
	INCLUDE 65816mac.h
	INCLUDE memory.h
	INCLUDE io.h

	IMPORT S9xResetCPU ;from 9x_cpu.c

	EXPORT reset_cpu
	EXPORT S9xGetByte
	EXPORT S9xGetWord
	EXPORT S9xSetByte
	EXPORT S9xSetWord
	EXPORT translate_addr
	EXPORT do_post_vblank
	EXPORT do_pre_vblank

	EXPORT cycles_per_line
	EXPORT vcount
	EXPORT HVtimer
	EXPORT vcount_latch
	EXPORT vtimetemp
	EXPORT HVtimerlatch
	EXPORT adjusted_vtime
	EXPORT timeup
	EXPORT nmitimen
	EXPORT rdnmi

	AREA iwram, CODE, READWRITE

cycles_per_line DCD 0
;(don't rearrange this stuff.. offsets are hardcoded in some places)
vcount DCD 0		;*i (current scanline)
HVtimer DCD 0		;*i (4207/09) interrupt when HVtimer<=vcount.  set to 0 when htimer enabled (interrupt every line)
vcount_latch DCD 0	;(213d)
vtimetemp DCW 0		;*i (4209)
htimetemp DCW 0		;*i
HVtimerlatch DCW 0	;*i copied to HVtimer every frame
rdnmi DCB 0		;*i 4210
nmitimen DCB 0		;*i 4200
adjusted_vtime DCW 0	;*i vtimetemp modified (262->263, 0->262)
adjusted_htime DCW 0	;*i htimetemp modified (0-339=0 >339=-1)??
timeup DCW 0		;(4211)

;------------------------------------------
	AREA rom, CODE, READONLY
;------------------------------------------
ADR_TYPE SETA _ABS
S9xGetByte			;uint8 S9xGetByte (uint32 Address)
	stmfd sp!,{snes_a,snes_memtbl,lr}
	mov snes_a,#0
	ldr snes_memtbl,=readmem8_tbl
	mov snes_memtbl,snes_memtbl,lsr#2
	mov r12,r0
	readmem8
	ldmfd sp!,{snes_a,snes_memtbl,lr}
	bx lr
S9xGetWord			;uint16 S9xGetWord (uint32 Address)
	stmfd sp!,{snes_a,snes_memtbl,lr}
	mov snes_a,#0
	ldr snes_memtbl,=readmem8_tbl
	mov snes_memtbl,snes_memtbl,lsr#2
	mov r12,r0
	readmem16
	orr r0,r1,r0,lsl#8
	ldmfd sp!,{snes_a,snes_memtbl,lr}
	bx lr
S9xSetByte			;void S9xSetWord (uint16 Word, uint32 Address)
	stmfd sp!,{snes_a,snes_memtbl,lr}
	mov snes_a,#0
	ldr snes_memtbl,=readmem8_tbl
	mov snes_memtbl,snes_memtbl,lsr#2
	mov r12,r1
	writemem8
	ldmfd sp!,{snes_a,snes_memtbl,lr}
	bx lr
S9xSetWord			;void S9xSetByte (uint8 Byte, uint32 Address)
	stmfd sp!,{snes_a,snes_memtbl,lr}
	mov snes_a,#0
	ldr snes_memtbl,=readmem8_tbl
	mov snes_memtbl,snes_memtbl,lsr#2
	mov r12,r1
	writemem16
	ldmfd sp!,{snes_a,snes_memtbl,lr}
	bx lr
translate_addr			;turn snes ptr into GBA ptr
	stmfd sp!,{snes_a,snes_memtbl,lr}
	mov snes_a,#0
	ldr snes_memtbl,=readmem8_tbl
	mov snes_memtbl,snes_memtbl,lsr#2
	mov r12,r0
	translateR12
	mov r0,r1
	ldmfd sp!,{snes_a,snes_memtbl,lr}
	bx lr

do_post_vblank
	stmfd sp!,{lr}
	adr lr,asdf
	ldr pc,=post_vblank_process
asdf	ldmfd sp!,{lr}
	bx lr

do_pre_vblank
	stmfd sp!,{lr}
	adr lr,asdf2
	ldr pc,=pre_vblank_process
asdf2	ldmfd sp!,{lr}
	bx lr

reset_cpu	;called by hardreset (65816.s)
	ldr r0,=S9xResetCPU
	bx r0
;------------------------------------------
 ]
	END