/*******************************************************************************
  Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 
  (c) Copyright 1996 - 2003 Gary Henderson (gary.henderson@ntlworld.com) and
                            Jerremy Koot (jkoot@snes9x.com)

  (c) Copyright 2002 - 2003 Matthew Kendora and
                            Brad Jorsch (anomie@users.sourceforge.net)
 

                      
  C4 x86 assembler and some C emulation code
  (c) Copyright 2000 - 2003 zsKnight (zsknight@zsnes.com),
                            _Demo_ (_demo_@zsnes.com), and
                            Nach (n-a-c-h@users.sourceforge.net)
                                          
  C4 C++ code
  (c) Copyright 2003 Brad Jorsch

  DSP-1 emulator code
  (c) Copyright 1998 - 2003 Ivar (ivar@snes9x.com), _Demo_, Gary Henderson,
                            John Weidman (jweidman@slip.net),
                            neviksti (neviksti@hotmail.com), and
                            Kris Bleakley (stinkfish@bigpond.com)
 
  DSP-2 emulator code
  (c) Copyright 2003 Kris Bleakley, John Weidman, neviksti, Matthew Kendora, and
                     Lord Nightmare (lord_nightmare@users.sourceforge.net

  OBC1 emulator code
  (c) Copyright 2001 - 2003 zsKnight, pagefault (pagefault@zsnes.com)
  Ported from x86 assembler to C by sanmaiwashi

  SPC7110 and RTC C++ emulator code
  (c) Copyright 2002 Matthew Kendora with research by
                     zsKnight, John Weidman, and Dark Force

  S-RTC C emulator code
  (c) Copyright 2001 John Weidman
  
  Super FX x86 assembler emulator code 
  (c) Copyright 1998 - 2003 zsKnight, _Demo_, and pagefault 

  Super FX C emulator code 
  (c) Copyright 1997 - 1999 Ivar and Gary Henderson.



 
  Specific ports contains the works of other authors. See headers in
  individual files.
 
  Snes9x homepage: http://www.snes9x.com
 
  Permission to use, copy, modify and distribute Snes9x in both binary and
  source form, for non-commercial purposes, is hereby granted without fee,
  providing that this license information and copyright notice appear with
  all copies and any derived work.
 
  This software is provided 'as-is', without any express or implied
  warranty. In no event shall the authors be held liable for any damages
  arising from the use of this software.
 
  Snes9x is freeware for PERSONAL USE only. Commercial users should
  seek permission of the copyright holders first. Commercial use includes
  charging money for Snes9x or software derived from Snes9x.
 
  The copyright holders request that bug fixes and improvements to the code
  should be forwarded to them so everyone can benefit from the modifications
  in future versions.
 
  Super NES and Super Nintendo Entertainment System are trademarks of
  Nintendo Co., Limited and its subsidiary companies.
*******************************************************************************/

#ifdef SNES9X

#include "9x_snes9x.h"
#include "9x_memmap.h"
//#include "ppu.h"
//#include "dsp1.h"
#include "9x_cpuexec.h"
//#include "debug.h"
//#include "apu.h"
//#include "dma.h"
//#include "sa1.h"
//#include "cheats.h"
//#include "srtc.h"
//#include "sdd1.h"
//#include "spc7110.h"
//#include "obc1.h"
#include "9x_cpuops.h"
//#include "snapshot.h"
//#include "gfx.h"
//#include "9x_missing.h"
//#include "fxemu.h"

//----
extern uint32 cycles_per_line;
extern uint32 vcount;		//current scanline
extern uint32 HVtimer;
extern uint8 timeup;
extern uint8 vblankflag;
extern uint8 rdnmi;
extern uint8 nmitimen;
uint32 translate_addr(uint32);
void do_post_vblank(void);
void do_pre_vblank(void);
//----

void copy_65816_state(uint32 *dst) {
	uint8 *p1,*p2;
	dst[0]=Registers.A.W;
	dst[1]=Registers.X.W|(Registers.DB<<16);
	dst[2]=Registers.Y.W|(Registers.DB<<16);
	dst[3]=Registers.D.W;
	dst[4]=Registers.S.W;
	dst[5]=Registers.PC|ICPU.ShiftedPB;
	dst[6]=Registers.P.W;
	dst[7]=CPU.Cycles;
	p1=(uint8*)dst;
	p2=CPU.PC;
	p1[0x20]=*(p2++);
	p1[0x21]=*(p2++);
	p1[0x22]=*(p2++);
	p1[0x23]=*(p2++);
	p1[0x24]=*(p2++);
	p1[0x25]=*(p2++);
	p1[0x26]=*(p2++);
	p1[0x27]=*(p2++);
//2030028 = Rom offset
}

void S9xSetPCBase (uint32 Address) {
	uint32 foo=translate_addr(Address);
	CPU.PCBase = (uint8 *)(foo-(Address&0xffff));
	CPU.PC = (uint8 *)foo;
}

void S9xResetCPU ()
{
    Registers.PB = 0;
    Registers.PC = S9xGetWord (0xFFFC);
    Registers.D.W = 0;
    Registers.DB = 0;
    Registers.SH = 1;
    Registers.SL = 0xFF;
    Registers.XH = 0;
    Registers.YH = 0;
    Registers.P.W = 0;

    ICPU.ShiftedPB = 0;
    ICPU.ShiftedDB = 0;
    SetFlags (MemoryFlag | IndexFlag | IRQ | Emulation);
    ClearFlags (Decimal);

//    CPU.Flags = CPU.Flags & (DEBUG_MODE_FLAG | TRACE_FLAG);
//    CPU.BranchSkip = FALSE;
//    CPU.NMIActive = FALSE;
//    CPU.IRQActive = FALSE;
    CPU.WaitingForInterrupt = FALSE;
//    CPU.InDMA = FALSE;
//    CPU.WhichEvent = HBLANK_START_EVENT;
    CPU.PC = NULL;
    CPU.PCBase = NULL;
//    CPU.PCAtOpcodeStart = NULL;
//    CPU.WaitAddress = NULL;
//    CPU.WaitCounter = 0;
    CPU.Cycles = 0;
//    CPU.NextEvent = Settings.HBlankStart;
//    CPU.V_Counter = 0;
//    CPU.MemSpeed = SLOW_ONE_CYCLE;
//    CPU.MemSpeedx2 = SLOW_ONE_CYCLE * 2;
//    CPU.FastROMSpeed = SLOW_ONE_CYCLE;
//    CPU.AutoSaveTimer = 0;
//    CPU.SRAMModified = FALSE;
    // CPU.NMITriggerPoint = 4; // Set when ROM image loaded
//    CPU.BRKTriggered = FALSE;
    //CPU.TriedInterleavedMode2 = FALSE; // Reset when ROM image loaded
//    CPU.NMICycleCount = 0;
//    CPU.IRQCycleCount = 0;
    S9xSetPCBase (Registers.PC);

    ICPU.S9xOpcodes = S9xOpcodesM1X1;
//    ICPU.CPUExecuting = TRUE;

    S9xUnpackStatus();
}

void debugstep (int instructions)
{
	while(instructions--)
	{
		while (CPU.Cycles>=0)
		{
			vcount++;
			if(vcount>=HVtimer) { //(check IRQ, etc)
				timeup=0x80;			//set VTIMEUP
				if(HVtimer>0) HVtimer=512;		//timer stop 
				if(nmitimen&0x30) {		//VIRQ enabled?
					if (CPU.WaitingForInterrupt)
					{
						CPU.WaitingForInterrupt = FALSE;
						CPU.PC++;
					}
					if (!CheckFlag (IRQ))
						S9xOpcode_IRQ ();
				}
			}
			if(vcount==241) {
				rdnmi=0x80;
				if(nmitimen&0x80) {		//NMI enabled?
				    if (CPU.WaitingForInterrupt)
				    {
					CPU.WaitingForInterrupt = FALSE;
					CPU.PC++;
				    }
				    S9xOpcode_NMI ();
				}
				do_pre_vblank();
			}
			else if(vcount==262) {
				vcount=0;
				rdnmi=0;
				do_post_vblank();		//do sprites, etc
			}
			CPU.Cycles-=cycles_per_line;
		}
		CPU.Cycles += ONE_CYCLE;

		ICPU.S9xOpcodes[*CPU.PC++]();
	
	}
	Registers.PC = CPU.PC - CPU.PCBase;
	S9xPackStatus ();
}

/*
void S9xSetIRQ (uint32 source)
{
    CPU.IRQActive |= source;
//    CPU.Flags |= IRQ_PENDING_FLAG;
    CPU.IRQCycleCount = 3;
    if (CPU.WaitingForInterrupt)
    {
	// Force IRQ to trigger immediately after WAI - 
	// Final Fantasy Mystic Quest crashes without this.
	CPU.IRQCycleCount = 0;
	CPU.WaitingForInterrupt = FALSE;
	CPU.PC++;
    }
}

void S9xClearIRQ (uint32 source)
{
    CLEAR_IRQ_SOURCE (source);
}


void S9xDoHBlankProcessing ()
{
#ifdef CPU_SHUTDOWN
    CPU.WaitCounter++;
#endif
    switch (CPU.WhichEvent)
    {
    case HBLANK_START_EVENT:
	if (IPPU.HDMA && CPU.V_Counter <= PPU.ScreenHeight)
	    IPPU.HDMA = S9xDoHDMA (IPPU.HDMA);

	break;

    case HBLANK_END_EVENT:
	S9xSuperFXExec ();

#ifndef STORM
	if (Settings.SoundSync)
	    S9xGenerateSound ();
#endif

	CPU.Cycles -= Settings.H_Max;
	if (IAPU.APUExecuting)
	{
	    APU.Cycles -= Settings.H_Max;
#ifdef MK_APU
		S9xCatchupCount();
#endif
	}
	else
	    APU.Cycles = 0;

	CPU.NextEvent = -1;
	ICPU.Scanline++;

	if (++CPU.V_Counter >= (Settings.PAL ? SNES_MAX_PAL_VCOUNTER : SNES_MAX_NTSC_VCOUNTER))
	{
		CPU.V_Counter = 0;
		Memory.FillRAM[0x213F]^=0x80;
		PPU.RangeTimeOver = 0;
	    CPU.NMIActive = FALSE;
	    ICPU.Frame++;
	    PPU.HVBeamCounterLatched = 0;
	    CPU.Flags |= SCAN_KEYS_FLAG;
	    S9xStartHDMA ();
	}

	if (PPU.VTimerEnabled && !PPU.HTimerEnabled &&
	    CPU.V_Counter == PPU.IRQVBeamPos)
	{
	    S9xSetIRQ (PPU_V_BEAM_IRQ_SOURCE);
	}

	if (CPU.V_Counter == PPU.ScreenHeight + FIRST_VISIBLE_LINE)
	{
	    // Start of V-blank
	    S9xEndScreenRefresh ();
	    IPPU.HDMA = 0;
	    // Bits 7 and 6 of $4212 are computed when read in S9xGetPPU.
	    missing.dma_this_frame = 0;
	    IPPU.MaxBrightness = PPU.Brightness;
	    PPU.ForcedBlanking = (Memory.FillRAM [0x2100] >> 7) & 1;

		if(!PPU.ForcedBlanking){
			PPU.OAMAddr = PPU.SavedOAMAddr;
			{
				uint8 tmp = 0;
				if(PPU.OAMPriorityRotation)
					tmp = (PPU.OAMAddr&0xFE)>>1;
				if((PPU.OAMFlip&1) || PPU.FirstSprite!=tmp){
					PPU.FirstSprite=tmp;
					IPPU.OBJChanged=TRUE;
				}
			}
			PPU.OAMFlip = 0;
		}

	    Memory.FillRAM[0x4210] = 0x80 |MAX_5A22_VERSION;
	    if (Memory.FillRAM[0x4200] & 0x80)
	    {
			CPU.NMIActive = TRUE;
			CPU.Flags |= NMI_FLAG;
			CPU.NMICycleCount = CPU.NMITriggerPoint;
	    }

	}

	if (CPU.V_Counter == PPU.ScreenHeight + 3)
	    S9xUpdateJoypads ();

	if (CPU.V_Counter == FIRST_VISIBLE_LINE)
	{
	    Memory.FillRAM[0x4210] = MAX_5A22_VERSION;
	    CPU.Flags &= ~NMI_FLAG;
	    S9xStartScreenRefresh ();
	}
	if (CPU.V_Counter >= FIRST_VISIBLE_LINE &&
	    CPU.V_Counter < PPU.ScreenHeight + FIRST_VISIBLE_LINE)
	{
	    RenderLine (CPU.V_Counter - FIRST_VISIBLE_LINE);
	}
	// Use TimerErrorCounter to skip update of SPC700 timers once
	// every 128 updates. Needed because this section of code is called
	// once every emulated 63.5 microseconds, which coresponds to
	// 15.750KHz, but the SPC700 timers need to be updated at multiples
	// of 8KHz, hence the error correction.
//	IAPU.TimerErrorCounter++;
//	if (IAPU.TimerErrorCounter >= )
//	    IAPU.TimerErrorCounter = 0;
//	else
	{
	    if (APU.TimerEnabled [2])
	    {
		APU.Timer [2] += 4;
		while (APU.Timer [2] >= APU.TimerTarget [2])
		{
		    IAPU.RAM [0xff] = (IAPU.RAM [0xff] + 1) & 0xf;
		    APU.Timer [2] -= APU.TimerTarget [2];
#ifdef SPC700_SHUTDOWN		
		    IAPU.WaitCounter++;
		    IAPU.APUExecuting = TRUE;
#endif		
		}
	    }
	    if (CPU.V_Counter & 1)
	    {
		if (APU.TimerEnabled [0])
		{
		    APU.Timer [0]++;
		    if (APU.Timer [0] >= APU.TimerTarget [0])
		    {
			IAPU.RAM [0xfd] = (IAPU.RAM [0xfd] + 1) & 0xf;
			APU.Timer [0] = 0;
#ifdef SPC700_SHUTDOWN		
			IAPU.WaitCounter++;
			IAPU.APUExecuting = TRUE;
#endif		    
		    }
		}
		if (APU.TimerEnabled [1])
		{
		    APU.Timer [1]++;
		    if (APU.Timer [1] >= APU.TimerTarget [1])
		    {
			IAPU.RAM [0xfe] = (IAPU.RAM [0xfe] + 1) & 0xf;
			APU.Timer [1] = 0;
#ifdef SPC700_SHUTDOWN		
			IAPU.WaitCounter++;
			IAPU.APUExecuting = TRUE;
#endif		    
		    }
		}
	    }
	}
	break;
    case HTIMER_BEFORE_EVENT:
    case HTIMER_AFTER_EVENT:
	if (PPU.HTimerEnabled &&
	    (!PPU.VTimerEnabled || CPU.V_Counter == PPU.IRQVBeamPos))
	{
	    S9xSetIRQ (PPU_H_BEAM_IRQ_SOURCE);
	}
	break;
    }
    S9xReschedule ();
}
*/
#endif //SNES9X